/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayWriteable2
implements IBinaryWriteable {
    ByteBuffer[] CE;
    int i = 0;
    ByteBuffer cur;
    ByteOrder CF;
    ChunkListener CG;

    public ByteBufferArrayWriteable2(ByteBuffer[] byteBufferArray, ChunkListener chunkListener) {
        if (byteBufferArray == null || chunkListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.CE = byteBufferArray;
        this.CG = chunkListener;
        this.cur = byteBufferArray[0];
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.CF;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.CF = byteOrder;
        this.cur.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.etS();
        this.cur.put(by);
        this.etR();
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.put(byArray, 0, byArray.length);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            this.etS();
            int n4 = Math.min(n3, this.cur.remaining());
            this.cur.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            this.etR();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            this.etS();
            ByteBufferUtils.copyRemaining(byteBuffer, this.cur);
            this.etR();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        while (n2 > 0) {
            this.etS();
            int n3 = Math.min(n2, Math.min(byteBuffer.remaining(), this.cur.remaining()));
            ByteBufferUtils.copy(byteBuffer, this.cur, n3);
            n2 -= n3;
            this.etR();
        }
    }

    @Override
    public void putDouble(double d2) throws IOException {
        this.putLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void putFloat(float f2) throws IOException {
        this.putInt(Float.floatToIntBits(f2));
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.CF == ByteOrder.BIG_ENDIAN) {
            this.E(n2 >> 24);
            this.E(n2 >> 16);
            this.E(n2 >> 8);
            this.E(n2);
        } else {
            this.E(n2);
            this.E(n2 >> 8);
            this.E(n2 >> 16);
            this.E(n2 >> 24);
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.CF == ByteOrder.BIG_ENDIAN) {
            this.E((int)(l2 >> 56));
            this.E((int)(l2 >> 48));
            this.E((int)(l2 >> 40));
            this.E((int)(l2 >> 32));
            this.E((int)(l2 >> 24));
            this.E((int)(l2 >> 16));
            this.E((int)(l2 >> 8));
            this.E((int)l2);
        } else {
            this.E((int)l2);
            this.E((int)(l2 >> 8));
            this.E((int)(l2 >> 16));
            this.E((int)(l2 >> 24));
            this.E((int)(l2 >> 32));
            this.E((int)(l2 >> 40));
            this.E((int)(l2 >> 48));
            this.E((int)(l2 >> 56));
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.CF == ByteOrder.BIG_ENDIAN) {
            this.E(s2 >> 8);
            this.E(s2);
        } else {
            this.E(s2);
            this.E(s2 >> 8);
        }
    }

    private void etR() {
        if (!this.cur.hasRemaining()) {
            this.fireChunkComplete(this.i);
        }
    }

    private void etS() {
        while (!this.cur.hasRemaining()) {
            ++this.i;
            if (this.i >= this.CE.length) {
                throw new BufferOverflowException();
            }
            this.cur = this.CE[this.i];
            this.cur.order(this.CF);
        }
    }

    protected void fireChunkComplete(int n2) {
        if (this.CG != null) {
            this.CG.onChunkComplete(this.CE, n2);
        }
    }

    void E(int n2) throws IOException {
        this.etS();
        this.cur.put((byte)n2);
        this.etR();
    }

    public static interface ChunkListener {
        public void onChunkComplete(ByteBuffer[] var1, int var2);
    }
}

