/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayReadable
implements IBinaryReadable {
    final ByteQueue CC;

    public ByteBufferArrayReadable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.CC = new ByteQueue();
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.CC.offer(byteBuffer);
        }
    }

    public ByteBufferArrayReadable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.CC = byteQueue;
    }

    @Override
    public byte get() throws IOException {
        return this.CC.getReadChunk().get();
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.CC.get(byArray);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) throws IOException {
        this.CC.get(byArray, n2, n3);
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        this.CC.get(byteBuffer);
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) throws IOException {
        this.CC.get(byteBuffer, n2);
    }

    public ByteQueue getByteQueue() {
        return this.CC;
    }

    @Override
    public double getDouble() throws IOException {
        if (this.CC.getReadChunk().remaining() >= 8) {
            return this.CC.getReadChunk().getDouble();
        }
        return this.CC.get(8).getDouble();
    }

    @Override
    public float getFloat() throws IOException {
        if (this.CC.getReadChunk().remaining() >= 4) {
            return this.CC.getReadChunk().getFloat();
        }
        return this.CC.get(4).getFloat();
    }

    @Override
    public int getInt() throws IOException {
        if (this.CC.getReadChunk().remaining() >= 4) {
            return this.CC.getReadChunk().getInt();
        }
        return this.CC.get(4).getInt();
    }

    @Override
    public long getLong() throws IOException {
        if (this.CC.getReadChunk().remaining() >= 8) {
            return this.CC.getReadChunk().getLong();
        }
        return this.CC.get(8).getLong();
    }

    @Override
    public short getShort() throws IOException {
        if (this.CC.getReadChunk().remaining() >= 2) {
            return this.CC.getReadChunk().getShort();
        }
        return this.CC.get(2).getShort();
    }

    @Override
    public long limit() {
        return this.CC.getBytesWritten();
    }

    @Override
    public ByteOrder order() {
        return this.CC.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.CC.order(byteOrder);
    }

    @Override
    public long position() {
        return this.CC.getBytesRead();
    }
}

