/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenableSocketChannel {
    static Logger logger = LoggerFactory.getLogger(ListenableSocketChannel.class);
    SocketChannel channel;
    volatile ConnectionListener Cu;
    volatile ReadableListener Cv;
    volatile WriteableListener Cw;
    AsyncSelector Cm;
    boolean closed = false;
    boolean Cp = false;
    AsyncSelector.SelectListener Cx = (asyncSelector, selectableChannel, n2, n3) -> {
        logger.trace("onSelected, channel: {},, ops: {}, oldOps: {}", selectableChannel, n2, n3);
        if ((n2 & 8) != 0) {
            asyncSelector.interestOps(selectableChannel, -9);
            this.etO();
        }
        if ((n2 & 1) != 0) {
            this.etP();
        }
        if ((n2 & 4) != 0) {
            this.etQ();
        }
    };

    public ListenableSocketChannel() throws IOException {
        this((SocketChannel)SocketChannel.open().configureBlocking(false));
    }

    public ListenableSocketChannel(SocketChannel socketChannel) throws IOException {
        this(socketChannel, new AsyncSelector());
        this.Cp = true;
    }

    public ListenableSocketChannel(SocketChannel socketChannel, AsyncSelector asyncSelector2) throws IOException {
        logger.debug("ListenableSocketChannel: channel={}", (Object)socketChannel);
        if (socketChannel == null) {
            throw new IllegalArgumentException("The given channel cannot be null");
        }
        if (socketChannel.isBlocking()) {
            throw new IllegalArgumentException("channel arg must be in non-blocking mode. (SocketChannel.configureBlocking(false))");
        }
        this.channel = socketChannel;
        this.Cm = asyncSelector2;
        this.Cm.register(socketChannel, 0, this.Cx);
    }

    public void close() {
        boolean bl = this.channel.isRegistered();
        boolean bl2 = this.channel.isOpen();
        logger.debug("close: channel.isRegistered()={}", (Object)bl);
        if (bl) {
            this.Cm.unregister(this.channel);
        }
        logger.debug("close: channel.isOpen()={}", (Object)bl2);
        if (bl2) {
            try {
                this.channel.close();
                logger.debug("closed");
            }
            catch (IOException iOException) {
                logger.error("close", iOException);
            }
        }
        logger.debug("close: ownsSelector={}", (Object)this.Cp);
        if (this.Cp) {
            try {
                this.Cm.close();
            }
            catch (IOException iOException) {
                logger.error("close: selector.close", iOException);
            }
        }
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.channel.connect(socketAddress);
        this.C(8);
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public ConnectionListener getConnectListener() {
        return this.Cu;
    }

    public ReadableListener getReadListener() {
        return this.Cv;
    }

    public AsyncSelector getSelectorThread() {
        return this.Cm;
    }

    public WriteableListener getWriteListener() {
        return this.Cw;
    }

    public void setConnectListener(ConnectionListener connectionListener) {
        this.Cu = connectionListener;
        this.C(8);
    }

    public void setReadListener(ReadableListener readableListener) {
        this.Cv = readableListener;
        this.C(1);
    }

    public void setWriteListener(WriteableListener writeableListener) {
        this.Cw = writeableListener;
        this.C(4);
    }

    public boolean syncConnect(SocketAddress socketAddress, long l2) throws IOException {
        final Semaphore semaphore = new Semaphore(0);
        final IOException[] iOExceptionArray = new IOException[1];
        this.setConnectListener(new ConnectionListener(){

            @Override
            public void onConnected(ListenableSocketChannel listenableSocketChannel) {
                semaphore.release();
            }

            @Override
            public void onConnectFailed(ListenableSocketChannel listenableSocketChannel, IOException iOException) {
                iOExceptionArray[0] = iOException;
                semaphore.release();
            }
        });
        this.connect(socketAddress);
        try {
            if (!semaphore.tryAcquire(l2, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void etO() {
        block9: {
            ConnectionListener connectionListener = this.getConnectListener();
            boolean bl = false;
            try {
                try {
                    boolean bl2 = this.channel.finishConnect();
                    if (bl2) {
                        if (connectionListener != null) {
                            connectionListener.onConnected(this);
                        }
                        break block9;
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    if (connectionListener != null) {
                        connectionListener.onConnectFailed(this, iOException);
                    }
                }
            }
            finally {
                if (bl) {
                    this.C(8);
                }
            }
        }
    }

    private void etP() {
        ReadableListener readableListener = this.getReadListener();
        if (readableListener != null) {
            readableListener.onDataReadable(this);
        }
    }

    private void etQ() {
        WriteableListener writeableListener = this.getWriteListener();
        if (writeableListener != null) {
            writeableListener.onDataWriteable(this);
        }
    }

    void C(int n2) {
        try {
            int n3 = this.D(n2);
            this.Cm.interestOps(this.channel, n3);
        }
        catch (CancelledKeyException cancelledKeyException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    int D(int n2) {
        switch (n2) {
            case 1: {
                if (this.Cv != null && this.channel.isConnected()) {
                    return 1;
                }
                return -2;
            }
            case 4: {
                if (this.Cw != null && this.channel.isConnected()) {
                    return 4;
                }
                return -5;
            }
            case 8: {
                if (this.Cu != null && !this.channel.isConnected()) {
                    return 8;
                }
                return -9;
            }
        }
        return 0;
    }

    public static interface WriteableListener {
        public void onDataWriteable(ListenableSocketChannel var1);
    }

    public static interface ReadableListener {
        public void onDataReadable(ListenableSocketChannel var1);
    }

    public static interface ConnectionListener {
        public void onConnected(ListenableSocketChannel var1);

        public void onConnectFailed(ListenableSocketChannel var1, IOException var2);
    }
}

