/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackUtils {
    private static Logger logger = LoggerFactory.getLogger(StackUtils.class);
    private static int Bi = 64;
    private static long Bj = 3L;
    private static final int Bk = Runtime.getRuntime().availableProcessors();
    private static Executor Bl;
    private static Executor Bm;
    private static ExecutorService Bn;
    private static Integer Bo;
    private static Integer Bp;
    private static Integer Bq;
    private static AsyncSelector Br;
    @Deprecated
    public static Random RANDOM;
    private static UnsignedInteger Bs;
    private static UnsignedInteger Bt;
    public static final int TCP_PROTOCOL_VERSION = 0;
    public static String NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN;
    public static String BLOCKING_WORK_EXECUTOR_NAME_PATTERN;
    public static String UA_TIMER_NAME_PATTERN;
    public static String SELECTOR_NAME_PATTERN;
    private static volatile Thread.UncaughtExceptionHandler Bu;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean barrierWait(AsyncResult<?>[] asyncResultArray, long l2) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        ResultListener resultListener = new ResultListener(){

            public void onCompleted(Object object) {
                semaphore.release();
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                semaphore.release();
            }
        };
        AsyncResult<?>[] asyncResultArray2 = asyncResultArray;
        int n2 = asyncResultArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            AsyncResult<?> asyncResult;
            AsyncResult<?> asyncResult2 = asyncResult = asyncResultArray2[i2];
            synchronized (asyncResult2) {
                if (asyncResult.getStatus() != AsyncResult.AsyncResultStatus.Waiting) {
                    semaphore.release();
                } else {
                    asyncResult.setListener(resultListener);
                }
                continue;
            }
        }
        return semaphore.tryAcquire(asyncResultArray.length, l2, TimeUnit.SECONDS);
    }

    public static int cores() {
        return Bk;
    }

    public static synchronized Executor createBlockingWorkExecutor(String string, int n2) {
        if (Bm == null) {
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, String.format(Locale.ROOT, BLOCKING_WORK_EXECUTOR_NAME_PATTERN, atomicInteger.incrementAndGet()));
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(Bu);
                    Integer n2 = StackUtils.getBlockingWorkExecutorThreadPriority();
                    if (n2 != null) {
                        thread.setPriority(n2);
                    }
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            Bm = new ThreadPoolExecutor(Bi, n2, Bj, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory);
            ((ThreadPoolExecutor)Bm).setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getRejectionExecutor().execute(runnable);
                }
            });
        }
        return Bm;
    }

    public static Integer getAsyncSelectorThreadPriority() {
        return Bq;
    }

    public static int getBlockingWorkerThreadPoolCoreSize() {
        return Bi;
    }

    public static long getBlockingWorkerThreadPoolTimeout() {
        return Bj;
    }

    public static Executor getBlockingWorkExecutor() {
        return StackUtils.createBlockingWorkExecutor("Blocking-Work-Executor", 256);
    }

    public static Integer getBlockingWorkExecutorThreadPriority() {
        return Bo;
    }

    public static synchronized Executor getNonBlockingWorkExecutor() {
        if (Bl == null) {
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, String.format(Locale.ROOT, NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN, atomicInteger.incrementAndGet()));
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(Bu);
                    Integer n2 = StackUtils.getNonBlockingWorkExecutorThreadPriority();
                    if (n2 != null) {
                        thread.setPriority(n2);
                    }
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getBlockingWorkExecutor().execute(runnable);
                }
            };
            Bl = new ThreadPoolExecutor(Bk, Bk, 3L, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory, rejectedExecutionHandler);
        }
        return Bl;
    }

    public static Integer getNonBlockingWorkExecutorThreadPriority() {
        return Bp;
    }

    public static synchronized Executor getRejectionExecutor() {
        if (Bn == null) {
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "RejectedRunnableHanlder");
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(Bu);
                    return thread;
                }
            };
            Bn = Executors.newSingleThreadExecutor(threadFactory);
        }
        return Bn;
    }

    public static UnsignedInteger getSecurityTokenLifetimeMax() {
        return Bt;
    }

    public static UnsignedInteger getSecurityTokenLifetimeMin() {
        return Bs;
    }

    public static AsyncSelector getSelector() {
        if (Br == null) {
            try {
                Br = new AsyncSelector(Selector.open());
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }
        return Br;
    }

    public static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return Bu;
    }

    public static void logStatus() {
        StackUtils.a("BLOCKING_EXECUTOR", (ThreadPoolExecutor)Bm);
        StackUtils.a("NON_BLOCKING_EXECUTOR", (ThreadPoolExecutor)Bl);
    }

    public static ThreadFactory newNamedThreadFactory(String string) {
        return new a(string);
    }

    public static void setAsyncSelectorThreadPriority(Integer n2) {
        Bq = n2;
    }

    public static void setBlockingWorkerThreadPoolCoreSize(int n2) {
        Bi = n2;
    }

    public static void setBlockingWorkerThreadPoolTimeout(long l2) {
        Bj = l2;
    }

    public static void setBlockingWorkExecutorThreadPriority(Integer n2) {
        Bo = n2;
    }

    public static void setNonBlockingWorkExecutorThreadPriority(Integer n2) {
        Bp = n2;
    }

    public static void setSecurityTokenLifetimeMax(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("The given value cannot be null");
        }
        Bt = unsignedInteger;
    }

    public static void setSecurityTokenLifetimeMin(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("The given value cannot be null");
        }
        Bs = unsignedInteger;
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Bu = uncaughtExceptionHandler;
    }

    public static void shutdown() {
        WeakReference<Timer> weakReference;
        Timer timer;
        if (Bm != null) {
            ((ThreadPoolExecutor)Bm).shutdown();
            Bm = null;
        }
        if (Bl != null) {
            ((ThreadPoolExecutor)Bl).shutdown();
            Bl = null;
        }
        if (Bn != null) {
            Bn.shutdown();
            Bn = null;
        }
        if (Br != null) {
            try {
                Br.close();
                Br = null;
            }
            catch (IOException iOException) {
                logger.debug("SELECTOR.close failed", iOException);
            }
        }
        Timer timer2 = timer = (weakReference = TimerUtil.timer) == null ? null : (Timer)weakReference.get();
        if (timer != null) {
            timer.cancel();
            TimerUtil.timer = null;
        }
    }

    public static ServiceResultException toServiceResultException(Exception exception) {
        if (exception instanceof ServiceResultException) {
            return (ServiceResultException)exception;
        }
        if (exception instanceof ClosedChannelException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        if (exception instanceof EOFException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (graceful)");
        }
        if (exception instanceof ConnectException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)exception);
        }
        if (exception instanceof SocketException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (unexpected)");
        }
        if (exception instanceof IOException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        return new ServiceResultException(exception);
    }

    private static void a(String string, ThreadPoolExecutor threadPoolExecutor) {
        logger.debug("{}: ActiveCount={} CompletedTaskCount={} PoolSize={} LargestPoolSize={} TaskCount={}", string, threadPoolExecutor.getActiveCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getPoolSize(), threadPoolExecutor.getLargestPoolSize(), threadPoolExecutor.getTaskCount());
    }

    static {
        Bo = null;
        Bp = null;
        Bq = null;
        RANDOM = new Random();
        Bs = UnsignedInteger.getFromBits(600000);
        Bt = UnsignedInteger.getFromBits(3600000);
        NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN = "OPC-UA-Stack-Non-Blocking-Work-Executor-%d";
        BLOCKING_WORK_EXECUTOR_NAME_PATTERN = "OPC-UA-Stack-Blocking-Work-Executor-%d";
        UA_TIMER_NAME_PATTERN = "OPC-UA-Stack-Timer";
        SELECTOR_NAME_PATTERN = "OPC-UA-Stack-Async-Selector";
        Bu = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                logger.error("Uncaught Exception in Thread: {}", (Object)thread, (Object)throwable);
            }
        };
    }

    static class a
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        a(String string) {
            this.namePrefix = string + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.namePrefix + this.threadNumber.getAndIncrement());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            thread.setUncaughtExceptionHandler(Bu);
            return thread;
        }
    }
}

