/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncubationQueue<T> {
    private static final Logger logger = LoggerFactory.getLogger(IncubationQueue.class);
    public static int maxWaitTime = 60000;
    Map<T, T> AW;
    LinkedList<T> AX = new LinkedList();

    public IncubationQueue() {
        this(false);
    }

    public IncubationQueue(boolean bl) {
        this.AW = bl ? new IdentityHashMap() : new HashMap();
    }

    public synchronized void clear() {
        this.AX.clear();
        this.AW.clear();
        this.notifyAll();
    }

    public synchronized boolean contains(T t) {
        return this.AW.containsKey(t);
    }

    public synchronized T getNext() throws InterruptedException {
        long l2 = System.currentTimeMillis();
        while (this.AX.isEmpty()) {
            this.wait(1000L);
            if (System.currentTimeMillis() - l2 <= (long)maxWaitTime || !this.AX.isEmpty()) continue;
            try {
                throw new RuntimeException("stacktrace get");
            }
            catch (Exception exception) {
                logger.trace("Waited maximum allowed time in getNext()", exception);
                throw new InterruptedException("Maximum wait time reached, incubation queue still empty");
            }
        }
        return this.AX.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNextHatched() throws InterruptedException {
        while (true) {
            T t = this.getNext();
            this.waitUntilIncubated(t);
            IncubationQueue incubationQueue = this;
            synchronized (incubationQueue) {
                if (this.AX.getFirst() == t) {
                    return t;
                }
            }
        }
    }

    public synchronized T getNextHatchedIfAvailable() {
        if (this.AX.isEmpty()) {
            return null;
        }
        T t = this.AX.getFirst();
        if (this.AW.get(t) != null) {
            return null;
        }
        return t;
    }

    public synchronized boolean hatch(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (!this.AW.containsKey(t)) {
            throw new IllegalArgumentException(t + " is not incubating");
        }
        T t2 = this.AW.get(t);
        this.AW.put(t2, null);
        this.notifyAll();
        return t2 != null;
    }

    public synchronized void incubate(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.AW.containsKey(t)) {
            throw new IllegalArgumentException(t + " is already incubating");
        }
        this.AW.put(t, t);
        this.AX.addLast(t);
        this.notifyAll();
    }

    public synchronized boolean isEmpty() {
        return this.AW.isEmpty();
    }

    public synchronized boolean isHatched(T t) {
        if (!this.AW.containsKey(t)) {
            return false;
        }
        return this.AW.get(t) == null;
    }

    public synchronized boolean isIncubating(T t) {
        if (!this.AW.containsKey(t)) {
            return false;
        }
        return this.AW.get(t) != null;
    }

    public Iterator<T> iterator() {
        return this.AX.iterator();
    }

    public synchronized boolean nextIsHatched() {
        if (this.AX.isEmpty()) {
            return false;
        }
        T t = this.AX.getFirst();
        return this.AW.get(t) == null;
    }

    public synchronized T removeNextHatched() throws InterruptedException {
        T t = this.getNextHatched();
        this.AX.removeFirst();
        this.AW.remove(t);
        this.notifyAll();
        return t;
    }

    public synchronized T removeNextHatchedIfAvailable() {
        T t = this.getNextHatchedIfAvailable();
        if (t == null) {
            return null;
        }
        this.AX.removeFirst();
        this.AW.remove(t);
        this.notifyAll();
        return t;
    }

    public synchronized T removeNextHatchedUninterruptibly() {
        while (true) {
            try {
                return this.removeNextHatched();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized int size() {
        return this.AW.size();
    }

    public synchronized void waitUntilIncubated(T t) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        while (this.isIncubating(t)) {
            this.wait(1000L);
            if (System.currentTimeMillis() - l2 <= (long)maxWaitTime || !this.isIncubating(t)) continue;
            try {
                throw new RuntimeException("stacktrace get");
            }
            catch (Exception exception) {
                logger.trace("Waited maximum allowed time in waitUntilIncubated(...)", exception);
                throw new InterruptedException("Maximum wait time reached; didn't incubate in time");
            }
        }
    }
}

