/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.NodeClass;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributesUtil {
    private static final Map<NodeClass, Set<UnsignedInteger>> AI;

    public static Set<UnsignedInteger> getSupportedAttributes(NodeClass nodeClass) {
        if (nodeClass == null || NodeClass.Unspecified == nodeClass) {
            return Collections.emptySet();
        }
        return AI.get(nodeClass);
    }

    public static EnumSet<AttributeWriteMask.Options> getSupportedWriteAccess(UnsignedInteger ... unsignedIntegerArray) {
        EnumSet<AttributeWriteMask.Options> enumSet = EnumSet.noneOf(AttributeWriteMask.Options.class);
        if (unsignedIntegerArray != null) {
            for (UnsignedInteger unsignedInteger : unsignedIntegerArray) {
                if (Attributes.Value.equals(unsignedInteger)) continue;
                AttributeWriteMask.Options options = Attributes.getAttributeWriteMask(unsignedInteger);
                if (options == null) {
                    throw new IllegalArgumentException("Unrecognized attribute id: " + unsignedInteger);
                }
                enumSet.add(options);
            }
        }
        return enumSet;
    }

    public static boolean hasAccessToAttribute(AttributeWriteMask attributeWriteMask, UnsignedInteger unsignedInteger) {
        AttributeWriteMask.Options options = Attributes.getAttributeWriteMask(unsignedInteger);
        if (options == null) {
            return false;
        }
        return attributeWriteMask.contains(options);
    }

    public static boolean isValid(NodeClass nodeClass, UnsignedInteger unsignedInteger) {
        if (nodeClass == null || unsignedInteger == null) {
            return false;
        }
        Set<UnsignedInteger> set = AI.get(nodeClass);
        return set.contains(unsignedInteger);
    }

    public static boolean isValid(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            return false;
        }
        return unsignedInteger.compareTo(Attributes.NodeId) >= 0 && unsignedInteger.compareTo(Attributes.AccessLevelEx) <= 0;
    }

    public static String toString(UnsignedInteger unsignedInteger) {
        String string = Attributes.getAttributeName(unsignedInteger);
        if (string == null) {
            string = "<InvalidAttributeValue " + unsignedInteger + ">";
        }
        return string;
    }

    private static void a(Map<NodeClass, Set<UnsignedInteger>> map, UnsignedInteger unsignedInteger, Iterable<NodeClass> iterable) {
        for (NodeClass nodeClass : iterable) {
            map.get(nodeClass).add(unsignedInteger);
        }
    }

    private static void a(Map<NodeClass, Set<UnsignedInteger>> map, UnsignedInteger unsignedInteger, NodeClass ... nodeClassArray) {
        for (NodeClass nodeClass : nodeClassArray) {
            map.get(nodeClass).add(unsignedInteger);
        }
    }

    static {
        EnumMap<NodeClass, Set<UnsignedInteger>> enumMap = new EnumMap<NodeClass, Set<UnsignedInteger>>(NodeClass.class);
        EnumSet<NodeClass[]> enumSet = EnumSet.of(NodeClass.DataType, new NodeClass[]{NodeClass.Method, NodeClass.Object, NodeClass.ObjectType, NodeClass.ReferenceType, NodeClass.Variable, NodeClass.VariableType, NodeClass.View});
        for (NodeClass object : enumSet) {
            enumMap.put(object, new HashSet());
        }
        AttributesUtil.a(enumMap, Attributes.NodeId, enumSet);
        AttributesUtil.a(enumMap, Attributes.NodeClass, enumSet);
        AttributesUtil.a(enumMap, Attributes.BrowseName, enumSet);
        AttributesUtil.a(enumMap, Attributes.DisplayName, enumSet);
        AttributesUtil.a(enumMap, Attributes.Description, enumSet);
        AttributesUtil.a(enumMap, Attributes.WriteMask, enumSet);
        AttributesUtil.a(enumMap, Attributes.UserWriteMask, enumSet);
        AttributesUtil.a(enumMap, Attributes.IsAbstract, NodeClass.ReferenceType, NodeClass.ObjectType, NodeClass.VariableType, NodeClass.DataType);
        AttributesUtil.a(enumMap, Attributes.Symmetric, NodeClass.ReferenceType);
        AttributesUtil.a(enumMap, Attributes.InverseName, NodeClass.ReferenceType);
        AttributesUtil.a(enumMap, Attributes.ContainsNoLoops, NodeClass.View);
        AttributesUtil.a(enumMap, Attributes.EventNotifier, NodeClass.View, NodeClass.Object);
        AttributesUtil.a(enumMap, Attributes.Value, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(enumMap, Attributes.DataType, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(enumMap, Attributes.ValueRank, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(enumMap, Attributes.ArrayDimensions, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(enumMap, Attributes.AccessLevel, NodeClass.Variable);
        AttributesUtil.a(enumMap, Attributes.UserAccessLevel, NodeClass.Variable);
        AttributesUtil.a(enumMap, Attributes.MinimumSamplingInterval, NodeClass.Variable);
        AttributesUtil.a(enumMap, Attributes.Historizing, NodeClass.Variable);
        AttributesUtil.a(enumMap, Attributes.Executable, NodeClass.Method);
        AttributesUtil.a(enumMap, Attributes.UserExecutable, NodeClass.Method);
        AttributesUtil.a(enumMap, Attributes.DataTypeDefinition, NodeClass.DataType);
        AttributesUtil.a(enumMap, Attributes.RolePermissions, enumSet);
        AttributesUtil.a(enumMap, Attributes.UserRolePermissions, enumSet);
        AttributesUtil.a(enumMap, Attributes.AccessRestrictions, enumSet);
        AttributesUtil.a(enumMap, Attributes.AccessLevelEx, NodeClass.Variable);
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : enumMap.entrySet()) {
            hashMap.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        AI = Collections.unmodifiableMap(hashMap);
    }
}

