/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.utils.CurrentThreadExecutor;
import com.prosysopc.ua.stack.utils.IStatefulObject;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.StateListener;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractState<T, E extends Throwable>
implements IStatefulObject<T, E> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractState.class);
    private volatile T state = null;
    private final T AE;
    private volatile E AF;
    private final CopyOnWriteArrayList<StateListener<T>> AG = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<StateListener<T>> AH = new CopyOnWriteArrayList();
    private Object lock = new Object();

    public AbstractState(T t) {
        this.state = t;
        this.AE = null;
    }

    public AbstractState(T t, T t2) {
        this.state = t;
        this.AE = t2;
    }

    @Override
    public synchronized void addStateListener(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AG.add(stateListener);
    }

    @Override
    public synchronized void addStateNotifiable(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AH.add(stateListener);
    }

    @Override
    public E getError() {
        return this.AF;
    }

    @Override
    public synchronized T getState() {
        return this.state;
    }

    public boolean hasError() {
        return this.AF != null;
    }

    @Override
    public synchronized void removeStateListener(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AG.remove(stateListener);
    }

    @Override
    public synchronized void removeStateNotifiable(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AH.remove(stateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForState(Set<T> set) throws InterruptedException, E {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                this.lock.wait();
            }
            E e2 = this.getError();
            if (e2 != null) {
                throw e2;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForState(Set<T> set, long l2, TimeUnit timeUnit) throws InterruptedException, TimeoutException, E {
        long l3 = System.currentTimeMillis() + timeUnit.toMillis(l2);
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                long l4 = System.currentTimeMillis() - l3;
                if (l4 < 0L) {
                    throw new TimeoutException("timeout");
                }
                this.lock.wait(l4);
                E e2 = this.getError();
                if (e2 == null) continue;
                throw e2;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForStateUninterruptibly(Set<T> set) throws E {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            E e2 = this.getError();
            if (e2 != null) {
                throw e2;
            }
            return this.state;
        }
    }

    protected T attemptSetState(Set<T> set, T t) {
        if (set == null || t == null) {
            throw new IllegalArgumentException("null arg");
        }
        return this.setState(t, null, set);
    }

    protected void clearError() {
        this.AF = null;
    }

    protected boolean isStateTransitionAllowed(T t, T t2) {
        return true;
    }

    protected void onListenerException(RuntimeException runtimeException) {
        logger.trace("onListenerException", runtimeException);
    }

    protected void onStateTransition(T t, T t2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(E e2) {
        this.AF = e2;
        if (this.AE == null || !this.setState(this.AE)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected boolean setState(T t) {
        return this.setState(t, null, null) == t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T setState(T t, Executor executor, Set<T> set) {
        if (executor != null && executor instanceof CurrentThreadExecutor) {
            executor = null;
        }
        T t2 = null;
        Object StateType2 = null;
        Object object = this;
        synchronized (object) {
            t2 = this.state;
            StateType2 = t;
            if (t2 == StateType2) {
                return t;
            }
            if (set != null && !set.contains(this.state)) {
                return t;
            }
            if (!this.isStateTransitionAllowed(t2, StateType2)) {
                return t;
            }
            this.state = StateType2;
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.onStateTransition(t2, StateType2);
        object = t2;
        Object StateType3 = StateType2;
        if (executor == null) {
            for (StateListener<T> stateListener : this.AG) {
                try {
                    stateListener.onStateTransition(this, object, StateType3);
                }
                catch (RuntimeException runtimeException) {
                    this.onListenerException(runtimeException);
                }
            }
        } else {
            for (StateListener<T> stateListener : this.AG) {
                executor.execute(() -> {
                    try {
                        stateListener.onStateTransition(this, object, StateType3);
                    }
                    catch (RuntimeException runtimeException) {
                        this.onListenerException(runtimeException);
                    }
                });
            }
        }
        for (StateListener<T> stateListener : this.AH) {
            StackUtils.getBlockingWorkExecutor().execute(() -> {
                try {
                    stateListener.onStateTransition(this, object, StateType3);
                }
                catch (RuntimeException runtimeException) {
                    this.onListenerException(runtimeException);
                }
            });
        }
        return t;
    }

    protected void throwIfError() throws E {
        E e2 = this.AF;
        if (e2 != null) {
            throw e2;
        }
    }
}

