/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.InputMessage;
import com.prosysopc.ua.stack.utils.bytebuffer.IncubationBuffer;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureInputMessageBuilder
implements InputMessage {
    static Logger ru = LoggerFactory.getLogger(SecureInputMessageBuilder.class);
    MessageListener Am;
    Object An;
    TcpConnectionParameters zq;
    EncoderContext vn;
    Exception Ao;
    IncubationBuffer Ap;
    Runnable Aq;
    int Ar;
    IEncodeable uL;
    Integer As;
    Integer At;
    int messageType;
    boolean Au = true;
    boolean done;
    String vj;
    byte[] xM;
    byte[] xN;
    List<Integer> Av = new ArrayList<Integer>(1);
    AtomicInteger Aw;
    long Ax = 0L;

    public SecureInputMessageBuilder(Object object, MessageListener messageListener, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, AtomicInteger atomicInteger) {
        this.Am = messageListener;
        this.An = object;
        this.zq = tcpConnectionParameters;
        this.vn = encoderContext;
        this.Aw = atomicInteger;
        ru.debug("SecureInputMessageBuilder: expectedSequenceNumber={}", (Object)atomicInteger);
        this.Ap = new IncubationBuffer();
        int n2 = tcpConnectionParameters.maxRecvMessageSize == 0 ? Integer.MAX_VALUE : tcpConnectionParameters.maxRecvMessageSize;
        InputStreamReadable inputStreamReadable = new InputStreamReadable(this.Ap, n2);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        final BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
        binaryDecoder.setEncoderContext(encoderContext);
        this.Aq = new Runnable(){

            @Override
            public void run() {
                try {
                    IEncodeable iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
                    if (!(SecureInputMessageBuilder.this.An instanceof SecurityToken)) {
                        for (int i2 = 1; i2 < SecureInputMessageBuilder.this.Av.size(); ++i2) {
                            if (SecureInputMessageBuilder.this.Av.get(i2) == SecureInputMessageBuilder.this.Av.get(i2 - 1) - 1) continue;
                            String string = "Sequence numbers of chunks are not consecutive";
                            ru.info(string);
                            SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, string));
                            return;
                        }
                    }
                    SecureInputMessageBuilder.this.setMessage(iEncodeable);
                }
                catch (Exception exception) {
                    SecureInputMessageBuilder.this.setError(exception);
                }
                catch (StackOverflowError stackOverflowError) {
                    SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
                }
            }
        };
    }

    public synchronized void addChunk(final ByteBuffer byteBuffer) throws ServiceResultException {
        if (!this.Au) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Final chunk added to message builder");
        }
        this.Ax += (long)byteBuffer.remaining();
        ru.trace("Current message size via chunks: {}", (Object)this.Ax);
        if (this.Ax > (long)this.vn.getMaxMessageSize()) {
            ru.trace("Max message limits ({}) exceeded, at {}, stopping accepting chunks", (Object)this.vn.getMaxMessageSize(), (Object)this.Ax);
            throw new ServiceResultException(StatusCodes.Bad_RequestTooLarge);
        }
        final int n2 = this.Ar++;
        this.Av.add(null);
        int n3 = ChunkUtils.getMessageType(byteBuffer);
        int n4 = n3 & 0xFFFFFF;
        int n5 = n3 & 0xFF000000;
        if (n5 == 0x46000000) {
            this.Au = false;
        }
        final Integer n6 = this.Aw != null ? Integer.valueOf(this.Aw.getAndIncrement()) : null;
        ru.debug("addChunk: expectedSequenceNumber={}", (Object)n6);
        if (n5 == 0x41000000) {
            this.setMessage(null);
        }
        if (n2 == 0) {
            this.messageType = n4;
            this.At = ChunkUtils.getSecureChannelId(byteBuffer);
        }
        this.Ap.incubate(byteBuffer);
        if (!this.Au) {
            this.Ap.close();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SecureInputMessageBuilder.this.hasError()) {
                    return;
                }
                try {
                    ru.debug("token: {}", SecureInputMessageBuilder.this.An);
                    if (SecureInputMessageBuilder.this.An instanceof SecurityToken) {
                        new ChunkSymmDecryptVerifier(byteBuffer, (SecurityToken)SecureInputMessageBuilder.this.An).run();
                    } else if (SecureInputMessageBuilder.this.An instanceof SecurityConfiguration) {
                        ChunkAsymmDecryptVerifier chunkAsymmDecryptVerifier = new ChunkAsymmDecryptVerifier(byteBuffer, (SecurityConfiguration)SecureInputMessageBuilder.this.An);
                        chunkAsymmDecryptVerifier.run();
                        SecureInputMessageBuilder.this.vj = chunkAsymmDecryptVerifier.getSecurityPolicyUri();
                        SecureInputMessageBuilder.this.xM = chunkAsymmDecryptVerifier.getSenderCertificate();
                        SecureInputMessageBuilder.this.xN = chunkAsymmDecryptVerifier.getReceiverCertificateThumbprint();
                    }
                    int n22 = byteBuffer.position();
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    byteBuffer.position(n22);
                    int n3 = byteBuffer.position();
                    byteBuffer.position(n3 - 8);
                    int n4 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.Av.set(n2, n4);
                    if (n6 != null) {
                        if (n4 > n6) {
                            long l2 = System.currentTimeMillis();
                            long l3 = 100L;
                            while (n4 > n6 && System.currentTimeMillis() - l2 < l3) {
                                Thread.sleep(1L);
                            }
                        }
                        if (n6 != n4) {
                            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "chunkSequenceNumber=" + n4 + ", expectedSequenceNumber=" + n6);
                        }
                    }
                    int n5 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.w(n5);
                    int n62 = ChunkUtils.getSecureChannelId(byteBuffer);
                    if (n62 != SecureInputMessageBuilder.this.At) {
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "secureChannelId=" + n62 + ", expected Id");
                    }
                    byteBuffer.position(n3);
                    ru.trace("hatching chunk, requestId: {}", (Object)n5);
                    SecureInputMessageBuilder.this.Ap.hatch(byteBuffer);
                }
                catch (Exception exception) {
                    ru.info("addChunk: failed", exception);
                    SecureInputMessageBuilder.this.Ap.forceClose();
                    SecureInputMessageBuilder.this.setError(exception);
                }
            }
        };
        runnable.run();
        if (!this.Au) {
            this.Aq.run();
        }
    }

    public void close() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.Ap.forceClose();
    }

    @Override
    public Exception getError() {
        return this.Ao;
    }

    @Override
    public IEncodeable getMessage() {
        return this.uL;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.xN;
    }

    @Override
    public int getRequestId() {
        return this.As;
    }

    @Override
    public int getSecureChannelId() {
        return this.At;
    }

    public String getSecurityPolicyUri() {
        return this.vj;
    }

    public byte[] getSenderCertificate() {
        return this.xM;
    }

    @Override
    public List<Integer> getSequenceNumbers() {
        return this.Av;
    }

    @Override
    public Object getToken() {
        return this.An;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean moreChunksRequired() {
        return this.Au;
    }

    public void softClose() {
        this.Ap.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("token=" + this.An);
        stringBuilder.append(", secureChannelId=" + this.At);
        stringBuilder.append(", more=" + this.moreChunksRequired());
        return stringBuilder.toString();
    }

    private synchronized void w(int n2) throws ServiceResultException {
        if (this.As != null && this.As != n2) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        this.As = n2;
    }

    protected void fireComplete() {
        if (this.Am != null) {
            this.Am.onMessageComplete(this);
        }
    }

    protected synchronized boolean hasError() {
        return this.Ao != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(Exception exception) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                ru.info("setError[when done]", exception);
                return;
            }
            this.done = true;
            this.Ao = exception;
            this.Ap.forceClose();
        }
        this.fireComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(IEncodeable iEncodeable) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                return;
            }
            this.Ap.close();
            this.done = true;
            this.uL = iEncodeable;
        }
        this.fireComplete();
    }

    public static interface MessageListener {
        public void onMessageComplete(InputMessage var1);
    }
}

