/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.tcp.impl.AbstractUaTcpCommMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.MessageType;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;

public class MessageToChunks
implements Callable<ByteBuffer[]> {
    MessageType zv;
    IEncodeable uL;
    TcpConnectionParameters zq;
    EncoderContext vn;
    ChunkFactory zw;

    public MessageToChunks(IEncodeable iEncodeable, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, ChunkFactory chunkFactory, MessageType messageType) {
        if (iEncodeable == null || tcpConnectionParameters == null || chunkFactory == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.uL = iEncodeable;
        this.zq = tcpConnectionParameters;
        this.vn = encoderContext;
        this.zw = chunkFactory;
        this.zv = messageType;
    }

    @Override
    public ByteBuffer[] call() throws RuntimeServiceResultException {
        try {
            SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
            BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
            binaryEncoder.setEncoderContext(this.vn);
            this.a(binaryEncoder);
            int n2 = sizeCalculationOutputStream.getLength();
            if (n2 > this.zq.maxSendMessageSize && this.zq.maxSendMessageSize != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            ByteQueue byteQueue = new ByteQueue();
            byteQueue.order(ByteOrder.LITTLE_ENDIAN);
            byteQueue.setWriteLimit(n2);
            byteQueue.setByteBufferFactory(this.zw);
            byteQueue.setChunkSize(this.zw.maxPlaintextSize);
            ByteBufferArrayWriteable byteBufferArrayWriteable = new ByteBufferArrayWriteable(byteQueue);
            byteBufferArrayWriteable.order(ByteOrder.LITTLE_ENDIAN);
            BinaryEncoder binaryEncoder2 = new BinaryEncoder(byteBufferArrayWriteable);
            binaryEncoder2.setEncoderContext(this.vn);
            this.a(binaryEncoder2);
            ByteBuffer[] byteBufferArray = byteQueue.getChunks(n2);
            if (byteBufferArray.length > this.zq.maxRecvChunkCount && this.zq.maxRecvChunkCount != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            return byteBufferArray;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private void a(BinaryEncoder binaryEncoder) throws EncodingException {
        if (this.zv == MessageType.Encodeable) {
            InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder, (AbstractUaTcpCommMessage)this.uL);
        } else if (this.uL instanceof ServiceResponse) {
            InternalBinaryEncodingsHelper.putServiceResponse(binaryEncoder, (ServiceResponse)this.uL);
        } else {
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, (ServiceRequest)this.uL);
        }
    }
}

