/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.AbstractUaTcpCommMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalClientSideDecodingServiceFault;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.io.IConnection;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.transport.tcp.io.SequenceNumber;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnectionLimits;
import com.prosysopc.ua.stack.transport.tcp.io.TcpQuotas;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable2;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.OutputStreamWriteable;
import com.prosysopc.ua.types.opcua.Ids;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnection
implements IConnection {
    static Logger logger = LoggerFactory.getLogger(TcpConnection.class);
    private static int yK = 0;
    private static int yL = 60000;
    private static int yM = 0;
    private static int yN = 0;
    private static SocketFactory yO = new DefaultSocketFactory();
    private static ReverseConnectionProvider yP = new DefaultReverseConnectionProvider();
    private static ExecutorProvider yQ = new DefaultExecutorProvider();
    EncodeType encodeType;
    PrivKey rF;
    Cert rE;
    Cert rD;
    EndpointConfiguration fZ;
    EndpointDescription yR;
    CertificateValidator cr;
    InetSocketAddress addr;
    TcpConnectionLimits yS;
    TcpQuotas yT = TcpQuotas.DEFAULT_CLIENT_QUOTA;
    EnumSet<OpcTcpSettings.Flag> yn = EnumSet.noneOf(OpcTcpSettings.Flag.class);
    int connectTimeout = yL;
    int yo = yL;
    SecurityConfiguration securityConfiguration;
    final List<SecurityToken> yU = new CopyOnWriteArrayList<SecurityToken>();
    final Map<Integer, SecurityToken> yV = new ConcurrentHashMap<Integer, SecurityToken>();
    final Map<Integer, ByteString> yW = new ConcurrentHashMap<Integer, ByteString>();
    final Map<Integer, SequenceNumber> yX = new ConcurrentHashMap<Integer, SequenceNumber>();
    private SocketWrapper yY = null;
    int yZ;
    OutputStreamWriteable za;
    ReentrantLock lock = new ReentrantLock();
    b zb;
    EncoderContext ti;
    List<IConnection.IMessageListener> listeners = new CopyOnWriteArrayList<IConnection.IMessageListener>();
    List<IConnectionListener> zc = new CopyOnWriteArrayList<IConnectionListener>();
    ReverseConnectionListener gL = null;
    boolean zd = false;
    int yp = yM;

    public static int getDefaultHandshakeTimeout() {
        return yL;
    }

    public static int getDefaultReverseHelloAcceptTimeout() {
        return yM;
    }

    public static ExecutorProvider getExecutorProvider() {
        return yQ;
    }

    public static int getReceiveBufferSize() {
        return yK;
    }

    public static ReverseConnectionProvider getReverseConnectionProvider() {
        return yP;
    }

    public static int getSendBufferSize() {
        return yN;
    }

    public static SocketFactory getSocketFactory() {
        return yO;
    }

    public static void setDefaultHandshakeTimeout(int n2) {
        yL = n2;
    }

    public static void setDefaultReverseHelloAcceptTimeout(int n2) {
        yM = n2;
    }

    public static void setExecutorProvider(ExecutorProvider executorProvider) {
        yQ = executorProvider;
    }

    public static void setReceiveBufferSize(int n2) {
        yK = n2;
    }

    public static void setReverseConnectionProvider(ReverseConnectionProvider reverseConnectionProvider) {
        yP = reverseConnectionProvider;
    }

    public static void setSendBufferSize(int n2) {
        yN = n2;
    }

    public static void setSocketFactory(SocketFactory socketFactory) {
        yO = socketFactory;
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.zc.add(iConnectionListener);
    }

    @Override
    public void addMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.add(iMessageListener);
    }

    @Override
    public void close() {
        b b2 = this.zb;
        if (b2 != null) {
            b2.zk = true;
        }
        this.a(new ServiceResultException(StatusCodes.Bad_CommunicationError, "Socket closed by the user"));
    }

    @Override
    public void dispose() {
        this.lock.lock();
        try {
            this.close();
            this.rF = null;
            this.rE = null;
            this.rD = null;
            this.fZ = null;
            this.yR = null;
            this.cr = null;
            this.setSocket(null);
            this.ti = null;
            this.za = null;
            this.yT = null;
            this.yS = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.fZ;
    }

    public EndpointDescription getEndpointDescription() {
        return this.yR;
    }

    public int getHandshakeTimeout() {
        return this.yo;
    }

    public EncoderContext getMessageContext() {
        return this.ti;
    }

    public int getProtocolVersion() {
        return this.yZ;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.yp;
    }

    public SocketAddress getSocketAddress() {
        return this.addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.lock.lock();
        try {
            if (transportChannelSettings.getOpctcpSettings().getConnectTimeout() >= 0) {
                this.connectTimeout = transportChannelSettings.getOpctcpSettings().getConnectTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getHandshakeTimeout() >= 0) {
                this.yo = transportChannelSettings.getOpctcpSettings().getHandshakeTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout() >= 0) {
                this.yp = transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout();
            }
            this.addr = inetSocketAddress;
            if (transportChannelSettings instanceof ReverseTransportChannelSettings) {
                this.gL = ((ReverseTransportChannelSettings)transportChannelSettings).getReverseConnectionListener();
                this.zd = true;
            } else {
                this.gL = null;
                this.zd = false;
            }
            this.fZ = transportChannelSettings.getConfiguration().clone();
            this.yR = transportChannelSettings.getDescription().clone();
            this.cr = transportChannelSettings.getOpctcpSettings().getCertificateValidator();
            this.ti = encoderContext;
            this.rE = transportChannelSettings.getOpctcpSettings().getClientCertificate();
            this.rD = transportChannelSettings.getServerCertificate();
            this.rF = transportChannelSettings.getOpctcpSettings().getPrivKey();
            this.encodeType = EncodeType.Binary;
            if (this.fZ.getUseBinaryEncoding() != null && !this.fZ.getUseBinaryEncoding().booleanValue()) {
                this.encodeType = EncodeType.Xml;
            }
            this.yn = transportChannelSettings.getOpctcpSettings().getFlags();
            KeyPair keyPair = this.rE == null ? null : new KeyPair(this.rE, this.rF);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.yR.getSecurityPolicyUri());
            SecurityMode securityMode = new SecurityMode(securityPolicy, this.yR.getSecurityMode());
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, this.rD);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        try {
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
            this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Error while TcpConnection.initialize", illegalArgumentException);
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
        }
    }

    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected()) {
                return;
            }
            if (!this.zd) {
                try {
                    logger.info("{} Connecting", (Object)this.addr);
                    socketWrapper = yO.createSocket(this);
                    socketWrapper.setTcpNoDelay(true);
                    if (yK > 0) {
                        socketWrapper.setReceiveBufferSize(yK);
                    }
                    if (yN > 0) {
                        socketWrapper.setSendBufferSize(yN);
                    }
                    this.setSocket(socketWrapper);
                    if (this.yo > 0) {
                        socketWrapper.setSoTimeout(this.yo);
                    }
                    if (this.connectTimeout == 0) {
                        socketWrapper.connect(this.addr);
                    } else {
                        socketWrapper.connect(this.addr, this.connectTimeout);
                    }
                }
                catch (ConnectException connectException) {
                    logger.info(this.addr + " Connect failed", connectException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)connectException);
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
                }
                logger.debug("{} Socket connected", (Object)this.addr);
            } else {
                try {
                    try {
                        socketWrapper = yP.provideOpenReverseConnectionSocket(this);
                    }
                    catch (SocketException socketException) {
                        logger.info("ServerSocket.accept {} failed (or the socket was closed while waiting)", (Object)this.addr, (Object)socketException);
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)socketException, "ServerSocket.accept failed (or was closed, possibly due to a timeout)");
                    }
                    socketWrapper.setTcpNoDelay(true);
                    if (yK > 0) {
                        socketWrapper.setReceiveBufferSize(yK);
                    }
                    if (yN > 0) {
                        socketWrapper.setSendBufferSize(yN);
                    }
                    if (this.yo > 0) {
                        socketWrapper.setSoTimeout(this.yo);
                    }
                    this.setSocket(socketWrapper);
                    logger.debug("{} Socket connected", (Object)socketWrapper.getRemoteSocketAddress());
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
            }
            try {
                AbstractUaTcpCommMessage abstractUaTcpCommMessage;
                this.etx();
                OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(new BufferedOutputStream(socketWrapper.getOutputStream()));
                outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
                InputStreamReadable inputStreamReadable = new InputStreamReadable(new BufferedInputStream(socketWrapper.getInputStream()), Long.MAX_VALUE);
                inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
                binaryDecoder.setEncoderContext(this.ti);
                BinaryEncoder binaryEncoder = new BinaryEncoder(outputStreamWriteable);
                binaryEncoder.setEncoderContext(this.ti);
                if (this.zd) {
                    abstractUaTcpCommMessage = this.a(inputStreamReadable, binaryDecoder);
                    logger.debug("Got ReverseHello: {}", (Object)abstractUaTcpCommMessage);
                    if (((ReverseHello)abstractUaTcpCommMessage).getServerUri() == null || ((ReverseHello)abstractUaTcpCommMessage).getServerUri().length() > 4096) {
                        logger.error("ReverseHello did not contain ServerUri, or is too long, got:{}", (Object)((ReverseHello)abstractUaTcpCommMessage).getServerUri());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl() == null || ((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl().length() > 4096) {
                        logger.error("ReverseHello did not contain correct EndpointUrl, or is too long, got:{}", (Object)((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (this.gL != null && !this.gL.onConnect(((ReverseHello)abstractUaTcpCommMessage).getServerUri(), ((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl(), socketWrapper.getRemoteSocketAddress())) {
                        throw new ServiceResultException(StatusCodes.Bad_ConnectionClosed, "Reverse Connection rejected by the ReverseConnectionListener");
                    }
                    if (this.yR.getEndpointUrl() == null) {
                        this.yR.setEndpointUrl(((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl());
                    }
                }
                abstractUaTcpCommMessage = new Hello();
                ((Hello)abstractUaTcpCommMessage).setEndpointUrl(this.yR.getEndpointUrl());
                ((Hello)abstractUaTcpCommMessage).setMaxChunkCount(UnsignedInteger.valueOf(this.fZ.getMaxBufferSize() == null ? 65535L : (long)this.fZ.getMaxBufferSize().intValue()));
                ((Hello)abstractUaTcpCommMessage).setMaxMessageSize(UnsignedInteger.valueOf(this.ti.getMaxMessageSize()));
                ((Hello)abstractUaTcpCommMessage).setReceiveBufferSize(UnsignedInteger.valueOf(this.yT.maxBufferSize));
                ((Hello)abstractUaTcpCommMessage).setSendBufferSize(UnsignedInteger.valueOf(this.yT.maxBufferSize));
                ((Hello)abstractUaTcpCommMessage).setProtocolVersion(UnsignedInteger.valueOf(0L));
                if (this.yS != null) {
                    ((Hello)abstractUaTcpCommMessage).setProtocolVersion(UnsignedInteger.valueOf(this.yZ));
                    ((Hello)abstractUaTcpCommMessage).setMaxChunkCount(UnsignedInteger.valueOf(this.yS.maxRecvChunkCount));
                    ((Hello)abstractUaTcpCommMessage).setMaxMessageSize(UnsignedInteger.valueOf(this.yS.maxRecvMessageSize));
                    ((Hello)abstractUaTcpCommMessage).setSendBufferSize(UnsignedInteger.valueOf(this.yS.maxSendBufferSize));
                    ((Hello)abstractUaTcpCommMessage).setReceiveBufferSize(UnsignedInteger.valueOf(this.yS.maxRecvBufferSize));
                }
                logger.debug("Writing Hello: {}", (Object)abstractUaTcpCommMessage);
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder2 = new BinaryEncoder(sizeCalculationOutputStream);
                binaryEncoder2.setEncoderContext(this.ti);
                outputStreamWriteable.putInt(1179403592);
                InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder2, abstractUaTcpCommMessage);
                int n2 = sizeCalculationOutputStream.getLength() + 8;
                outputStreamWriteable.putInt(n2);
                InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder, abstractUaTcpCommMessage);
                outputStreamWriteable.flush();
                int n3 = -1;
                while (n3 == -1) {
                    try {
                        n3 = inputStreamReadable.getInt();
                    }
                    catch (EOFException eOFException) {
                        n3 = inputStreamReadable.getInt();
                    }
                }
                n2 = inputStreamReadable.getInt();
                if (n2 < 8 || n2 > 4096) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
                }
                if (n3 == 1179800133) {
                    binaryDecoder.getEncoderContext().setMaxStringLength(4096);
                    ErrorMessage errorMessage = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ErrorMessage.class);
                    throw new ServiceResultException(StatusCode.valueOf(errorMessage.getError()), errorMessage.getReason());
                }
                if (n3 != 1179337537) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n3 + ", expected " + 1179337537);
                }
                Acknowledge acknowledge = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, Acknowledge.class);
                logger.debug("Received Acknowledge: {}", (Object)acknowledge);
                if (acknowledge.getProtocolVersion().intValue() < ((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_ProtocolVersionUnsupported, "Version " + ((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue() + " requested, got " + acknowledge.getProtocolVersion());
                }
                this.yZ = Math.min(((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue(), acknowledge.getProtocolVersion().intValue());
                if (acknowledge.getMaxMessageSize().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxMessageSize(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getMaxChunkCount().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxChunkCount(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getReceiveBufferSize().longValue() > ((Hello)abstractUaTcpCommMessage).getReceiveBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.ReceiveBufferSize > Hello.ReceiveBufferSize");
                }
                if (acknowledge.getReceiveBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server recv buffer size < 8192");
                }
                if (acknowledge.getSendBufferSize().longValue() > ((Hello)abstractUaTcpCommMessage).getSendBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.SendBufferSize > Hello.SendBufferSize");
                }
                if (acknowledge.getSendBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server send buffer size < 8192");
                }
                this.yS = new TcpConnectionLimits();
                this.yS.maxSendBufferSize = (int)Math.min(acknowledge.getSendBufferSize().longValue(), Integer.MAX_VALUE);
                this.yS.maxRecvBufferSize = (int)Math.min(acknowledge.getReceiveBufferSize().longValue(), Integer.MAX_VALUE);
                this.yS.maxSendChunkCount = (int)Math.min(acknowledge.getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.yS.maxRecvChunkCount = (int)Math.min(((Hello)abstractUaTcpCommMessage).getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.yS.maxSendMessageSize = (int)Math.min(acknowledge.getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                this.yS.maxRecvMessageSize = (int)Math.min(((Hello)abstractUaTcpCommMessage).getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                socketWrapper.setSoTimeout(0);
                socketWrapper.setKeepAlive(true);
                if (this.zd) {
                    logger.info("Connected (reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                } else {
                    logger.info("Connected (non-reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                }
                for (IConnectionListener iConnectionListener : this.zc) {
                    iConnectionListener.onOpen();
                }
                logger.debug("Creating ReadThread");
                this.zb = new b(socketWrapper, binaryDecoder.getEncoderContext());
                this.zb.start();
                this.ti = binaryEncoder.getEncoderContext();
                this.za = outputStreamWriteable;
            }
            catch (IOException iOException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", iOException);
                throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
            }
            catch (ServiceResultException serviceResultException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", serviceResultException);
                throw serviceResultException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reconnect() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected() && !socketWrapper.isClosed()) {
                this.close();
            }
            this.open();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.zc.remove(iConnectionListener);
    }

    @Override
    public void removeMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.remove(iMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ServiceRequest serviceRequest, int n2, int n3) throws ServiceResultException {
        block16: {
            if (serviceRequest == null) {
                logger.warn("sendRequest: request=null");
            }
            boolean bl = serviceRequest instanceof OpenSecureChannelRequest;
            SocketWrapper socketWrapper = this.getSocket();
            logger.debug("sendRequest: socket={}", (Object)socketWrapper);
            try {
                ByteBuffer[] byteBufferArray;
                ByteBuffer[] byteBufferArray2;
                a a2;
                if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerNotConnected);
                }
                logger.debug("sendRequest: {} Sending Request rid:{}", (Object)n2, (Object)n3);
                logger.trace("sendrequest: request={}", (Object)serviceRequest);
                SecurityToken securityToken = null;
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
                binaryEncoder.setEncoderContext(this.ti);
                InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, serviceRequest);
                int n4 = sizeCalculationOutputStream.getLength();
                if (n2 != 0) {
                    securityToken = this.v(n2);
                }
                logger.debug("sendRequest: token={}", (Object)securityToken);
                SecurityMode securityMode = this.a(bl, serviceRequest, securityToken);
                int n5 = securityToken != null ? securityToken.getSecurityPolicy().getEncryptionKeySize() : 0;
                logger.debug("sendRequest: keySize={}", (Object)n5);
                ChunkFactory chunkFactory = this.a(bl, securityMode, n5);
                if (chunkFactory == null || (a2 = this.a(chunkFactory, n4, serviceRequest)) == null || !((byteBufferArray2 = a2.etz()) != null & (byteBufferArray = a2.etA()) != null)) break block16;
                try {
                    this.lock.lock();
                    try {
                        if (bl) {
                            ByteString byteString = ((OpenSecureChannelRequest)serviceRequest).getClientNonce();
                            this.yW.put(n3, byteString);
                            for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
                                boolean bl2 = i2 == byteBufferArray2.length - 1;
                                this.a(n2, n3, securityMode, byteBufferArray2[i2], byteBufferArray[i2], bl2);
                                byteBufferArray[i2] = null;
                                byteBufferArray2[i2] = null;
                            }
                        } else {
                            this.yV.put(n2, securityToken);
                            SequenceNumber sequenceNumber = this.yX.get(n2);
                            for (int i3 = 0; i3 < byteBufferArray2.length; ++i3) {
                                ByteBuffer byteBuffer = byteBufferArray2[i3];
                                ByteBuffer byteBuffer2 = byteBufferArray[i3];
                                boolean bl3 = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
                                int n6 = 1128747853;
                                if (bl3) {
                                    n6 = 1179079501;
                                }
                                if (serviceRequest instanceof CloseSecureChannelRequest) {
                                    n6 = 1179601987;
                                }
                                this.a(n3, securityToken, sequenceNumber, byteBuffer, byteBuffer2, n6);
                                byteBufferArray[i3] = null;
                                byteBufferArray2[i3] = null;
                            }
                        }
                        this.za.flush();
                    }
                    catch (IOException iOException) {
                        this.yW.remove(n3);
                        logger.info(this.addr + " Connect failed", iOException);
                        this.close();
                        throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.warn(String.format(Locale.ROOT, "sendRequest %s failed: socket=%s, asymm=%s", serviceRequest.getClass().getName(), socketWrapper, bl), runtimeException);
                throw runtimeException;
            }
        }
    }

    public void setHandshakeTimeout(int n2) {
        this.yo = n2;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.yp = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ServiceResultException serviceResultException) {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                return;
            }
            try {
                socketWrapper.close();
            }
            catch (IOException iOException) {
                logger.warn(this.addr + " Close error", iOException);
            }
            this.setSocket(null);
            this.yW.clear();
            logger.info(this.addr + " Closed");
        }
        finally {
            this.lock.unlock();
        }
        for (IConnectionListener iConnectionListener : this.zc) {
            iConnectionListener.onClosed(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private a a(ChunkFactory chunkFactory, int n2, ServiceRequest<?> serviceRequest) throws ServiceResultException {
        int n3;
        if (this.ti.getMaxMessageSize() != 0 && n2 > this.ti.getMaxMessageSize()) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxMessageSize " + this.ti.getMaxMessageSize() + " < " + n2);
            logger.warn("encodeMessage: failed", encodingException);
            throw encodingException;
        }
        int n4 = (n2 + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
        this.lock.lock();
        try {
            if (this.yS == null) {
                a a2 = null;
                return a2;
            }
            n3 = this.yS.maxSendChunkCount;
        }
        finally {
            this.lock.unlock();
        }
        if (n3 != 0 && n4 > n3) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        int n5 = n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n4];
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBufferArray[i2] = chunkFactory.allocate(n5);
            byteBufferArray2[i2] = chunkFactory.expandToCompleteChunk(byteBufferArray[i2]);
            n5 -= byteBufferArray[i2].remaining();
        }
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, int n2) {
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable2);
        binaryEncoder.setEncoderContext(this.ti);
        InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, serviceRequest);
        return new a(byteBufferArray2, byteBufferArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkFactory a(boolean bl, SecurityMode securityMode, int n2) throws ServiceResultException {
        int n3;
        MessageSecurityMode messageSecurityMode = securityMode.getMessageSecurityMode();
        this.lock.lock();
        try {
            if (this.yS == null) {
                ChunkFactory chunkFactory = null;
                return chunkFactory;
            }
            n3 = this.yS.maxSendBufferSize;
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            return new ChunkFactory.AsymmMsgChunkFactory(n3, this.securityConfiguration);
        }
        SecurityPolicy securityPolicy = securityMode.getSecurityPolicy();
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        SecurityAlgorithm securityAlgorithm2 = securityPolicy.getSymmetricSignatureAlgorithm();
        int n4 = CryptoUtil.getCipherBlockSize(securityAlgorithm, null);
        int n5 = CryptoUtil.getSignatureSize(securityAlgorithm2, null);
        return new ChunkFactory(n3, 8, 8, 8, n5, n4, messageSecurityMode, n2);
    }

    private SecurityMode a(boolean bl, ServiceRequest<?> serviceRequest, SecurityToken securityToken) {
        SecurityPolicy securityPolicy;
        MessageSecurityMode messageSecurityMode;
        if (bl) {
            messageSecurityMode = ((OpenSecureChannelRequest)serviceRequest).getSecurityMode();
            securityPolicy = this.securityConfiguration.getSecurityMode().getSecurityPolicy();
        } else {
            messageSecurityMode = securityToken.getMessageSecurityMode();
            securityPolicy = securityToken.getSecurityPolicy();
        }
        return new SecurityMode(securityPolicy, messageSecurityMode);
    }

    private SecurityToken v(int n2) throws ServiceResultException {
        this.etl();
        SecurityToken securityToken = null;
        logger.debug("tokens={}", (Object)this.yU);
        for (SecurityToken securityToken2 : this.yU) {
            if (securityToken2.getSecureChannelId() != n2 || securityToken != null && securityToken.getCreationTime() >= securityToken2.getCreationTime()) continue;
            securityToken = securityToken2;
        }
        logger.debug("getSecurityTokenToUse={}", (Object)securityToken);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_CommunicationError, "All security tokens have expired");
        }
        return securityToken;
    }

    private void etx() {
        int n2 = Math.min(this.fZ.getMaxMessageSize() != null ? this.fZ.getMaxMessageSize() : Integer.MAX_VALUE, this.yT.maxMessageSize);
        this.ti.setMaxMessageSize(n2);
        this.ti.setMaxArrayLength(this.fZ.getMaxArrayLength() != null ? this.fZ.getMaxArrayLength() : 0);
        this.ti.setMaxStringLength(this.fZ.getMaxStringLength() != null ? this.fZ.getMaxStringLength() : 0);
        this.ti.setMaxByteStringLength(this.fZ.getMaxByteStringLength() != null ? this.fZ.getMaxByteStringLength() : 0);
    }

    private void etl() {
        logger.debug("pruneInvalidTokens: tokens({})={}", (Object)this.yU.size(), (Object)this.yU);
        for (SecurityToken securityToken : this.yU) {
            if (securityToken.isValid()) continue;
            this.yU.remove(securityToken);
        }
    }

    private ReverseHello a(InputStreamReadable inputStreamReadable, BinaryDecoder binaryDecoder) throws IOException, ServiceResultException, DecodingException {
        int n2 = -1;
        while (n2 == -1) {
            try {
                n2 = inputStreamReadable.getInt();
            }
            catch (EOFException eOFException) {
                n2 = inputStreamReadable.getInt();
            }
        }
        int n3 = inputStreamReadable.getInt();
        if (n3 < 8 || n3 > 4096) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        if (n2 != 1178945618) {
            logger.error("Did not receive correct message type, expecting: {}, got: {}", (Object)1178945618, (Object)n2);
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n2 + ", expected " + 1178945618);
        }
        ReverseHello reverseHello = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ReverseHello.class);
        return reverseHello;
    }

    private void a(int n2, int n3, SecurityMode securityMode, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ServiceResultException, IOException {
        SequenceNumber sequenceNumber;
        byteBuffer.rewind();
        byteBuffer.putInt(bl ? 1179537487 : 1129205839);
        byteBuffer.position(8);
        byteBuffer.putInt(n2);
        byte[] byArray = securityMode.getSecurityPolicy().getEncodedPolicyUri();
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byArray = this.securityConfiguration.getEncodedLocalCertificate();
        byteBuffer.putInt(byArray == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        byteBuffer.putInt((byArray = this.securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        int n4 = (sequenceNumber = this.yX.get(n2)) == null ? 1 : sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n3);
        logger.debug("SecureChannelId={} SequenceNumber={}, RequestId={}", n2, n4, n3);
        try {
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, this.securityConfiguration).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.za.put(byteBuffer);
    }

    private void a(int n2, SecurityToken securityToken, SequenceNumber sequenceNumber, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n3) throws ServiceResultException, IOException {
        byteBuffer.rewind();
        byteBuffer.putInt(n3);
        byteBuffer.position(8);
        byteBuffer.putInt(securityToken.getSecureChannelId());
        byteBuffer.putInt(securityToken.getTokenId());
        int n4 = sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n2);
        try {
            new ChunkSymmEncryptSigner(byteBuffer, byteBuffer2, securityToken).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.za.put(byteBuffer);
    }

    protected SocketWrapper getSocket() {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.yY;
            return socketWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setSocket(SocketWrapper socketWrapper) {
        this.yY = socketWrapper;
    }

    class b
    extends Thread {
        SocketWrapper zj;
        EncoderContext ti;
        ServiceResultException lp;
        boolean zk;

        b(SocketWrapper socketWrapper, EncoderContext encoderContext) {
            super("TcpConnection/Read");
            this.lp = null;
            this.zk = false;
            this.setDaemon(true);
            this.zj = socketWrapper;
            this.ti = encoderContext;
        }

        @Override
        public void run() {
            block47: {
                try {
                    InputStreamReadable inputStreamReadable = new InputStreamReadable(new BufferedInputStream(this.zj.getInputStream()), Long.MAX_VALUE);
                    inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                    ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(256);
                    while (this.zj == TcpConnection.this.getSocket()) {
                        byte[] byArray;
                        int n2;
                        int n3;
                        int n4;
                        block48: {
                            Object object;
                            Object object2;
                            Object object3;
                            Object object4;
                            Object object5;
                            int n5;
                            arrayList.clear();
                            int n6 = 0;
                            int n7 = 0;
                            int n8 = 0;
                            n4 = 0;
                            n3 = 0;
                            do {
                                Object object6;
                                if (n7 > TcpConnection.this.yS.maxRecvChunkCount) {
                                    this.lp = new ServiceResultException("Recv chunk count exceeded (max = " + n7 + ")");
                                    logger.warn("{} Recv chunk count exceeded (max = {})", (Object)TcpConnection.this.addr, (Object)n7);
                                    break block47;
                                }
                                int n9 = inputStreamReadable.getInt();
                                n5 = n9 & 0xFFFFFF;
                                n8 = n9 & 0xFF000000;
                                if (n7 == 0) {
                                    n6 = n5;
                                } else if (n5 != n6) {
                                    this.lp = new ServiceResultException("Error, message type changed between chunks");
                                    logger.warn("{} Error, message type changed between chunks", (Object)TcpConnection.this.addr);
                                    break block47;
                                }
                                if (n5 != 5132367 && n5 != 4674381 && n9 != 1179800133) {
                                    this.lp = new ServiceResultException("Error, unknown message type " + String.format(Locale.ROOT, "0x%08x", n9));
                                    logger.warn("{} Error, unknown message type {}", (Object)TcpConnection.this.addr, (Object)String.format(Locale.ROOT, "0x%08x", n9));
                                    break block47;
                                }
                                int n10 = inputStreamReadable.getInt();
                                if (n10 > TcpConnection.this.yS.maxRecvBufferSize) {
                                    this.lp = new ServiceResultException("Error, chunk too large (max = " + TcpConnection.this.yS.maxRecvBufferSize + ")");
                                    logger.warn("{} Error, chunk too large (max = {})", (Object)TcpConnection.this.addr, (Object)TcpConnection.this.yS.maxRecvBufferSize);
                                    break block47;
                                }
                                object5 = ByteBuffer.allocate(n10);
                                ((ByteBuffer)object5).order(ByteOrder.LITTLE_ENDIAN);
                                ((ByteBuffer)object5).putInt(n9);
                                ((ByteBuffer)object5).putInt(n10);
                                inputStreamReadable.get((ByteBuffer)object5, n10 - 8);
                                if (n9 == 1179800133) {
                                    ServiceResultException serviceResultException;
                                    ((ByteBuffer)object5).position(8);
                                    BinaryDecoder binaryDecoder = new BinaryDecoder((ByteBuffer)object5);
                                    binaryDecoder.setEncoderContext(this.ti);
                                    ErrorMessage errorMessage = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ErrorMessage.class);
                                    this.lp = serviceResultException = new ServiceResultException(errorMessage.getError(), errorMessage.getReason());
                                    logger.warn(this.zj.getRemoteSocketAddress() + " Error", serviceResultException);
                                    break block47;
                                }
                                int n11 = ChunkUtils.getSecureChannelId((ByteBuffer)object5);
                                if (n7 == 0) {
                                    n3 = n11;
                                } else if (n3 != n11) {
                                    this.lp = new ServiceResultException("Error, SecureChannelId mismatch");
                                    logger.warn("{} Error, SecureChannelId mismatch", (Object)TcpConnection.this.addr);
                                    break block47;
                                }
                                if (n6 == 5132367) {
                                    try {
                                        String string = ChunkUtils.getSecurityPolicyUri((ByteBuffer)object5);
                                        object4 = SecurityPolicy.getSecurityPolicy(string);
                                        object6 = ChunkUtils.getByteString((ByteBuffer)object5);
                                        object3 = ChunkUtils.getByteString((ByteBuffer)object5);
                                        if (object4 != TcpConnection.this.securityConfiguration.getSecurityPolicy()) {
                                            this.lp = new ServiceResultException("Error, unexpected security policy in OpenSecureChannelResponse");
                                            logger.warn("{} Error, unexpected security policy in OpenSecureChannelResponse", (Object)TcpConnection.this.addr);
                                            break block47;
                                        }
                                        if (TcpConnection.this.securityConfiguration.getSecurityPolicy() != SecurityPolicy.NONE && !Arrays.equals((byte[])object3, TcpConnection.this.securityConfiguration.getEncodedLocalCertificateThumbprint())) {
                                            this.lp = new ServiceResultException("Error, certificate thumbprint mismatch");
                                            logger.warn("{} Error, certificate thumbprint mismatch", (Object)TcpConnection.this.addr);
                                            break block47;
                                        }
                                        object2 = null;
                                        if (object6 != null && ((Object)object6).length > 0) {
                                            try {
                                                object2 = new Cert(CertificateUtils.decodeX509Certificate((byte[])object6));
                                            }
                                            catch (CertificateException certificateException) {
                                                this.lp = new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Error, Invalid Remote Certificate");
                                                logger.warn(TcpConnection.this.addr + " Error, Invalid Remote Certificate", certificateException);
                                                break block47;
                                            }
                                        }
                                        if (TcpConnection.this.cr != null && (object = TcpConnection.this.cr.validateCertificate((Cert)object2)) != null && !((StatusCode)object).isGood()) {
                                            this.lp = new ServiceResultException((StatusCode)object, "Remote certificate not accepted");
                                            logger.info("{} Remote certificate not accepted: {}", (Object)TcpConnection.this.addr, object);
                                            break block47;
                                        }
                                        TcpConnection.this.securityConfiguration = new SecurityConfiguration(TcpConnection.this.securityConfiguration.getSecurityMode(), TcpConnection.this.securityConfiguration.getLocalCertificate2(), (Cert)object2);
                                        object = new ChunkAsymmDecryptVerifier((ByteBuffer)object5, TcpConnection.this.securityConfiguration);
                                        ((ChunkAsymmDecryptVerifier)object).run();
                                    }
                                    catch (ServiceResultException serviceResultException) {
                                        this.lp = serviceResultException;
                                        logger.warn(TcpConnection.this.addr + "", serviceResultException);
                                        break block47;
                                    }
                                }
                                if (n6 == 4674381) {
                                    int n12 = ChunkUtils.getTokenId((ByteBuffer)object5);
                                    object4 = null;
                                    logger.debug("tokens({})={}", (Object)TcpConnection.this.yU.size(), (Object)TcpConnection.this.yU);
                                    object6 = TcpConnection.this.yU.iterator();
                                    while (object6.hasNext()) {
                                        object3 = (SecurityToken)object6.next();
                                        if (((SecurityToken)object3).getTokenId() != n12 || ((SecurityToken)object3).getSecureChannelId() != n11) continue;
                                        object4 = object3;
                                    }
                                    logger.debug("token={}", object4);
                                    if (object4 == null) {
                                        this.lp = new ServiceResultException("Unexpected securityTokenId = " + n12);
                                        logger.warn("{} Unexpected securityTokenId = {}", (Object)TcpConnection.this.addr, (Object)n12);
                                        break block47;
                                    }
                                    if (!((SecurityToken)object4).isValid()) {
                                        this.lp = new ServiceResultException("SecurityToken " + n12 + " has timeouted");
                                        logger.warn("{} SecurityToken {} has timeouted", (Object)TcpConnection.this.addr, object4);
                                        break block47;
                                    }
                                    TcpConnection.this.yV.put(n11, (SecurityToken)object4);
                                    object6 = new ChunkSymmDecryptVerifier((ByteBuffer)object5, (SecurityToken)object4);
                                    ((ChunkSymmDecryptVerifier)object6).run();
                                    ((ByteBuffer)object5).position(24);
                                }
                                ((ByteBuffer)object5).position(((Buffer)object5).position() - 8);
                                int n13 = ((ByteBuffer)object5).getInt();
                                object4 = TcpConnection.this.yX.get(n3);
                                if (!(n6 != 4674381 && object4 == null || ((SequenceNumber)object4).testAndSetRecvSequencenumber(n13))) {
                                    this.lp = new ServiceResultException("Sequence number mismatch");
                                    logger.warn("{} Sequence number mismatch: {} vs. {}", TcpConnection.this.addr, ((SequenceNumber)object4).getRecvSequenceNumber(), n13);
                                    break block47;
                                }
                                n2 = ((ByteBuffer)object5).getInt();
                                if (n7 == 0) {
                                    n4 = n2;
                                } else if (n2 != n4) {
                                    this.lp = new ServiceResultException("Request id mismatch");
                                    logger.warn("{} Request id mismatch", (Object)TcpConnection.this.addr);
                                    break block47;
                                }
                                arrayList.add((ByteBuffer)object5);
                                ++n7;
                            } while (n8 == 0x43000000);
                            if (n8 == 0x41000000) continue;
                            ByteBufferArrayReadable byteBufferArrayReadable = new ByteBufferArrayReadable(arrayList.toArray(new ByteBuffer[arrayList.size()]));
                            byteBufferArrayReadable.order(ByteOrder.LITTLE_ENDIAN);
                            n5 = (int)byteBufferArrayReadable.getByteQueue().remaining();
                            byArray = new byte[n5];
                            byteBufferArrayReadable.getByteQueue().get(byArray);
                            object5 = new BinaryDecoder(byArray);
                            ((BinaryDecoder)object5).setEncoderContext(this.ti);
                            NodeId nodeId = object5.getNodeId(null);
                            NodeId nodeId2 = new NodeId(0, (UnsignedInteger)Ids.OpenSecureChannelResponse_DefaultBinary.getValue());
                            if (nodeId2.equals(nodeId)) {
                                object5 = new BinaryDecoder(byArray);
                                ((BinaryDecoder)object5).setEncoderContext(this.ti);
                                object4 = InternalBinaryEncodingsHelper.getServiceResponse((BinaryDecoder)object5);
                                OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)object4;
                                object3 = openSecureChannelResponse.getSecurityToken();
                                object2 = TcpConnection.this.yW.get(n4);
                                object = openSecureChannelResponse.getServerNonce();
                                int n14 = n3;
                                int n15 = ((ChannelSecurityToken)object3).getChannelId().intValue();
                                if (n15 != n14) {
                                    logger.warn("{} OpenSecureChannel, server sent two secureChannelIds {} and {} using {}", TcpConnection.this.addr, n14, n15, n14);
                                }
                                try {
                                    SecurityToken securityToken = new SecurityToken(TcpConnection.this.securityConfiguration, n14, ((ChannelSecurityToken)object3).getTokenId().intValue(), System.currentTimeMillis(), ((ChannelSecurityToken)object3).getRevisedLifetime().longValue(), (ByteString)object2, (ByteString)object);
                                    logger.debug("new token={}", (Object)securityToken);
                                    TcpConnection.this.yU.add(securityToken);
                                    if (TcpConnection.this.yX.containsKey(n14)) break block48;
                                    TcpConnection.this.yX.put(n14, new SequenceNumber());
                                }
                                catch (ServiceResultException serviceResultException) {
                                    this.lp = serviceResultException;
                                    logger.warn(TcpConnection.this.addr + " SecurityTokenError ", serviceResultException);
                                    break;
                                }
                            }
                        }
                        TcpConnection.this.yW.remove(n4);
                        final int n16 = n4;
                        n2 = n3;
                        yQ.get(TcpConnection.this).execute(new Runnable(){

                            @Override
                            public void run() {
                                IEncodeable iEncodeable;
                                BinaryDecoder binaryDecoder = new BinaryDecoder(byArray);
                                binaryDecoder.setEncoderContext(b.this.ti);
                                AtomicReference atomicReference = new AtomicReference();
                                binaryDecoder.setStructureFieldDecodeListener((fieldSpecification, object) -> {
                                    if (UaIds.ResponseHeader.equals(fieldSpecification.getDataTypeId()) && "ResponseHeader".equals(fieldSpecification.getName())) {
                                        atomicReference.compareAndSet(null, (ResponseHeader)object);
                                    }
                                });
                                try {
                                    iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
                                }
                                catch (DecodingException decodingException) {
                                    ResponseHeader object2 = (ResponseHeader)atomicReference.get();
                                    if (object2 == null) {
                                        logger.error("Decoding error for Message", decodingException);
                                        return;
                                    }
                                    iEncodeable = new InternalClientSideDecodingServiceFault(object2, decodingException);
                                }
                                for (IConnection.IMessageListener iMessageListener : TcpConnection.this.listeners) {
                                    iMessageListener.onMessage(n16, n2, iEncodeable);
                                }
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof SocketException) {
                        if (!this.zk) {
                            logger.info("{} Closed (unexpected)", (Object)TcpConnection.this.addr);
                            this.lp = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (unexpected)");
                        } else {
                            logger.info("{} Closed (expected)", (Object)TcpConnection.this.addr);
                            this.lp = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (expected)");
                        }
                    } else if (iOException instanceof EOFException) {
                        this.lp = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (graceful)");
                        logger.info("{} Closed (graceful)", (Object)TcpConnection.this.addr);
                    } else {
                        this.lp = StackUtils.toServiceResultException(iOException);
                        logger.warn(TcpConnection.this.addr + " Error", iOException);
                    }
                }
                catch (DecodingException decodingException) {
                    if (decodingException.getCause() != null && decodingException.getCause() instanceof EOFException) {
                        logger.info("{} Closed", (Object)TcpConnection.this.addr);
                    } else {
                        logger.warn(TcpConnection.this.addr + " Error", decodingException);
                    }
                    this.lp = decodingException;
                }
                catch (RuntimeServiceResultException runtimeServiceResultException) {
                    ServiceResultException serviceResultException = runtimeServiceResultException.getCause();
                    logger.warn(TcpConnection.this.addr + " Error", serviceResultException);
                    this.lp = serviceResultException;
                }
                catch (Exception exception) {
                    this.lp = new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)exception);
                    logger.error("Error in ReadThread", this.lp);
                }
                catch (StackOverflowError stackOverflowError) {
                    this.lp = new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)stackOverflowError);
                    logger.error("Error in ReadThread", this.lp);
                }
            }
            TcpConnection.this.a(this.lp);
        }
    }

    private class a {
        private ByteBuffer[] zh;
        private ByteBuffer[] zi;

        public a(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
            this.zh = byteBufferArray;
            this.zi = byteBufferArray2;
        }

        public ByteBuffer[] etz() {
            return this.zh;
        }

        public ByteBuffer[] etA() {
            return this.zi;
        }
    }

    public static interface SocketWrapper {
        public void close() throws IOException;

        public void connect(InetSocketAddress var1) throws IOException;

        public void connect(InetSocketAddress var1, int var2) throws IOException;

        public InputStream getInputStream() throws IOException;

        public SocketAddress getLocalSocketAddress();

        public OutputStream getOutputStream() throws IOException;

        public SocketAddress getRemoteSocketAddress();

        public boolean isClosed();

        public boolean isConnected();

        public void setKeepAlive(boolean var1) throws IOException;

        public void setReceiveBufferSize(int var1) throws IOException;

        public void setSendBufferSize(int var1) throws IOException;

        public void setSoTimeout(int var1) throws IOException;

        public void setTcpNoDelay(boolean var1) throws IOException;
    }

    public static interface SocketFactory {
        public SocketWrapper createSocket(TcpConnection var1) throws IOException;
    }

    public static interface ReverseConnectionProvider {
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection var1) throws IOException;
    }

    public static interface ExecutorProvider {
        public Executor get(TcpConnection var1);
    }

    public static class DelegatingSocketWrapper
    implements SocketWrapper {
        protected final Socket delegate;

        public DelegatingSocketWrapper(Socket socket) {
            this.delegate = socket;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress) throws IOException {
            this.delegate.connect(inetSocketAddress);
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress, int n2) throws IOException {
            this.delegate.connect(inetSocketAddress, n2);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.delegate.getLocalSocketAddress();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.delegate.getRemoteSocketAddress();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public boolean isConnected() {
            return this.delegate.isConnected();
        }

        @Override
        public void setKeepAlive(boolean bl) throws IOException {
            this.delegate.setKeepAlive(bl);
        }

        @Override
        public void setReceiveBufferSize(int n2) throws IOException {
            this.delegate.setReceiveBufferSize(n2);
        }

        @Override
        public void setSendBufferSize(int n2) throws IOException {
            this.delegate.setSendBufferSize(n2);
        }

        @Override
        public void setSoTimeout(int n2) throws IOException {
            this.delegate.setSoTimeout(n2);
        }

        @Override
        public void setTcpNoDelay(boolean bl) throws IOException {
            this.delegate.setTcpNoDelay(bl);
        }
    }

    public static class DefaultSocketFactory
    implements SocketFactory {
        @Override
        public SocketWrapper createSocket(TcpConnection tcpConnection) {
            return new DelegatingSocketWrapper(new Socket());
        }
    }

    public static class DefaultReverseConnectionProvider
    implements ReverseConnectionProvider {
        @Override
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection tcpConnection) throws IOException {
            final ServerSocket serverSocket = new ServerSocket();
            serverSocket.bind(tcpConnection.addr);
            logger.info("Opened ServerSocket at:{}, waiting ReverseHello connection", (Object)tcpConnection.addr);
            if (tcpConnection.yp > 0) {
                TimerUtil.getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException) {
                            logger.error("Could not close ServerSocket in timeout", iOException);
                        }
                    }
                }, tcpConnection.yp);
            }
            DelegatingSocketWrapper delegatingSocketWrapper = new DelegatingSocketWrapper(serverSocket.accept());
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                try {
                    delegatingSocketWrapper.delegate.close();
                }
                catch (Exception exception) {
                    logger.warn("Closing ReverseHello related ServerSocket failed and also closing the accepted connection failed", exception);
                }
                throw iOException;
            }
            logger.debug("ReverseHello ServerSocket {} closed.", (Object)tcpConnection.addr);
            return delegatingSocketWrapper;
        }
    }

    public static class DefaultExecutorProvider
    implements ExecutorProvider {
        @Override
        public Executor get(TcpConnection tcpConnection) {
            return StackUtils.getBlockingWorkExecutor();
        }
    }
}

