/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalClientSideDecodingServiceFault;
import com.prosysopc.ua.stack.transport.tcp.io.IConnection;
import com.prosysopc.ua.stack.transport.tcp.io.ITransportChannel;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnection;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannelTcp
implements IConnectionListener,
SecureChannel,
IConnection.IMessageListener,
ITransportChannel {
    static Logger logger = LoggerFactory.getLogger(SecureChannelTcp.class);
    private static final int[] yr = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 120, 120, 120};
    private static final double oJ = 0.1;
    @Deprecated
    public static boolean disableReconnectLogic = false;
    private EncoderContext ti;
    Executor executor = StackUtils.getBlockingWorkExecutor();
    int uX = -1;
    long ys;
    long yt;
    TransportChannelSettings yu;
    InetSocketAddress addr;
    AtomicInteger vb = new AtomicInteger(0);
    AtomicReference<IConnection> yv = new AtomicReference<Object>(null);
    Map<Integer, a> vk = new ConcurrentHashMap<Integer, a>();
    int yw = 0;
    TimerTask yx;
    boolean yy = false;
    Object yz = new Object();
    TimerTask yA;
    AtomicReference<TimerTask> vm = new AtomicReference<Object>(null);
    Timer vl;
    Runnable vq = new Runnable(){

        @Override
        public void run() {
            SecureChannelTcp.this.etn();
            long l2 = System.currentTimeMillis();
            for (a a2 : SecureChannelTcp.this.vk.values()) {
                if (l2 < a2.vu) continue;
                logger.warn("Request id={} timeouted {}ms elapsed. timeout at {}ms", a2.requestId, System.currentTimeMillis() - a2.vt, a2.vu - a2.vt);
                a2.vv.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                SecureChannelTcp.this.vk.remove(a2.requestId);
            }
            SecureChannelTcp.this.eto();
        }
    };
    private Runnable yB = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable = SecureChannelTcp.this.yB;
            synchronized (runnable) {
                try {
                    SecureChannelTcp.this.etv();
                }
                catch (ServiceResultException serviceResultException) {
                    logger.trace("failure while sendPendingRequestMessages", serviceResultException);
                }
            }
        }
    };
    Runnable yC = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SecureChannelTcp.this.yz;
            synchronized (object) {
                if (!SecureChannelTcp.this.yy) {
                    return;
                }
            }
            if (!SecureChannelTcp.this.isOpen()) {
                SecureChannelTcp.this.d(false);
                logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.uX);
                SecureChannelTcp.this.close();
                return;
            }
            try {
                logger.debug("{}: Error recovery reconnect", (Object)SecureChannelTcp.this.uX);
                if (SecureChannelTcp.this.etw() == null) {
                    throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
                }
                SecureChannelTcp.this.etw().open();
                SecureChannelTcp.this.c(true);
                SecureChannelTcp.this.d(false);
                SecureChannelTcp.this.executor.execute(SecureChannelTcp.this.yB);
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_TcpSecureChannelUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_SecureChannelTokenUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_NotFound)) {
                    logger.info(SecureChannelTcp.this.uX + ": The secure channel has been closed by the server", serviceResultException);
                    SecureChannelTcp.this.close();
                    return;
                }
                Object object2 = SecureChannelTcp.this.yz;
                synchronized (object2) {
                    ++SecureChannelTcp.this.yw;
                    long l2 = System.currentTimeMillis();
                    long l3 = SecureChannelTcp.this.yw >= yr.length ? (long)(yr[yr.length - 1] * 1000) : (long)(yr[SecureChannelTcp.this.yw] * 1000);
                    long l4 = (long)((double)SecureChannelTcp.this.yt * 1.25) + SecureChannelTcp.this.ys;
                    if (l2 + l3 > l4) {
                        logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.uX);
                        SecureChannelTcp.this.close();
                        return;
                    }
                    if (!disableReconnectLogic) {
                        SecureChannelTcp.this.yx = TimerUtil.schedule(SecureChannelTcp.this.vl, SecureChannelTcp.this.yC, SecureChannelTcp.this.executor, l2 + l3);
                    }
                }
            }
        }
    };
    private Runnable yD = new Runnable(){

        @Override
        public void run() {
            try {
                logger.debug("{} Renewing security token", (Object)SecureChannelTcp.this.uX);
                SecureChannelTcp.this.c(true);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error(SecureChannelTcp.this.uX + " Failed to renew security token. ", serviceResultException);
            }
        }
    };

    @Override
    public void close() {
        Cloneable cloneable;
        this.d(false);
        Object object = this.yA;
        this.yA = null;
        if (object != null) {
            ((TimerTask)object).cancel();
        }
        if ((object = this.etw()) != null) {
            cloneable = new CloseSecureChannelRequest();
            try {
                this.serviceRequest((ServiceRequest)cloneable);
            }
            catch (ServiceResultException serviceResultException) {
                // empty catch block
            }
            if (this.uX != -1) {
                logger.info("{} Closed", (Object)this.uX);
            }
            this.uX = -1;
            object.close();
            object.removeMessageListener(this);
            object.removeConnectionListener(this);
            object.dispose();
            this.setTransportChannel(null);
        }
        this.etn();
        cloneable = new ArrayList<a>(this.vk.values());
        logger.debug("requests.clear()");
        this.vk.clear();
        if (!cloneable.isEmpty()) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
            Iterator iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                a a2 = (a)iterator.next();
                a2.vv.setError(serviceResultException);
            }
        }
    }

    @Override
    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.close();
                }
                finally {
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public void dispose() {
        this.close();
        this.yv = null;
        this.yu = null;
        this.addr = null;
        this.vk = null;
        this.vl = null;
    }

    @Override
    public String getConnectURL() {
        return this.getEndpointDescription().getEndpointUrl();
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        if (this.yu == null) {
            return null;
        }
        return this.yu.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        if (this.yu == null) {
            return null;
        }
        return this.yu.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.ti;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.getEndpointDescription().getSecurityMode();
    }

    @Override
    public int getOperationTimeout() {
        Integer n2 = this.yu.getConfiguration().getOperationTimeout();
        return n2 == null ? 0 : n2;
    }

    @Override
    public int getSecureChannelId() {
        return this.uX;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        try {
            return SecurityPolicy.getSecurityPolicy(this.getEndpointDescription().getSecurityPolicyUri());
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    @Override
    public EnumSet<ITransportChannel.TransportChannelFeature> getSupportedFeatures() {
        return EnumSet.of(ITransportChannel.TransportChannelFeature.open, new ITransportChannel.TransportChannelFeature[]{ITransportChannel.TransportChannelFeature.openAsync, ITransportChannel.TransportChannelFeature.close, ITransportChannel.TransportChannelFeature.closeAync, ITransportChannel.TransportChannelFeature.sendRequest, ITransportChannel.TransportChannelFeature.sendRequestAsync});
    }

    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        if (this.uX != -1) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Cannot reconfigure already opened secure channel");
        }
        this.yu = transportChannelSettings.clone();
        this.addr = inetSocketAddress;
        this.ti = encoderContext;
        this.yx = null;
        this.yw = 0;
        this.vl = TimerUtil.getTimer();
        String string = transportChannelSettings.getDescription().getEndpointUrl();
        if (string != null && !string.isEmpty() && !"opc.tcp".equals(UriUtil.getTransportProtocol(string))) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, "The protocol is not supported by the this SecureChannelTcp");
        }
        this.setTransportChannel(new TcpConnection());
        this.etw().initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        this.etw().addConnectionListener(this);
        this.etw().addMessageListener(this);
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        logger.debug("initialize: url={}, settings: {}", (Object)string, (Object)transportChannelSettings);
        InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
        this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
    }

    @Override
    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    @Override
    public boolean isOpen() {
        if (this.uX == -1) {
            return false;
        }
        long l2 = (long)((double)this.yt * 1.25) + this.ys;
        long l3 = System.currentTimeMillis();
        return l2 > l3;
    }

    @Override
    public void onClosed(ServiceResultException serviceResultException) {
        StatusCode statusCode;
        if (this.uX == -1) {
            return;
        }
        StatusCode statusCode2 = statusCode = serviceResultException == null ? null : serviceResultException.getStatusCode();
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.d(true);
        } else {
            if (serviceResultException == null) {
                serviceResultException = new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            while (!this.vk.isEmpty()) {
                ArrayList<a> arrayList = new ArrayList<a>(this.vk.values());
                for (a a2 : arrayList) {
                    a2.vv.setError(serviceResultException);
                }
                this.vk.values().removeAll(arrayList);
            }
            this.d(false);
        }
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.d(true);
        }
        boolean bl = serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_ConnectionClosed);
        this.d(bl);
    }

    @Override
    public void onMessage(int n2, int n3, IEncodeable iEncodeable) {
        if (n3 != this.uX) {
            return;
        }
        a a2 = this.vk.remove(n2);
        if (a2 == null) {
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                ServiceFault serviceFault;
                ServiceFault serviceFault2 = serviceFault = iEncodeable instanceof ServiceFault ? (ServiceFault)iEncodeable : null;
                if (serviceFault != null && serviceFault.getResponseHeader().getServiceResult().equals(StatusCode.valueOf(StatusCodes.Bad_TooManyPublishRequests))) {
                    logger.info("ServiceFault={}", (Object)serviceFault);
                } else {
                    logger.warn("{} Unidentified message, RequestId={}, type={}!", n3, n2, iEncodeable.getClass().getSimpleName());
                    if (serviceFault != null) {
                        logger.warn("ServiceFault={}", (Object)serviceFault);
                    }
                }
            }
            return;
        }
        if (iEncodeable instanceof ServiceFault) {
            if (iEncodeable instanceof InternalClientSideDecodingServiceFault) {
                InternalClientSideDecodingServiceFault internalClientSideDecodingServiceFault = (InternalClientSideDecodingServiceFault)iEncodeable;
                a2.vv.setError(new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)internalClientSideDecodingServiceFault.getDecodingException(), "Client-side DecodingException happened while decoding the server reponse"));
            } else {
                a2.vv.setError(new ServiceFaultException((ServiceFault)iEncodeable));
            }
        } else {
            try {
                a2.vv.setResult(iEncodeable);
            }
            catch (ClassCastException classCastException) {
                logger.error("onMessage: Cannot set result", classCastException);
            }
        }
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void open() throws ServiceResultException {
        logger.debug("open");
        if (this.uX == -1) {
            try {
                this.etw().open();
            }
            catch (ServiceResultException serviceResultException) {
                logger.warn("Connection failed: {}", (Object)serviceResultException.getMessage());
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_CommunicationError)) {
                    logger.warn("Bad_CommunicationError: Retrying");
                    this.etw().open();
                }
                throw serviceResultException;
            }
            this.c(false);
        }
    }

    @Override
    public AsyncResult<SecureChannel> openAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        if (this.uX != -1) {
            asyncResultImpl.setResult(this);
            return asyncResultImpl;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.open();
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
                catch (ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceFaultException, ServiceResultException {
        long l2 = this.getRequestTimeout(serviceRequest);
        return this.serviceRequest(serviceRequest, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest, long l2) throws ServiceFaultException, ServiceResultException {
        int n2 = 0;
        while (!this.isOpen()) {
            try {
                if (n2++ > 100) {
                    throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        a<T> a2 = this.a(serviceRequest, l2);
        a2.vv = new AsyncResultImpl();
        this.vk.put(a2.requestId, a2);
        logger.debug("serviceRequest: requests.size={}", (Object)this.vk.size());
        try {
            Object object;
            try {
                object = this.etw();
                if (object != null) {
                    object.sendRequest(serviceRequest, this.uX, a2.requestId);
                }
                logger.debug("serviceRequest: Message sent, requestId={} secureChannelId={}", (Object)a2.requestId, (Object)this.uX);
                logger.trace("serviceRequest: message={}", (Object)serviceRequest);
            }
            catch (ServiceResultException serviceResultException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("serviceRequest: While sending requestId=" + a2.requestId + ", secureChannelId=" + this.uX + ", message=" + serviceRequest, serviceResultException);
                }
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    a2.yJ = serviceRequest;
                    this.executor.execute(this.yB);
                }
                throw serviceResultException;
            }
            if (serviceRequest instanceof CloseSecureChannelRequest) {
                object = null;
                return (T)object;
            }
            if (l2 == 0L) {
                object = (ServiceResponse)a2.vv.waitForResult();
            } else {
                long l3 = a2.vu - System.currentTimeMillis();
                object = (ServiceResponse)a2.vv.waitForResult(l3, TimeUnit.MILLISECONDS);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Response: {}", object);
            } else {
                logger.debug("Response: {}", (Object)object.getClass().getSimpleName());
            }
            ResponseHeader responseHeader = object.getResponseHeader();
            StatusCode statusCode = responseHeader.getServiceResult();
            if (statusCode.isBad()) {
                logger.debug("BAD response: {}", (Object)statusCode);
                throw new ServiceFaultException(new ServiceFault(responseHeader));
            }
            Object object2 = object;
            return (T)object2;
        }
        finally {
            this.vk.remove(a2.requestId);
        }
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        long l2 = this.getRequestTimeout(serviceRequest);
        return this.serviceRequestAsync(serviceRequest, l2);
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest, long l2) {
        AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        if (!this.isOpen()) {
            asyncResultImpl.setError(new ServiceResultException(StatusCodes.Bad_SecureChannelClosed));
            return asyncResultImpl;
        }
        a<T> a2 = this.a(serviceRequest, l2);
        a2.vv = asyncResultImpl;
        a2.yJ = serviceRequest;
        this.vk.put(a2.requestId, a2);
        logger.debug("serviceRequestAsync: requests.size={}", (Object)this.vk.size());
        if (l2 != 0L) {
            this.eto();
        }
        this.executor.execute(this.yB);
        return asyncResultImpl;
    }

    @Override
    public void setOperationTimeout(int n2) {
        this.yu.getConfiguration().setOperationTimeout(n2);
    }

    public String toString() {
        return "SecureChannel " + this.uX + " " + (this.isOpen() ? "open" : "closed");
    }

    private void etn() {
        TimerTask timerTask = this.vm.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    private void c(boolean bl) throws ServiceResultException {
        IConnection iConnection = this.etw();
        logger.debug("createSecureChannel: renew={} channel={}", (Object)bl, (Object)iConnection);
        if (iConnection == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
        }
        long l2 = System.currentTimeMillis();
        int n2 = this.vb.incrementAndGet();
        logger.debug("createSecureChannel: requestId={}", (Object)n2);
        OpenSecureChannelRequest openSecureChannelRequest = new OpenSecureChannelRequest();
        SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.yu.getDescription().getSecurityPolicyUri());
        ByteString byteString = CryptoUtil.createNonce(securityPolicy.getSecureChannelNonceLength());
        Integer n3 = this.yu.getConfiguration().getSecurityTokenLifetime();
        if (n3 == null) {
            n3 = 3600000;
        }
        logger.debug("tokenLifetime: {}", (Object)n3);
        openSecureChannelRequest.setClientNonce(byteString);
        openSecureChannelRequest.setClientProtocolVersion(UnsignedInteger.valueOf(0L));
        openSecureChannelRequest.setRequestedLifetime(UnsignedInteger.valueOf(n3.intValue()));
        openSecureChannelRequest.setRequestType(bl ? SecurityTokenRequestType.Renew : SecurityTokenRequestType.Issue);
        openSecureChannelRequest.setSecurityMode(this.yu.getDescription().getSecurityMode());
        int n4 = bl ? this.uX : 0;
        final Semaphore semaphore = new Semaphore(0);
        final ServiceResultException[] serviceResultExceptionArray = new ServiceResultException[1];
        final IEncodeable[] iEncodeableArray = new IEncodeable[1];
        final int[] nArray = new int[1];
        final int n5 = n2;
        IConnection.IMessageListener iMessageListener = new IConnection.IMessageListener(){

            @Override
            public void onMessage(int n2, int n3, IEncodeable iEncodeable) {
                if (n2 != n5) {
                    return;
                }
                iEncodeableArray[0] = iEncodeable;
                nArray[0] = n3;
                semaphore.release(10);
            }
        };
        IConnectionListener iConnectionListener = new IConnectionListener(){

            @Override
            public void onClosed(ServiceResultException serviceResultException) {
                if (serviceResultException == null) {
                    serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError, "Connection Closed");
                }
                serviceResultExceptionArray[0] = serviceResultException;
                semaphore.release(10);
            }

            @Override
            public void onOpen() {
            }
        };
        iConnection.addConnectionListener(iConnectionListener);
        iConnection.addMessageListener(iMessageListener);
        try {
            iConnection.sendRequest(openSecureChannelRequest, n4, n2);
            try {
                long l3 = this.getOperationTimeout();
                if (l3 > 0L) {
                    long l4 = (System.currentTimeMillis() - l2) / 1000L;
                    long l5 = l3 - l4;
                    semaphore.tryAcquire(1, l5, TimeUnit.MILLISECONDS);
                } else {
                    semaphore.acquire();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (serviceResultExceptionArray[0] != null) {
                throw serviceResultExceptionArray[0];
            }
            IEncodeable iEncodeable = iEncodeableArray[0];
            if (iEncodeable == null) {
                throw new ServiceResultException(StatusCodes.Bad_Timeout);
            }
            if (iEncodeable instanceof ServiceFault) {
                ServiceFaultException serviceFaultException = new ServiceFaultException((ServiceFault)iEncodeable);
                logger.error(nArray + ": CreateSecureChannel Fault", serviceFaultException);
                throw serviceFaultException;
            }
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Unexpected result " + iEncodeable.getClass().getName() + " OpenSecureChannelResponse expected");
            }
            OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)iEncodeable;
            ChannelSecurityToken channelSecurityToken = openSecureChannelResponse.getSecurityToken();
            this.uX = channelSecurityToken.getChannelId().intValue();
            if (bl) {
                logger.debug("{} Secure channel renewed, SecureChannelId={}, TokenId={}", this.uX, this.uX, channelSecurityToken.getTokenId().longValue());
            } else {
                logger.debug("{} Secure channel opened, SecureChannelId={}, TokenId={}", this.uX, this.uX, channelSecurityToken.getTokenId().longValue());
            }
            if (bl) {
                this.uX = n4;
            }
            long l6 = System.currentTimeMillis();
            this.ys = l2 / 2L + l6 / 2L;
            this.yt = channelSecurityToken.getRevisedLifetime().longValue();
            TimerTask timerTask = this.yA;
            this.yA = null;
            if (timerTask != null) {
                timerTask.cancel();
            }
            long l7 = channelSecurityToken.getRevisedLifetime().longValue();
            logger.debug("RevisedLifetime: {}", (Object)l7);
            this.yA = TimerUtil.schedule(this.vl, this.yD, this.executor, l6 + (long)((double)l7 * 0.75));
        }
        catch (ServiceResultException serviceResultException) {
            throw serviceResultException;
        }
        finally {
            iConnection.removeConnectionListener(iConnectionListener);
            iConnection.removeMessageListener(iMessageListener);
        }
    }

    private a ett() {
        long l2 = Long.MAX_VALUE;
        a a2 = null;
        logger.debug("getNextTimeoutingPendingRequest: requests.size={}", (Object)this.vk.size());
        for (a a3 : this.vk.values()) {
            if (l2 <= a3.vu) continue;
            l2 = a3.vu;
            a2 = a3;
        }
        return a2;
    }

    private a etu() {
        for (a a2 : this.vk.values()) {
            if (a2.yJ == null) continue;
            return a2;
        }
        return null;
    }

    private <T extends ServiceResponse> a<T> a(ServiceRequest<T> serviceRequest, long l2) {
        a a2 = new a();
        a2.requestId = this.vb.incrementAndGet();
        a2.vt = System.currentTimeMillis();
        a2.vu = l2 == 0L ? Long.MAX_VALUE : (long)((double)a2.vt + (double)l2 * 1.1);
        return a2;
    }

    private void eto() {
        a a2 = this.ett();
        if (a2 == null) {
            this.etn();
        } else {
            TimerTask timerTask = this.vm.get();
            if (timerTask == null || timerTask.scheduledExecutionTime() > a2.vu) {
                this.etn();
                timerTask = TimerUtil.schedule(this.vl, this.vq, this.executor, a2.vu);
                if (!this.vm.compareAndSet(null, timerTask)) {
                    timerTask.cancel();
                }
            }
        }
    }

    private void etv() throws ServiceResultException {
        if (!this.isOpen()) {
            return;
        }
        a a2 = null;
        while ((a2 = this.etu()) != null) {
            IEncodeable iEncodeable = a2.yJ;
            a2.yJ = null;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - a2.vt;
            if (l2 > a2.vu) {
                logger.debug("Request id={} timeouted {}ms elapsed. timeout at {} ms", a2.requestId, l3, a2.vu - a2.vt);
                this.vk.remove(a2.requestId);
                a2.vv.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                continue;
            }
            if (iEncodeable == null) continue;
            try {
                logger.debug("sendPendingRequestMessages: requestId={}", (Object)a2.requestId);
                IConnection iConnection = this.etw();
                if (iConnection == null) continue;
                iConnection.sendRequest((ServiceRequest)iEncodeable, this.uX, a2.requestId);
            }
            catch (EncodingException encodingException) {
                this.vk.remove(a2.requestId);
                a2.vv.setError(encodingException);
            }
            catch (ServiceResultException serviceResultException) {
                StatusCode statusCode = serviceResultException.getStatusCode();
                if (statusCode.isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    a2.yJ = iEncodeable;
                    continue;
                }
                a2.vv.setError(serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(boolean bl) {
        Object object = this.yz;
        synchronized (object) {
            if (this.yy == bl) {
                return;
            }
            if (bl) {
                logger.info("{}: Error recovery = true", (Object)this.uX);
                this.yy = true;
                this.yw = 0;
                if (!disableReconnectLogic) {
                    long l2 = System.currentTimeMillis();
                    this.yx = TimerUtil.schedule(this.vl, this.yC, this.executor, l2 + (long)yr[0]);
                }
            } else {
                logger.info("{}: Error recovery = false", (Object)this.uX);
                this.yy = false;
                this.yw = 0;
                this.yx.cancel();
                this.yx = null;
            }
        }
    }

    protected long getRequestTimeout(ServiceRequest serviceRequest) {
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)this.getOperationTimeout();
        return l2;
    }

    protected void setTransportChannel(IConnection iConnection) {
        this.yv.set(iConnection);
    }

    IConnection etw() {
        return this.yv.get();
    }

    static class a<T extends ServiceResponse> {
        long vt = System.currentTimeMillis();
        long vu;
        int requestId;
        AsyncResultImpl<T> vv;
        IEncodeable yJ;

        a() {
        }
    }
}

