/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;

public class OpcTcpSettings
implements Cloneable {
    PrivKey ym;
    Cert rE;
    CertificateValidator cr;
    EnumSet<Flag> yn = EnumSet.noneOf(Flag.class);
    int yo = -1;
    int connectTimeout = -1;
    int yp = -1;
    int vh = 0;

    public OpcTcpSettings clone() {
        OpcTcpSettings opcTcpSettings = new OpcTcpSettings();
        opcTcpSettings.setClientCertificate(this.rE);
        opcTcpSettings.setCertificateValidator(this.cr);
        opcTcpSettings.setPrivKey(this.ym);
        opcTcpSettings.yn = this.yn.clone();
        opcTcpSettings.setConnectTimeout(this.connectTimeout);
        opcTcpSettings.setHandshakeTimeout(this.yo);
        opcTcpSettings.setReverseHelloAcceptTimeout(this.yp);
        return opcTcpSettings;
    }

    public CertificateValidator getCertificateValidator() {
        return this.cr;
    }

    public Cert getClientCertificate() {
        return this.rE;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public EnumSet<Flag> getFlags() {
        return this.yn;
    }

    public int getHandshakeTimeout() {
        return this.yo;
    }

    public int getMaxConnections() {
        return this.vh;
    }

    public PrivKey getPrivKey() {
        return this.ym;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.yp;
    }

    public void readFrom(OpcTcpSettings opcTcpSettings) {
        if (opcTcpSettings.rE != null) {
            this.rE = opcTcpSettings.rE;
        }
        if (opcTcpSettings.cr != null) {
            this.cr = opcTcpSettings.cr;
        }
        if (opcTcpSettings.ym != null) {
            this.ym = opcTcpSettings.ym;
        }
        this.yn = opcTcpSettings.yn;
        this.yp = opcTcpSettings.yp;
        this.yo = opcTcpSettings.yo;
        this.connectTimeout = opcTcpSettings.connectTimeout;
        this.vh = opcTcpSettings.vh;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.cr = certificateValidator;
    }

    public void setClientCertificate(Cert cert) {
        this.rE = cert;
    }

    public void setClientCertificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.rE = new Cert(x509Certificate);
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public void setFlags(EnumSet<Flag> enumSet) {
        this.yn = enumSet;
    }

    public void setHandshakeTimeout(int n2) {
        this.yo = n2;
    }

    public void setMaxConnections(int n2) {
        this.vh = n2;
    }

    public void setPrivKey(PrivKey privKey) {
        this.ym = privKey;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.yp = n2;
    }

    public static enum Flag {
        MultiThread;

    }
}

