/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import javax.crypto.Mac;

public class SecurityToken {
    private SecurityConfiguration securityConfiguration;
    private int ya;
    private int uX;
    private long yb;
    private long yc;
    private ByteString yd;
    private ByteString ye;
    private byte[] yf;
    private byte[] yg;
    private byte[] yh;
    private byte[] yi;
    private byte[] yj;
    private byte[] yk;

    public SecurityToken(SecurityConfiguration securityConfiguration, int n2, int n3, long l2, long l3, ByteString byteString, ByteString byteString2) throws ServiceResultException {
        if (securityConfiguration == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.uX = n2;
        this.securityConfiguration = securityConfiguration;
        this.ya = n3;
        this.yc = l3;
        this.yb = l2;
        this.yd = byteString;
        this.ye = byteString2;
        boolean bl = securityConfiguration.getMessageSecurityMode() == MessageSecurityMode.None;
        int n4 = this.getSecurityPolicy().getSignatureKeySize();
        int n5 = this.getSecurityPolicy().getEncryptionKeySize();
        int n6 = this.getSecurityPolicy().getEncryptionBlockSize();
        this.yf = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), 0, n4);
        this.yg = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), n4, n5);
        this.yh = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), n4 + n5, n6);
        this.yi = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), 0, n4);
        this.yj = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), n4, n5);
        this.yk = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), n4 + n5, n6);
    }

    public Mac createLocalHmac() throws ServiceResultException {
        return this.createHmac(this.getLocalSigningKey());
    }

    public Mac createRemoteHmac() throws ServiceResultException {
        return this.createHmac(this.getRemoteSigningKey());
    }

    public long getCreationTime() {
        return this.yb;
    }

    public long getLifeTime() {
        return this.yc;
    }

    public byte[] getLocalEncryptingKey() {
        return this.yg;
    }

    public byte[] getLocalInitializationVector() {
        return this.yh;
    }

    public ByteString getLocalNonce() {
        return this.yd;
    }

    public byte[] getLocalSigningKey() {
        return this.yf;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.securityConfiguration.getMessageSecurityMode();
    }

    public byte[] getRemoteEncryptingKey() {
        return this.yj;
    }

    public byte[] getRemoteInitializationVector() {
        return this.yk;
    }

    public ByteString getRemoteNonce() {
        return this.ye;
    }

    public byte[] getRemoteSigningKey() {
        return this.yi;
    }

    public long getRenewTime() {
        return this.yb + this.yc * 3L / 4L;
    }

    public int getSecureChannelId() {
        return this.uX;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityConfiguration.getSecurityPolicy();
    }

    public int getTokenId() {
        return this.ya;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.yb + this.yc;
    }

    public boolean isTimeToRenew() {
        return this.yb + this.yc * 3L / 4L < System.currentTimeMillis();
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.yb + this.yc + this.yc / 4L;
    }

    public void setLocalEncryptingKey(byte[] byArray) {
        this.yg = byArray;
    }

    public void setLocalInitializationVector(byte[] byArray) {
        this.yh = byArray;
    }

    public void setLocalSigningKey(byte[] byArray) {
        this.yf = byArray;
    }

    public void setRemoteEncryptingKey(byte[] byArray) {
        this.yj = byArray;
    }

    public void setRemoteInitializationVector(byte[] byArray) {
        this.yk = byArray;
    }

    public void setRemoteSigningKey(byte[] byArray) {
        this.yi = byArray;
    }

    public String toString() {
        return "SecurityToken(Id=" + this.ya + ", secureChannelId=" + this.uX + ", creationTime=" + Instant.ofEpochMilli(this.yb) + ", lifetime=" + this.yc + ")";
    }

    private byte[] a(ByteString byteString, String string, ByteString byteString2, int n2, int n3) throws ServiceResultException {
        Object object;
        byte[] byArray;
        if (byteString == null) {
            throw new IllegalArgumentException("ArgumentNullException: secret");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        byte[] byArray2 = byArray = string != null && !string.isEmpty() ? string.getBytes(StandardCharsets.UTF_8) : null;
        if (byteString2 != null && byteString2.getLength() > 0) {
            if (byArray != null) {
                object = ByteBuffer.allocate(byArray.length + byteString2.getLength());
                ((ByteBuffer)object).put(byArray);
                ((ByteBuffer)object).put(byteString2.getValue());
                ((ByteBuffer)object).rewind();
                byArray = ((ByteBuffer)object).array();
            } else {
                byArray = byteString2.getValue();
            }
        }
        if (byArray == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The PSHA algorithm requires a non-null seed.");
        }
        object = this.securityConfiguration.getSecurityPolicy();
        Mac mac = CryptoUtil.createMac(((SecurityPolicy)((Object)object)).getKeyDerivationAlgorithm(), byteString.getValue());
        mac.update(byArray);
        byte[] byArray3 = mac.doFinal();
        byte[] byArray4 = new byte[mac.getMacLength() + byArray.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        byte[] byArray5 = new byte[n3];
        int n4 = 0;
        do {
            mac.update(byArray4);
            byte[] byArray6 = mac.doFinal();
            if (n2 < byArray6.length) {
                for (int i2 = n2; n4 < n3 && i2 < byArray6.length; ++i2) {
                    byArray5[n4++] = byArray6[i2];
                }
            }
            n2 = n2 > byArray6.length ? (n2 -= byArray6.length) : 0;
            mac.update(byArray3);
            byArray3 = mac.doFinal();
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        } while (n4 < n3);
        return byArray5;
    }

    protected Mac createHmac(byte[] byArray) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.securityConfiguration.getSecurityPolicy();
        return CryptoUtil.createMac(securityPolicy.getSymmetricSignatureAlgorithm(), byArray);
    }
}

