/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.tcp.impl.AbstractUaTcpCommMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import com.prosysopc.ua.types.opcua.CommonInformationModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InternalBinaryEncodingsHelper {
    private static final Map<UaNodeId, StructureSpecification> xX;

    public static IEncodeable getMessage(BinaryDecoder binaryDecoder) throws DecodingException {
        NodeId nodeId = binaryDecoder.getNodeId(null);
        if (nodeId == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        if (nodeId.getNamespaceIndex() != 0) {
            throw new DecodingException("Not valid 'Message' type: " + nodeId);
        }
        UaNodeId uaNodeId = UaNodeId.fromStandard(nodeId);
        if (!xX.containsKey(uaNodeId)) {
            throw new DecodingException("Not valid 'Message' type: " + nodeId);
        }
        return (IEncodeable)binaryDecoder.get(null, uaNodeId, 0);
    }

    public static ServiceRequest<?> getServiceRequest(BinaryDecoder binaryDecoder) throws DecodingException {
        try {
            return (ServiceRequest)ServiceRequest.class.cast(InternalBinaryEncodingsHelper.getMessage(binaryDecoder));
        }
        catch (ClassCastException classCastException) {
            throw new DecodingException("Expected ServiceRequest, but wasn't", classCastException);
        }
    }

    public static ServiceResponse getServiceResponse(BinaryDecoder binaryDecoder) throws DecodingException {
        try {
            return (ServiceResponse)ServiceResponse.class.cast(InternalBinaryEncodingsHelper.getMessage(binaryDecoder));
        }
        catch (ClassCastException classCastException) {
            throw new DecodingException("Expected ServiceResponse, but wasn't", classCastException);
        }
    }

    public static <T extends AbstractUaTcpCommMessage> T getUaTcpCommMessage(BinaryDecoder binaryDecoder, Class<T> clazz) throws DecodingException {
        if (ErrorMessage.class.equals(clazz)) {
            return (T)((AbstractUaTcpCommMessage)clazz.cast(InternalBinaryEncodingsHelper.b(binaryDecoder)));
        }
        if (Hello.class.equals(clazz)) {
            return (T)((AbstractUaTcpCommMessage)clazz.cast(InternalBinaryEncodingsHelper.c(binaryDecoder)));
        }
        if (Acknowledge.class.equals(clazz)) {
            return (T)((AbstractUaTcpCommMessage)clazz.cast(InternalBinaryEncodingsHelper.a(binaryDecoder)));
        }
        if (ReverseHello.class.equals(clazz)) {
            return (T)((AbstractUaTcpCommMessage)clazz.cast(InternalBinaryEncodingsHelper.d(binaryDecoder)));
        }
        throw new DecodingException("Encountered unknown opc.tcp comm structure: " + clazz);
    }

    public static void putServiceRequest(BinaryEncoder binaryEncoder, ServiceRequest<?> serviceRequest) throws EncodingException {
        if (serviceRequest == null) {
            throw new IllegalStateException("Cannot encode null ServiceRequest");
        }
        InternalBinaryEncodingsHelper.a(binaryEncoder, serviceRequest);
    }

    public static void putServiceResponse(BinaryEncoder binaryEncoder, ServiceResponse serviceResponse) throws EncodingException {
        if (serviceResponse == null) {
            throw new IllegalStateException("Cannot encode null ServiceResponse");
        }
        InternalBinaryEncodingsHelper.a(binaryEncoder, serviceResponse);
    }

    public static void putUaTcpCommMessage(BinaryEncoder binaryEncoder, AbstractUaTcpCommMessage abstractUaTcpCommMessage) throws EncodingException {
        if (abstractUaTcpCommMessage == null) {
            throw new EncodingException("Cannot encode null opc.tcp comm structure");
        }
        if (abstractUaTcpCommMessage instanceof ErrorMessage) {
            InternalBinaryEncodingsHelper.a(binaryEncoder, (ErrorMessage)abstractUaTcpCommMessage);
        } else if (abstractUaTcpCommMessage instanceof Hello) {
            InternalBinaryEncodingsHelper.a(binaryEncoder, (Hello)abstractUaTcpCommMessage);
        } else if (abstractUaTcpCommMessage instanceof Acknowledge) {
            InternalBinaryEncodingsHelper.a(binaryEncoder, (Acknowledge)abstractUaTcpCommMessage);
        } else if (abstractUaTcpCommMessage instanceof ReverseHello) {
            InternalBinaryEncodingsHelper.a(binaryEncoder, (ReverseHello)abstractUaTcpCommMessage);
        } else {
            throw new EncodingException("Encountered unknown opc.tcp comm structure: " + abstractUaTcpCommMessage.getClass());
        }
    }

    private static void c(StructureSpecification structureSpecification) {
    }

    private static Acknowledge a(BinaryDecoder binaryDecoder) throws DecodingException {
        Acknowledge acknowledge = new Acknowledge();
        acknowledge.setProtocolVersion(binaryDecoder.getUInt32("ProtocolVersion"));
        acknowledge.setReceiveBufferSize(binaryDecoder.getUInt32("ReceiveBufferSize"));
        acknowledge.setSendBufferSize(binaryDecoder.getUInt32("SendBufferSize"));
        acknowledge.setMaxMessageSize(binaryDecoder.getUInt32("MaxMessageSize"));
        acknowledge.setMaxChunkCount(binaryDecoder.getUInt32("MaxChunkCount"));
        return acknowledge;
    }

    private static ErrorMessage b(BinaryDecoder binaryDecoder) throws DecodingException {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setError(binaryDecoder.getUInt32("Error"));
        errorMessage.setReason(binaryDecoder.getString("Reason"));
        return errorMessage;
    }

    private static Hello c(BinaryDecoder binaryDecoder) throws DecodingException {
        Hello hello = new Hello();
        hello.setProtocolVersion(binaryDecoder.getUInt32("ProtocolVersion"));
        hello.setReceiveBufferSize(binaryDecoder.getUInt32("ReceiveBufferSize"));
        hello.setSendBufferSize(binaryDecoder.getUInt32("SendBufferSize"));
        hello.setMaxMessageSize(binaryDecoder.getUInt32("MaxMessageSize"));
        hello.setMaxChunkCount(binaryDecoder.getUInt32("MaxChunkCount"));
        hello.setEndpointUrl(binaryDecoder.getString("EndpointUrl"));
        return hello;
    }

    private static ReverseHello d(BinaryDecoder binaryDecoder) throws DecodingException {
        ReverseHello reverseHello = new ReverseHello();
        reverseHello.setServerUri(binaryDecoder.getString("ServerUri"));
        reverseHello.setEndpointUrl(binaryDecoder.getString("EndpointUrl"));
        return reverseHello;
    }

    private static void a(BinaryEncoder binaryEncoder, Acknowledge acknowledge) throws EncodingException {
        binaryEncoder.putUInt32(null, acknowledge.getProtocolVersion());
        binaryEncoder.putUInt32(null, acknowledge.getReceiveBufferSize());
        binaryEncoder.putUInt32(null, acknowledge.getSendBufferSize());
        binaryEncoder.putUInt32(null, acknowledge.getMaxMessageSize());
        binaryEncoder.putUInt32(null, acknowledge.getMaxChunkCount());
    }

    private static void a(BinaryEncoder binaryEncoder, ErrorMessage errorMessage) throws EncodingException {
        binaryEncoder.putUInt32(null, errorMessage.getError());
        binaryEncoder.putString(null, errorMessage.getReason());
    }

    private static void a(BinaryEncoder binaryEncoder, Hello hello) throws EncodingException {
        binaryEncoder.putUInt32(null, hello.getProtocolVersion());
        binaryEncoder.putUInt32(null, hello.getReceiveBufferSize());
        binaryEncoder.putUInt32(null, hello.getSendBufferSize());
        binaryEncoder.putUInt32(null, hello.getMaxMessageSize());
        binaryEncoder.putUInt32(null, hello.getMaxChunkCount());
        binaryEncoder.putString(null, hello.getEndpointUrl());
    }

    private static void a(BinaryEncoder binaryEncoder, ReverseHello reverseHello) throws EncodingException {
        binaryEncoder.putString(null, reverseHello.getServerUri());
        binaryEncoder.putString(null, reverseHello.getEndpointUrl());
    }

    private static void a(BinaryEncoder binaryEncoder, Structure structure) throws EncodingException {
        StructureSpecification structureSpecification = structure.specification();
        try {
            NodeId nodeId = structureSpecification.getBinaryEncodeId().asNodeId(binaryEncoder.getEncoderContext().getNamespaceTable());
            if (NodeId.isNull(nodeId)) {
                throw new EncodingException("Cannot determine Message TypeId: " + nodeId);
            }
            binaryEncoder.put(null, nodeId, UaIds.NodeId, 0);
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException(serviceResultException);
        }
        binaryEncoder.put(null, structure, structureSpecification.getTypeId(), 0);
    }

    private InternalBinaryEncodingsHelper() {
    }

    static {
        HashMap<UaNodeId, StructureSpecification> hashMap = new HashMap<UaNodeId, StructureSpecification>();
        for (UaDataTypeSpecification uaDataTypeSpecification : CommonInformationModel.MODEL.getSpecifications().values()) {
            StructureSpecification structureSpecification;
            if (!(uaDataTypeSpecification instanceof StructureSpecification) || !ServiceRequest.class.isAssignableFrom((structureSpecification = (StructureSpecification)uaDataTypeSpecification).getJavaClass()) && !ServiceResponse.class.isAssignableFrom(structureSpecification.getJavaClass())) continue;
            hashMap.put(structureSpecification.getTypeId(), structureSpecification);
            hashMap.put(structureSpecification.getBinaryEncodeId(), structureSpecification);
        }
        xX = Collections.unmodifiableMap(hashMap);
    }
}

