/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkFactory
extends ByteBufferFactory {
    static Logger logger = LoggerFactory.getLogger(ChunkFactory.class);
    public int maxChunkSize;
    public int maxPlaintextSize;
    public int messageHeaderSize;
    public int securityHeader;
    public int sequenceHeader;
    public int cipherBlockSize;
    public int signatureSize;
    public MessageSecurityMode securityMode;
    private boolean xQ;

    public ChunkFactory(int n2, int n3, int n4, int n5, int n6, int n7, MessageSecurityMode messageSecurityMode, int n8) {
        logger.trace("ChunkFactory: class={}", (Object)this.getClass());
        this.maxChunkSize = n2;
        this.messageHeaderSize = n3;
        this.securityHeader = n4;
        this.sequenceHeader = n5;
        this.cipherBlockSize = n7;
        this.signatureSize = n6;
        this.securityMode = messageSecurityMode;
        boolean bl = this.xQ = n8 > 2048;
        if (messageSecurityMode == MessageSecurityMode.None) {
            this.maxPlaintextSize = n2 - n3 - n4 - this.sequenceHeader;
        } else if (messageSecurityMode == MessageSecurityMode.Sign) {
            this.maxPlaintextSize = n2 - n3 - n4 - this.sequenceHeader - n6;
        }
        if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
            int n9 = this.getMinimumPadding();
            int n10 = n2 - n3 - n4 - n9;
            n10 -= n10 % n7;
            this.maxPlaintextSize = n10 - n5 - n6 - n9;
        }
    }

    @Override
    public ByteBuffer allocate(int n2) {
        int n3;
        n2 = Math.min(n2, this.maxPlaintextSize);
        int n4 = 0;
        if (this.securityMode == MessageSecurityMode.SignAndEncrypt) {
            n3 = n2 + this.sequenceHeader + this.signatureSize;
            n4 = this.getMinimumPadding();
            int n5 = (n4 + n3) % this.cipherBlockSize;
            if (n5 != 0) {
                n4 += this.cipherBlockSize - n5;
            }
            logger.trace("allocate: padding={}", (Object)n4);
        }
        n3 = n2 + this.messageHeaderSize + this.securityHeader + this.sequenceHeader + this.signatureSize + n4;
        logger.trace("allocate: chunkSize={}", (Object)n3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(4);
        byteBuffer.putInt(n3);
        if (this.securityMode == MessageSecurityMode.SignAndEncrypt) {
            this.writePadding(this.messageHeaderSize + this.securityHeader + this.sequenceHeader + n2, n4, byteBuffer);
        }
        byteBuffer.position(this.messageHeaderSize + this.securityHeader + this.sequenceHeader);
        byteBuffer = byteBuffer.slice();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.limit(n2);
        return byteBuffer;
    }

    public void encryptChunk(ByteBuffer byteBuffer) {
    }

    public ByteBuffer expandToCompleteChunk(ByteBuffer byteBuffer) {
        return ByteBuffer.wrap(byteBuffer.array()).order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer[] expandToCompleteChunk(ByteBuffer[] byteBufferArray) {
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[byteBufferArray.length];
        for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
            byteBufferArray2[i2] = this.expandToCompleteChunk(byteBufferArray[i2]);
        }
        return byteBufferArray2;
    }

    public void signChunk(ByteBuffer byteBuffer) {
    }

    protected int getMinimumPadding() {
        return this.xQ ? 2 : 1;
    }

    protected void writePadding(int n2, int n3, ByteBuffer byteBuffer) {
        int n4;
        byte by;
        int n5 = this.getMinimumPadding();
        logger.trace("writePadding: result.position={}", (Object)byteBuffer.position());
        logger.trace("writePadding: minimumPadding={}", (Object)n5);
        logger.trace("writePadding: padding={}", (Object)n3);
        if (n5 == 1) {
            byteBuffer.position(n2);
            by = (byte)(n3 - 1 & 0xFF);
            for (n4 = 0; n4 < n3; ++n4) {
                byteBuffer.put(by);
            }
        }
        if (n5 == 2) {
            byteBuffer.position(n2);
            by = (byte)(n3 - 2 & 0xFF);
            for (n4 = 0; n4 < n3 - 1; ++n4) {
                byteBuffer.put(by);
            }
            byteBuffer.put((byte)(n3 - 2 >> 8));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("writePadding: result={}", (Object)CryptoUtil.toHex(byteBuffer.array(), 64));
        }
    }

    protected void writePaddingSize(int n2, int n3, ByteBuffer byteBuffer) {
        int n4 = this.getMinimumPadding();
        byteBuffer.position(n2);
        if (n4 == 1) {
            byteBuffer.put((byte)(n3 - 1 & 0xFF));
        }
        if (n4 == 2) {
            byteBuffer.put((byte)(n3 - 2 & 0xFF));
            byteBuffer.put((byte)(n3 - 2 >> 8));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("writePadding: result={}", (Object)CryptoUtil.toHex(byteBuffer.array(), 64));
        }
    }

    public static class HelloChunkFactory
    extends ChunkFactory {
        public HelloChunkFactory() {
            super(8192, 8, 0, 0, 0, 0, MessageSecurityMode.None, 0);
            this.maxChunkSize = 8192;
            this.messageHeaderSize = 8;
            this.maxPlaintextSize = this.maxChunkSize - 8;
        }
    }

    public static class ErrorMessageChunkFactory
    extends ChunkFactory {
        public ErrorMessageChunkFactory() {
            super(4100, 8, 0, 0, 0, 1, MessageSecurityMode.None, 0);
            this.maxChunkSize = 4108;
            this.messageHeaderSize = 8;
            this.maxPlaintextSize = 4092;
        }
    }

    public static class AsymmMsgChunkFactory
    extends ChunkFactory {
        SecurityConfiguration xP;

        public AsymmMsgChunkFactory(int n2, SecurityConfiguration securityConfiguration) throws ServiceResultException {
            super(n2, 12, 12 + securityConfiguration.getSecurityPolicy().getEncodedPolicyUri().length + (securityConfiguration.getEncodedLocalCertificate() != null ? securityConfiguration.getEncodedLocalCertificate().length : 0) + (securityConfiguration.getEncodedRemoteCertificateThumbprint() != null ? securityConfiguration.getEncodedRemoteCertificateThumbprint().length : 0), 8, securityConfiguration.getMessageSecurityMode() != MessageSecurityMode.None ? CryptoUtil.getSignatureSize(securityConfiguration.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), securityConfiguration.getLocalPrivateKey()) : 0, securityConfiguration.getMessageSecurityMode() != MessageSecurityMode.None ? CryptoUtil.getCipherBlockSize(securityConfiguration.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), securityConfiguration.getRemoteCertificate().getPublicKey()) : 1, securityConfiguration.getMessageSecurityMode(), securityConfiguration.getLocalCertificate() == null ? 0 : ((RSAPublicKey)securityConfiguration.getRemoteCertificate().getPublicKey()).getModulus().bitLength());
            this.xP = securityConfiguration;
        }

        @Override
        public ByteBuffer allocate(int n2) {
            MessageSecurityMode messageSecurityMode = this.securityMode;
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            n2 = Math.min(n2, this.maxPlaintextSize);
            int n3 = -1;
            int n4 = -1;
            int n5 = n2 + this.sequenceHeader;
            int n6 = 0;
            int n7 = this.getMinimumPadding();
            int n8 = 0;
            int n9 = -1;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n10 = 1;
                try {
                    PublicKey publicKey = this.xP.getReceiverCertificate().getPublicKey();
                    n10 = CryptoUtil.getPlainTextBlockSize(this.xP.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), publicKey);
                }
                catch (ServiceResultException serviceResultException) {
                    throw new RuntimeServiceResultException(serviceResultException);
                }
                n5 += this.signatureSize;
                if ((n5 += n7) % n10 != 0) {
                    n8 = n10 - n5 % n10;
                    n5 += n8;
                }
                n6 = n7 + n8;
                n3 = n5 / n10;
                n4 = n3 * this.cipherBlockSize;
                n9 = this.messageHeaderSize + this.securityHeader + n4;
            } else if (messageSecurityMode == MessageSecurityMode.Sign) {
                n9 = this.messageHeaderSize + this.securityHeader + n5 + this.signatureSize;
            } else if (messageSecurityMode == MessageSecurityMode.None) {
                n9 = this.messageHeaderSize + this.securityHeader + n5;
            }
            logger.trace("AsymmMSGChunkFactory.allocate: chunkSize={}", (Object)n9);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n9);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                this.writePadding(this.messageHeaderSize + this.securityHeader + this.sequenceHeader + n2, n6, byteBuffer);
                this.writePaddingSize(n9 - n7, n6, byteBuffer);
            }
            byteBuffer.position(4);
            byteBuffer.putInt(n9);
            byteBuffer.position(this.messageHeaderSize + this.securityHeader + this.sequenceHeader);
            byteBuffer = byteBuffer.slice();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.limit(n2);
            return byteBuffer;
        }
    }

    public static class AcknowledgeChunkFactory
    extends ChunkFactory {
        public AcknowledgeChunkFactory() {
            super(8192, 8, 0, 0, 0, 1, MessageSecurityMode.None, 0);
            this.maxChunkSize = 8192;
            this.messageHeaderSize = 8;
            this.maxPlaintextSize = this.maxChunkSize - 8;
        }
    }
}

