/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkAsymmDecryptVerifier
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkAsymmDecryptVerifier.class);
    ByteBuffer xK;
    SecurityConfiguration xL;
    String vj;
    byte[] xM;
    byte[] xN;

    public ChunkAsymmDecryptVerifier(ByteBuffer byteBuffer, SecurityConfiguration securityConfiguration) {
        this.xK = byteBuffer;
        this.xL = securityConfiguration;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.xN;
    }

    public String getSecurityPolicyUri() {
        return this.vj;
    }

    public byte[] getSenderCertificate() {
        return this.xM;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        try {
            SecurityPolicy securityPolicy = this.xL.getSecurityPolicy();
            MessageSecurityMode messageSecurityMode = this.xL.getMessageSecurityMode();
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            this.xK.position(12);
            this.vj = ChunkUtils.getString(this.xK);
            logger.debug("SecurityPolicy in use: {}", (Object)this.vj);
            logger.debug("SecurityMode in use: {}", (Object)this.xL.getMessageSecurityMode());
            if (logger.isTraceEnabled()) {
                logger.trace("Chunk: {}", (Object)CryptoUtil.toHex(this.xK.array(), 64));
            }
            this.xM = ChunkUtils.getByteString(this.xK);
            this.xN = ChunkUtils.getByteString(this.xK);
            int n2 = this.xK.position();
            int n3 = this.xK.position() + 8;
            int n4 = this.xK.limit();
            int n5 = n4 - n2;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n5];
                this.xK.position(n2);
                this.xK.get(byArray, 0, byArray.length);
                n5 = this.a(byArray, this.xL.getLocalPrivateKey(), this.xK.array(), n2 + this.xK.arrayOffset());
                if (logger.isTraceEnabled()) {
                    logger.trace("Chunk decrypted: {}", (Object)CryptoUtil.toHex(this.xK.array(), 64));
                }
            }
            int n6 = 0;
            if (MessageSecurityMode.Sign == messageSecurityMode || MessageSecurityMode.SignAndEncrypt == messageSecurityMode) {
                SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
                logger.debug("signatureAlgorithm={}", (Object)securityAlgorithm);
                PublicKey publicKey = this.xL.getRemoteCertificate().getPublicKey();
                n6 = CryptoUtil.getSignatureSize(securityAlgorithm, publicKey);
                logger.debug("signatureSize={}", (Object)n6);
                byte[] byArray = new byte[n2 + n5 - n6];
                this.xK.position(0);
                this.xK.get(byArray, 0, byArray.length);
                this.xK.position(n2 + n5 - n6);
                byte[] byArray2 = new byte[n6];
                this.xK.get(byArray2, 0, n6);
                Certificate certificate = this.xL.getRemoteCertificate();
                if (!this.a(byArray, certificate, byArray2)) {
                    logger.error("Signature verification fails.");
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature could not be VERIFIED");
                }
            }
            int n7 = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n8;
                byte by;
                boolean bl;
                int n9 = this.xL.getLocalCertificate2().getCertificate().getKeySize();
                int n10 = n2 + n5 - n6 - 1;
                boolean bl2 = bl = n9 > 2048;
                if (bl) {
                    by = this.xK.get(n10 - 1);
                    n8 = this.xK.get(n10);
                    n7 = (by & 0xFF | (n8 & 0xFF) << 8) + 2;
                } else {
                    by = this.xK.get(n10);
                    n7 = (by & 0xFF) + 1;
                }
                logger.debug("paddingEnd={} paddingSize={}", (Object)n10, (Object)n7);
                n8 = bl ? n7 - 1 : n7;
                int n11 = bl ? n10 - n8 : n10 - n8 + 1;
                for (int i2 = 0; i2 < n8; ++i2) {
                    byte by2 = this.xK.get(n11 + i2);
                    if (by2 == by) continue;
                    logger.error(String.format(Locale.ROOT, "Padding does not match: %x <> %x", (int)by2, (int)by));
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Could not verify the padding in the message");
                }
            }
            this.xK.position(n3);
            this.xK.limit(this.xK.position() + n5 - 8 - n7 - n6);
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int a(byte[] byArray, PrivateKey privateKey, byte[] byArray2, int n2) throws ServiceResultException {
        int n3 = CryptoUtil.getCryptoProvider().decryptAsymm(privateKey, this.xL.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n2);
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: dataToDecrypt={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("decrypt: output={}", (Object)CryptoUtil.toHex(byArray2, 64));
            logger.trace("decrypt: bytesDecrypted={}", (Object)n3);
        }
        return n3;
    }

    private boolean a(byte[] byArray, Certificate certificate, byte[] byArray2) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.xL.getSecurityPolicy();
        logger.debug("verify: policy={}", (Object)securityPolicy);
        if (logger.isTraceEnabled()) {
            logger.trace("verify: {}", (Object)certificate);
            logger.trace("verify: dataToVerify={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("verify: signature={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
        return CryptoUtil.getCryptoProvider().verifyAsymm(certificate.getPublicKey(), this.xL.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), byArray, byArray2);
    }
}

