/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum SecurityPolicy {
    NONE("http://opcfoundation.org/UA/SecurityPolicy#None", null, null, null, null, null, null, 0, 0, 0, 1, 1024, 2048, 0),
    BASIC128RSA15("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsa15, SecurityAlgorithm.Rsa15, SecurityAlgorithm.PSha1, 20, 16, 16, 16, 1024, 2048, 16),
    BASIC256("http://opcfoundation.org/UA/SecurityPolicy#Basic256", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha1, 20, 24, 32, 16, 1024, 2048, 32),
    BASIC256SHA256("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32),
    AES128_SHA256_RSAOAEP("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 16, 16, 2048, 4096, 32),
    AES256_SHA256_RSAPSS("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaPssSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep256, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32);

    public static final Set<SecurityPolicy> ALL_SECURE_101;
    public static final Set<SecurityPolicy> ALL_SECURE_102;
    public static final Set<SecurityPolicy> ALL_SECURE_103;
    public static final Set<SecurityPolicy> ALL_SECURE_104;
    public static final Set<SecurityPolicy> ALL_SECURE_105;
    public static final SecurityPolicy[] EMPTY_ARRAY;
    private static Map<String, SecurityPolicy> xr;
    private final SecurityAlgorithm xs;
    private final SecurityAlgorithm xt;
    private final SecurityAlgorithm xu;
    private final byte[] xv;
    private final int xw;
    private final int xx;
    private final SecurityAlgorithm xy;
    private final int wZ;
    private final int xa;
    private final String xb;
    private final int xz;
    private final SecurityAlgorithm xA;
    private final SecurityAlgorithm xB;
    private final int xC;
    private final String jf;
    private final int xD;

    @Deprecated
    public static SecurityPolicy[] getAllSecurityPolicies() {
        return SecurityPolicy.values();
    }

    public static SecurityPolicy getSecurityPolicy(String string) throws ServiceResultException {
        if (string == null || string.isEmpty()) {
            return NONE;
        }
        SecurityPolicy securityPolicy = xr.get(string);
        if (securityPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected);
        }
        return securityPolicy;
    }

    private static void a(SecurityPolicy securityPolicy) {
        xr.put(securityPolicy.xb, securityPolicy);
    }

    private SecurityPolicy(String string2, SecurityAlgorithm securityAlgorithm, SecurityAlgorithm securityAlgorithm2, SecurityAlgorithm securityAlgorithm3, SecurityAlgorithm securityAlgorithm4, SecurityAlgorithm securityAlgorithm5, SecurityAlgorithm securityAlgorithm6, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.xs = securityAlgorithm5;
        this.xt = securityAlgorithm4;
        this.xu = securityAlgorithm3;
        this.xy = securityAlgorithm6;
        this.xb = string2;
        this.xA = securityAlgorithm2;
        this.xB = securityAlgorithm;
        this.xv = string2.getBytes(StandardCharsets.UTF_8);
        this.xC = n3;
        this.xz = n4;
        this.xx = n5;
        this.xw = n6;
        this.xa = n7;
        this.wZ = n8;
        this.xD = n9;
        this.jf = string2.substring(string2.indexOf("#") + 1, string2.length()).replace("_", "");
    }

    public SecurityAlgorithm getAsymmetricEncryptionAlgorithm() {
        return this.xs;
    }

    public SecurityAlgorithm getAsymmetricKeyWrapAlgorithm() {
        return this.xt;
    }

    public SecurityAlgorithm getAsymmetricSignatureAlgorithm() {
        return this.xu;
    }

    public String getDisplayName() {
        return this.jf;
    }

    public byte[] getEncodedPolicyUri() {
        return this.xv;
    }

    public int getEncryptionBlockSize() {
        return this.xw;
    }

    public int getEncryptionKeySize() {
        return this.xx;
    }

    public SecurityAlgorithm getKeyDerivationAlgorithm() {
        return this.xy;
    }

    public int getMaxAsymmetricKeyLength() {
        return this.wZ;
    }

    public int getMinAsymmetricKeyLength() {
        return this.xa;
    }

    public String getPolicyUri() {
        return this.xb;
    }

    public int getSecureChannelNonceLength() {
        return this.xD;
    }

    public int getSignatureKeySize() {
        return this.xz;
    }

    public SecurityAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.xA;
    }

    public SecurityAlgorithm getSymmetricSignatureAlgorithm() {
        return this.xB;
    }

    public int getSymmetricSignatureSize() {
        return this.xC;
    }

    public boolean isUsableWith(Cert cert) {
        int n2 = cert.getKeySize();
        return n2 >= this.xa && n2 <= this.wZ;
    }

    public String toString() {
        return this.xb;
    }

    static {
        ALL_SECURE_101 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256));
        ALL_SECURE_102 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_103 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_104 = Collections.unmodifiableSet(EnumSet.of(BASIC256SHA256, AES128_SHA256_RSAOAEP, AES256_SHA256_RSAPSS));
        ALL_SECURE_105 = Collections.unmodifiableSet(EnumSet.of(BASIC256SHA256, AES128_SHA256_RSAOAEP, AES256_SHA256_RSAPSS));
        EMPTY_ARRAY = new SecurityPolicy[0];
        xr = new ConcurrentHashMap<String, SecurityPolicy>();
        SecurityPolicy.a(NONE);
        SecurityPolicy.a(BASIC128RSA15);
        SecurityPolicy.a(BASIC256);
        SecurityPolicy.a(BASIC256SHA256);
        SecurityPolicy.a(AES128_SHA256_RSAOAEP);
        SecurityPolicy.a(AES256_SHA256_RSAPSS);
    }
}

