/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class SecurityMode {
    public static final SecurityMode BASIC128RSA15_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.BASIC128RSA15, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode BASIC128RSA15_SIGN = new SecurityMode(SecurityPolicy.BASIC128RSA15, MessageSecurityMode.Sign);
    public static final SecurityMode BASIC256_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.BASIC256, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode BASIC256_SIGN = new SecurityMode(SecurityPolicy.BASIC256, MessageSecurityMode.Sign);
    public static final SecurityMode BASIC256SHA256_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.BASIC256SHA256, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode BASIC256SHA256_SIGN = new SecurityMode(SecurityPolicy.BASIC256SHA256, MessageSecurityMode.Sign);
    public static final SecurityMode AES128_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.AES128_SHA256_RSAOAEP, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode AES128_SIGN = new SecurityMode(SecurityPolicy.AES128_SHA256_RSAOAEP, MessageSecurityMode.Sign);
    public static final SecurityMode AES256_SIGN_ENCRYPT = new SecurityMode(SecurityPolicy.AES256_SHA256_RSAPSS, MessageSecurityMode.SignAndEncrypt);
    public static final SecurityMode AES256_SIGN = new SecurityMode(SecurityPolicy.AES256_SHA256_RSAPSS, MessageSecurityMode.Sign);
    public static final SecurityMode[] EMPTY_ARRAY = new SecurityMode[0];
    public static final SecurityMode NONE = new SecurityMode(SecurityPolicy.NONE, MessageSecurityMode.None);
    private final SecurityPolicy wv;
    private final MessageSecurityMode xq;

    public static Set<SecurityMode> combinations(Set<MessageSecurityMode> set, Set<SecurityPolicy> set2) {
        if (set == null || set2 == null || set.isEmpty() || set2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<SecurityMode> hashSet = new HashSet<SecurityMode>();
        if (set.contains(MessageSecurityMode.None) && set2.contains((Object)SecurityPolicy.NONE)) {
            hashSet.add(NONE);
        }
        for (MessageSecurityMode messageSecurityMode : set) {
            if (MessageSecurityMode.None == messageSecurityMode) continue;
            for (SecurityPolicy securityPolicy : set2) {
                if (SecurityPolicy.NONE == securityPolicy) continue;
                hashSet.add(new SecurityMode(securityPolicy, messageSecurityMode));
            }
        }
        return hashSet;
    }

    public SecurityMode(SecurityPolicy securityPolicy, MessageSecurityMode messageSecurityMode) {
        if (securityPolicy == null || messageSecurityMode == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.wv = securityPolicy;
        this.xq = messageSecurityMode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecurityMode)) {
            return false;
        }
        SecurityMode securityMode = (SecurityMode)object;
        return securityMode.wv == this.wv && securityMode.xq == this.xq;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.xq;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.wv;
    }

    public boolean hasEncryption() {
        return MessageSecurityMode.SignAndEncrypt == this.xq;
    }

    public int hashCode() {
        return this.wv.hashCode() ^ this.xq.hashCode();
    }

    public boolean hasSigning() {
        return MessageSecurityMode.Sign == this.xq || MessageSecurityMode.SignAndEncrypt == this.xq;
    }

    public String toString() {
        return "[" + this.wv.getPolicyUri() + "," + this.xq + "]";
    }
}

