/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfiguration {
    public static final SecurityConfiguration NO_SECURITY;
    static Logger ru;
    SecurityMode xn;
    KeyPair xo = null;
    Cert xp = null;

    public SecurityConfiguration(SecurityMode securityMode, KeyPair keyPair, Cert cert) {
        if (securityMode == null) {
            throw new NullPointerException("SecurityMode mode is null");
        }
        this.xn = securityMode;
        if (securityMode.hasSigning()) {
            if (keyPair == null) {
                throw new NullPointerException("localApplicationInstanceCertificate is null");
            }
            this.xo = keyPair;
            if (cert == null) {
                throw new NullPointerException("remoteCertificate is null");
            }
            this.xp = cert;
        }
    }

    public byte[] getEncodedLocalCertificate() {
        if (this.xo == null) {
            return null;
        }
        return this.xo.getCertificate().getEncoded();
    }

    public byte[] getEncodedLocalCertificateThumbprint() {
        if (this.xo == null) {
            return null;
        }
        return this.xo.getCertificate().getEncodedThumbprint();
    }

    public byte[] getEncodedLocalPrivateKey() {
        if (this.xo == null) {
            return null;
        }
        return this.xo.getPrivateKey().getPrivateKey().getEncoded();
    }

    public byte[] getEncodedRemoteCertificate() {
        if (this.xp == null) {
            return null;
        }
        return this.xp.getEncoded();
    }

    public byte[] getEncodedRemoteCertificateThumbprint() {
        if (this.xp == null) {
            return null;
        }
        return this.xp.getEncodedThumbprint();
    }

    public Certificate getLocalCertificate() {
        if (this.xo == null) {
            return null;
        }
        return this.xo.getCertificate().getCertificate();
    }

    public KeyPair getLocalCertificate2() {
        return this.xo;
    }

    public RSAPrivateKey getLocalPrivateKey() {
        if (this.xo == null) {
            return null;
        }
        return this.xo.getPrivateKey().getPrivateKey();
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.xn.getMessageSecurityMode();
    }

    public Certificate getReceiverCertificate() {
        if (this.xp == null) {
            return null;
        }
        return this.xp.getCertificate();
    }

    public Certificate getRemoteCertificate() {
        if (this.xp == null) {
            return null;
        }
        return this.xp.getCertificate();
    }

    public Cert getRemoteCertificate2() {
        return this.xp;
    }

    public SecurityMode getSecurityMode() {
        return this.xn;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.xn.getSecurityPolicy();
    }

    static {
        ru = LoggerFactory.getLogger(SecurityConfiguration.class);
        NO_SECURITY = new SecurityConfiguration(SecurityMode.NONE, null, null);
    }
}

