/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import java.util.EnumSet;

public enum SecurityAlgorithm {
    HmacSha1(AlgorithmType.SymmetricSignature, "http://www.w3.org/2000/09/xmldsig#hmac-sha1", "HmacSHA1", 160),
    HmacSha256(AlgorithmType.SymmetricSignature, "http://www.w3.org/2000/09/xmldsig#hmac-sha256", "HmacSHA256", 256),
    Aes128(AlgorithmType.SymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES/CBC/NoPadding", 128),
    Aes256(AlgorithmType.SymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES/CBC/NoPadding", 256),
    Aes128Ctr(AlgorithmType.SymmetricEncryption, "http://opcfoundation.org/ua/security/aes128-ctr", "AES/CTR/NoPadding", 128),
    Aes256Ctr(AlgorithmType.SymmetricEncryption, "http://opcfoundation.org/ua/security/aes256-ctr", "AES/CTR/NoPadding", 256),
    RsaSha1(AlgorithmType.AsymmetricSignature, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA", 160),
    RsaSha256(AlgorithmType.AsymmetricSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "SHA256withRSA", 256),
    RsaPssSha256(AlgorithmType.AsymmetricSignature, "http://opcfoundation.org/UA/security/rsa-pss-sha2-256", "SHA256withRSAandMGF1", 256),
    Rsa15(AlgorithmType.AsymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA/NONE/PKCS1Padding", 0),
    RsaOaep(AlgorithmType.AsymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#rsa-oaep", "RSA/NONE/OAEPWithSHA1AndMGF1Padding", 0),
    RsaOaep256(AlgorithmType.AsymmetricEncryption, "http://opcfoundation.org/UA/security/rsa-oaep-sha2-256", "RSA/NONE/OAEPWithSHA-256AndMGF1Padding", 0),
    KwRsaOaep(AlgorithmType.AsymmetricKeywrap, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "", 0),
    KwRsa15(AlgorithmType.AsymmetricKeywrap, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "", 0),
    PSha1(AlgorithmType.KeyDerivation, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "HmacSHA1", 0),
    PSha256(AlgorithmType.KeyDerivation, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha256", "HmacSHA256", 0);

    private AlgorithmType xh;
    private final String uri;
    private final String xi;
    private final String xj;
    private final int keySize;
    private final String mode;
    private final String xk;

    public static SecurityAlgorithm valueOfUri(String string) {
        for (SecurityAlgorithm securityAlgorithm : EnumSet.allOf(SecurityAlgorithm.class)) {
            if (!securityAlgorithm.getUri().equals(string)) continue;
            return securityAlgorithm;
        }
        return null;
    }

    private SecurityAlgorithm(AlgorithmType algorithmType, String string2, String string3, int n3) {
        this.xh = algorithmType;
        this.uri = string2;
        this.xj = string3;
        String[] stringArray = string3.split("/");
        this.xi = stringArray[0];
        this.mode = stringArray.length > 1 ? stringArray[1] : "EBC";
        this.xk = stringArray.length > 2 ? stringArray[2] : "PKCS5Padding";
        this.keySize = n3;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.xk;
    }

    public String getStandardName() {
        return this.xi;
    }

    public String getTransformation() {
        return this.xj;
    }

    public AlgorithmType getType() {
        return this.xh;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return "Algorithm URI=" + this.uri + " StandardName=" + this.xi + " Transformation=" + this.xj;
    }

    public static enum AlgorithmType {
        SymmetricSignature,
        SymmetricEncryption,
        AsymmetricSignature,
        AsymmetricEncryption,
        AsymmetricKeywrap,
        KeyDerivation;

    }
}

