/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.CryptoProvider;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcCryptoProvider
implements CryptoProvider {
    static Logger logger = LoggerFactory.getLogger(BcCryptoProvider.class);

    public BcCryptoProvider() {
        CryptoUtil.loadOrInstallProvider("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
    }

    @Override
    public byte[] base64Decode(String string) {
        return Base64.decode((String)StringUtils.removeWhitespace(string));
    }

    @Override
    public String base64Encode(byte[] byArray) {
        try {
            return new String(Base64.encode((byte[])byArray), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public Mac createMac(SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        Mac mac;
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, securityAlgorithm.getStandardName());
        try {
            mac = Mac.getInstance(securityAlgorithm.getStandardName());
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
        return mac;
    }

    @Override
    public int decryptAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2, int n2) throws ServiceResultException {
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        AsymmetricBlockCipher asymmetricBlockCipher = this.a(securityAlgorithm, rSAPrivateKey);
        try {
            int n3 = 0;
            int n4 = asymmetricBlockCipher.getInputBlockSize();
            int n5 = asymmetricBlockCipher.getOutputBlockSize();
            logger.debug("Decrypt: inputBlockSize={}, outputBlockSize={}, dataToDecrypt.length={}", n4, n5, byArray.length);
            for (int i2 = 0; i2 < byArray.length; i2 += n4) {
                int n6 = Math.min(byArray.length - i2, n4);
                byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, i2, n6);
                System.arraycopy(byArray3, 0, byArray2, n2 + n3, byArray3.length);
                n3 += byArray3.length;
            }
            return n3;
        }
        catch (CryptoException cryptoException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)cryptoException);
        }
    }

    @Override
    public int decryptSymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3, byte[] byArray4, int n4) throws ServiceResultException {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        bufferedBlockCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(byArray), byArray2));
        int n5 = bufferedBlockCipher.processBytes(byArray3, n2, n3, byArray4, n4);
        try {
            n5 += bufferedBlockCipher.doFinal(byArray4, n4 + n5);
            return n5;
        }
        catch (DataLengthException dataLengthException) {
            logger.error("Input data is not an even number of encryption blocks.");
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in symmetric decrypt: Input data is not an even number of encryption blocks.");
        }
        catch (CryptoException cryptoException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)cryptoException);
        }
    }

    @Override
    public void encryptAsymm(PublicKey publicKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2, int n2) throws ServiceResultException {
        try {
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
            RSAPublicKey rSAPublicKey2 = new RSAPublicKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            AsymmetricBlockCipher asymmetricBlockCipher = this.a(securityAlgorithm, rSAPublicKey2);
            int n3 = 0;
            int n4 = asymmetricBlockCipher.getInputBlockSize();
            int n5 = asymmetricBlockCipher.getOutputBlockSize();
            logger.debug("Encrypt: inputBlockSize={}, outputBlockSize={}, dataToEncrypt.length={}", n4, n5, byArray.length);
            for (int i2 = 0; i2 < byArray.length; i2 += n4) {
                int n6 = Math.min(byArray.length - i2, n4);
                byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, i2, n6);
                System.arraycopy(byArray3, 0, byArray2, n2 + n3, byArray3.length);
                n3 += byArray3.length;
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)invalidCipherTextException);
        }
    }

    @Override
    public int encryptSymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3, byte[] byArray4, int n4) throws ServiceResultException {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new RijndaelEngine()));
        bufferedBlockCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(byArray), byArray2));
        int n5 = bufferedBlockCipher.processBytes(byArray3, n2, n3, byArray4, n4);
        try {
            n5 += bufferedBlockCipher.doFinal(byArray4, n4 + n5);
            return n5;
        }
        catch (DataLengthException dataLengthException) {
            logger.error("Input data is not an even number of encryption blocks.");
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in symmetric decrypt: Input data is not an even number of encryption blocks.");
        }
        catch (CryptoException cryptoException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)cryptoException);
        }
    }

    @Override
    public String getSecurityProviderName(Class<?> clazz) {
        return "BC";
    }

    @Override
    public byte[] signAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return null;
        }
        if (byArray == null || privateKey == null) {
            throw new IllegalArgumentException("null arg");
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        Signer signer = this.a(true, securityAlgorithm, rSAPrivateKey);
        signer.update(byArray, 0, byArray.length);
        try {
            return signer.generateSignature();
        }
        catch (DataLengthException dataLengthException) {
            logger.error("Input data is not an even number of encryption blocks.");
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in symmetric decrypt: Input data is not an even number of encryption blocks.");
        }
        catch (CryptoException cryptoException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)cryptoException);
        }
    }

    @Override
    public void signSymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) throws ServiceResultException {
        HMac hMac = this.a(securityPolicy.getSymmetricSignatureAlgorithm(), new KeyParameter(byArray));
        hMac.update(byArray2, n2, n3);
        hMac.doFinal(byArray3, n4);
    }

    @Override
    public boolean verifyAsymm(PublicKey publicKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return true;
        }
        if (publicKey == null || byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("null arg");
        }
        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
        RSAPublicKey rSAPublicKey2 = new RSAPublicKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        Signer signer = this.a(false, securityAlgorithm, rSAPublicKey2);
        signer.update(byArray, 0, byArray.length);
        return signer.verifySignature(byArray2);
    }

    @Override
    public void verifySymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) throws ServiceResultException {
        HMac hMac = this.a(securityPolicy.getSymmetricSignatureAlgorithm(), new KeyParameter(byArray));
        byte[] byArray4 = new byte[hMac.getMacSize()];
        hMac.update(byArray2, n2, n3);
        hMac.doFinal(byArray4, 0);
        if (byArray3.length != byArray4.length) {
            logger.warn("Signature lengths do not match: \n" + CryptoUtil.toHex(byArray3) + " vs. \n" + CryptoUtil.toHex(byArray4));
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Invalid signature: lengths do not match");
        }
        for (int i2 = 0; i2 < byArray3.length; ++i2) {
            if (byArray3[i2] == byArray4[i2]) continue;
            logger.warn("Signatures do not match: \n" + CryptoUtil.toHex(byArray3) + " vs. \n" + CryptoUtil.toHex(byArray4));
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Invalid signature: signatures do not match");
        }
    }

    private HMac a(SecurityAlgorithm securityAlgorithm, KeyParameter keyParameter) throws ServiceResultException {
        HMac hMac = null;
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.HmacSha1)) {
            hMac = new HMac((Digest)new SHA1Digest());
        } else if (securityAlgorithm.equals((Object)SecurityAlgorithm.HmacSha256)) {
            hMac = new HMac((Digest)new SHA256Digest());
        } else {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Unsupported symmetric signature algorithm: " + (Object)((Object)securityAlgorithm));
        }
        hMac.init((CipherParameters)keyParameter);
        return hMac;
    }

    private AsymmetricBlockCipher a(boolean bl, SecurityAlgorithm securityAlgorithm, CipherParameters cipherParameters) throws ServiceResultException {
        PKCS1Encoding pKCS1Encoding = null;
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15)) {
            pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        } else if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep)) {
            pKCS1Encoding = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)new SHA1Digest());
        } else if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep256)) {
            pKCS1Encoding = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)new SHA256Digest());
        } else {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Unsupported asymmetric encryption algorithm: " + (Object)((Object)securityAlgorithm));
        }
        pKCS1Encoding.init(bl, cipherParameters);
        return pKCS1Encoding;
    }

    private AsymmetricBlockCipher a(SecurityAlgorithm securityAlgorithm, RSAPrivateKey rSAPrivateKey) throws ServiceResultException {
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
        return this.a(false, securityAlgorithm, (CipherParameters)rSAPrivateCrtKeyParameters);
    }

    private AsymmetricBlockCipher a(SecurityAlgorithm securityAlgorithm, RSAPublicKey rSAPublicKey) throws ServiceResultException {
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        return this.a(true, securityAlgorithm, (CipherParameters)rSAKeyParameters);
    }

    private Signer b(boolean bl, SecurityAlgorithm securityAlgorithm, CipherParameters cipherParameters) throws ServiceResultException {
        RSADigestSigner rSADigestSigner = null;
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaSha1)) {
            rSADigestSigner = new RSADigestSigner((Digest)new SHA1Digest());
        } else if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaSha256)) {
            rSADigestSigner = new RSADigestSigner((Digest)new SHA256Digest());
        } else if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaPssSha256)) {
            rSADigestSigner = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new SHA256Digest(), 32);
        } else {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Unsupported asymmetric signature algorithm: " + (Object)((Object)securityAlgorithm));
        }
        rSADigestSigner.init(bl, cipherParameters);
        return rSADigestSigner;
    }

    private Signer a(boolean bl, SecurityAlgorithm securityAlgorithm, RSAPrivateKey rSAPrivateKey) throws ServiceResultException {
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
        return this.b(bl, securityAlgorithm, (CipherParameters)rSAPrivateCrtKeyParameters);
    }

    private Signer a(boolean bl, SecurityAlgorithm securityAlgorithm, RSAPublicKey rSAPublicKey) throws ServiceResultException {
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        return this.b(bl, securityAlgorithm, (CipherParameters)rSAKeyParameters);
    }
}

