/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.impl;

import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.ServerConnection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCollection
implements ConnectionMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionCollection.class);
    Set<ServerConnection> wP = new CopyOnWriteArraySet<ServerConnection>();
    CopyOnWriteArrayList<ConnectionMonitor.ConnectListener> uZ = new CopyOnWriteArrayList();
    Object wQ;

    public ConnectionCollection(Object object) {
        this.wQ = object;
    }

    public void addConnection(ServerConnection serverConnection) {
        logger.trace("addConnection: {}", (Object)serverConnection);
        if (!this.wP.add(serverConnection)) {
            return;
        }
        for (ConnectionMonitor.ConnectListener connectListener : this.uZ) {
            connectListener.onConnect(this.wQ, serverConnection);
        }
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.uZ.add(connectListener);
    }

    public Iterator<ConnectionMonitor.ConnectListener> getConnectionListeners() {
        return this.uZ.iterator();
    }

    @Override
    public synchronized void getConnections(Collection<ServerConnection> collection) {
        collection.addAll(this.wP);
    }

    public void removeConnection(ServerConnection serverConnection) {
        logger.trace("removeConnection: {}", (Object)serverConnection);
        this.wP.remove(serverConnection);
        for (ConnectionMonitor.ConnectListener connectListener : this.uZ) {
            connectListener.onClose(this.wQ, serverConnection);
        }
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.uZ.remove(connectListener);
    }
}

