/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.impl;

import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResultImpl<T>
implements AsyncResult<T> {
    static Logger logger = LoggerFactory.getLogger(AsyncResultImpl.class);
    static Logger wI = LoggerFactory.getLogger(ResultListener.class);
    static Executor executor = StackUtils.getBlockingWorkExecutor();
    ServiceResultException wJ;
    T result;
    ResultListener<T> wK;
    Semaphore wL = new Semaphore(0);

    public static <T> AsyncResultImpl<T> failed(ServiceResultException serviceResultException) {
        AsyncResultImpl<T> asyncResultImpl = new AsyncResultImpl<T>();
        asyncResultImpl.setError(serviceResultException);
        return asyncResultImpl;
    }

    @Override
    public ServiceResultException getError() {
        return this.wJ;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public AsyncResult.AsyncResultStatus getStatus() {
        if (this.wJ != null) {
            return AsyncResult.AsyncResultStatus.Failed;
        }
        if (this.result != null) {
            return AsyncResult.AsyncResultStatus.Succeed;
        }
        return AsyncResult.AsyncResultStatus.Waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(final ServiceResultException serviceResultException) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.wJ = serviceResultException;
            final ResultListener<T> resultListener = this.wK;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resultListener.onError(serviceResultException);
                        }
                        catch (RuntimeException runtimeException) {
                            wI.error("Unexpected RuntimeException in ResultListener#onError(", runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.wL.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorSync(ServiceResultException serviceResultException) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.wJ = serviceResultException;
            ResultListener<T> resultListener = this.wK;
            if (resultListener != null) {
                try {
                    resultListener.onError(serviceResultException);
                }
                catch (RuntimeException runtimeException) {
                    wI.error("Unexpected RuntimeException in ResultListener#onError(", runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.wL.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(ResultListener<T> resultListener) {
        T t;
        ServiceResultException serviceResultException;
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            this.wK = resultListener;
            serviceResultException = this.wJ;
            t = this.result;
        }
        if (resultListener != null) {
            if (t != null) {
                resultListener.onCompleted(t);
            }
            if (serviceResultException != null) {
                resultListener.onError(serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T t) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t;
            final ResultListener<T> resultListener = this.wK;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resultListener.onCompleted(AsyncResultImpl.this.result);
                        }
                        catch (RuntimeException runtimeException) {
                            wI.error("Unexpected RuntimeException in ResultListener#onCompleted", runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.wL.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSync(T t) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t;
            ResultListener<T> resultListener = this.wK;
            if (resultListener != null) {
                try {
                    resultListener.onCompleted(t);
                }
                catch (RuntimeException runtimeException) {
                    wI.error("Unexpected RuntimeException in ResultListener#onCompleted(", runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.wL.release(Integer.MAX_VALUE);
    }

    public void setSource(AsyncResult<T> asyncResult) {
        asyncResult.setListener(new ResultListener<T>(){

            @Override
            public void onCompleted(T t) {
                AsyncResultImpl.this.setResult(t);
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                AsyncResultImpl.this.setError(serviceResultException);
            }
        });
    }

    @Override
    public T waitForResult() throws ServiceResultException {
        try {
            this.wL.acquire();
        }
        catch (InterruptedException interruptedException) {
            logger.debug("timeout: ", this.wJ);
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        if (this.wJ != null) {
            logger.debug("error: ", this.wJ);
            if (this.wJ instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.wJ).getServiceFault());
            }
            throw this.wJ;
        }
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
    }

    @Override
    public T waitForResult(long l2, TimeUnit timeUnit) throws ServiceResultException {
        try {
            this.wL.tryAcquire(l2, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        logger.debug("error:", this.wJ);
        if (this.wJ != null) {
            if (this.wJ instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.wJ).getServiceFault());
            }
            throw this.wJ;
        }
        throw new ServiceResultException(StatusCodes.Bad_Timeout);
    }

    private void finish() {
        this.setListener(null);
    }

    private boolean isFinished() {
        return this.result != null || this.wJ != null;
    }
}

