/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.transport.https.HttpsServerConnection;
import com.prosysopc.ua.stack.transport.https.HttpsServerEndpointHandler;
import com.prosysopc.ua.stack.transport.https.HttpsServerSecureChannel;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class b
extends EndpointServiceRequest<ServiceRequest<ServiceResponse>, ServiceResponse>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(b.class);
    HttpsServerEndpointHandler wq;
    HttpAsyncExchange wr;
    HttpRequest ws;
    HttpEntity wt;
    HttpsServerSecureChannel wu;
    SecurityPolicy wv;
    int requestId;
    AsyncWrite ww;
    Thread wx;
    int uX = -1;

    public b(HttpsServerEndpointHandler httpsServerEndpointHandler, HttpAsyncExchange httpAsyncExchange, HttpRequest httpRequest, HttpsServerSecureChannel httpsServerSecureChannel, int n2) {
        super(null, httpsServerEndpointHandler.wd.serviceServer, httpsServerEndpointHandler.wd.endpointAddress);
        this.wq = httpsServerEndpointHandler;
        this.ws = httpRequest;
        this.requestId = n2;
        this.wr = httpAsyncExchange;
        this.wu = httpsServerSecureChannel;
        String string = null;
        if (httpRequest instanceof HttpMessage) {
            HttpRequest httpRequest2 = httpRequest;
            Header header = httpRequest2.getFirstHeader("OPCUA-SecurityPolicy");
            if (header != null) {
                string = header.getValue();
            }
            if (string == null) {
                string = "http://opcfoundation.org/UA/SecurityPolicy#None";
            }
        }
        if (string == null || string.isEmpty()) {
            this.wv = SecurityPolicy.NONE;
        } else {
            try {
                this.wv = SecurityPolicy.getSecurityPolicy(string);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("Encountered unknown SecurityPolicyUri, {}", (Object)string, (Object)serviceResultException);
                throw new RuntimeException();
            }
        }
    }

    @Override
    public ServerSecureChannel getChannel() {
        return this.wu;
    }

    @Override
    public SecurityMode getSecurityMode() {
        if (SecurityPolicy.NONE == this.wv) {
            return SecurityMode.NONE;
        }
        return new SecurityMode(this.wv, MessageSecurityMode.Sign);
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.wv;
    }

    @Override
    public void run() {
        Object object;
        this.wx = Thread.currentThread();
        Header header = this.ws.getFirstHeader("Content-Length");
        if (header != null && !((String)(object = header.getValue().trim())).isEmpty()) {
            try {
                long l2 = Long.parseLong((String)object);
                long l3 = this.wq.fZ.getMaxMessageSize().intValue();
                if (l3 != 0L && l2 > l3) {
                    this.a(500, StatusCodes.Bad_RequestTooLarge, "No request message");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            Object object2;
            if (this.ws instanceof HttpEntityEnclosingRequest) {
                object2 = (HttpEntityEnclosingRequest)this.ws;
                this.wt = object2.getEntity();
                long l4 = this.wt.getContentLength();
                long l5 = this.wq.fZ.getMaxMessageSize().intValue();
                if (l5 != 0L && l4 > l5) {
                    this.a(500, StatusCodes.Bad_RequestTooLarge, "No request message");
                    return;
                }
            } else {
                this.a(500, StatusCodes.Bad_RequestTypeInvalid, "No request message");
                return;
            }
            object = EntityUtils.toByteArray(this.wt);
            object2 = new BinaryDecoder((byte[])object);
            ((BinaryDecoder)object2).setEncoderContext(this.wq.getEncoderContext());
            this.request = InternalBinaryEncodingsHelper.getServiceRequest((BinaryDecoder)object2);
            logger.trace("request={}", this.request);
            logger.debug("request={}", (Object)this.request.getClass().getSimpleName());
        }
        catch (IllegalStateException illegalStateException) {
            this.a(500, StatusCodes.Bad_UnexpectedError, illegalStateException.getMessage());
            return;
        }
        catch (IOException iOException) {
            this.a(400, StatusCodes.Bad_UnexpectedError, iOException.getMessage());
            return;
        }
        catch (DecodingException decodingException) {
            this.a(400, StatusCodes.Bad_RequestTypeInvalid, decodingException.getMessage());
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            this.a(400, StatusCodes.Bad_DecodingError, stackOverflowError.getMessage());
            return;
        }
        this.wq.a(this);
    }

    @Override
    public void sendResponse(final AsyncWrite asyncWrite) {
        this.ww = asyncWrite;
        IEncodeable iEncodeable = asyncWrite.getMessage();
        final int n2 = iEncodeable instanceof ServiceFault ? 400 : (iEncodeable instanceof ServiceResponse ? 200 : 400);
        asyncWrite.setQueued();
        if (Thread.currentThread() == this.wx) {
            asyncWrite.setWriting();
            this.a(n2, asyncWrite.getMessage(), asyncWrite.getLocales());
            asyncWrite.setWritten();
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    asyncWrite.setWriting();
                    b.this.a(n2, asyncWrite.getMessage(), asyncWrite.getLocales());
                    asyncWrite.setWritten();
                }
            };
            StackUtils.getBlockingWorkExecutor().execute(runnable);
        }
    }

    @Override
    public AsyncWrite sendResponse(ServiceResponse serviceResponse, List<Locale> list) {
        if (EndpointServiceRequest.sendServiceFaultsForBadServiceLevelOpcHttpsResponses) {
            StatusCode statusCode = serviceResponse.getResponseHeader().getServiceResult();
            if (statusCode == null || statusCode.isGood()) {
                this.ww = new AsyncWrite(serviceResponse, list);
                this.sendResponse(this.ww);
                return this.ww;
            }
            return this.sendFault(new ServiceFault(serviceResponse.getResponseHeader()));
        }
        this.ww = new AsyncWrite(serviceResponse, list);
        this.sendResponse(this.ww);
        return this.ww;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(int n2, UnsignedInteger unsignedInteger, String string) {
        try {
            ErrorMessage errorMessage = null;
            if (string != null) {
                errorMessage = new ErrorMessage(unsignedInteger, string);
            }
            this.a(n2, errorMessage, null);
        }
        finally {
            this.wq.wo.remove(this.requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(int n2, IEncodeable iEncodeable, List<Locale> list) {
        try {
            HttpResponse httpResponse;
            block8: {
                httpResponse = this.wr.getResponse();
                httpResponse.setHeader("Content-Type", "application/octet-stream");
                httpResponse.setStatusCode(n2);
                if (iEncodeable != null) {
                    try {
                        Closeable closeable;
                        logger.trace("sendResponse: requestId={} statusCode={} responseObject={}", this.requestId, n2, iEncodeable);
                        logger.debug("sendResponse: requestId={} statusCode={} responseObject={}", this.requestId, n2, iEncodeable.getClass().getSimpleName());
                        if (logger.isDebugEnabled() && this.wu.getConnection() != null) {
                            closeable = ((HttpsServerConnection)this.wu.getConnection()).getNHttpServerConnection();
                            logger.debug("sendResponse: timeout={} {} context={}", this.wr.getTimeout(), closeable.getSocketTimeout(), closeable.getContext());
                        }
                        closeable = new ByteArrayOutputStream();
                        BinaryEncoder binaryEncoder = new BinaryEncoder((OutputStream)closeable);
                        binaryEncoder.setEncoderContext(this.wq.getEncoderContext());
                        if (list != null) {
                            binaryEncoder.getLocales().addAll(list);
                        }
                        InternalBinaryEncodingsHelper.putServiceResponse(binaryEncoder, (ServiceResponse)iEncodeable);
                        httpResponse.setEntity(new NByteArrayEntity(((ByteArrayOutputStream)closeable).toByteArray()));
                    }
                    catch (Exception exception) {
                        logger.info("sendResponse: Encoding failed", exception);
                        if (iEncodeable instanceof ErrorMessage) break block8;
                        httpResponse.setStatusCode(500);
                    }
                }
            }
            logger.debug("sendResponse: {} length={}", (Object)httpResponse, (Object)httpResponse.getEntity().getContentLength());
            this.wr.submitResponse(new BasicAsyncResponseProducer(httpResponse));
        }
        finally {
            this.wq.wo.remove(this.requestId);
        }
    }
}

