/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.https.HttpsClient;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a<T extends ServiceResponse>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(a.class);
    HttpsClient vs;
    long vt = System.currentTimeMillis();
    long vu = 0L;
    int requestId;
    AsyncResultImpl<T> vv;
    ServiceRequest<T> vw;
    HttpPost vx;
    UnsignedInteger vy = null;
    int uX;
    String vz;

    public a(HttpsClient httpsClient, ServiceRequest<T> serviceRequest) {
        long l2;
        this.vs = httpsClient;
        this.vw = serviceRequest;
        this.vv = new AsyncResultImpl();
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l3 = l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)httpsClient.getOperationTimeout();
        if (l2 != 0L) {
            this.vu = this.vt + l2;
        }
    }

    public void cancel() {
        if (this.vs.vk.remove(this.requestId) == null) {
            return;
        }
        this.vy = StatusCodes.Bad_RequestCancelledByRequest;
        HttpPost httpPost = this.vx;
        if (httpPost != null) {
            httpPost.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CloseableHttpResponse closeableHttpResponse;
            if (this.vy != null) {
                this.vv.setError(new ServiceResultException(this.vy));
                return;
            }
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(this.vs.vd);
            String string = inetSocketAddress.getHostName();
            int n2 = inetSocketAddress.getPort();
            String string2 = UriUtil.getTransportProtocol(this.vs.vd);
            HttpHost httpHost = new HttpHost(string, n2, string2);
            String string3 = this.vs.vc.getDescription().getEndpointUrl();
            String string4 = string3 == null ? "" : string3;
            this.vx = new HttpPost(string4);
            this.vx.addHeader("OPCUA-SecurityPolicy", this.vs.vj);
            this.vx.addHeader("Content-Type", "application/octet-stream");
            SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
            BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
            binaryEncoder.setEncoderContext(this.vs.vn);
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, this.vw);
            int n3 = sizeCalculationOutputStream.getLength();
            int n4 = this.vs.vn.getMaxMessageSize();
            if (n4 != 0 && n3 > n4) {
                EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n4 + " < " + n3);
                logger.warn("run: failed", encodingException);
                throw encodingException;
            }
            byte[] byArray = new byte[n3];
            BinaryEncoder binaryEncoder2 = new BinaryEncoder(byArray);
            binaryEncoder2.setEncoderContext(this.vs.vn);
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder2, this.vw);
            this.vx.setEntity(new NByteArrayEntity(byArray));
            if (this.vy != null) {
                this.vv.setError(new ServiceResultException(this.vy));
                return;
            }
            try {
                closeableHttpResponse = this.vs.vi.execute(httpHost, this.vx);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                this.vv.setError(new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, (Throwable)sSLPeerUnverifiedException, "Could not negotiate a TLS security cipher or the server did not provide a valid certificate."));
                this.vs.vk.remove(this.requestId);
                return;
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            int n5 = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n5 != 200) {
                UnsignedInteger unsignedInteger = StatusCodes.Bad_UnknownResponse;
                if (n5 == 501) {
                    unsignedInteger = StatusCodes.Bad_ServiceUnsupported;
                }
                String string5 = EntityUtils.toString(httpEntity);
                this.vv.setError(new ServiceResultException(unsignedInteger, n5 + ": " + string5));
                return;
            }
            if (this.vy != null) {
                this.vv.setError(new ServiceResultException(this.vy));
                return;
            }
            byArray = EntityUtils.toByteArray(httpEntity);
            BinaryDecoder binaryDecoder = new BinaryDecoder(byArray);
            binaryDecoder.setEncoderContext(this.vs.vn);
            IEncodeable iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
            if (iEncodeable instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)iEncodeable;
                ServiceResultException serviceResultException = new ServiceResultException(new StatusCode(errorMessage.getError()), errorMessage.getReason());
                this.vv.setError(serviceResultException);
                return;
            }
            try {
                ServiceResponse serviceResponse = (ServiceResponse)iEncodeable;
                this.vv.setResult(serviceResponse);
            }
            catch (ClassCastException classCastException) {
                this.vv.setError(new ServiceResultException(classCastException));
                logger.error("Cannot cast response to ServiceResponse, response=" + iEncodeable.getClass(), classCastException);
            }
        }
        catch (EncodingException encodingException) {
            this.vv.setError(new ServiceResultException(StatusCodes.Bad_EncodingError, (Throwable)encodingException));
        }
        catch (ClientProtocolException clientProtocolException) {
            this.vv.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)clientProtocolException));
        }
        catch (IOException iOException) {
            if (this.vy != null) {
                this.vv.setError(new ServiceResultException(this.vy, (Throwable)iOException));
            } else {
                this.vv.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException));
            }
        }
        catch (DecodingException decodingException) {
            this.vv.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)decodingException));
        }
        catch (ServiceResultException serviceResultException) {
            this.vv.setError(serviceResultException);
        }
        catch (RuntimeException runtimeException) {
            this.vv.setError(new ServiceResultException(runtimeException));
        }
        catch (StackOverflowError stackOverflowError) {
            this.vv.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
        }
        finally {
            this.vs.vk.remove(this.requestId);
        }
    }

    public void timeout() {
        if (this.vs.vk.remove(this.requestId) == null) {
            return;
        }
        this.vy = StatusCodes.Bad_Timeout;
        HttpPost httpPost = this.vx;
        if (httpPost != null) {
            httpPost.abort();
        }
        this.vv.setError(new ServiceResultException(this.vy));
    }
}

