/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.server.ReverseConnectionParameters;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.https.HttpsServerConnection;
import com.prosysopc.ua.stack.transport.https.HttpsServerEndpointHandler;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.impl.ConnectionCollection;
import com.prosysopc.ua.stack.transport.security.CertValidatorTrustManager;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncServerSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger ru = LoggerFactory.getLogger(HttpsServer.class);
    public static final HttpParams DEFAULT_HTTPPARAMS = new SyncBasicHttpParams().setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setParameter("http.origin-server", "OpcUA/1.1").setParameter("http.useragent", "OpcUA/1.1");
    Application application;
    String[] vC;
    String[] vD;
    String[] vp;
    AtomicInteger vE = new AtomicInteger();
    AsyncServerSocket vF;
    int vh;
    private boolean initialized = false;
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    ConnectionCollection vG = new ConnectionCollection(this);
    Thread vH;
    Thread vI;
    Semaphore vJ;
    Semaphore vK;
    HttpAsyncService vL;
    ConnectionReuseStrategy vM;
    a vN;
    NHttpConnectionFactory<DefaultNHttpServerConnection> vO;
    NHttpConnectionFactory<DefaultNHttpServerConnection> vP;
    SSLEngine vQ;
    SSLSetupHandler vR;
    IOEventDispatch vS;
    IOEventDispatch vT;
    ListeningIOReactor vU;
    IOReactorConfig vV;
    HttpsSecurityPolicy[] ve;
    Map<SocketAddress, SocketHandle> vW = new HashMap<SocketAddress, SocketHandle>();
    Server discoveryServer;
    HttpsServerEndpointHandler vX;
    private int vY = -1;

    public static TrustManager[] makeTrustManager(CertificateValidator ... certificateValidatorArray) {
        TrustManager[] trustManagerArray = new TrustManager[certificateValidatorArray.length];
        for (int i2 = 0; i2 < trustManagerArray.length; ++i2) {
            trustManagerArray[i2] = new CertValidatorTrustManager(certificateValidatorArray[i2]);
        }
        return trustManagerArray;
    }

    public HttpsServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        this.vV = new IOReactorConfig();
        this.ve = application.getHttpsSettings().getHttpsSecurityPolicies();
        this.vV.setTcpNoDelay(true);
        ImmutableHttpProcessor immutableHttpProcessor = new ImmutableHttpProcessor(new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl());
        this.vN = new a();
        final Map map = Collections.synchronizedMap(new HashMap());
        this.vM = new DefaultConnectionReuseStrategy();
        this.vL = new HttpAsyncService(immutableHttpProcessor, this.vM, (HttpAsyncRequestHandlerResolver)this.vN, this.getHttpParams()){

            @Override
            public void closed(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)((Object)nHttpServerConnection);
                ru.info("closed: {} {}<-> {} context={} socketTimeout={}", HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout());
                HttpsServerConnection httpsServerConnection = (HttpsServerConnection)map.remove(nHttpServerConnection);
                HttpsServer.this.vG.removeConnection(httpsServerConnection);
                super.closed(nHttpServerConnection);
            }

            @Override
            public void connected(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)((Object)nHttpServerConnection);
                ru.info("connected: {} {}<-> {} context={} socketTimeout={}", HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout());
                HttpsServerConnection httpsServerConnection = new HttpsServerConnection(HttpsServer.this, nHttpServerConnection);
                map.put(nHttpServerConnection, httpsServerConnection);
                HttpsServer.this.vG.addConnection(httpsServerConnection);
                super.connected(nHttpServerConnection);
                ArrayList<ServerConnection> arrayList = new ArrayList<ServerConnection>();
                HttpsServer.this.vG.getConnections(arrayList);
                ru.trace("Checking maximum number of connections, limit: {}, current: {}", (Object)HttpsServer.this.vh, (Object)arrayList.size());
                if (arrayList.size() >= HttpsServer.this.vh) {
                    int n2 = HttpsServer.this.vh - arrayList.size() + 1;
                    ru.trace("We are at max or over limit, closing this connection");
                    try {
                        nHttpServerConnection.shutdown();
                        HttpsServer.this.vG.removeConnection(httpsServerConnection);
                    }
                    catch (IOException iOException) {
                        ru.error("Cannot close opc.https connection properly", iOException);
                    }
                }
            }
        };
        this.discoveryServer = new Server(application);
        this.discoveryServer.setEndpointBindings(this.endpointBindings);
        EndpointBinding endpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        this.vX = new HttpsServerEndpointHandler(endpointBinding);
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vG.addConnectionListener(connectListener);
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        Object object;
        Object object2;
        String string;
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        this.init();
        String string2 = string = endpointBinding.endpointAddress.getEndpointUrl();
        string2 = UriUtil.getEndpointName(string);
        if (string2 == null) {
            string2 = "";
        }
        if ((object2 = this.vN.lookup(string2)) == null) {
            object = new HttpsServerEndpointHandler(endpointBinding);
            this.vN.a(string2, (HttpsServerEndpointHandler)object);
            this.vN.a("", this.vX);
        } else {
            object = (HttpsServerEndpointHandler)object2;
            if (((HttpsServerEndpointHandler)object).wn != endpointBinding.endpointServer) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind endpoint " + string + " and " + ((HttpsServerEndpointHandler)object).wd.endpointAddress.getEndpointUrl() + " with two different sets of service.");
            }
        }
        string2 = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        object2 = this.a(socketAddress, string2);
        object = ((SocketHandle)object2).a(endpointBinding);
        try {
            InetSocketAddress inetSocketAddress;
            SocketHandle socketHandle2;
            int n2;
            int n3;
            this.shutdownReactor();
            this.initReactor();
            if (((SocketHandle)object2).getPort() > 0) {
                SocketHandle[] object3 = this.socketHandleSnapshot();
                n3 = object3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    socketHandle2 = object3[n2];
                    if (socketHandle2.wh != null) continue;
                    socketHandle2.wh = this.vU.listen(socketHandle2.getSocketAddress());
                    inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                    socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), inetSocketAddress.getPort()));
                }
            } else if (this.vY > 0 && ((SocketHandle)object2).getPort() == 0) {
                SocketHandle[] serviceResultException = this.socketHandleSnapshot();
                n3 = serviceResultException.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    socketHandle2 = serviceResultException[n2];
                    if (socketHandle2.wh != null) continue;
                    endpointBinding.rewriteEndpointUrlPort(this.vY);
                    inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                    socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), this.vY));
                    socketHandle2.wh = this.vU.listen(socketHandle2.getBoundSocketAddress());
                }
            }
            if ("opc.https".equals(string2) && (this.vH == null || !this.vH.isAlive())) {
                final ListeningIOReactor listeningIOReactor = this.vU;
                final Semaphore semaphore = this.vJ = new Semaphore(0);
                this.vH = new Thread(){

                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            listeningIOReactor.execute(HttpsServer.this.vT);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            semaphore.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.vH.start();
            }
            if ("http".equals(string2) && (this.vI == null || !this.vI.isAlive())) {
                final ListeningIOReactor listeningIOReactor = this.vU;
                final Semaphore semaphore = this.vK = new Semaphore(0);
                this.vI = new Thread(){

                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            listeningIOReactor.execute(HttpsServer.this.vS);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            semaphore.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.vI.start();
            }
            if (((SocketHandle)object2).getPort() == 0 && ((SocketHandle)object2).getBoundSocketAddress() == null) {
                for (SocketHandle socketHandle2 : this.socketHandleSnapshot()) {
                    if (socketHandle2.wh != null) continue;
                    socketHandle2.wh = this.vU.listen(socketHandle2.getSocketAddress());
                    if (socketHandle2.getBoundSocketAddress() != null) continue;
                    try {
                        socketHandle2.wh.waitFor();
                        this.vY = ((InetSocketAddress)socketHandle2.wh.getAddress()).getPort();
                        ru.info("Replace port number 0 in socket addresses with: {}", (Object)this.vY);
                        endpointBinding.rewriteEndpointUrlPort(this.vY);
                        inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                        socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), this.vY));
                    }
                    catch (InterruptedException interruptedException) {
                        ru.error("InterruptedException", interruptedException);
                    }
                }
            }
        }
        catch (ServiceResultException serviceResultException) {
            ((HttpsEndpointHandle)object).close();
            throw serviceResultException;
        }
        ru.info("HTTPS Socket bound to {}", (Object)(((SocketHandle)object2).getBoundSocketAddress() != null ? ((SocketHandle)object2).getBoundSocketAddress() : ((SocketHandle)object2).getSocketAddress()));
        ru.info("Endpoint bound to {}", (Object)((HttpsEndpointHandle)object).endpointBinding().endpointAddress.getEndpointUrl());
        return object;
    }

    @Override
    public EndpointServer.ReverseEndpointHandle bindReverse(SocketAddress socketAddress, ReverseConnectionParameters reverseConnectionParameters, ScheduledExecutorService scheduledExecutorService) {
        throw new UnsupportedOperationException("HTTPS does not support ReverseHello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            endpointBinding.endpointServer.getEndpointBindings().remove(endpointBinding);
        }
        this.endpointBindings.clear();
        try {
            this.setState(CloseableObjectState.Closing);
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            try {
                if (this.vU != null) {
                    this.vU.shutdown();
                }
                if (this.vH != null) {
                    this.vH.interrupt();
                    this.vH = null;
                }
                if (this.vI != null) {
                    this.vI.interrupt();
                    this.vI = null;
                }
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress() : socketHandle.getSocketAddress());
        }
        return arrayList;
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.vG.getConnections(collection);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public HttpsSettings getHttpsSettings() {
        return this.application.getHttpsSettings();
    }

    public Collection<HttpsSecurityPolicy> getSupportedSecurityPolicies() {
        if (this.ve == null) {
            return HttpsSecurityPolicy.getAvailablePolicies().values();
        }
        return Arrays.asList(this.ve);
    }

    public int getWorkerThreadCount() {
        return this.vV.getIoThreadCount();
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vG.removeConnectionListener(connectListener);
    }

    public void setWorkerThreadCount(int n2) {
        if (this.vU != null) {
            throw new RuntimeException("Set workercount before binding the first socket address");
        }
        this.vV.setIoThreadCount(n2);
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.vW.values().toArray(new SocketHandle[this.vW.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void init() {
        if (!this.initialized) {
            int n2 = this.application.getHttpsSettings().getMaxConnections();
            if (n2 <= 0) {
                throw new IllegalStateException("Maximum number of connections was not configured; must be greater than 0");
            }
            this.vh = n2;
            this.initialized = true;
        }
    }

    protected void initReactor() throws ServiceResultException {
        boolean bl = false;
        boolean bl2 = false;
        for (SocketHandle socketHandle : this.vW.values()) {
            bl |= socketHandle.scheme.equals("opc.https");
            bl2 |= socketHandle.scheme.equals("http");
        }
        try {
            Object[] objectArray;
            if (bl && this.vR == null) {
                try {
                    objectArray = SSLContext.getInstance("TLSv1.2");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    ru.debug("No TLSv1.2 implementation found, trying TLS");
                    objectArray = SSLContext.getInstance("TLS");
                }
                objectArray.init(this.application.getHttpsSettings().getKeyManagers(), this.application.getHttpsSettings().getTrustManagers(), null);
                this.vR = new SSLSetupHandler(){

                    @Override
                    public void initalize(SSLEngine sSLEngine) throws SSLException {
                    }

                    @Override
                    public void verify(IOSession iOSession, SSLSession sSLSession) throws SSLException {
                    }
                };
                this.vP = new SSLNHttpServerConnectionFactory((SSLContext)objectArray, this.vR, this.getHttpParams());
                this.vT = new DefaultHttpServerIODispatch<HttpAsyncService>(this.vL, this.vP);
                this.vQ = objectArray.createSSLEngine();
                ru.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(this.vQ.getEnabledProtocols()));
                this.vC = this.vQ.getEnabledCipherSuites();
                ru.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(this.vC));
            }
            if (bl) {
                objectArray = this.vp;
                this.vD = this.etp();
                this.vp = CryptoUtil.filterCipherSuiteList(this.vC, this.vD);
                this.vQ.setEnabledCipherSuites(this.vp);
                if (objectArray == null || !Arrays.equals(objectArray, this.vp)) {
                    ru.info("CipherSuites for policies ({}) are {}", (Object)Arrays.toString((Object[])this.ve), (Object)Arrays.toString(this.vp));
                }
            }
            if (bl2 && this.vO == null) {
                this.vO = new DefaultNHttpServerConnectionFactory(this.getHttpParams());
                this.vS = new DefaultHttpServerIODispatch<HttpAsyncService>(this.vL, this.vO);
            }
            if (this.vU == null) {
                this.vU = new DefaultListeningIOReactor(this.vV, null);
            }
        }
        catch (KeyManagementException keyManagementException) {
            throw new ServiceResultException(keyManagementException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (IOReactorException iOReactorException) {
            throw new ServiceResultException(iOReactorException);
        }
    }

    protected void shutdownReactor() {
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            ListenerEndpoint listenerEndpoint = socketHandle.wh;
            if (listenerEndpoint != null) {
                listenerEndpoint.close();
            }
            socketHandle.wh = null;
        }
        if (this.vU != null) {
            try {
                this.vU.shutdown();
            }
            catch (IOException iOException) {
                ru.error("Failed to shutdown ioReactor", iOException);
            }
            this.vU = null;
        }
        if (this.vH != null) {
            this.vH.interrupt();
            try {
                this.vJ.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.vJ = null;
            this.vH = null;
        }
        if (this.vI != null) {
            this.vI.interrupt();
            try {
                this.vK.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.vK = null;
            this.vI = null;
        }
    }

    String[] etp() throws ServiceResultException {
        Collection<HttpsSecurityPolicy> collection = this.getSupportedSecurityPolicies();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpsSecurityPolicy httpsSecurityPolicy : collection) {
            String[] stringArray = httpsSecurityPolicy.getCipherSuites();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    Set<SecurityPolicy> etq() {
        HashSet<SecurityPolicy> hashSet = new HashSet<SecurityPolicy>();
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            for (SecurityMode securityMode : endpointBinding.endpointAddress.getSecurityModes()) {
                hashSet.add(securityMode.getSecurityPolicy());
            }
        }
        return hashSet;
    }

    int a(Endpoint endpoint) {
        int n2 = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (HttpsEndpointHandle httpsEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!httpsEndpointHandle.wd.endpointAddress.equals(endpoint)) continue;
                ++n2;
            }
        }
        return n2;
    }

    List<HttpsEndpointHandle> at(String string) {
        ArrayList<HttpsEndpointHandle> arrayList = new ArrayList<HttpsEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.b(arrayList);
        }
        return arrayList;
    }

    HttpParams getHttpParams() {
        return this.application.getHttpsSettings().getHttpParams() == null ? DEFAULT_HTTPPARAMS : this.application.getHttpsSettings().getHttpParams();
    }

    synchronized SocketHandle a(SocketAddress socketAddress, String string) throws ServiceResultException {
        SocketHandle socketHandle = this.vW.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress, string);
            this.vW.put(socketAddress, socketHandle);
        } else if (!string.equals(socketHandle.scheme)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Socket port=" + (socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress().getPort() : socketHandle.getPort()) + " cannot be bound as http and https.");
        }
        return socketHandle;
    }

    class a
    implements HttpAsyncRequestHandlerResolver {
        Map<String, HttpsServerEndpointHandler> map = new HashMap<String, HttpsServerEndpointHandler>();

        public Map<String, HttpAsyncRequestHandler<?>> getHandlers() {
            return new HashMap(this.map);
        }

        @Override
        public HttpAsyncRequestHandler<?> lookup(String string) {
            HttpAsyncRequestHandler httpAsyncRequestHandler = this.map.get(string);
            if (httpAsyncRequestHandler == null && (string.equals("") || string.equals("/"))) {
                return HttpsServer.this.vX;
            }
            return httpAsyncRequestHandler;
        }

        public void a(String string, HttpsServerEndpointHandler httpsServerEndpointHandler) {
            this.map.put(string, httpsServerEndpointHandler);
        }

        public void setHandlers(Map<String, HttpAsyncRequestHandler<?>> map) {
            this.map.clear();
            for (Map.Entry<String, HttpAsyncRequestHandler<?>> entry : map.entrySet()) {
                this.map.put(entry.getKey(), (HttpsServerEndpointHandler)entry.getValue());
            }
        }

        public void unregister(String string) {
            this.map.remove(string);
        }
    }

    public class SocketHandle {
        private SocketAddress wf;
        private InetSocketAddress wg;
        ListenerEndpoint wh;
        String scheme;
        Map<Endpoint, HttpsEndpointHandle> endpoints = new HashMap<Endpoint, HttpsEndpointHandle>();

        SocketHandle(SocketAddress socketAddress, String string) {
            this.setSocketAddress(socketAddress);
            this.scheme = string;
        }

        public synchronized HttpsEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new HttpsEndpointHandle[this.endpoints.size()]);
        }

        public InetSocketAddress getBoundSocketAddress() {
            return this.wg;
        }

        public SocketAddress getSocketAddress() {
            return this.wf;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme + "(" + (this.getBoundSocketAddress() != null ? this.getBoundSocketAddress() : this.getSocketAddress()) + ", ");
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(httpsEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        void close() {
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                httpsEndpointHandle.ets();
            }
            HttpsServer.this.vW.remove(this.getSocketAddress());
            if (this.wh != null) {
                this.wh.close();
            }
        }

        synchronized void b(Collection<HttpsEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized HttpsEndpointHandle a(EndpointBinding endpointBinding) throws ServiceResultException {
            HttpsEndpointHandle httpsEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (httpsEndpointHandle == null) {
                httpsEndpointHandle = new HttpsEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, httpsEndpointHandle);
                HttpsServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!httpsEndpointHandle.wd.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return httpsEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.getSocketAddress()).getPort();
        }

        void setBoundSocketAddress(InetSocketAddress inetSocketAddress) {
            this.wg = inetSocketAddress;
        }

        void setSocketAddress(SocketAddress socketAddress) {
            this.wf = socketAddress;
        }
    }

    public class HttpsEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding wd;
        SocketHandle we;

        HttpsEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.we = socketHandle;
            this.wd = endpointBinding;
        }

        @Override
        public void close() {
            this.etr();
            this.ets();
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.wd;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.we.getBoundSocketAddress() != null ? this.we.getBoundSocketAddress() : this.we.getSocketAddress();
        }

        public String toString() {
            return "(" + this.wd.endpointAddress.toString() + ")";
        }

        void etr() {
            this.we.endpoints.remove(this.wd.endpointAddress);
            if (this.we.endpoints.isEmpty()) {
                this.we.close();
            }
        }

        void ets() {
            int n2 = HttpsServer.this.a(this.wd.endpointAddress);
            if (n2 == 0) {
                String string = this.wd.endpointAddress.getEndpointUrl();
                HttpsServer.this.vN.unregister(string);
                HttpsServer.this.vN.unregister("");
                HttpsServer.this.endpointBindings.remove(this.wd);
                this.wd.serviceServer.getEndpointBindings().remove(this.wd);
            }
        }
    }
}

