/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.https.a;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.io.ITransportChannel;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClient
implements ITransportChannel {
    static final ServiceResultException va = new ServiceResultException(StatusCodes.Bad_Timeout);
    static final Logger logger = LoggerFactory.getLogger(HttpsClient.class);
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new X509HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }

        @Override
        public void verify(String string, SSLSocket sSLSocket) throws IOException {
        }

        @Override
        public void verify(String string, String[] stringArray, String[] stringArray2) throws SSLException {
        }

        @Override
        public void verify(String string, X509Certificate x509Certificate) throws SSLException {
        }
    };
    AtomicInteger vb = new AtomicInteger(0);
    TransportChannelSettings vc;
    String vd;
    HttpsSecurityPolicy[] ve;
    Executor executor = StackUtils.getBlockingWorkExecutor();
    SchemeRegistry vf;
    ClientConnectionManager vg;
    int vh = 20;
    DefaultHttpClient vi;
    String protocol;
    String vj;
    Map<Integer, a> vk = new ConcurrentHashMap<Integer, a>();
    Timer vl;
    AtomicReference<TimerTask> vm = new AtomicReference<Object>(null);
    EncoderContext vn;
    AtomicInteger vo = new AtomicInteger();
    String[] vp;
    Runnable vq = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpsClient.this.etn();
            Map<Integer, a> map = HttpsClient.this.vk;
            synchronized (map) {
                long l2 = System.currentTimeMillis();
                for (a a2 : HttpsClient.this.vk.values()) {
                    if (a2.vu == 0L || l2 < a2.vu) continue;
                    long l3 = System.currentTimeMillis() - a2.vt;
                    long l4 = a2.vu - a2.vt;
                    logger.warn("Request id={} msg={} timeouted {} ms elapsed. timeout at {} ms", a2.requestId, a2.vw.getClass(), l3, l4);
                    a2.timeout();
                }
            }
            HttpsClient.this.eto();
        }
    };

    public HttpsClient(String string) {
        if (!string.equals("http") && !string.equals("opc.https")) {
            throw new IllegalArgumentException();
        }
        this.protocol = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<a> arrayList;
        this.vg.shutdown();
        this.etn();
        Map<Integer, a> map = this.vk;
        synchronized (map) {
            arrayList = new ArrayList<a>(this.vk.values());
            logger.debug("requests.clear()");
            this.vk.clear();
        }
        if (!arrayList.isEmpty()) {
            for (a a2 : arrayList) {
                a2.cancel();
            }
        }
    }

    @Override
    public void dispose() {
        this.close();
        this.vg = null;
        this.vf = null;
        this.vi = null;
        this.vc = null;
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.vc.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.vc.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.vn;
    }

    @Override
    public int getOperationTimeout() {
        Integer n2 = this.vc.getConfiguration().getOperationTimeout();
        return n2 == null ? 0 : n2;
    }

    @Override
    public EnumSet<ITransportChannel.TransportChannelFeature> getSupportedFeatures() {
        return EnumSet.of(ITransportChannel.TransportChannelFeature.open, new ITransportChannel.TransportChannelFeature[]{ITransportChannel.TransportChannelFeature.openAsync, ITransportChannel.TransportChannelFeature.close, ITransportChannel.TransportChannelFeature.closeAync, ITransportChannel.TransportChannelFeature.sendRequest, ITransportChannel.TransportChannelFeature.sendRequestAsync});
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.vd = string;
        this.vj = transportChannelSettings.getDescription().getSecurityPolicyUri();
        this.vc = transportChannelSettings;
        HttpsSettings httpsSettings = transportChannelSettings.getHttpsSettings();
        this.ve = httpsSettings.getHttpsSecurityPolicies();
        if (this.ve == null || this.ve.length == 0) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "No HttpsSecurityPolicies defined");
        }
        logger.debug("initialize: url={}; settings={}", (Object)transportChannelSettings.getDescription().getEndpointUrl(), (Object)transportChannelSettings);
        EndpointConfiguration endpointConfiguration = transportChannelSettings.getConfiguration();
        this.vn = encoderContext;
        this.vn.setMaxArrayLength(endpointConfiguration.getMaxArrayLength() != null ? endpointConfiguration.getMaxArrayLength() : 0);
        this.vn.setMaxStringLength(endpointConfiguration.getMaxStringLength() != null ? endpointConfiguration.getMaxStringLength() : 0);
        this.vn.setMaxByteStringLength(endpointConfiguration.getMaxByteStringLength() != null ? endpointConfiguration.getMaxByteStringLength() : 0);
        this.vn.setMaxMessageSize(endpointConfiguration.getMaxMessageSize() != null ? endpointConfiguration.getMaxMessageSize() : 0);
        this.vl = TimerUtil.getTimer();
        try {
            Object object;
            Object object2;
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            if (this.protocol.equals("opc.https")) {
                try {
                    object2 = SSLContext.getInstance("TLSv1.2");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    logger.debug("No TLSv1.2 implementation found, trying TLS");
                    object2 = SSLContext.getInstance("TLS");
                }
                ((SSLContext)object2).init(httpsSettings.getKeyManagers(), httpsSettings.getTrustManagers(), null);
                object = httpsSettings.getHostnameVerifier() != null ? httpsSettings.getHostnameVerifier() : SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                SSLSocketFactory sSLSocketFactory = new SSLSocketFactory((SSLContext)object2, (X509HostnameVerifier)object){

                    @Override
                    protected void prepareSocket(SSLSocket sSLSocket) throws IOException {
                        sSLSocket.setEnabledCipherSuites(HttpsClient.this.vp);
                    }
                };
                SSLEngine sSLEngine = ((SSLContext)object2).createSSLEngine();
                Object[] objectArray = sSLEngine.getEnabledCipherSuites();
                HashSet<String> hashSet = new HashSet<String>();
                for (HttpsSecurityPolicy httpsSecurityPolicy : this.ve) {
                    for (String string2 : httpsSecurityPolicy.getCipherSuites()) {
                        hashSet.add(string2);
                    }
                }
                this.vp = CryptoUtil.filterCipherSuiteList((String[])objectArray, hashSet.toArray(new String[0]));
                logger.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(sSLEngine.getEnabledProtocols()));
                logger.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(objectArray));
                logger.info("Client CipherSuite selection for {} is {}", (Object)Arrays.toString((Object[])this.ve), (Object)Arrays.toString(this.vp));
                Scheme scheme = new Scheme("opc.https", 443, sSLSocketFactory);
                schemeRegistry.register(scheme);
            }
            if (this.protocol.equals("http")) {
                object2 = new Scheme("http", 80, PlainSocketFactory.getSocketFactory());
                schemeRegistry.register((Scheme)object2);
            }
            if (this.vg == null) {
                this.vg = object2 = new PoolingClientConnectionManager(schemeRegistry);
                ((PoolingClientConnectionManager)object2).setMaxTotal(this.vh);
                ((PoolingClientConnectionManager)object2).setDefaultMaxPerRoute(this.vh);
            }
            object2 = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)object2, this.vc.getConfiguration().getOperationTimeout());
            HttpConnectionParams.setSoTimeout((HttpParams)object2, 0);
            this.vi = new DefaultHttpClient(this.vg, (HttpParams)object2);
            if (httpsSettings.getUsername() != null && httpsSettings.getPassword() != null) {
                object = new BasicCredentialsProvider();
                ((BasicCredentialsProvider)object).setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), new UsernamePasswordCredentials(httpsSettings.getUsername(), httpsSettings.getPassword()));
                this.vi.setCredentialsProvider((CredentialsProvider)object);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new ServiceResultException(keyManagementException);
        }
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceResultException {
        return this.serviceRequest(serviceRequest, this.b(serviceRequest));
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest, long l2) throws ServiceResultException {
        AsyncResult<T> asyncResult = this.serviceRequestAsync(serviceRequest);
        return (T)((ServiceResponse)asyncResult.waitForResult(l2, TimeUnit.MILLISECONDS));
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        return this.serviceRequestAsync(serviceRequest, this.b(serviceRequest));
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest, long l2) {
        return this.serviceRequestAsync(serviceRequest, l2, -1);
    }

    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest, long l2, int n2) {
        a<T> a2 = new a<T>(this, serviceRequest);
        a2.uX = n2;
        a2.vz = this.vj;
        a2.requestId = this.vb.getAndIncrement();
        logger.debug("serviceRequestAsync: Sending message, requestId={} message={} operationTimeout={}", a2.requestId, serviceRequest.getClass().getSimpleName(), l2);
        logger.trace("serviceRequestAsync: message={}", (Object)serviceRequest);
        this.vk.put(a2.requestId, a2);
        if (a2.vt != 0L) {
            this.eto();
        }
        this.executor.execute(a2);
        return a2.vv;
    }

    public void setClientConnectionManager(ClientConnectionManager clientConnectionManager) {
        this.vg = clientConnectionManager;
    }

    public void setMaxConnections(int n2) {
        this.vh = n2;
    }

    @Override
    public void setOperationTimeout(int n2) {
        this.vc.getConfiguration().setOperationTimeout(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private a etm() {
        long l2 = Long.MAX_VALUE;
        a a2 = null;
        Map<Integer, a> map = this.vk;
        synchronized (map) {
            for (a a3 : this.vk.values()) {
                if (l2 <= a3.vu) continue;
                l2 = a3.vu;
                a2 = a3;
                break;
            }
        }
        return a2;
    }

    private void etn() {
        TimerTask timerTask = this.vm.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    private void eto() {
        a a2 = this.etm();
        if (a2 == null) {
            this.etn();
        } else {
            TimerTask timerTask = this.vm.get();
            if (timerTask == null || timerTask.scheduledExecutionTime() > a2.vu) {
                this.etn();
                timerTask = TimerUtil.schedule(this.vl, this.vq, this.executor, a2.vu);
                if (!this.vm.compareAndSet(null, timerTask)) {
                    timerTask.cancel();
                }
            }
        }
    }

    long b(ServiceRequest serviceRequest) {
        long l2;
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l3 = l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)this.getOperationTimeout();
        if (l2 == 0L) {
            l2 = 100000L;
        }
        return l2;
    }
}

