/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.endpoint;

import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EndpointBindingCollection {
    List<EndpointBinding> uY;
    CopyOnWriteArrayList<EndpointBindingListener> uZ = new CopyOnWriteArrayList();

    public static List<Endpoint> getEndpointAddresses(List<EndpointBinding> list) {
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        for (EndpointBinding endpointBinding : list) {
            if (arrayList.contains(endpointBinding.endpointAddress)) continue;
            arrayList.add(endpointBinding.endpointAddress);
        }
        return arrayList;
    }

    public static List<EndpointServer> getEndpointServers(List<EndpointBinding> list) {
        ArrayList<EndpointServer> arrayList = new ArrayList<EndpointServer>();
        for (EndpointBinding endpointBinding : list) {
            if (arrayList.contains(endpointBinding.endpointServer)) continue;
            arrayList.add(endpointBinding.endpointServer);
        }
        return arrayList;
    }

    public static List<Server> getServiceServers(List<EndpointBinding> list) {
        ArrayList<Server> arrayList = new ArrayList<Server>();
        for (EndpointBinding endpointBinding : list) {
            if (arrayList.contains(endpointBinding.serviceServer)) continue;
            arrayList.add(endpointBinding.serviceServer);
        }
        return arrayList;
    }

    public EndpointBindingCollection() {
        this.uY = new CopyOnWriteArrayList<EndpointBinding>();
    }

    public EndpointBindingCollection(List<EndpointBinding> list) {
        this.uY = Collections.synchronizedList(list);
    }

    public void add(EndpointBinding endpointBinding) {
        if (this.uY.contains(endpointBinding)) {
            return;
        }
        this.uY.add(endpointBinding);
    }

    public void addListener(EndpointBindingListener endpointBindingListener) {
        this.uZ.add(endpointBindingListener);
    }

    public void clear() {
        this.uY.clear();
    }

    public boolean contains(EndpointBinding endpointBinding) {
        return this.uY.contains(endpointBinding);
    }

    public List<EndpointBinding> get(Endpoint endpoint) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.uY) {
            if (!endpointBinding.endpointAddress.equals(endpoint)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(Endpoint endpoint, Server server) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.uY) {
            if (!endpointBinding.endpointAddress.equals(endpoint) || !endpointBinding.serviceServer.equals(server)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(EndpointServer endpointServer) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.uY) {
            if (!endpointBinding.endpointServer.equals(endpointServer)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(EndpointServer endpointServer, Endpoint endpoint) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.uY) {
            if (!endpointBinding.endpointAddress.equals(endpoint) || !endpointBinding.endpointServer.equals(endpointServer)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(EndpointServer endpointServer, Server server) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.uY) {
            if (!endpointBinding.endpointServer.equals(endpointServer) || !endpointBinding.serviceServer.equals(server)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(Server server) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.uY) {
            if (!endpointBinding.serviceServer.equals(server)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> get(String string) {
        ArrayList<EndpointBinding> arrayList = new ArrayList<EndpointBinding>();
        for (EndpointBinding endpointBinding : this.uY) {
            if (endpointBinding.endpointAddress.getEndpointUrl().equals(string)) {
                arrayList.add(endpointBinding);
                continue;
            }
            if (!endpointBinding.getOriginalAddress().equals(string)) continue;
            arrayList.add(endpointBinding);
        }
        return arrayList;
    }

    public List<EndpointBinding> getAll() {
        return this.uY;
    }

    public EndpointBinding getDefault(String string) {
        if (string == null) {
            throw new NullPointerException("url must be defined");
        }
        for (EndpointBinding endpointBinding : this.uY) {
            if (!EndpointUtil.urlEqualsHostIgnoreCase(endpointBinding.endpointAddress.getEndpointUrl(), string)) continue;
            return endpointBinding;
        }
        for (EndpointBinding endpointBinding : this.uY) {
            if (!EndpointUtil.urlEqualsProtocolAndServerNameIgnoringCase(endpointBinding.endpointAddress.getEndpointUrl(), string)) continue;
            return endpointBinding;
        }
        return null;
    }

    public List<Endpoint> getEndpointAddresses() {
        return EndpointBindingCollection.getEndpointAddresses(this.uY);
    }

    public List<EndpointServer> getEndpointServers() {
        return EndpointBindingCollection.getEndpointServers(this.uY);
    }

    public List<Server> getServiceServers() {
        return EndpointBindingCollection.getServiceServers(this.uY);
    }

    public EndpointBinding getSingle(EndpointServer endpointServer, Endpoint endpoint) {
        for (EndpointBinding endpointBinding : this.uY) {
            if (!endpointBinding.endpointAddress.equals(endpoint) || !endpointBinding.endpointServer.equals(endpointServer)) continue;
            return endpointBinding;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.uY.isEmpty();
    }

    public void remove(EndpointBinding endpointBinding) {
        this.uY.remove(endpointBinding);
    }

    public void removeListener(EndpointBindingListener endpointBindingListener) {
        this.uZ.remove(endpointBindingListener);
    }

    public int size() {
        return this.uY.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (EndpointBinding endpointBinding : this.uY) {
            stringBuilder.append(endpointBinding.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static interface EndpointBindingListener {
        public void onAddingEndpoint(EndpointBinding var1);
    }
}

