/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class TransportChannelSettings
implements Cloneable {
    EndpointDescription uS;
    EndpointConfiguration uT;
    NamespaceTable uU;
    OpcTcpSettings rr = new OpcTcpSettings();
    HttpsSettings gb = new HttpsSettings();

    public TransportChannelSettings() {
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, Cert cert, PrivKey privKey, CertificateValidator certificateValidator, NamespaceTable namespaceTable) throws RuntimeServiceResultException {
        this.uT = endpointConfiguration;
        this.uS = endpointDescription;
        this.rr.setClientCertificate(cert);
        this.rr.setCertificateValidator(certificateValidator);
        this.rr.setPrivKey(privKey);
        if (namespaceTable != null) {
            this.uU = namespaceTable;
        }
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, KeyPair keyPair, CertificateValidator certificateValidator, X509HostnameVerifier x509HostnameVerifier) throws RuntimeServiceResultException {
        this.uT = endpointConfiguration;
        this.uS = endpointDescription;
        this.gb.setKeyPair(keyPair, new Cert[0]);
        this.gb.setCertificateValidator(certificateValidator);
        this.gb.setHostnameVerifier(x509HostnameVerifier);
    }

    public TransportChannelSettings clone() {
        TransportChannelSettings transportChannelSettings;
        try {
            transportChannelSettings = (TransportChannelSettings)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("super.clone failed when it should not", cloneNotSupportedException);
        }
        if (this.uS != null) {
            transportChannelSettings.setDescription(this.uS.clone());
        }
        if (this.uT != null) {
            transportChannelSettings.setConfiguration(this.uT.clone());
        }
        if (this.rr != null) {
            transportChannelSettings.rr = this.rr.clone();
        }
        if (this.gb != null) {
            transportChannelSettings.gb = this.gb.clone();
        }
        if (this.uU != null) {
            transportChannelSettings.setNamespaceUris(this.uU);
        }
        return transportChannelSettings;
    }

    public EndpointConfiguration getConfiguration() {
        return this.uT;
    }

    public EndpointDescription getDescription() {
        return this.uS;
    }

    public HttpsSettings getHttpsSettings() {
        return this.gb;
    }

    public NamespaceTable getNamespaceUris() {
        return this.uU;
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.rr;
    }

    public Cert getServerCertificate() {
        try {
            if (this.uS != null && this.uS.getServerCertificate() != null && this.uS.getServerCertificate().getLength() > 0) {
                return new Cert(ByteString.asByteArray(this.uS.getServerCertificate()));
            }
            return null;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    public void readFrom(TransportChannelSettings transportChannelSettings) {
        if (transportChannelSettings.uS != null) {
            this.uS = transportChannelSettings.uS.clone();
        }
        if (transportChannelSettings.uT != null) {
            this.uT = transportChannelSettings.uT.clone();
        }
        if (transportChannelSettings.rr != null) {
            this.rr.readFrom(transportChannelSettings.rr);
        }
        if (transportChannelSettings.gb != null) {
            this.gb.readFrom(transportChannelSettings.gb);
        }
        if (transportChannelSettings.uU != null) {
            this.uU = transportChannelSettings.uU;
        }
    }

    public void setConfiguration(EndpointConfiguration endpointConfiguration) {
        this.uT = endpointConfiguration;
    }

    public void setDescription(EndpointDescription endpointDescription) {
        this.uS = endpointDescription;
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.gb = httpsSettings;
    }

    public void setNamespaceUris(NamespaceTable namespaceTable) {
        this.uU = namespaceTable;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.rr = opcTcpSettings;
    }

    public String toString() {
        return "TransportChannelSettings [description=" + this.uS + ", configuration=" + this.uT + ", namespaceUris=" + this.uU + ", opctcpSettings=" + this.rr + ", httpsSettings=" + this.gb + "]";
    }
}

