/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.xml;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.UriTable;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDecoder
implements IDecoder {
    private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String EMPTY_STRING = "";
    private static final String ug = "http://opcfoundation.org/UA/2008/02/Types.xsd";
    private static Logger logger = LoggerFactory.getLogger(XmlDecoder.class);
    private static final Map<Class<?>, a<?>> sU = new HashMap();
    private static final Map<UaNodeId, a<?>> sV = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> sW = new BijectionMap();
    private static final a<DateTime> uh;
    private static final a<ExtensionObject> ui;
    private static final a<Structure> uj;
    private static final a<DataValue> uk;
    private static final a<Variant> ul;
    private static final a<DiagnosticInfo> um;
    private static final a<Enumeration> un;
    private static final a<BigDecimal> uo;
    private static final a<UaOptionSet> up;
    private static final ExpandedNodeId tg;
    private XMLStreamReader reader;
    private NamespaceTable iz;
    private ServerTable sN;
    private EncoderContext kg;
    private UnsignedShort[] uq;
    private UnsignedShort[] ur;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (sV.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (sW.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (sW.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            sW.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (sU.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        XmlDecoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> j(Class<?> clazz) throws DecodingException {
        if (clazz == null) {
            throw new DecodingException("Cannot decode class null");
        }
        a<?> a2 = sU.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return ui;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return uj;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return uk;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return ul;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return um;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return un;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return uh;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return uo;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return up;
        }
        throw new DecodingException("Cannot decode class: " + clazz);
    }

    private static a<Object> e(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws DecodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return XmlDecoder.j(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return XmlDecoder.j(ExtensionObject.class);
        }
        a<Object> a2 = sV.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = sV.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = uj;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = up;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = un;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(sW.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new DecodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new DecodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    public XmlDecoder(XmlElement xmlElement, EncoderContext encoderContext) throws DecodingException {
        if (encoderContext == null) {
            throw new NullPointerException("context");
        }
        this.initialize();
        try {
            this.reader = XMLFactoryCache.getXMLInputFactory().createXMLStreamReader(new StringReader(xmlElement.toString()));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
        this.kg = encoderContext;
    }

    public XmlDecoder(XMLStreamReader xMLStreamReader, EncoderContext encoderContext) throws DecodingException {
        if (encoderContext == null) {
            throw new NullPointerException("context");
        }
        this.initialize();
        this.reader = xMLStreamReader;
        this.kg = encoderContext;
    }

    public void close() throws DecodingException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
    }

    public void close(boolean bl) throws DecodingException {
        if (bl && this.reader.getEventType() != 8) {
            this.getEndElement();
        }
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
    }

    @Override
    public <T> T get(String string, UaNodeId uaNodeId, int n2) throws DecodingException {
        Object object;
        Class clazz;
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            clazz = Object.class;
        } else if (UaIds.Structure.equals(uaNodeId)) {
            clazz = ExtensionObject.class;
        } else {
            object = this.getEncoderContext().getDataTypeSpecification(uaNodeId);
            if (object == null) {
                throw new DecodingException("Cannot find UaDataTypeSpecification, cannot decode DataType: " + uaNodeId);
            }
            clazz = object.getJavaClass();
        }
        try {
            if (n2 < 0) {
                throw new DecodingException("The given dimensions cannot be negative");
            }
            object = this.a(string, clazz, uaNodeId, n2);
            return (T)object;
        }
        catch (Exception exception) {
            throw new DecodingException("Error while trying to decode, DataTypeId: " + uaNodeId, exception);
        }
    }

    @Override
    public Boolean[] getBooleanArray(String string) throws DecodingException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        if (this.c(string, true)) {
            while (this.aq("Boolean")) {
                arrayList.add(this.getBoolean("Boolean"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Boolean[0]);
    }

    @Override
    public UnsignedByte[] getByteArray(String string) throws DecodingException {
        ArrayList<UnsignedByte> arrayList = new ArrayList<UnsignedByte>();
        if (this.c(string, true)) {
            while (this.aq("Byte")) {
                arrayList.add(this.getByte("Byte"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new UnsignedByte[0]);
    }

    @Override
    public ByteString[] getByteStringArray(String string) throws DecodingException {
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        if (this.c(string, true)) {
            while (this.aq("ByteString")) {
                arrayList.add(this.getByteString("ByteString"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new ByteString[0]);
    }

    @Override
    public DataValue[] getDataValueArray(String string) throws DecodingException {
        ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
        if (this.c(string, true)) {
            while (this.aq("DataValue")) {
                arrayList.add(this.getDataValue("DataValue"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new DataValue[0]);
    }

    @Override
    public DateTime[] getDateTimeArray(String string) throws DecodingException {
        ArrayList<DateTime> arrayList = new ArrayList<DateTime>();
        if (this.c(string, true)) {
            while (this.aq("DateTime")) {
                arrayList.add(this.getDateTime("DateTime"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new DateTime[0]);
    }

    public DiagnosticInfo getDiagnosticInfo() throws DecodingException {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo();
        if (this.c("SymbolicId", true)) {
            diagnosticInfo.setSymbolicId(this.getInt32(null));
            this.ap("SymbolicId");
        }
        if (this.c("NamespaceUri", true)) {
            diagnosticInfo.setNamespaceUri(this.getInt32(null));
            this.ap("NamespaceUri");
        }
        if (this.c("Locale", true)) {
            diagnosticInfo.setLocale(this.getInt32(null));
            this.ap("Locale");
        }
        if (this.c("LocalizedText", true)) {
            diagnosticInfo.setLocalizedText(this.getInt32(null));
            this.ap("LocalizedText");
        }
        diagnosticInfo.setAdditionalInfo(this.getString("AdditionalInfo"));
        diagnosticInfo.setInnerStatusCode(this.getStatusCode("InnerStatusCode"));
        if (this.c("InnerDiagnosticInfo", true)) {
            diagnosticInfo.setInnerDiagnosticInfo(this.getDiagnosticInfo());
            this.ap("InnerDiagnosticInfo");
        }
        return diagnosticInfo;
    }

    @Override
    public DiagnosticInfo[] getDiagnosticInfoArray(String string) throws DecodingException {
        ArrayList<DiagnosticInfo> arrayList = new ArrayList<DiagnosticInfo>();
        if (this.c(string, true)) {
            while (this.aq("DiagnosticInfo")) {
                arrayList.add(this.getDiagnosticInfo("DiagnosticInfo"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new DiagnosticInfo[0]);
    }

    @Override
    public Double[] getDoubleArray(String string) throws DecodingException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.c(string, true)) {
            while (this.aq("Double")) {
                arrayList.add(this.getDouble("Double"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Double[0]);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.kg;
    }

    public void getEndElement() throws DecodingException {
        this.esL();
        if (this.reader.isEndElement()) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        } else {
            throw new DecodingException("Not an end element");
        }
    }

    @Override
    public ExpandedNodeId[] getExpandedNodeIdArray(String string) throws DecodingException {
        ArrayList<ExpandedNodeId> arrayList = new ArrayList<ExpandedNodeId>();
        if (this.c(string, true)) {
            while (this.aq("ExpandedNodeId")) {
                arrayList.add(this.getExpandedNodeId("ExpandedNodeId"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new ExpandedNodeId[0]);
    }

    @Override
    public ExtensionObject[] getExtensionObjectArray(String string) throws DecodingException {
        ArrayList<ExtensionObject> arrayList = new ArrayList<ExtensionObject>();
        if (this.c(string, true)) {
            while (this.aq("ExtensionObject")) {
                arrayList.add(this.getExtensionObject("ExtensionObject"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new ExtensionObject[0]);
    }

    public Object getExtensionObjectBody(ExpandedNodeId expandedNodeId) throws DecodingException {
        this.esL();
        if (this.reader.getLocalName() == "ByteString" && this.reader.getNamespaceURI() == ug) {
            ByteString byteString = this.getByteString("ByteString");
            return byteString;
        }
        return this.getXmlElement(EMPTY_STRING);
    }

    @Override
    public Float[] getFloatArray(String string) throws DecodingException {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        if (this.c(string, true)) {
            while (this.aq("Float")) {
                arrayList.add(this.getFloat("Float"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Float[0]);
    }

    @Override
    public UUID[] getGuidArray(String string) throws DecodingException {
        ArrayList<UUID> arrayList = new ArrayList<UUID>();
        if (this.c(string, true)) {
            while (this.aq("Guid")) {
                arrayList.add(this.getGuid("Guid"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new UUID[0]);
    }

    @Override
    public Short[] getInt16Array(String string) throws DecodingException {
        ArrayList<Short> arrayList = new ArrayList<Short>();
        if (this.c(string, true)) {
            while (this.aq("Int16")) {
                arrayList.add(this.getInt16("Int16"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Short[0]);
    }

    @Override
    public Integer[] getInt32Array(String string) throws DecodingException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.c(string, true)) {
            while (this.aq("Int32")) {
                arrayList.add(this.getInt32("Int32"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Integer[0]);
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.c(string, true)) {
            while (this.aq("Int32")) {
                arrayList.add(this.getInt32("Int32"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
            int[] nArray = new int[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                nArray[i2] = (Integer)arrayList.get(i2);
            }
            return nArray;
        }
        return new int[0];
    }

    @Override
    public Long[] getInt64Array(String string) throws DecodingException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (this.c(string, true)) {
            while (this.aq("Int64")) {
                arrayList.add(this.getInt64("Int64"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Long[0]);
    }

    @Override
    public LocalizedText[] getLocalizedTextArray(String string) throws DecodingException {
        ArrayList<LocalizedText> arrayList = new ArrayList<LocalizedText>();
        if (this.c(string, true)) {
            while (this.aq("LocalizedText")) {
                arrayList.add(this.getLocalizedText("LocalizedText"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new LocalizedText[0]);
    }

    public Object getMatrix(String string) throws DecodingException {
        if (this.c(string, true)) {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            int[] nArray = this.getInt32Array_("Dimensions");
            if (this.c("Elements", true)) {
                this.esM();
                while (this.reader.getEventType() != 2) {
                    Object object = null;
                    String string2 = this.reader.getLocalName();
                    if (string2.equals("Boolean")) {
                        object = this.getBoolean(string2);
                    } else if (string2.equals("SByte")) {
                        object = this.getSByte(string2);
                    } else if (string2.equals("Byte")) {
                        object = this.getByte(string2);
                    } else if (string2.equals("Int16")) {
                        object = this.getInt16(string2);
                    } else if (string2.equals("UInt16")) {
                        object = this.getUInt16(string2);
                    } else if (string2.equals("Int32")) {
                        object = this.getInt32(string2);
                    } else if (string2.equals("UInt32")) {
                        object = this.getUInt32(string2);
                    } else if (string2.equals("Int64")) {
                        object = this.getInt64(string2);
                    } else if (string2.equals("UInt64")) {
                        object = this.getUInt64(string2);
                    } else if (string2.equals("Float")) {
                        object = this.getFloat(string2);
                    } else if (string2.equals("Double")) {
                        object = this.getDouble(string2);
                    } else if (string2.equals("String")) {
                        object = this.getString(string2);
                    } else if (string2.equals("DateTime")) {
                        object = this.getDateTime(string2);
                    } else if (string2.equals("Guid")) {
                        object = this.getGuid(string2);
                    } else if (string2.equals("ByteString")) {
                        object = this.getByteString(string2);
                    } else if (string2.equals("XmlElement")) {
                        object = this.getXmlElement(string2);
                    } else if (string2.equals("NodeId")) {
                        object = this.getNodeId(string2);
                    } else if (string2.equals("ExpandedNodeId")) {
                        object = this.getExpandedNodeId(string2);
                    } else if (string2.equals("StatusCode")) {
                        object = this.getStatusCode(string2);
                    } else if (string2.equals("DiagnosticInfo")) {
                        object = this.getDiagnosticInfo(string2);
                    } else if (string2.equals("QualifiedName")) {
                        object = this.getQualifiedName(string2);
                    } else if (string2.equals("LocalizedText")) {
                        object = this.getLocalizedText(string2);
                    } else if (string2.equals("ExtensionObject")) {
                        ExtensionObject extensionObject = this.getExtensionObject(string2);
                        try {
                            object = this.c(extensionObject);
                        }
                        catch (DecodingException decodingException) {
                            object = extensionObject;
                        }
                    } else if (string2.equals("DataValue")) {
                        object = this.getDataValue(string2);
                    } else if (string2.equals("Variant")) {
                        object = this.getVariant(string2);
                    }
                    arrayList.add((Boolean)object);
                    this.esM();
                }
                this.ap("Elements");
            }
            this.ap(string);
            if (MultiDimensionArrayUtils.getLength(nArray) != arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_DecodingError);
            }
            return MultiDimensionArrayUtils.demuxArray((Object)arrayList.toArray(), nArray, arrayList.get(0).getClass());
        }
        return null;
    }

    public NamespaceTable getNamespaceTable() {
        return this.iz;
    }

    @Override
    public NodeId[] getNodeIdArray(String string) throws DecodingException {
        ArrayList<NodeId> arrayList = new ArrayList<NodeId>();
        if (this.c(string, true)) {
            while (this.aq("NodeId")) {
                arrayList.add(this.getNodeId("NodeId"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new NodeId[0]);
    }

    @Override
    public QualifiedName[] getQualifiedNameArray(String string) throws DecodingException {
        ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
        if (this.c(string, true)) {
            while (this.aq("QualifiedName")) {
                arrayList.add(this.getQualifiedName("QualifiedName"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new QualifiedName[0]);
    }

    @Override
    public Byte[] getSByteArray(String string) throws DecodingException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        if (this.c(string, true)) {
            while (this.aq("SByte")) {
                arrayList.add(this.getSByte("SByte"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Byte[0]);
    }

    public ServerTable getServerTable() {
        return this.sN;
    }

    public void getStartElement() throws DecodingException {
        if (this.reader.isStartElement()) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
    }

    @Override
    public StatusCode[] getStatusCodeArray(String string) throws DecodingException {
        ArrayList<StatusCode> arrayList = new ArrayList<StatusCode>();
        if (this.c(string, true)) {
            while (this.aq("StatusCode")) {
                arrayList.add(this.getStatusCode("StatusCode"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new StatusCode[0]);
    }

    @Override
    public String[] getStringArray(String string) throws DecodingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.c(string, true)) {
            while (this.aq("String")) {
                arrayList.add(this.getString("String"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public UnsignedShort[] getUInt16Array(String string) throws DecodingException {
        ArrayList<UnsignedShort> arrayList = new ArrayList<UnsignedShort>();
        if (this.c(string, true)) {
            while (this.aq("UInt16")) {
                arrayList.add(this.getUInt16("UInt16"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new UnsignedShort[0]);
    }

    @Override
    public UnsignedInteger[] getUInt32Array(String string) throws DecodingException {
        ArrayList<UnsignedInteger> arrayList = new ArrayList<UnsignedInteger>();
        if (this.c(string, true)) {
            while (this.aq("UInt32")) {
                arrayList.add(this.getUInt32("UInt32"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new UnsignedInteger[0]);
    }

    @Override
    public UnsignedLong[] getUInt64Array(String string) throws DecodingException {
        ArrayList<UnsignedLong> arrayList = new ArrayList<UnsignedLong>();
        if (this.c(string, true)) {
            while (this.aq("UInt64")) {
                arrayList.add(this.getUInt64("UInt64"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new UnsignedLong[0]);
    }

    @Override
    public Variant[] getVariantArray(String string) throws DecodingException {
        ArrayList<Variant> arrayList = new ArrayList<Variant>();
        if (this.c(string, true)) {
            while (this.aq("Variant")) {
                arrayList.add(this.getVariant("Variant"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new Variant[0]);
    }

    public Object getVariantContents() throws DecodingException {
        while (this.reader.getEventType() != 1) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
        String string = this.reader.getLocalName();
        if (string.startsWith("ListOf")) {
            String string2 = string.substring("ListOf".length());
            if (string2.equals("Boolean")) {
                return this.getBooleanArray(string);
            }
            if (string2.equals("SByte")) {
                return this.getSByteArray(string);
            }
            if (string2.equals("Byte")) {
                return this.getByteArray(string);
            }
            if (string2.equals("Int16")) {
                return this.getInt16Array(string);
            }
            if (string2.equals("UInt16")) {
                return this.getUInt16Array(string);
            }
            if (string2.equals("Int32")) {
                return this.getInt32Array(string);
            }
            if (string2.equals("UInt32")) {
                return this.getUInt32Array(string);
            }
            if (string2.equals("Int64")) {
                return this.getInt64Array(string);
            }
            if (string2.equals("UInt64")) {
                return this.getUInt64Array(string);
            }
            if (string2.equals("Float")) {
                return this.getFloatArray(string);
            }
            if (string2.equals("Double")) {
                return this.getDoubleArray(string);
            }
            if (string2.equals("String")) {
                return this.getStringArray(string);
            }
            if (string2.equals("DateTime")) {
                return this.getDateTimeArray(string);
            }
            if (string2.equals("Guid")) {
                return this.getGuidArray(string);
            }
            if (string2.equals("ByteString")) {
                return this.getByteStringArray(string);
            }
            if (string2.equals("XmlElement")) {
                return this.getXmlElementArray(string);
            }
            if (string2.equals("NodeId")) {
                return this.getNodeIdArray(string);
            }
            if (string2.equals("ExpandedNodeId")) {
                return this.getExpandedNodeIdArray(string);
            }
            if (string2.equals("StatusCode")) {
                return this.getStatusCodeArray(string);
            }
            if (string2.equals("DiagnosticInfo")) {
                return this.getDiagnosticInfoArray(string);
            }
            if (string2.equals("QualifiedName")) {
                return this.getQualifiedNameArray(string);
            }
            if (string2.equals("LocalizedText")) {
                return this.getLocalizedTextArray(string);
            }
            if (string2.equals("ExtensionObject")) {
                ExtensionObject[] extensionObjectArray = this.getExtensionObjectArray(string);
                try {
                    return this.decode(extensionObjectArray);
                }
                catch (DecodingException decodingException) {
                    return extensionObjectArray;
                }
            }
            if (string2.equals("DataValue")) {
                return this.getDataValueArray(string);
            }
            if (string2.equals("Variant")) {
                return this.getVariantArray(string);
            }
        } else {
            if (string.equals("Null")) {
                if (this.c(string, true)) {
                    this.ap(string);
                }
                return null;
            }
            if (string.equals("Boolean")) {
                return this.getBoolean(string);
            }
            if (string.equals("SByte")) {
                return this.getSByte(string);
            }
            if (string.equals("Byte")) {
                return this.getByte(string);
            }
            if (string.equals("Int16")) {
                return this.getInt16(string);
            }
            if (string.equals("UInt16")) {
                return this.getUInt16(string);
            }
            if (string.equals("Int32")) {
                return this.getInt32(string);
            }
            if (string.equals("UInt32")) {
                return this.getUInt32(string);
            }
            if (string.equals("Int64")) {
                return this.getInt64(string);
            }
            if (string.equals("UInt64")) {
                return this.getUInt64(string);
            }
            if (string.equals("Float")) {
                return this.getFloat(string);
            }
            if (string.equals("Double")) {
                return this.getDouble(string);
            }
            if (string.equals("String")) {
                return this.getString(string);
            }
            if (string.equals("DateTime")) {
                return this.getDateTime(string);
            }
            if (string.equals("Guid")) {
                return this.getGuid(string);
            }
            if (string.equals("ByteString")) {
                return this.getByteString(string);
            }
            if (string.equals("XmlElement")) {
                return this.getXmlElement(string);
            }
            if (string.equals("NodeId")) {
                return this.getNodeId(string);
            }
            if (string.equals("ExpandedNodeId")) {
                return this.getExpandedNodeId(string);
            }
            if (string.equals("StatusCode")) {
                return this.getStatusCode(string);
            }
            if (string.equals("DiagnosticInfo")) {
                return this.getDiagnosticInfo(string);
            }
            if (string.equals("QualifiedName")) {
                return this.getQualifiedName(string);
            }
            if (string.equals("LocalizedText")) {
                return this.getLocalizedText(string);
            }
            if (string.equals("ExtensionObject")) {
                ExtensionObject extensionObject = this.getExtensionObject(string);
                try {
                    return this.c(extensionObject);
                }
                catch (DecodingException decodingException) {
                    return extensionObject;
                }
            }
            if (string.equals("DataValue")) {
                return this.getDataValue(string);
            }
            if (string.equals("Matrix")) {
                return this.getMatrix(string);
            }
        }
        throw new DecodingException(StatusCodes.Bad_DecodingError, "Element '" + this.reader.getNamespaceURI() + ":" + this.reader.getLocalName() + "' is not allowed in an Variant.");
    }

    @Override
    public XmlElement[] getXmlElementArray(String string) throws DecodingException {
        ArrayList<XmlElement> arrayList = new ArrayList<XmlElement>();
        if (this.c(string, true)) {
            while (this.aq("XmlElement")) {
                arrayList.add(this.getXmlElement("XmlElement"));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new XmlElement[0]);
    }

    public boolean loadStringTable(String string, String string2, List<String> list) throws DecodingException {
        if (!this.peek(string)) {
            return false;
        }
        this.getStartElement();
        while (this.peek(string2)) {
            String string3 = this.getString(string2);
            list.add(string3);
        }
        this.a(new QName(string, ug));
        return true;
    }

    public QName peek(int n2) {
        this.esJ();
        if (n2 != this.reader.getEventType()) {
            return null;
        }
        return new QName(this.reader.getLocalName(), this.reader.getNamespaceURI());
    }

    public boolean peek(String string) {
        this.esJ();
        if (1 != this.reader.getEventType()) {
            return false;
        }
        String string2 = this.reader.getLocalName();
        return string.equals(string2);
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.kg = encoderContext;
    }

    public void setNamespaceTable(NamespaceTable namespaceTable) {
        this.iz = namespaceTable;
        this.uq = null;
        if (namespaceTable != null && this.kg.getNamespaceTable() != null) {
            this.uq = this.a(namespaceTable, this.kg.getNamespaceTable(), false);
        }
    }

    public void setServerTable(ServerTable serverTable) {
        this.sN = serverTable;
        this.ur = null;
        if (serverTable != null && this.kg.getServerTable() != null) {
            this.ur = this.a(serverTable, this.kg.getServerTable(), false);
        }
    }

    private boolean b(String string, boolean bl) throws DecodingException {
        String string2;
        if (this.isNullOrEmpty(string)) {
            return true;
        }
        this.esL();
        if (!this.ao(string)) {
            if (!bl) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, String.format(Locale.ROOT, "Encountered element: '{1}:{0}' when expecting element: '{2}'.", this.reader.getLocalName(), this.reader.getNamespaceURI(), string));
            }
            return false;
        }
        if (this.reader.getAttributeCount() != 0 && !this.isNullOrEmpty(string2 = this.reader.getAttributeValue("nil", XML_SCHEMA_INSTANCE)) && Boolean.parseBoolean(string2)) {
            return false;
        }
        this.getStartElement();
        this.esJ();
        if (this.reader.getEventType() == 2 && this.reader.getLocalName() == string) {
            this.getEndElement();
            return false;
        }
        return true;
    }

    private UnsignedShort[] a(UriTable uriTable, UriTable uriTable2, boolean bl) {
        if (uriTable == null) {
            return null;
        }
        UnsignedShort[] unsignedShortArray = new UnsignedShort[uriTable.size()];
        for (int i2 = 0; i2 < uriTable.size(); ++i2) {
            String string = uriTable.getUri(i2);
            int n2 = uriTable2.getIndex(string);
            if (n2 < 0) {
                if (!bl) {
                    unsignedShortArray[i2] = UnsignedShort.MAX_VALUE;
                    continue;
                }
                n2 = uriTable2.add(-1, string);
            }
            unsignedShortArray[i2] = UnsignedShort.valueOf(n2);
        }
        return unsignedShortArray;
    }

    private Object c(ExtensionObject extensionObject) throws DecodingException {
        if (this.a(extensionObject)) {
            return this.c((XmlElement)extensionObject.getObject());
        }
        return extensionObject.decode(this.getEncoderContext(), this.iz);
    }

    private Object decode(ExtensionObject[] extensionObjectArray) throws DecodingException {
        Object object = this.b(extensionObjectArray);
        if (object instanceof ExtensionObject[]) {
            return this.getEncoderContext().decode(extensionObjectArray, this.iz);
        }
        return object;
    }

    /*
     * Exception decompiling
     */
    private String esI() throws DecodingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BigDecimal G(String string) throws DecodingException {
        ExtensionObject extensionObject = this.getExtensionObject(string);
        XmlElement xmlElement = (XmlElement)extensionObject.getObject();
        return this.c(xmlElement);
    }

    private BigDecimal[] N(String string) throws DecodingException {
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        if (this.c(string, true)) {
            while (this.aq("ExtensionObject")) {
                ExtensionObject extensionObject = this.getExtensionObject("ExtensionObject");
                arrayList.add(this.c((XmlElement)extensionObject.getObject()));
            }
            if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
        }
        return arrayList.toArray(new BigDecimal[0]);
    }

    private String O(String string) throws DecodingException {
        String string2 = EMPTY_STRING;
        boolean bl = true;
        int n2 = 0;
        try {
            do {
                int n3 = this.reader.getEventType();
                switch (n3) {
                    case 1: {
                        if (this.reader.getLocalName().equals(string)) {
                            bl = true;
                        }
                        if (bl) {
                            string2 = string2 + "<" + this.reader.getLocalName() + ">";
                        }
                        ++n2;
                        break;
                    }
                    case 4: {
                        if (!bl) break;
                        string2 = string2 + this.reader.getText();
                        break;
                    }
                    case 2: {
                        if (--n2 < 0) {
                            return string2;
                        }
                        if (this.reader.getLocalName().equals(string)) {
                            string2 = string2 + "</" + this.reader.getLocalName() + ">";
                            bl = false;
                        }
                        if (!bl || this.reader.getLocalName().equals(string)) break;
                        string2 = string2 + "</" + this.reader.getLocalName() + ">";
                        break;
                    }
                }
                this.reader.next();
            } while (this.reader.hasNext());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
        return string2;
    }

    private UaOptionSet a(String string, UaNodeId uaNodeId) throws DecodingException {
        OptionSetSpecification optionSetSpecification = this.getEncoderContext().getOptionSetSpecification(uaNodeId);
        if (optionSetSpecification == null) {
            throw new DecodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
        }
        Object obj = this.a(string, optionSetSpecification.getBaseTypeJavaClass(), optionSetSpecification.getBaseTypeId(), 0);
        try {
            return (UaOptionSet)new Variant(obj).asOptionSet(optionSetSpecification);
        }
        catch (Exception exception) {
            throw new DecodingException(exception, "Could not resolve the value as UaOptionSet");
        }
    }

    private String getString() throws DecodingException {
        String string = this.esI();
        if (string != null && this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < string.length()) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
        }
        return string;
    }

    private <T> T a(String string, Class<T> clazz, UaNodeId uaNodeId, int n2) throws DecodingException {
        Class clazz2;
        Object[] objectArray;
        if (n2 < 0) {
            throw new DecodingException("The given dimensions cannot be negative");
        }
        a<Object> a2 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = sW.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            objectArray = new AtomicReference();
            a2 = XmlDecoder.e(uaNodeId2, this.getEncoderContext(), objectArray);
            clazz2 = (Class)objectArray.get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a2 = XmlDecoder.j(clazz2);
        }
        if (n2 == 0) {
            objectArray = a2;
            return objectArray.get(this, string, clazz, uaNodeId);
        }
        if (n2 == 1) {
            objectArray = new ArrayList();
            a<Object> a3 = a2;
            String string2 = uaNodeId2 != null ? this.kg.getDataTypeSpecification(uaNodeId2).getName() : clazz2.getSimpleName();
            if (BigDecimal.class.equals((Object)clazz2) || UaIds.Decimal.equals(uaNodeId2)) {
                string2 = "ExtensionObject";
            }
            this.esL();
            if (!this.peek(string)) {
                return null;
            }
            if (this.c(string, true)) {
                while (this.aq(string2)) {
                    objectArray.add(a3.get(this, string2, clazz2, uaNodeId));
                }
                if (this.kg.getMaxArrayLength() > 0 && this.kg.getMaxArrayLength() < objectArray.size()) {
                    throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
                }
                this.ap(string);
            }
            int n3 = objectArray.size();
            Object[] objectArray2 = (Object[])Array.newInstance(clazz2, n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                objectArray2[i2] = objectArray.get(i2);
            }
            Object[] objectArray3 = objectArray2;
            return (T)objectArray3;
        }
        if (this.c(string, true)) {
            objectArray = this.getInt32Array_("Dimensions");
            if (objectArray == null) {
                return null;
            }
            int n4 = 1;
            for (Object object : objectArray) {
                if (object < 0) {
                    return null;
                }
                n4 *= object;
            }
            Object[] objectArray4 = (Object[])this.a("Elements", MultiDimensionArrayUtils.arrayClassOf(clazz2, 1), uaNodeId, 1);
            if (objectArray4.length != n4) {
                throw new DecodingException("The number of elements in array does not match dimensions");
            }
            this.ap(string);
            Object object = MultiDimensionArrayUtils.demuxArray((Object)objectArray4, (int[])objectArray, clazz2);
            return (T)object;
        }
        return null;
    }

    private Boolean P(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            boolean bl = Boolean.parseBoolean(string2.toLowerCase(Locale.ROOT));
            this.ap(string);
            return bl;
        }
        return false;
    }

    private UnsignedByte Q(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedByte unsignedByte = UnsignedByte.parseUnsignedByte(string2);
            this.ap(string);
            return unsignedByte;
        }
        return UnsignedByte.ZERO;
    }

    private ByteString R(String string) throws DecodingException {
        if (this.c(string, true)) {
            byte[] byArray = null;
            String string2 = this.esI();
            byArray = !this.isNullOrEmpty(string2) ? CryptoUtil.base64Decode(string2) : new byte[]{};
            if (this.kg.getMaxByteStringLength() > 0 && this.kg.getMaxByteStringLength() < byArray.length) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.ap(string);
            return ByteString.valueOf(byArray);
        }
        return null;
    }

    private DataValue S(String string) throws DecodingException {
        DataValue dataValue = new DataValue();
        if (this.c(string, true)) {
            dataValue.setValue(this.getVariant("Value"));
            dataValue.setStatusCode(this.getStatusCode("StatusCode"));
            dataValue.setSourceTimestamp(this.getDateTime("SourceTimestamp"));
            dataValue.setSourcePicoseconds(this.getUInt16("SourcePicoseconds"));
            dataValue.setServerTimestamp(this.getDateTime("ServerTimestamp"));
            dataValue.setServerPicoseconds(this.getUInt16("ServerPicoseconds"));
            this.ap(string);
        }
        return dataValue;
    }

    private DateTime T(String string) throws DecodingException {
        if (this.c(string, true)) {
            String string2 = this.getString();
            if (this.kg.getMaxStringLength() > 0 && this.kg.getMaxStringLength() < string2.length()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            if (!this.isNullOrEmpty(string2)) {
                DateTime dateTime;
                try {
                    dateTime = DateTime.parseDateTime(string2);
                }
                catch (ParseException parseException) {
                    throw new DecodingException(parseException);
                }
                this.ap(string);
                return dateTime;
            }
        }
        return DateTime.MIN_VALUE;
    }

    private DiagnosticInfo U(String string) throws DecodingException {
        DiagnosticInfo diagnosticInfo = null;
        if (this.c(string, true)) {
            diagnosticInfo = this.getDiagnosticInfo();
            this.ap(string);
            return diagnosticInfo;
        }
        return diagnosticInfo;
    }

    private Double V(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            double d2 = 0.0;
            if (string2.length() == 3) {
                if (string2 == "NaN") {
                    d2 = Double.NaN;
                }
                if (string2 == "INF") {
                    d2 = Double.POSITIVE_INFINITY;
                }
            }
            if (string2.length() == 4 && string2 == "-INF") {
                d2 = Double.NEGATIVE_INFINITY;
            }
            if (d2 == 0.0) {
                d2 = Double.parseDouble(string2);
            }
            this.ap(string);
            return d2;
        }
        return 0.0;
    }

    private <T extends Enumeration> T a(String string, Class<T> clazz, UaNodeId uaNodeId) throws DecodingException {
        Enumeration enumeration = null;
        if (clazz.getEnumConstants() != null && ((Enumeration[])clazz.getEnumConstants()).length > 0) {
            enumeration = ((Enumeration[])clazz.getEnumConstants())[0];
        }
        if (this.c(string, true)) {
            String string2 = this.getString();
            if (!this.isNullOrEmpty(string2)) {
                int n2 = string2.lastIndexOf(95);
                if (n2 != -1) {
                    int n3 = Integer.parseInt(string2.substring(n2 + 1));
                    try {
                        EnumerationSpecification enumerationSpecification = this.getEncoderContext().getEnumerationSpecification(uaNodeId);
                        if (enumerationSpecification != null) {
                            enumeration = enumerationSpecification.getByValue(n3);
                        }
                        Method method = clazz.getMethod("valueOf", Integer.TYPE);
                        enumeration = (Enumeration)method.invoke(null, n3);
                    }
                    catch (SecurityException securityException) {
                        throw new DecodingException(securityException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new DecodingException(noSuchMethodException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException(illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new DecodingException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new DecodingException(invocationTargetException);
                    }
                } else {
                    int n4 = Integer.parseInt(string2);
                    try {
                        EnumerationSpecification enumerationSpecification = this.getEncoderContext().getEnumerationSpecification(uaNodeId);
                        if (enumerationSpecification != null) {
                            enumeration = enumerationSpecification.getByValue(n4);
                        } else {
                            Method method = clazz.getMethod("valueOf", Integer.TYPE);
                            enumeration = (Enumeration)method.invoke(null, n4);
                        }
                    }
                    catch (SecurityException securityException) {
                        throw new DecodingException(securityException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new DecodingException(noSuchMethodException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException(illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new DecodingException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new DecodingException(invocationTargetException);
                    }
                }
            }
            this.ap(string);
        }
        return (T)enumeration;
    }

    private ExpandedNodeId W(String string) throws DecodingException {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.NULL;
        if (this.c(string, true)) {
            expandedNodeId = ExpandedNodeId.parseExpandedNodeId(this.getString("Identifier"));
            this.ap(string);
        }
        int n2 = expandedNodeId.getNamespaceIndex();
        int n3 = expandedNodeId.getServerIndex().intValue();
        boolean bl = false;
        if (this.uq != null && this.uq.length > expandedNodeId.getNamespaceIndex()) {
            n2 = this.uq[expandedNodeId.getNamespaceIndex()].intValue();
            bl = true;
        }
        if (this.ur != null && this.ur.length > expandedNodeId.getServerIndex().intValue()) {
            n3 = this.ur[expandedNodeId.getServerIndex().intValue()].intValue();
            bl = true;
        }
        if (bl) {
            expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n3), n2, expandedNodeId.getValue());
        }
        return expandedNodeId;
    }

    private ExtensionObject X(String string) throws IllegalArgumentException, DecodingException {
        if (!this.c(string, true)) {
            return null;
        }
        NodeId nodeId = this.getNodeId("TypeId");
        ExpandedNodeId expandedNodeId = this.kg.getNamespaceTable().toExpandedNodeId(nodeId);
        if (!NodeId.isNull(nodeId) && ExpandedNodeId.isNull(expandedNodeId)) {
            logger.error("Cannot de-serialized extension objects if the NamespaceUri is not in the NamespaceTable: Type = {}", (Object)nodeId);
        }
        if (!this.c("Body", true)) {
            this.ap(string);
            return new ExtensionObject(expandedNodeId, new XmlElement(EMPTY_STRING));
        }
        Object object = this.getExtensionObjectBody(expandedNodeId);
        this.ap("Body");
        this.ap(string);
        ExtensionObject extensionObject = object instanceof XmlElement ? new ExtensionObject(expandedNodeId, (XmlElement)object) : new ExtensionObject(expandedNodeId, (ByteString)object);
        try {
            if (this.iz == null) {
                Structure structure = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject(structure);
            }
            Structure structure = (Structure)extensionObject.decode(this.getEncoderContext(), this.iz);
            return new ExtensionObject(structure);
        }
        catch (DecodingException decodingException) {
            return extensionObject;
        }
    }

    private Float Y(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            float f2 = 0.0f;
            if (string2.length() == 3) {
                if (string2 == "NaN") {
                    f2 = Float.NaN;
                }
                if (string2 == "INF") {
                    f2 = Float.POSITIVE_INFINITY;
                }
            }
            if (string2.length() == 4 && string2 == "-INF") {
                f2 = Float.NEGATIVE_INFINITY;
            }
            if (f2 == 0.0f) {
                f2 = Float.parseFloat(string2);
            }
            this.ap(string);
            return Float.valueOf(f2);
        }
        return Float.valueOf(0.0f);
    }

    private UUID Z(String string) throws DecodingException {
        String string2 = null;
        if (this.c(string, true)) {
            string2 = this.getString("String");
            this.ap(string);
        }
        if (string2 == null) {
            return null;
        }
        return UUID.fromString(string2);
    }

    private Short aa(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            short s2 = Short.parseShort(string2);
            this.ap(string);
            return s2;
        }
        return (short)0;
    }

    private Integer ab(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            int n2 = Integer.parseInt(string2);
            this.ap(string);
            return n2;
        }
        return 0;
    }

    private Long ac(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            long l2 = Long.parseLong(string2);
            this.ap(string);
            return l2;
        }
        return 0L;
    }

    private LocalizedText ad(String string) throws DecodingException {
        if (this.c(string, true)) {
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            if (this.c("Locale", true)) {
                string3 = this.getString(null);
                this.ap("Locale");
            } else if (!bl) {
                string3 = EMPTY_STRING;
            }
            if (this.c("Text", true)) {
                string2 = this.getString(null);
                this.ap("Text");
            } else if (!bl) {
                string2 = EMPTY_STRING;
            }
            LocalizedText localizedText = LocalizedText.builder().setText(string2, string3).build();
            this.ap(string);
            return localizedText;
        }
        return LocalizedText.EMPTY;
    }

    private NodeId ae(String string) throws IllegalArgumentException, DecodingException {
        NodeId nodeId = null;
        if (this.c(string, true)) {
            nodeId = NodeId.parseNodeId(this.getString("Identifier"));
            this.ap(string);
        }
        if (this.uq != null && this.uq.length > nodeId.getNamespaceIndex()) {
            nodeId = NodeId.get(nodeId.getIdType(), this.uq[nodeId.getNamespaceIndex()].intValue(), nodeId.getValue());
        }
        return nodeId;
    }

    private QualifiedName af(String string) throws DecodingException {
        if (this.c(string, true)) {
            UnsignedShort unsignedShort = UnsignedShort.ZERO;
            if (this.c("NamespaceIndex", true)) {
                unsignedShort = this.getUInt16(null);
                this.ap("NamespaceIndex");
            }
            String string2 = null;
            if (this.c("Name", true)) {
                string2 = this.getString(null);
                this.ap("Name");
            }
            this.ap(string);
            if (this.uq != null && this.uq.length > unsignedShort.getValue()) {
                unsignedShort = this.uq[unsignedShort.getValue()];
            }
            return new QualifiedName(unsignedShort, string2);
        }
        return QualifiedName.NULL;
    }

    private Byte ag(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            byte by = Byte.parseByte(string2);
            this.ap(string);
            return by;
        }
        return (byte)0;
    }

    private StatusCode ah(String string) throws DecodingException {
        StatusCode statusCode = StatusCode.getFromBits(0);
        if (this.c(string, true)) {
            statusCode = new StatusCode(this.getUInt32("Code"));
            this.ap(string);
        }
        return statusCode;
    }

    private String ai(String string) throws DecodingException {
        if (this.c(string, true)) {
            String string2 = this.getString();
            if (string2 != null) {
                string2 = string2.trim();
            }
            this.ap(string);
            return string2;
        }
        return null;
    }

    private Structure a(String string, StructureSpecification structureSpecification) throws DecodingException {
        UnsignedLong unsignedLong = null;
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        if (!this.c(string, true)) {
            return builder.build();
        }
        if (StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
            unsignedLong = this.getUInt64("EncodingMask");
            logger.trace("EncodingMask: {}", (Object)unsignedLong);
        }
        if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
            long l2 = this.getUInt32("SwitchField").longValue();
            logger.trace("SwitchField: {}", (Object)l2);
            if (l2 < 0L) {
                throw new DecodingException("Union SwitchField must be >= 0");
            }
            if (l2 == 0L) {
                return builder.build();
            }
            long l3 = 0L;
            for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
                if (l2 != ++l3) continue;
                logger.trace("Decoded Union Field: {}, SwitchValue: {}", (Object)fieldSpecification, (Object)l3);
                builder.set(fieldSpecification, this.a(fieldSpecification));
                return builder.build();
            }
            throw new DecodingException("Union SwitchField overflow: " + ++l3);
        }
        int n2 = -1;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            if (fieldSpecification.isOptional()) {
                if ((unsignedLong.longValue() & (long)(1 << ++n2)) == 0L) continue;
                builder.set(fieldSpecification, this.a(fieldSpecification));
                continue;
            }
            builder.set(fieldSpecification, this.a(fieldSpecification));
        }
        this.ap(string);
        return builder.build();
    }

    private Object a(FieldSpecification fieldSpecification) throws DecodingException {
        int n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
        Class<?> clazz = fieldSpecification.getJavaClass();
        if (fieldSpecification.isAllowSubTypes()) {
            Class<?> clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            if (ExtensionObject.class.isAssignableFrom(clazz2)) {
                return this.a(fieldSpecification.getName(), MultiDimensionArrayUtils.arrayClassOf(ExtensionObject.class, n2), UaIds.Structure, n2);
            }
            return this.a(fieldSpecification.getName(), MultiDimensionArrayUtils.arrayClassOf(Variant.class, n2), UaIds.BaseDataType, n2);
        }
        return this.a(fieldSpecification.getName(), clazz, fieldSpecification.getDataTypeId(), n2);
    }

    private UnsignedShort aj(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedShort unsignedShort = UnsignedShort.parseUnsignedShort(string2);
            this.ap(string);
            return unsignedShort;
        }
        return UnsignedShort.ZERO;
    }

    private UnsignedInteger ak(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedInteger unsignedInteger = UnsignedInteger.parseUnsignedInteger(string2);
            this.ap(string);
            return unsignedInteger;
        }
        return UnsignedInteger.ZERO;
    }

    private UnsignedLong al(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.isNullOrEmpty(string2 = this.getString())) {
            UnsignedLong unsignedLong = UnsignedLong.parseUnsignedLong(string2);
            this.ap(string);
            return unsignedLong;
        }
        return UnsignedLong.valueOf(0L);
    }

    private Variant am(String string) throws DecodingException {
        Variant variant = new Variant(null);
        if (this.c(string, true)) {
            if (this.c("Value", true)) {
                Object object = this.getVariantContents();
                variant = new Variant(object);
                this.ap("Value");
            }
            if (!this.isNullOrEmpty(string)) {
                this.ap(string);
            }
        }
        return variant;
    }

    private XmlElement an(String string) throws DecodingException {
        if (this.c(string, true)) {
            return new XmlElement(this.O(EMPTY_STRING));
        }
        return null;
    }

    private void initialize() {
        this.reader = null;
    }

    private boolean a(ExtensionObject extensionObject) {
        return this.getEncoderContext().getNamespaceTable().nodeIdEquals(Identifiers.Decimal, extensionObject.getTypeId());
    }

    private boolean isNullOrEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    private boolean ao(String string) {
        this.esJ();
        return this.peek(string);
    }

    private void esJ() {
        while (this.reader.getEventType() != 12 && this.reader.getEventType() != 1 && this.reader.getEventType() != 2 && this.reader.getEventType() != 9 && this.reader.getEventType() != 4 && this.reader.getEventType() != 8) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private void esK() {
        while (this.reader.getEventType() != 2 && this.reader.getEventType() != 8) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private void esL() throws DecodingException {
        while (this.reader.getEventType() != 1 && this.reader.getEventType() != 2 && this.reader.getEventType() != 9 && this.reader.getEventType() != 8) {
            try {
                this.reader.nextTag();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private BigDecimal c(XmlElement xmlElement) throws DecodingException {
        XmlDecoder xmlDecoder = new XmlDecoder(xmlElement, this.getEncoderContext());
        xmlDecoder.c("Decimal", false);
        Short s2 = xmlDecoder.getInt16("Scale");
        String string = xmlDecoder.getString("Value").trim();
        xmlDecoder.close();
        return new BigDecimal(new BigInteger(string), s2.shortValue());
    }

    private void skip() throws XMLStreamException {
        int n2 = 0;
        this.reader.next();
        if (this.reader.getEventType() != 2) {
            ++n2;
            while (n2 != 0) {
                this.reader.next();
                if (this.reader.getEventType() != 1) {
                    ++n2;
                    continue;
                }
                if (this.reader.getEventType() == 1) continue;
                --n2;
            }
        }
        this.reader.next();
    }

    private void a(QName qName) throws DecodingException {
        this.esJ();
        int n2 = 1;
        while (n2 > 0) {
            if (this.reader.getEventType() == 2) {
                if (this.reader.getLocalName().equals(qName.getLocalPart()) && this.reader.getNamespaceURI().equals(qName.getNamespaceURI())) {
                    --n2;
                }
            } else if (this.reader.getEventType() == 1 && this.reader.getLocalName().equals(qName.getLocalPart()) && this.reader.getNamespaceURI().equals(qName.getNamespaceURI())) {
                ++n2;
            }
            try {
                this.skip();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
            this.esJ();
        }
    }

    private void esM() {
        while (this.reader.getEventType() == 4) {
            try {
                logger.trace("Skipping: <{}>", (Object)this.reader.getText());
                if (this.reader.hasNext()) {
                    this.reader.next();
                    continue;
                }
                logger.warn("Reached the END_DOCUMENT while skipping CHARACTERS events.");
                break;
            }
            catch (XMLStreamException xMLStreamException) {
                logger.error("Could not skip CHARACTERS events from the stream", xMLStreamException);
            }
        }
    }

    private Object b(ExtensionObject[] extensionObjectArray) throws DecodingException {
        BigDecimal[] bigDecimalArray = new BigDecimal[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (!this.a(extensionObject)) {
                return extensionObjectArray;
            }
            bigDecimalArray[i2] = this.c((XmlElement)extensionObject.getObject());
        }
        return bigDecimalArray;
    }

    boolean c(String string, boolean bl) throws DecodingException {
        return this.b(string, bl);
    }

    void ap(String string) throws DecodingException {
        if (!this.isNullOrEmpty(string)) {
            this.esK();
            int n2 = this.reader.getEventType();
            String string2 = this.reader.getLocalName();
            if (n2 != 2) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, "No end element found: '" + string2 + ":" + this.reader.getNamespaceURI() + "' eventType=" + n2);
            }
            if (!string2.equals(string)) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, "Encountered end element: '" + string2 + ":" + this.reader.getNamespaceURI() + "' when expecting element: '" + string + "'.");
            }
            this.getEndElement();
        }
    }

    @Deprecated
    <T> T a(String string, Class<T> clazz) throws DecodingException {
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        return this.a(string, clazz, null, n2);
    }

    boolean aq(String string) throws DecodingException {
        while (!this.reader.isStartElement()) {
            if (this.reader.getEventType() == 2) {
                return false;
            }
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
        if (this.isNullOrEmpty(string)) {
            return true;
        }
        return this.reader.getLocalName().equals(string);
    }

    static {
        tg = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        XmlDecoder.b(UaIds.Boolean, Boolean.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.P(string));
        XmlDecoder.b(UaIds.SByte, Byte.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ag(string));
        XmlDecoder.b(UaIds.Byte, UnsignedByte.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.Q(string));
        XmlDecoder.b(UaIds.Int16, Short.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.aa(string));
        XmlDecoder.b(UaIds.UInt16, UnsignedShort.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.aj(string));
        XmlDecoder.b(UaIds.Int32, Integer.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ab(string));
        XmlDecoder.b(UaIds.UInt32, UnsignedInteger.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ak(string));
        XmlDecoder.b(UaIds.Int64, Long.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ac(string));
        XmlDecoder.b(UaIds.UInt64, UnsignedLong.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.al(string));
        XmlDecoder.b(UaIds.Float, Float.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.Y(string));
        XmlDecoder.b(UaIds.Double, Double.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.V(string));
        XmlDecoder.b(UaIds.String, String.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ai(string));
        XmlDecoder.b(UaIds.Guid, UUID.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.Z(string));
        XmlDecoder.b(UaIds.ByteString, ByteString.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.R(string));
        XmlDecoder.b(UaIds.XmlElement, XmlElement.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.an(string));
        XmlDecoder.b(UaIds.NodeId, NodeId.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ae(string));
        XmlDecoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.W(string));
        XmlDecoder.b(UaIds.StatusCode, StatusCode.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ah(string));
        XmlDecoder.b(UaIds.QualifiedName, QualifiedName.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.af(string));
        XmlDecoder.b(UaIds.LocalizedText, LocalizedText.class, (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.ad(string));
        uh = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.T(string);
        XmlDecoder.a(UaIds.DateTime, DateTime.class, uh);
        ui = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.X(string);
        XmlDecoder.a(UaIds.Structure, ExtensionObject.class, ui);
        uj = (xmlDecoder, string, clazz, uaNodeId) -> {
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            StructureSpecification structureSpecification = xmlDecoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new DecodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            return xmlDecoder.a(string, structureSpecification);
        };
        uk = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.S(string);
        XmlDecoder.a(UaIds.DataValue, DataValue.class, uk);
        ul = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.am(string);
        um = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.U(string);
        XmlDecoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, um);
        un = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.a(string, clazz, uaNodeId);
        uo = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.G(string);
        XmlDecoder.a(UaIds.Decimal, BigDecimal.class, uo);
        up = (xmlDecoder, string, clazz, uaNodeId) -> xmlDecoder.a(string, uaNodeId);
        XmlDecoder.b(null, Object.class, (xmlDecoder, string, clazz, uaNodeId) -> ul.get(xmlDecoder, string, Variant.class, uaNodeId).getValue());
    }

    private static interface a<T> {
        public T get(XmlDecoder var1, String var2, Class<? extends T> var3, UaNodeId var4) throws DecodingException;
    }
}

