/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.json;

import com.prosysopc.ua.InternalHasDataTypeId;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.core.DataSetFieldContentMask;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEncoder
implements IEncoder {
    private static final Logger logger = LoggerFactory.getLogger(JsonEncoder.class);
    private static final String tO = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static DateTimeFormatter tP = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ROOT).withZone(ZoneOffset.UTC);
    private static final Map<UaNodeId, a<?>> sV = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> sW = new BijectionMap();
    private static final String tQ = "0001-01-01T00:00:00Z";
    private static final String tR = "9999-12-31T23:59:59Z";
    private static final Map<Class<?>, a<?>> sU = new HashMap();
    private static final a<DateTime> tS;
    private static final a<ExtensionObject> tT;
    private static final a<Structure> tU;
    private static final a<DataValue> tV;
    private static final a<Variant> tW;
    private static final a<DiagnosticInfo> tX;
    private static final a<Enumeration> tY;
    private static final a<BigDecimal> tZ;
    private static final a<UaOptionSet> ua;
    private EncoderContext ti;
    private List<Integer> ub = new ArrayList<Integer>();
    private boolean uc = true;
    private final Writer writer;
    private List<Integer> ud = new ArrayList<Integer>();
    private int ue;
    private int uf;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (sV.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (sW.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (sW.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            sW.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        a<T> a3 = sU.put(clazz, a2);
        if (a3 != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        JsonEncoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> i(Class<?> clazz) throws EncodingException {
        a<?> a2 = sU.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return tT;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return tU;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return tV;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return tW;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return tX;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return tY;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return tS;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return tZ;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return ua;
        }
        throw new EncodingException("Cannot encode class: " + clazz);
    }

    private static a<Object> d(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws EncodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return JsonEncoder.i(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return JsonEncoder.i(ExtensionObject.class);
        }
        a<Object> a2 = sV.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = sV.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = tU;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = ua;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = tY;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(sW.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new EncodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new EncodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    private static void a(Throwable throwable, String string, Object object) throws EncodingException {
        String string2 = String.format(Locale.ROOT, "fieldname=%s, value=%s", string, object);
        if (throwable instanceof ClosedChannelException) {
            throw new EncodingException(StatusCodes.Bad_ConnectionClosed, throwable, string2);
        }
        if (throwable instanceof EOFException) {
            throw new EncodingException(StatusCodes.Bad_EndOfStream, throwable, string2);
        }
        if (throwable instanceof ConnectException) {
            throw new EncodingException(StatusCodes.Bad_ConnectionRejected, throwable, string2);
        }
        if (throwable instanceof SocketException) {
            throw new EncodingException(StatusCodes.Bad_CommunicationError, throwable, string2);
        }
        throw new EncodingException(StatusCodes.Bad_UnexpectedError, throwable, string2);
    }

    public JsonEncoder(Writer writer) {
        this.writer = writer;
        this.ue = -1;
        this.uf = -1;
    }

    public void beginArray() throws EncodingException {
        try {
            this.writer.write("[");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "beginArray", null);
        }
        ++this.uf;
        this.ud.add(0);
    }

    public void beginArray(String string) throws EncodingException {
        this.K(string);
        this.beginArray();
    }

    public void beginObject() throws EncodingException {
        try {
            this.writer.write(123);
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "beginObject", null);
        }
        ++this.ue;
        this.ub.add(0);
    }

    public void beginObject(String string) throws EncodingException {
        this.K(string);
        this.beginObject();
    }

    public void close() throws EncodingException {
        if (this.ue > 0) {
            throw new EncodingException("JsonEncoder: close called without matching beginObject/endObject calls");
        }
        if (this.uf > 0) {
            throw new EncodingException("JsonEncoder: close called without matching beginArray/endArray calls");
        }
        if (this.ue == 0) {
            this.endObject();
        }
        if (this.uf == 0) {
            this.endArray();
        }
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "close", null);
        }
    }

    public void endArray() throws EncodingException {
        if (this.ud.size() > this.uf) {
            if (this.ud.size() > this.uf + 1) {
                throw new EncodingException("JsonEncoder: endArray called with invalid arrayIndex list");
            }
            this.ud.remove(this.uf);
        }
        if (this.uf-- < 0) {
            throw new EncodingException("JsonEncoder: endArray called without beginArray");
        }
        try {
            this.writer.write("]");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "endArray", null);
        }
    }

    public void endObject() throws EncodingException {
        if (this.ub.size() > this.ue) {
            if (this.ub.size() > this.ue + 1) {
                throw new EncodingException("JsonEncoder: endObject called with invalid fieldIndex list");
            }
            this.ub.remove(this.ue);
        }
        if (this.ue-- < 0) {
            throw new EncodingException("JsonEncoder: endObject called without beginObject");
        }
        try {
            this.writer.write(125);
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "endObject", this.ue);
        }
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.ti;
    }

    @Override
    public List<Locale> getLocales() {
        return new ArrayList<Locale>();
    }

    public boolean getReversibleEncoding() {
        return this.uc;
    }

    @Override
    public void put(String string, Object object, UaNodeId uaNodeId, int n2) throws EncodingException {
        this.a(string, object, null, uaNodeId, n2);
    }

    public void putArrayElement(Object object) throws EncodingException {
        this.esH();
        this.g(object);
    }

    @Override
    public void putBoolean(String string, Boolean bl) throws EncodingException {
        this.putObject(string, bl);
    }

    @Override
    public void putBooleanArray(String string, Boolean[] booleanArray) throws EncodingException {
        this.a(string, booleanArray);
    }

    @Override
    public void putBooleanArray(String string, Collection<Boolean> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putByte(String string, UnsignedByte unsignedByte) throws EncodingException {
        this.putObject(string, unsignedByte);
    }

    @Override
    public void putByteArray(String string, Collection<UnsignedByte> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putByteArray(String string, UnsignedByte[] unsignedByteArray) throws EncodingException {
        this.a(string, unsignedByteArray);
    }

    @Override
    public void putByteString(String string, ByteString byteString) throws EncodingException {
        if (byteString != null) {
            this.putObject(string, byteString.getValue());
        }
    }

    @Override
    public void putByteStringArray(String string, ByteString[] byteStringArray) throws EncodingException {
        this.a(string, byteStringArray);
    }

    @Override
    public void putByteStringArray(String string, Collection<ByteString> collection) throws EncodingException {
        this.a(string, collection);
    }

    public void putComma() throws EncodingException {
        try {
            this.writer.write(",");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "", "comma");
        }
    }

    @Override
    public void putDataValue(String string, DataValue dataValue) throws EncodingException {
        if (dataValue != null) {
            this.K(string);
            this.beginObject();
            if (dataValue.getValue().getValue() != null) {
                this.putVariant("Value", dataValue.getValue());
            }
            if (dataValue.getStatusCode() != StatusCode.GOOD) {
                this.putStatusCode("Status", dataValue.getStatusCode());
            }
            if (dataValue.getSourceTimestamp() != null) {
                this.putObject("SourceTimestamp", dataValue.getSourceTimestamp());
            }
            if (dataValue.getSourcePicoseconds() != null && dataValue.getSourcePicoseconds().intValue() != 0) {
                this.putObject("SourcePicoSeconds", dataValue.getSourcePicoseconds());
            }
            if (dataValue.getServerTimestamp() != null) {
                this.putObject("ServerTimestamp", dataValue.getServerTimestamp());
            }
            if (dataValue.getServerPicoseconds() != null && dataValue.getServerPicoseconds().intValue() != 0) {
                this.putObject("ServerPicoSeconds", dataValue.getServerPicoseconds());
            }
            this.endObject();
        }
    }

    public void putDataValue(String string, DataValue dataValue, DataSetFieldContentMask dataSetFieldContentMask) throws EncodingException {
        if (dataValue != null) {
            boolean bl;
            boolean bl2 = dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.RawData);
            boolean bl3 = bl = bl2 || ((UnsignedInteger)dataSetFieldContentMask.asBuiltInType()).getValue() == 0L;
            if (bl2 || bl) {
                this.putVariant(string, dataValue.getValue());
            } else {
                this.K(string);
                this.beginObject();
                this.putVariant("Value", dataValue.getValue());
                if (dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.StatusCode) && dataValue.getStatusCode() != StatusCode.GOOD) {
                    this.putStatusCode("Status", dataValue.getStatusCode());
                }
                if (dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.SourceTimestamp)) {
                    this.putObject("SourceTimestamp", dataValue.getSourceTimestamp());
                    if (dataValue.getSourcePicoseconds() != null && dataValue.getSourcePicoseconds().intValue() != 0) {
                        this.putObject("SourcePicoSeconds", dataValue.getSourcePicoseconds());
                    }
                }
                if (dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.ServerTimestamp)) {
                    this.putObject("ServerTimestamp", dataValue.getServerTimestamp());
                    if (dataValue.getServerPicoseconds() != null && dataValue.getServerPicoseconds().intValue() != 0) {
                        this.putObject("ServerPicoSeconds", dataValue.getServerPicoseconds());
                    }
                }
                this.endObject();
            }
        }
    }

    @Override
    public void putDataValueArray(String string, Collection<DataValue> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (DataValue dataValue : collection) {
                this.esH();
                if (dataValue == null) {
                    this.putNull();
                    continue;
                }
                this.putDataValue(null, dataValue);
            }
            this.endArray();
        }
    }

    @Override
    public void putDataValueArray(String string, DataValue[] dataValueArray) throws EncodingException {
        if (dataValueArray != null) {
            this.K(string);
            this.p(dataValueArray.length);
            this.beginArray();
            for (DataValue dataValue : dataValueArray) {
                this.esH();
                if (dataValue == null) {
                    this.putNull();
                    continue;
                }
                this.putDataValue(null, dataValue);
            }
            this.endArray();
        }
    }

    @Override
    public void putDateTime(String string, DateTime dateTime) throws EncodingException {
        this.putObject(string, dateTime);
    }

    @Override
    public void putDateTimeArray(String string, Collection<DateTime> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putDateTimeArray(String string, DateTime[] dateTimeArray) throws EncodingException {
        this.a(string, dateTimeArray);
    }

    @Override
    public void putDiagnosticInfo(String string, DiagnosticInfo diagnosticInfo) throws EncodingException {
        if (diagnosticInfo != null) {
            this.K(string);
            this.beginObject();
            this.putObject("SymbolicId", diagnosticInfo.getSymbolicId());
            this.putObject("NamespaceUri", diagnosticInfo.getNamespaceUri());
            this.putObject("Locale", diagnosticInfo.getLocale());
            this.putObject("LocalizedText", diagnosticInfo.getLocalizedText());
            this.putObject("Additional Info", diagnosticInfo.getAdditionalInfo());
            if (diagnosticInfo.getInnerStatusCode() != null && diagnosticInfo.getInnerStatusCode().isNotGood()) {
                if (this.uc) {
                    this.putObject("Inner StatusCode", diagnosticInfo.getInnerStatusCode().getValue());
                } else {
                    this.putStatusCode(null, diagnosticInfo.getInnerStatusCode());
                }
            }
            if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
                this.putDiagnosticInfo("Inner DiagnosticInfo", diagnosticInfo.getInnerDiagnosticInfo());
            }
            this.endObject();
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, Collection<DiagnosticInfo> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (DiagnosticInfo diagnosticInfo : collection) {
                this.esH();
                if (diagnosticInfo == null) {
                    this.putNull();
                    continue;
                }
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
            this.endArray();
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, DiagnosticInfo[] diagnosticInfoArray) throws EncodingException {
        if (diagnosticInfoArray != null) {
            this.K(string);
            this.p(diagnosticInfoArray.length);
            this.beginArray();
            for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
                this.esH();
                if (diagnosticInfo == null) {
                    this.putNull();
                    continue;
                }
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
            this.endArray();
        }
    }

    @Override
    public void putDouble(String string, double d2) throws EncodingException {
        this.putObject(string, d2);
    }

    @Override
    public void putDouble(String string, Double d2) throws EncodingException {
        this.putObject(string, d2);
    }

    @Override
    public void putDoubleArray(String string, Collection<Double> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putDoubleArray(String string, Double[] doubleArray) throws EncodingException {
        this.a(string, doubleArray);
    }

    @Override
    public void putExpandedNodeId(String string, ExpandedNodeId expandedNodeId) throws EncodingException {
        if (expandedNodeId != null) {
            this.K(string);
            this.beginObject();
            this.s(expandedNodeId.getIdType().getValue());
            this.putObject("Id", expandedNodeId.getValue());
            if (expandedNodeId.getNamespaceUri() != null) {
                this.a("Namespace", this.ti.getNamespaceTable().getIndex(expandedNodeId.getNamespaceUri()));
            } else {
                this.a("Namespace", expandedNodeId.getNamespaceIndex());
            }
            this.k(expandedNodeId.getServerIndex());
            this.endObject();
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, Collection<ExpandedNodeId> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (ExpandedNodeId expandedNodeId : collection) {
                this.esH();
                if (expandedNodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putExpandedNodeId(null, expandedNodeId);
            }
            this.endArray();
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, ExpandedNodeId[] expandedNodeIdArray) throws EncodingException {
        if (expandedNodeIdArray != null) {
            this.K(string);
            this.p(expandedNodeIdArray.length);
            this.beginArray();
            for (ExpandedNodeId expandedNodeId : expandedNodeIdArray) {
                this.esH();
                if (expandedNodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putExpandedNodeId(null, expandedNodeId);
            }
            this.endArray();
        }
    }

    @Override
    public void putExtensionObject(String string, ExtensionObject extensionObject) throws EncodingException {
        if (extensionObject != null) {
            Object object;
            UaNodeId uaNodeId;
            this.K(string);
            this.beginObject();
            if (extensionObject.getTypeId() != null && this.getReversibleEncoding()) {
                this.putExpandedNodeId("TypeId", extensionObject.getTypeId());
            } else if (this.getReversibleEncoding() && extensionObject.getObject() instanceof Structure && (uaNodeId = (object = ((Structure)extensionObject.getObject()).specification()).getJsonEncodeId()) != null) {
                this.putExpandedNodeId("TypeId", uaNodeId.asExpandedNodeId());
            }
            object = extensionObject.getObject();
            if (object != null) {
                if (object instanceof ByteString) {
                    if (this.getReversibleEncoding()) {
                        this.putObject("Encoding", 1);
                    }
                    this.putByteString("Body", (ByteString)object);
                } else if (object instanceof XmlElement) {
                    if (this.getReversibleEncoding()) {
                        this.putObject("Encoding", 2);
                    }
                    this.putXmlElement("Body", (XmlElement)object);
                } else {
                    this.putStructure("Body", (Structure)extensionObject.getObject());
                }
            }
            this.endObject();
        }
    }

    @Override
    public void putExtensionObjectArray(String string, Collection<ExtensionObject> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (ExtensionObject extensionObject : collection) {
                this.esH();
                if (extensionObject == null) {
                    this.putNull();
                    continue;
                }
                this.putExtensionObject(null, extensionObject);
            }
            this.endArray();
        }
    }

    @Override
    public void putExtensionObjectArray(String string, ExtensionObject[] extensionObjectArray) throws EncodingException {
        if (extensionObjectArray != null) {
            this.K(string);
            this.p(extensionObjectArray.length);
            this.beginArray();
            for (ExtensionObject extensionObject : extensionObjectArray) {
                this.esH();
                if (extensionObject == null) {
                    this.putNull();
                    continue;
                }
                this.putExtensionObject(null, extensionObject);
            }
            this.endArray();
        }
    }

    @Override
    public void putFloat(String string, float f2) throws EncodingException {
        this.putObject(string, Float.valueOf(f2));
    }

    @Override
    public void putFloat(String string, Float f2) throws EncodingException {
        this.putObject(string, f2);
    }

    @Override
    public void putFloatArray(String string, Collection<Float> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putFloatArray(String string, Float[] floatArray) throws EncodingException {
        this.a(string, floatArray);
    }

    @Override
    public void putGuid(String string, UUID uUID) throws EncodingException {
        this.putObject(string, uUID);
    }

    @Override
    public void putGuidArray(String string, Collection<UUID> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putGuidArray(String string, UUID[] uUIDArray) throws EncodingException {
        this.a(string, uUIDArray);
    }

    @Override
    public void putInt16(String string, short s2) throws EncodingException {
        this.putObject(string, s2);
    }

    @Override
    public void putInt16(String string, Short s2) throws EncodingException {
        this.putObject(string, s2);
    }

    @Override
    public void putInt16Array(String string, Collection<Short> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putInt16Array(String string, Short[] shortArray) throws EncodingException {
        this.a(string, shortArray);
    }

    @Override
    public void putInt32(String string, int n2) throws EncodingException {
        this.putObject(string, n2);
    }

    @Override
    public void putInt32(String string, Integer n2) throws EncodingException {
        this.putObject(string, n2);
    }

    @Override
    public void putInt32Array(String string, Collection<Integer> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putInt32Array(String string, int[] nArray) throws EncodingException {
        if (nArray != null) {
            this.p(nArray.length);
            this.K(string);
            this.beginArray();
            for (int n2 : nArray) {
                this.putArrayElement(n2);
            }
            this.endArray();
        }
    }

    @Override
    public void putInt32Array(String string, Integer[] integerArray) throws EncodingException {
        this.a(string, integerArray);
    }

    @Override
    public void putInt64(String string, long l2) throws EncodingException {
        this.putObject(string, l2);
    }

    @Override
    public void putInt64(String string, Long l2) throws EncodingException {
        this.putObject(string, l2);
    }

    @Override
    public void putInt64Array(String string, Collection<Long> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putInt64Array(String string, Long[] longArray) throws EncodingException {
        this.a(string, longArray);
    }

    @Override
    public void putLocalizedText(String string, LocalizedText localizedText) throws EncodingException {
        if (localizedText != null) {
            this.K(string);
            localizedText = localizedText.asSingleLocale(this.getLocales());
            String string2 = localizedText.getLocaleId();
            String string3 = localizedText.getText();
            if (this.uc) {
                this.beginObject();
                if (string3 != null && !string3.isEmpty()) {
                    this.putObject("Text", string3);
                }
                if (string2 != null && !string2.isEmpty()) {
                    this.putObject("Locale", string2);
                }
                this.endObject();
            } else {
                this.g(localizedText.getText());
            }
        }
    }

    @Override
    public void putLocalizedTextArray(String string, Collection<LocalizedText> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (LocalizedText localizedText : collection) {
                this.esH();
                if (localizedText == null) {
                    this.putNull();
                    continue;
                }
                this.putLocalizedText(null, localizedText);
            }
            this.endArray();
        }
    }

    @Override
    public void putLocalizedTextArray(String string, LocalizedText[] localizedTextArray) throws EncodingException {
        if (localizedTextArray != null) {
            this.K(string);
            this.p(localizedTextArray.length);
            this.beginArray();
            for (LocalizedText localizedText : localizedTextArray) {
                this.esH();
                if (localizedText == null) {
                    this.putNull();
                    continue;
                }
                this.putLocalizedText(null, localizedText);
            }
            this.endArray();
        }
    }

    @Override
    public void putNodeId(String string, NodeId nodeId) throws EncodingException {
        if (nodeId != null) {
            this.K(string);
            this.beginObject();
            this.s(nodeId.getIdType().getValue());
            this.putObject("Id", nodeId.getValue());
            this.a("Namespace", nodeId.getNamespaceIndex());
            this.endObject();
        }
    }

    @Override
    public void putNodeIdArray(String string, Collection<NodeId> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (NodeId nodeId : collection) {
                if (nodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putNodeId(null, nodeId);
            }
            this.endArray();
        }
    }

    @Override
    public void putNodeIdArray(String string, NodeId[] nodeIdArray) throws EncodingException {
        if (nodeIdArray != null) {
            this.K(string);
            this.p(nodeIdArray.length);
            this.beginArray();
            for (NodeId nodeId : nodeIdArray) {
                this.esH();
                if (nodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putNodeId(null, nodeId);
            }
            this.endArray();
        }
    }

    @Deprecated
    public void putObject(String string, Object object) throws EncodingException {
        if (object != null) {
            this.K(string);
            this.g(object);
        }
    }

    @Override
    public void putQualifiedName(String string, QualifiedName qualifiedName) throws EncodingException {
        if (qualifiedName != null) {
            this.K(string);
            this.beginObject();
            this.putObject("Name", qualifiedName.getName());
            this.a("Uri", qualifiedName.getNamespaceIndex());
            this.endObject();
        }
    }

    @Override
    public void putQualifiedNameArray(String string, Collection<QualifiedName> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (QualifiedName qualifiedName : collection) {
                this.esH();
                if (qualifiedName == null) {
                    this.putNull();
                    continue;
                }
                this.putQualifiedName(null, qualifiedName);
            }
            this.endArray();
        }
    }

    @Override
    public void putQualifiedNameArray(String string, QualifiedName[] qualifiedNameArray) throws EncodingException {
        if (qualifiedNameArray != null) {
            this.K(string);
            this.p(qualifiedNameArray.length);
            this.beginArray();
            for (QualifiedName qualifiedName : qualifiedNameArray) {
                this.esH();
                if (qualifiedName == null) {
                    this.putNull();
                    continue;
                }
                this.putQualifiedName(null, qualifiedName);
            }
            this.endArray();
        }
    }

    @Override
    public void putSByte(String string, byte by) throws EncodingException {
        this.putObject(string, by);
    }

    @Override
    public void putSByte(String string, Byte by) throws EncodingException {
        this.putObject(string, by);
    }

    @Override
    public void putSByte(String string, int n2) throws EncodingException {
        this.putObject(string, n2);
    }

    @Override
    public void putSByteArray(String string, Byte[] byteArray) throws EncodingException {
        this.a(string, byteArray);
    }

    @Override
    public void putSByteArray(String string, Collection<Byte> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putStatusCode(String string, StatusCode statusCode) throws EncodingException {
        if (statusCode == null) {
            return;
        }
        if (StatusCode.GOOD.equals(statusCode)) {
            this.K(null);
            if (this.esD() > 0) {
                this.putNull();
            }
            return;
        }
        this.K(string);
        if (!this.uc) {
            this.beginObject();
            this.putObject("Code", statusCode.getValue());
            this.putObject("Symbol", statusCode.getName());
            this.endObject();
        } else {
            this.g(statusCode.getValue());
        }
    }

    @Override
    public void putStatusCodeArray(String string, Collection<StatusCode> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.p(collection.size());
            this.beginArray();
            for (StatusCode statusCode : collection) {
                this.esH();
                if (statusCode == null || statusCode == StatusCode.GOOD) {
                    this.putNull();
                    continue;
                }
                this.putStatusCode(null, statusCode);
            }
            this.endArray();
        }
    }

    @Override
    public void putStatusCodeArray(String string, StatusCode[] statusCodeArray) throws EncodingException {
        if (statusCodeArray != null) {
            this.K(string);
            this.p(statusCodeArray.length);
            this.beginArray();
            for (StatusCode statusCode : statusCodeArray) {
                this.esH();
                if (statusCode == null || statusCode.isGood()) {
                    this.putNull();
                    continue;
                }
                this.putStatusCode(null, statusCode);
            }
            this.endArray();
        }
    }

    @Override
    public void putString(String string, String string2) throws EncodingException {
        this.putObject(string, string2);
    }

    @Override
    public void putStringArray(String string, Collection<String> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putStringArray(String string, String[] stringArray) throws EncodingException {
        this.a(string, stringArray);
    }

    @Deprecated
    public void putStructure(String string, Structure structure) throws EncodingException {
        if (structure != null) {
            this.a(string, (Object)structure, structure.getClass());
        }
    }

    @Override
    public void putUInt16(String string, UnsignedShort unsignedShort) throws EncodingException {
        this.putObject(string, unsignedShort);
    }

    @Override
    public void putUInt16Array(String string, Collection<UnsignedShort> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putUInt16Array(String string, UnsignedShort[] unsignedShortArray) throws EncodingException {
        this.a(string, unsignedShortArray);
    }

    @Override
    public void putUInt32(String string, UnsignedInteger unsignedInteger) throws EncodingException {
        this.putObject(string, unsignedInteger);
    }

    @Override
    public void putUInt32Array(String string, Collection<UnsignedInteger> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putUInt32Array(String string, UnsignedInteger[] unsignedIntegerArray) throws EncodingException {
        this.a(string, unsignedIntegerArray);
    }

    @Override
    public void putUInt64(String string, UnsignedLong unsignedLong) throws EncodingException {
        this.putObject(string, unsignedLong);
    }

    @Override
    public void putUInt64Array(String string, Collection<UnsignedLong> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putUInt64Array(String string, UnsignedLong[] unsignedLongArray) throws EncodingException {
        this.a(string, unsignedLongArray);
    }

    @Override
    @Deprecated
    public void putVariant(String string, Variant variant) throws EncodingException {
        if (variant != null && !variant.isEmpty()) {
            Integer n2 = BuiltinsMap.ID_MAP.get(variant.getCompositeClass());
            if (n2 == null && Structure.class.isAssignableFrom(variant.getCompositeClass())) {
                n2 = 22;
            }
            if (n2 == null || n2 == 0) {
                return;
            }
            this.K(string);
            if (this.uc) {
                this.beginObject();
                this.putObject("Type", n2);
                this.a("Body", variant);
                int[] nArray = variant.getArrayDimensions();
                if (nArray.length > 1) {
                    this.putInt32Array("Dimensions", nArray);
                }
                this.endObject();
            } else {
                this.a(null, variant);
            }
        }
    }

    @Deprecated
    public void putVariantArray(String string, Collection<Variant> collection) throws EncodingException {
        this.p(collection.size());
        this.K(string);
        this.beginArray();
        for (Variant variant : collection) {
            this.esH();
            if (variant != null && BuiltinsMap.ID_MAP.get(variant.getCompositeClass()) != 0) {
                this.putVariant(null, variant);
                continue;
            }
            this.putNull();
        }
        this.endArray();
    }

    @Override
    public void putVariantArray(String string, Variant[] variantArray) throws EncodingException {
        this.p(variantArray.length);
        this.K(string);
        this.beginArray();
        for (Variant variant : variantArray) {
            this.esH();
            if (variant != null && BuiltinsMap.ID_MAP.get(variant.getCompositeClass()) != 0) {
                this.putVariant(null, variant);
                continue;
            }
            this.putNull();
        }
        this.endArray();
    }

    @Override
    public void putXmlElement(String string, XmlElement xmlElement) throws EncodingException {
        this.putObject(string, xmlElement);
    }

    @Override
    public void putXmlElementArray(String string, Collection<XmlElement> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putXmlElementArray(String string, XmlElement[] xmlElementArray) throws EncodingException {
        this.a(string, xmlElementArray);
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ti = encoderContext;
    }

    public void setReversibleEncoding(boolean bl) {
        this.uc = bl;
    }

    public String toString() {
        return this.writer.toString();
    }

    private void p(int n2) throws EncodingException {
        int n3 = this.ti.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void l(int n2) throws EncodingException {
        int n3 = this.ti.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
            throw encodingException;
        }
    }

    private Integer esD() {
        if (this.uf < 0) {
            return -1;
        }
        return this.ud.get(this.uf);
    }

    private Integer esE() {
        return this.ub.get(this.ue);
    }

    private void a(String string, Object object, Class<?> clazz, UaNodeId uaNodeId, int n2) throws EncodingException {
        Class<?> clazz2;
        Object[] objectArray;
        a<Object> a2 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 != null || clazz != null) {
            // empty if block
        }
        if (uaNodeId2 != null) {
            objectArray = new AtomicReference();
            a2 = JsonEncoder.d(uaNodeId2, this.getEncoderContext(), objectArray);
            clazz2 = objectArray.get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a2 = JsonEncoder.i(clazz2);
        }
        if (n2 == 0) {
            a2.put(this, string, object, clazz2);
            return;
        }
        if (n2 == 1) {
            if (object == null) {
                return;
            }
            objectArray = (Object[])object;
            this.p(objectArray.length);
            if (string != null) {
                this.K(string);
                this.beginArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.a(objectArray[i2], a2, clazz2);
                }
                this.endArray();
            }
            return;
        }
        if (object == null) {
            objectArray = new int[n2];
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                objectArray[i3] = -1;
            }
            this.putInt32Array((String)null, (int[])objectArray);
            return;
        }
        objectArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray2 = (Object[])MultiDimensionArrayUtils.muxArray(object, (int[])objectArray, clazz2);
        int n3 = objectArray2.length;
        this.p(n3);
        this.putInt32Array((String)null, (int[])objectArray);
        for (Object object2 : objectArray2) {
            a2.put(this, null, object2, clazz2);
        }
    }

    private void a(String string, Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        if (structure == null) {
            return;
        }
        this.K(string);
        this.beginObject();
        this.b(structure, structureSpecification);
        this.endObject();
    }

    private void esF() {
        this.ud.set(this.uf, this.esD() + 1);
    }

    private void esG() {
        this.ub.set(this.ue, this.esE() + 1);
    }

    private String J(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block9: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void a(String string, Collection<?> collection) throws EncodingException {
        if (collection != null) {
            this.p(collection.size());
            this.K(string);
            this.beginArray();
            for (Object obj : collection) {
                this.putArrayElement(obj);
            }
            this.endArray();
        }
    }

    private void a(String string, Object[] objectArray) throws EncodingException {
        if (objectArray != null) {
            this.p(objectArray.length);
            this.K(string);
            this.beginArray();
            for (Object object : objectArray) {
                if (object != null && MultiDimensionArrayUtils.getDimension(object) > 0) {
                    this.esH();
                    this.a(null, (Object[])object);
                    continue;
                }
                this.putArrayElement(object);
            }
            this.endArray();
        }
    }

    private void esH() throws EncodingException {
        if (this.esD() > 0) {
            this.putComma();
        }
        this.esF();
    }

    private void a(Object object, a<Object> a2, Class<?> clazz) throws EncodingException {
        this.esH();
        if (object == null) {
            this.putNull();
        } else {
            a2.put(this, null, object, clazz);
        }
    }

    private void a(String string, BigDecimal bigDecimal) throws EncodingException {
        if (bigDecimal != null) {
            this.K(string);
            this.beginObject();
            this.putObject("Scale", bigDecimal.scale());
            this.putObject("Value", bigDecimal.unscaledValue());
            this.endObject();
        }
    }

    private void K(String string) throws EncodingException {
        if (this.ue == -1 && this.uf == -1) {
            this.beginObject();
        }
        if (string != null) {
            if (this.esE() > 0) {
                this.putComma();
            }
            try {
                this.writer.write(this.L(string) + ":");
            }
            catch (IOException iOException) {
                JsonEncoder.a(iOException, "fieldName", string);
            }
            this.esG();
        }
    }

    private void s(int n2) throws EncodingException {
        if (n2 != 0) {
            this.putObject("IdType", n2);
        }
    }

    private void a(String string, int n2) throws EncodingException {
        if (n2 != 0) {
            if (n2 == 1 || this.uc) {
                this.putObject(string, n2);
            } else {
                String string2 = this.ti.getNamespaceTable().getUri(n2);
                if (string2 == null) {
                    throw new EncodingException(new String("Unable to find matching Namespace Uri for Namespace Index: " + n2));
                }
                this.putObject(string, string2);
            }
        }
    }

    private void putNull() throws EncodingException {
        try {
            this.writer.write("null");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "null", null);
        }
    }

    private void a(String string, UaOptionSet uaOptionSet, Class<? extends UaOptionSet> clazz) throws EncodingException {
        if (uaOptionSet != null) {
            this.put(string, uaOptionSet, uaOptionSet.specification().getTypeId(), 0);
        }
    }

    private void k(UnsignedInteger unsignedInteger) throws EncodingException {
        if (unsignedInteger.intValue() != 0) {
            if (this.uc) {
                this.putObject("ServerUri", unsignedInteger);
            } else {
                String string = this.ti.getServerTable().getUri(unsignedInteger.intValue());
                if (string == null) {
                    throw new EncodingException(new String("Unable to find matching Server Uri for Server Index: " + unsignedInteger));
                }
                this.putObject("ServerUri", string);
            }
        }
    }

    private void b(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        if (structure == null) {
            return;
        }
        Map<FieldSpecification, Object> map = structure.toFieldsMap(structureSpecification);
        if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
            long l2 = 0L;
            FieldSpecification fieldSpecification = null;
            Object object = null;
            for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                ++l2;
                if (entry.getValue() == null) continue;
                fieldSpecification = entry.getKey();
                object = entry.getValue();
                break;
            }
            if (fieldSpecification == null) {
                return;
            }
            this.putUInt32("SwitchField", UnsignedInteger.valueOf(l2));
            int n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
            this.put(fieldSpecification.getName(), object, fieldSpecification.getDataTypeId(), n2);
            return;
        }
        if (this.uc && StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
            int n3 = -1;
            long l3 = 0L;
            for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                if (!entry.getKey().isOptional()) continue;
                ++n3;
                if (entry.getValue() == null) continue;
                l3 |= (long)(1 << n3);
            }
            this.putUInt64("EncodingMask", UnsignedLong.getFromBits(l3));
        }
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            int n4;
            FieldSpecification fieldSpecification = entry.getKey();
            Object object = entry.getValue();
            if (fieldSpecification.isOptional() && object == null) continue;
            int n5 = n4 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
            if (fieldSpecification.isAllowSubTypes()) {
                if (ExtensionObject.class.isAssignableFrom(fieldSpecification.getCompositeClass())) {
                    this.put(fieldSpecification.getName(), object, UaIds.Structure, n4);
                    continue;
                }
                if (Object.class.equals(fieldSpecification.getCompositeClass())) {
                    this.put(fieldSpecification.getName(), object, UaIds.BaseDataType, n4);
                    continue;
                }
                throw new EncodingException("The java class for AllowSubTypes field should either be ExtensionObject.class or Object.class, got: " + fieldSpecification + "in structure type: " + structureSpecification);
            }
            this.put(fieldSpecification.getName(), object, fieldSpecification.getDataTypeId(), n4);
        }
    }

    @Deprecated
    private void a(String string, Structure[] structureArray) throws EncodingException {
        if (structureArray != null) {
            this.K(string);
            this.p(structureArray.length);
            this.beginArray();
            for (Structure structure : structureArray) {
                this.esH();
                if (structure == null) {
                    this.putNull();
                    continue;
                }
                this.putStructure(null, structure);
            }
            this.endArray();
        }
    }

    private void g(Object object) throws EncodingException {
        try {
            this.writer.write(this.h(object));
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "value", null);
        }
    }

    private void a(String string, Variant variant) throws EncodingException {
        if (variant != null) {
            Object object;
            Object object2;
            if (variant instanceof InternalHasDataTypeId && (object2 = ((InternalHasDataTypeId)((Object)variant)).getDataTypeId()) != null && (object = this.getEncoderContext().getEnumerationSpecification((UaNodeId)object2)) != null) {
                Object object3 = variant.asEnum((EnumerationSpecification)object);
                this.put(string, object3, ((EnumerationSpecification)object).getTypeId(), MultiDimensionArrayUtils.getDimension(object3));
                return;
            }
            if (variant.getDimension() > 0) {
                this.b(string, variant);
                return;
            }
            object2 = variant.getValue();
            object = BuiltinsMap.ID_MAP.get(variant.getCompositeClass());
            if (object == null && Structure.class.isAssignableFrom(variant.getCompositeClass())) {
                object = 22;
            }
            switch ((Integer)object) {
                case 1: {
                    this.putBoolean(string, (Boolean)object2);
                    break;
                }
                case 2: {
                    this.putSByte(string, (Byte)object2);
                    break;
                }
                case 3: {
                    this.putByte(string, (UnsignedByte)object2);
                    break;
                }
                case 4: {
                    this.putInt16(string, (Short)object2);
                    break;
                }
                case 5: {
                    this.putUInt16(string, (UnsignedShort)object2);
                    break;
                }
                case 6: {
                    this.putInt32(string, (Integer)object2);
                    break;
                }
                case 7: {
                    this.putUInt32(string, (UnsignedInteger)object2);
                    break;
                }
                case 8: {
                    this.putInt64(string, (Long)object2);
                    break;
                }
                case 9: {
                    this.putUInt64(string, (UnsignedLong)object2);
                    break;
                }
                case 10: {
                    this.putFloat(string, (Float)object2);
                    break;
                }
                case 11: {
                    this.putDouble(string, (Double)object2);
                    break;
                }
                case 12: {
                    this.putString(string, (String)object2);
                    break;
                }
                case 13: {
                    this.putDateTime(string, (DateTime)object2);
                    break;
                }
                case 14: {
                    this.putGuid(string, (UUID)object2);
                    break;
                }
                case 15: {
                    this.putByteString(string, (ByteString)object2);
                    break;
                }
                case 16: {
                    this.putXmlElement(string, (XmlElement)object2);
                    break;
                }
                case 17: {
                    this.putNodeId(string, (NodeId)object2);
                    break;
                }
                case 18: {
                    this.putExpandedNodeId(string, (ExpandedNodeId)object2);
                    break;
                }
                case 19: {
                    this.putStatusCode(string, (StatusCode)object2);
                    break;
                }
                case 20: {
                    this.putQualifiedName(string, (QualifiedName)object2);
                    break;
                }
                case 21: {
                    this.putLocalizedText(string, (LocalizedText)object2);
                    break;
                }
                case 22: {
                    if (object2 instanceof Structure) {
                        this.putExtensionObject(string, new ExtensionObject((Structure)object2));
                        break;
                    }
                    this.putExtensionObject(string, (ExtensionObject)object2);
                    break;
                }
                case 23: {
                    this.putDataValue(string, (DataValue)object2);
                    break;
                }
                case 24: {
                    this.putVariant(string, (Variant)object2);
                    break;
                }
                case 25: {
                    this.putDiagnosticInfo(string, (DiagnosticInfo)object2);
                    break;
                }
                default: {
                    throw new EncodingException("cannot encode builtin type " + object);
                }
            }
        }
    }

    private void b(String string, Variant variant) throws EncodingException {
        int[] nArray = variant.getArrayDimensions();
        Object object = variant.getValue();
        if (this.uc && nArray.length > 1) {
            Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, variant.getCompositeClass());
            this.a(string, objectArray);
            return;
        }
        this.a(string, (Object[])object);
    }

    private String c(byte[] byArray) throws EncodingException {
        if (byArray == null) {
            return "null";
        }
        this.l(byArray.length);
        return "\"" + CryptoUtil.base64Encode(byArray) + "\"";
    }

    private String f(DateTime dateTime) {
        String string;
        try {
            string = dateTime.compareTo(DateTime.MAX_VALUE) >= 0 ? tR : (dateTime.compareTo(DateTime.MIN_VALUE) <= 0 ? tQ : tP.format(dateTime.toInstant()));
        }
        catch (Exception exception) {
            string = tQ;
        }
        return this.L(string);
    }

    private String d(Double d2) {
        if (!d2.equals(Double.NaN)) {
            return d2.toString();
        }
        return "\"NaN\"";
    }

    private String b(Enumeration enumeration) {
        if (enumeration == null) {
            throw new IllegalStateException("Given Enumeration value shouldn't be null at this point");
        }
        String string = null;
        if (!this.uc) {
            if (enumeration.specification() != null) {
                string = enumeration.specification().getIntToStringMappings().get(enumeration.getValue());
            } else {
                logger.warn("Encountered Enumeration for which .specification returned null, using number form for encoding as a fallback");
            }
        }
        if (string == null) {
            return Integer.toString(enumeration.getValue());
        }
        return this.L(string + "_" + enumeration.getValue());
    }

    private String b(Float f2) {
        if (!f2.equals(Float.valueOf(Float.NaN))) {
            return f2.toString();
        }
        return "\"NaN\"";
    }

    private String L(String string) {
        if (string == null) {
            return "null";
        }
        if (string.startsWith("{")) {
            return string;
        }
        return "\"" + this.J(string) + "\"";
    }

    private String b(UUID uUID) {
        return this.L(uUID.toString());
    }

    private String b(XmlElement xmlElement) {
        return this.L(xmlElement.getValue());
    }

    private String h(Object object) throws EncodingException {
        if (object instanceof byte[]) {
            return this.c((byte[])object);
        }
        if (object instanceof ByteString) {
            return this.c(((ByteString)object).getValue());
        }
        if (object instanceof String || object == null) {
            return this.L((String)object);
        }
        if (object instanceof Enumeration) {
            return this.b((Enumeration)object);
        }
        if (object instanceof Float) {
            return this.b((Float)object);
        }
        if (object instanceof Double) {
            return this.d((Double)object);
        }
        if (object instanceof DateTime) {
            return this.f((DateTime)object);
        }
        if (object instanceof UUID) {
            return this.b((UUID)object);
        }
        if (object instanceof XmlElement) {
            return this.b((XmlElement)object);
        }
        if (object instanceof Long || object instanceof UnsignedLong) {
            return "\"" + object + "\"";
        }
        return object.toString();
    }

    @Deprecated
    void put(String string, Object object) throws EncodingException {
        this.a(string, object, object.getClass());
    }

    @Deprecated
    void a(String string, Object object, Class<?> clazz) throws EncodingException {
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        this.a(string, object, clazz, null, n2);
    }

    static {
        JsonEncoder.b(UaIds.Boolean, Boolean.class, (jsonEncoder, string, bl, clazz) -> jsonEncoder.putBoolean(string, (Boolean)bl));
        JsonEncoder.b(UaIds.SByte, Byte.class, (jsonEncoder, string, by, clazz) -> jsonEncoder.putSByte(string, (Byte)by));
        JsonEncoder.b(UaIds.Byte, UnsignedByte.class, (jsonEncoder, string, unsignedByte, clazz) -> jsonEncoder.putByte(string, (UnsignedByte)unsignedByte));
        JsonEncoder.b(UaIds.Int16, Short.class, (jsonEncoder, string, s2, clazz) -> jsonEncoder.putInt16(string, (Short)s2));
        JsonEncoder.b(UaIds.UInt16, UnsignedShort.class, (jsonEncoder, string, unsignedShort, clazz) -> jsonEncoder.putUInt16(string, (UnsignedShort)unsignedShort));
        JsonEncoder.b(UaIds.Int32, Integer.class, (jsonEncoder, string, n2, clazz) -> jsonEncoder.putInt32(string, (Integer)n2));
        JsonEncoder.b(UaIds.UInt32, UnsignedInteger.class, (jsonEncoder, string, unsignedInteger, clazz) -> jsonEncoder.putUInt32(string, (UnsignedInteger)unsignedInteger));
        JsonEncoder.b(UaIds.Int64, Long.class, (jsonEncoder, string, l2, clazz) -> jsonEncoder.putInt64(string, (Long)l2));
        JsonEncoder.b(UaIds.UInt64, UnsignedLong.class, (jsonEncoder, string, unsignedLong, clazz) -> jsonEncoder.putUInt64(string, (UnsignedLong)unsignedLong));
        JsonEncoder.b(UaIds.Float, Float.class, (jsonEncoder, string, f2, clazz) -> jsonEncoder.putFloat(string, (Float)f2));
        JsonEncoder.b(UaIds.Double, Double.class, (jsonEncoder, string, d2, clazz) -> jsonEncoder.putDouble(string, (Double)d2));
        JsonEncoder.b(UaIds.String, String.class, (jsonEncoder, string, string2, clazz) -> jsonEncoder.putString(string, (String)string2));
        JsonEncoder.b(UaIds.Guid, UUID.class, (jsonEncoder, string, uUID, clazz) -> jsonEncoder.putGuid(string, (UUID)uUID));
        JsonEncoder.b(UaIds.ByteString, ByteString.class, (jsonEncoder, string, byteString, clazz) -> jsonEncoder.putByteString(string, (ByteString)byteString));
        JsonEncoder.b(UaIds.XmlElement, XmlElement.class, (jsonEncoder, string, xmlElement, clazz) -> jsonEncoder.putXmlElement(string, (XmlElement)xmlElement));
        JsonEncoder.b(UaIds.NodeId, NodeId.class, (jsonEncoder, string, nodeId, clazz) -> jsonEncoder.putNodeId(string, (NodeId)nodeId));
        JsonEncoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (jsonEncoder, string, expandedNodeId, clazz) -> jsonEncoder.putExpandedNodeId(string, (ExpandedNodeId)expandedNodeId));
        JsonEncoder.b(UaIds.StatusCode, StatusCode.class, (jsonEncoder, string, statusCode, clazz) -> jsonEncoder.putStatusCode(string, (StatusCode)statusCode));
        JsonEncoder.b(UaIds.QualifiedName, QualifiedName.class, (jsonEncoder, string, qualifiedName, clazz) -> jsonEncoder.putQualifiedName(string, (QualifiedName)qualifiedName));
        JsonEncoder.b(UaIds.LocalizedText, LocalizedText.class, (jsonEncoder, string, localizedText, clazz) -> jsonEncoder.putLocalizedText(string, (LocalizedText)localizedText));
        tS = (jsonEncoder, string, dateTime, clazz) -> jsonEncoder.putDateTime(string, (DateTime)dateTime);
        JsonEncoder.a(UaIds.DateTime, DateTime.class, tS);
        tT = (jsonEncoder, string, extensionObject, clazz) -> jsonEncoder.putExtensionObject(string, (ExtensionObject)extensionObject);
        JsonEncoder.a(UaIds.Structure, ExtensionObject.class, tT);
        tU = (jsonEncoder, string, structure, clazz) -> {
            StructureSpecification structureSpecification = null;
            if (structure != null) {
                structureSpecification = structure.specification();
            }
            jsonEncoder.a(string, (Structure)structure, structureSpecification);
        };
        tV = (jsonEncoder, string, dataValue, clazz) -> jsonEncoder.putDataValue(string, (DataValue)dataValue);
        JsonEncoder.a(UaIds.DataValue, DataValue.class, tV);
        tW = (jsonEncoder, string, variant, clazz) -> jsonEncoder.putVariant(string, (Variant)variant);
        tX = (jsonEncoder, string, diagnosticInfo, clazz) -> jsonEncoder.putDiagnosticInfo(string, (DiagnosticInfo)diagnosticInfo);
        JsonEncoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, tX);
        tY = (jsonEncoder, string, enumeration, clazz) -> jsonEncoder.putObject(string, enumeration);
        tZ = (jsonEncoder, string, bigDecimal, clazz) -> jsonEncoder.a(string, (BigDecimal)bigDecimal);
        JsonEncoder.a(UaIds.Decimal, BigDecimal.class, tZ);
        ua = (jsonEncoder, string, uaOptionSet, clazz) -> jsonEncoder.a(string, (UaOptionSet)uaOptionSet, clazz);
        JsonEncoder.b(null, Object.class, (jsonEncoder, string, object, clazz) -> {
            if (object == null) {
                tW.put(jsonEncoder, string, null, Variant.class);
            } else if (object instanceof Variant) {
                tW.put(jsonEncoder, string, (Variant)object, Variant.class);
            } else {
                tW.put(jsonEncoder, string, new Variant(object), Variant.class);
            }
        });
    }

    private static interface a<T> {
        public void put(JsonEncoder var1, String var2, T var3, Class<? extends T> var4) throws EncodingException;
    }
}

