/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.json;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.json.b;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDecoder
implements IDecoder {
    private static final Logger logger = LoggerFactory.getLogger(JsonDecoder.class);
    private static final Map<Class<?>, a<?>> sU = new HashMap();
    private static final Map<UaNodeId, a<?>> sV = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> sW = new BijectionMap();
    private static final a<DateTime> ty;
    private static final a<ExtensionObject> tz;
    private static final a<Structure> tA;
    private static final a<DataValue> tB;
    private static final a<Variant> tC;
    private static final a<DiagnosticInfo> tD;
    private static final a<Enumeration> tE;
    private static final a<BigDecimal> tF;
    private static final a<UaOptionSet> tG;
    private EncoderContext ti;
    private InputStream in;
    private InputStreamReader tH;
    private com.prosysopc.ua.stack.encoding.json.a tI;
    private Stack<com.prosysopc.ua.stack.encoding.json.a> tJ = new Stack();
    private boolean tK = false;
    private char tL;
    private boolean tM = false;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (sV.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (sW.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (sW.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            sW.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serializtion helper");
        }
        a<T> a3 = sU.put(clazz, a2);
        if (a3 != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        JsonDecoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> h(Class<?> clazz) throws DecodingException {
        a<?> a2 = sU.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return tz;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return tA;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return tB;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return tC;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return tD;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return tE;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return ty;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return tF;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return tG;
        }
        throw new DecodingException("Cannot decode class: " + clazz);
    }

    private static a<Object> c(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws DecodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return JsonDecoder.h(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return JsonDecoder.h(ExtensionObject.class);
        }
        a<Object> a2 = sV.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = sV.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = tA;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = tG;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = tE;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(sW.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new DecodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new DecodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    @Override
    public <T> T get(String string, UaNodeId uaNodeId, int n2) throws DecodingException {
        Object object;
        Class clazz;
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            clazz = Object.class;
        } else if (UaIds.Structure.equals(uaNodeId)) {
            clazz = ExtensionObject.class;
        } else {
            object = this.getEncoderContext().getDataTypeSpecification(uaNodeId);
            if (object == null) {
                throw new DecodingException("Cannot find UaDataTypeSpecification, cannot decode DataType: " + uaNodeId);
            }
            clazz = object.getJavaClass();
        }
        object = this.I(string);
        if (object == null) {
            return null;
        }
        if (n2 > 0 && !((com.prosysopc.ua.stack.encoding.json.a)object).esy()) {
            throw new DecodingException("JsonDecoder: field '" + string + "' is not an array as expected");
        }
        Object object2 = this.a((com.prosysopc.ua.stack.encoding.json.a)object, clazz, uaNodeId, n2);
        return (T)object2;
    }

    @Override
    public Boolean getBoolean(String string) throws DecodingException {
        return this.a(string, Boolean.class);
    }

    @Override
    public Boolean[] getBooleanArray(String string) throws DecodingException {
        return this.a(string, Boolean[].class);
    }

    @Override
    public UnsignedByte getByte(String string) throws DecodingException {
        return this.a(string, UnsignedByte.class);
    }

    @Override
    public UnsignedByte[] getByteArray(String string) throws DecodingException {
        return this.a(string, UnsignedByte[].class);
    }

    @Override
    public ByteString getByteString(String string) throws DecodingException {
        return this.a(string, ByteString.class);
    }

    @Override
    public ByteString[] getByteStringArray(String string) throws DecodingException {
        return this.a(string, ByteString[].class);
    }

    @Override
    public DataValue getDataValue(String string) throws DecodingException {
        return this.a(string, DataValue.class);
    }

    @Override
    public DataValue[] getDataValueArray(String string) throws DecodingException {
        return this.a(string, DataValue[].class);
    }

    @Override
    public DateTime getDateTime(String string) throws DecodingException {
        return this.a(string, DateTime.class);
    }

    @Override
    public DateTime[] getDateTimeArray(String string) throws DecodingException {
        return this.a(string, DateTime[].class);
    }

    @Override
    public DiagnosticInfo getDiagnosticInfo(String string) throws DecodingException {
        return this.a(string, DiagnosticInfo.class);
    }

    @Override
    public DiagnosticInfo[] getDiagnosticInfoArray(String string) throws DecodingException {
        return this.a(string, DiagnosticInfo[].class);
    }

    @Override
    public Double getDouble(String string) throws DecodingException {
        return this.a(string, Double.class);
    }

    @Override
    public Double[] getDoubleArray(String string) throws DecodingException {
        return this.a(string, Double[].class);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.ti;
    }

    @Override
    public ExpandedNodeId getExpandedNodeId(String string) throws DecodingException {
        return this.a(string, ExpandedNodeId.class);
    }

    @Override
    public ExpandedNodeId[] getExpandedNodeIdArray(String string) throws DecodingException {
        return this.a(string, ExpandedNodeId[].class);
    }

    @Override
    public ExtensionObject getExtensionObject(String string) throws DecodingException {
        return this.a(string, ExtensionObject.class);
    }

    @Override
    public ExtensionObject[] getExtensionObjectArray(String string) throws DecodingException {
        return this.a(string, ExtensionObject[].class);
    }

    public Set<String> getFieldNames() throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.eso();
        if (!a2.esz()) {
            return new HashSet<String>();
        }
        return a2.esx().getFieldNames();
    }

    @Override
    public Float getFloat(String string) throws DecodingException {
        return this.a(string, Float.class);
    }

    @Override
    public Float[] getFloatArray(String string) throws DecodingException {
        return this.a(string, Float[].class);
    }

    @Override
    public UUID getGuid(String string) throws DecodingException {
        return this.a(string, UUID.class);
    }

    @Override
    public UUID[] getGuidArray(String string) throws DecodingException {
        return this.a(string, UUID[].class);
    }

    @Override
    public Short getInt16(String string) throws DecodingException {
        return this.a(string, Short.class);
    }

    @Override
    public Short[] getInt16Array(String string) throws DecodingException {
        return this.a(string, Short[].class);
    }

    @Override
    public Integer getInt32(String string) throws DecodingException {
        return this.a(string, Integer.class);
    }

    @Override
    public Integer[] getInt32Array(String string) throws DecodingException {
        return this.a(string, Integer[].class);
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        Integer[] integerArray = this.getInt32Array(string);
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    @Override
    public Long getInt64(String string) throws DecodingException {
        return this.a(string, Long.class);
    }

    @Override
    public Long[] getInt64Array(String string) throws DecodingException {
        return this.a(string, Long[].class);
    }

    public String getJson(String string) throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.I(string);
        if (a2 == null) {
            return null;
        }
        return a2.esC();
    }

    public int getJsonArraySize() throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.eso();
        if (!a2.esy()) {
            return -1;
        }
        return a2.esw().size();
    }

    @Override
    public LocalizedText getLocalizedText(String string) throws DecodingException {
        return this.a(string, LocalizedText.class);
    }

    @Override
    public LocalizedText[] getLocalizedTextArray(String string) throws DecodingException {
        return this.a(string, LocalizedText[].class);
    }

    @Override
    public NodeId getNodeId(String string) throws DecodingException {
        return this.a(string, NodeId.class);
    }

    @Override
    public NodeId[] getNodeIdArray(String string) throws DecodingException {
        return this.a(string, NodeId[].class);
    }

    @Override
    public QualifiedName getQualifiedName(String string) throws DecodingException {
        return this.a(string, QualifiedName.class);
    }

    @Override
    public QualifiedName[] getQualifiedNameArray(String string) throws DecodingException {
        return this.a(string, QualifiedName[].class);
    }

    @Override
    public Byte getSByte(String string) throws DecodingException {
        return this.a(string, Byte.class);
    }

    @Override
    public Byte[] getSByteArray(String string) throws DecodingException {
        return this.a(string, Byte[].class);
    }

    @Override
    public StatusCode getStatusCode(String string) throws DecodingException {
        return this.a(string, StatusCode.class);
    }

    @Override
    public StatusCode[] getStatusCodeArray(String string) throws DecodingException {
        return this.a(string, StatusCode[].class);
    }

    @Override
    public String getString(String string) throws DecodingException {
        return this.a(string, String.class);
    }

    @Override
    public String[] getStringArray(String string) throws DecodingException {
        return this.a(string, String[].class);
    }

    @Override
    public UnsignedShort getUInt16(String string) throws DecodingException {
        return this.a(string, UnsignedShort.class);
    }

    @Override
    public UnsignedShort[] getUInt16Array(String string) throws DecodingException {
        return this.a(string, UnsignedShort[].class);
    }

    @Override
    public UnsignedInteger getUInt32(String string) throws DecodingException {
        return this.a(string, UnsignedInteger.class);
    }

    @Override
    public UnsignedInteger[] getUInt32Array(String string) throws DecodingException {
        return this.a(string, UnsignedInteger[].class);
    }

    @Override
    public UnsignedLong getUInt64(String string) throws DecodingException {
        return this.a(string, UnsignedLong.class);
    }

    @Override
    public UnsignedLong[] getUInt64Array(String string) throws DecodingException {
        return this.a(string, UnsignedLong[].class);
    }

    @Override
    public Variant getVariant(String string) throws DecodingException {
        return this.a(string, Variant.class);
    }

    @Override
    public Variant[] getVariantArray(String string) throws DecodingException {
        return this.a(string, Variant[].class);
    }

    @Override
    public XmlElement getXmlElement(String string) throws DecodingException {
        return this.a(string, XmlElement.class);
    }

    @Override
    public XmlElement[] getXmlElementArray(String string) throws DecodingException {
        return this.a(string, XmlElement[].class);
    }

    public void popElementStack() {
        if (this.tJ.isEmpty()) {
            return;
        }
        this.tJ.pop();
    }

    public void pushElementStack(int n2) throws DecodingException {
        ArrayList<com.prosysopc.ua.stack.encoding.json.a> arrayList = this.eso().esw();
        this.tJ.push((com.prosysopc.ua.stack.encoding.json.a)arrayList.get(n2));
    }

    public void pushElementStack(String string) throws DecodingException {
        this.tJ.push(this.I(string));
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ti = encoderContext;
    }

    public void setReadable(InputStream inputStream) {
        this.in = inputStream;
        this.tH = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.tK = false;
        this.tJ.clear();
    }

    private Object a(com.prosysopc.ua.stack.encoding.json.a a2, int n2) throws DecodingException {
        Class clazz;
        switch (n2) {
            case 1: {
                clazz = Boolean.class;
                break;
            }
            case 2: {
                clazz = Byte.class;
                break;
            }
            case 3: {
                clazz = UnsignedByte.class;
                break;
            }
            case 4: {
                clazz = Short.class;
                break;
            }
            case 5: {
                clazz = UnsignedShort.class;
                break;
            }
            case 6: {
                clazz = Integer.class;
                break;
            }
            case 7: {
                clazz = UnsignedInteger.class;
                break;
            }
            case 8: {
                clazz = Long.class;
                break;
            }
            case 9: {
                clazz = UnsignedLong.class;
                break;
            }
            case 10: {
                clazz = Float.class;
                break;
            }
            case 11: {
                clazz = Double.class;
                break;
            }
            case 12: {
                clazz = String.class;
                break;
            }
            case 13: {
                clazz = DateTime.class;
                break;
            }
            case 14: {
                clazz = UUID.class;
                break;
            }
            case 15: {
                clazz = ByteString.class;
                break;
            }
            case 16: {
                clazz = XmlElement.class;
                break;
            }
            case 17: {
                clazz = NodeId.class;
                break;
            }
            case 18: {
                clazz = ExpandedNodeId.class;
                break;
            }
            case 19: {
                clazz = StatusCode.class;
                break;
            }
            case 20: {
                clazz = QualifiedName.class;
                break;
            }
            case 21: {
                clazz = LocalizedText.class;
                break;
            }
            case 22: {
                clazz = ExtensionObject.class;
                break;
            }
            case 23: {
                clazz = DataValue.class;
                break;
            }
            case 24: {
                clazz = Variant.class;
                break;
            }
            case 25: {
                clazz = DiagnosticInfo.class;
                break;
            }
            default: {
                throw new DecodingException("Cannot decode builtin type id " + n2);
            }
        }
        this.tJ.push(a2);
        Object obj = this.a("Body", MultiDimensionArrayUtils.arrayClassOf(clazz, 1));
        this.tJ.pop();
        return obj;
    }

    private Boolean a(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return Boolean.parseBoolean(a2.getString());
    }

    private UnsignedByte b(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        String string = a2.getString();
        if (string.isEmpty()) {
            return null;
        }
        return UnsignedByte.valueOf(string);
    }

    private ByteString c(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return ByteString.valueOf(CryptoUtil.base64Decode(a2.getString()));
    }

    private DataValue d(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null) {
            return null;
        }
        if (a2.esz()) {
            b b2 = a2.esx();
            Variant variant = this.z(b2.M("Value"));
            DateTime dateTime = this.e(b2.M("SourceTimestamp"));
            UnsignedShort unsignedShort = this.w(b2.M("SourcePicoSeconds"));
            DateTime dateTime2 = this.e(b2.M("ServerTimestamp"));
            UnsignedShort unsignedShort2 = this.w(b2.M("ServerPicoSeconds"));
            StatusCode statusCode = this.u(b2.M("Status"));
            return new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2);
        }
        return null;
    }

    private DateTime e(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        try {
            return DateTime.parseDateTime(a2.getString());
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
    }

    private BigDecimal f(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        b b2 = a2.esx();
        Integer n2 = this.n(b2.M("Scale"));
        Long l2 = Long.valueOf(b2.M("Value").getString());
        return BigDecimal.valueOf(l2, n2);
    }

    private DiagnosticInfo g(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        b b2 = a2.esx();
        String string = this.v(b2.M("Additional Info"));
        DiagnosticInfo diagnosticInfo = this.g(b2.M("Inner DiagnosticInfo"));
        StatusCode statusCode = this.u(b2.M("Inner StatusCode"));
        if (statusCode == null) {
            statusCode = StatusCode.GOOD;
        }
        Integer n2 = this.n(b2.M("Locale"));
        Integer n3 = this.n(b2.M("LocalizedText"));
        Integer n4 = this.n(b2.M("NamespaceUri"));
        Integer n5 = this.n(b2.M("SymbolicId"));
        return new DiagnosticInfo(string, diagnosticInfo, statusCode, n2, n3, n4, n5);
    }

    private Double h(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return this.B(a2);
    }

    private <T extends Enumeration> T a(com.prosysopc.ua.stack.encoding.json.a a2, Class<T> clazz, UaNodeId uaNodeId) throws DecodingException {
        if (a2 != null && a2.esA()) {
            try {
                Method method = clazz.getMethod("valueOf", Integer.TYPE);
                if (a2.esB()) {
                    EnumerationSpecification enumerationSpecification = this.getEncoderContext().getEnumerationSpecification(uaNodeId);
                    if (enumerationSpecification != null) {
                        return (T)enumerationSpecification.getByValue(this.C(a2));
                    }
                    return (T)((Enumeration)method.invoke(null, this.C(a2)));
                }
                String[] stringArray = a2.getString().split("_");
                int n2 = Integer.parseInt(stringArray[stringArray.length - 1]);
                EnumerationSpecification enumerationSpecification = this.getEncoderContext().getEnumerationSpecification(uaNodeId);
                if (enumerationSpecification != null) {
                    return (T)enumerationSpecification.getByValue(n2);
                }
                return (T)((Enumeration)method.invoke(null, n2));
            }
            catch (Exception exception) {
                throw new DecodingException(exception, "cannot decode" + clazz);
            }
        }
        return null;
    }

    private ExpandedNodeId i(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || !a2.esz()) {
            return null;
        }
        b b2 = a2.esx();
        Object object = null;
        Integer n2 = this.n(b2.M("IdType"));
        if (n2 == null || n2 == 0) {
            object = this.x(b2.M("Id"));
        } else {
            switch (n2) {
                case 1: {
                    object = this.v(b2.M("Id"));
                    break;
                }
                case 2: {
                    object = this.l(b2.M("Id"));
                    break;
                }
                case 3: {
                    object = this.c(b2.M("Id"));
                }
            }
        }
        UnsignedInteger unsignedInteger = this.x(b2.M("ServerUri"));
        com.prosysopc.ua.stack.encoding.json.a a3 = b2.M("Namespace");
        if (a3 == null) {
            return new ExpandedNodeId(unsignedInteger, 0, object);
        }
        if (a3.esB()) {
            return new ExpandedNodeId(unsignedInteger, this.C(a3), object);
        }
        return new ExpandedNodeId(unsignedInteger, a3.getString(), object);
    }

    private ExtensionObject j(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 != null && a2.esz()) {
            ExtensionObject extensionObject;
            Object object;
            b b2 = a2.esx();
            ExpandedNodeId expandedNodeId = this.i(b2.M("TypeId"));
            UaNodeId uaNodeId = UaNodeId.fromLocal(expandedNodeId, this.ti.getNamespaceTable());
            expandedNodeId = uaNodeId.asExpandedNodeId();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.M("Encoding");
            Integer n2 = a3 != null && a3.esB() ? this.C(a3) : 0;
            if (a3 == null || a3.isNull() || n2 == 0) {
                object = b2.M("Body");
                extensionObject = new ExtensionObject(expandedNodeId, object == null ? null : ((com.prosysopc.ua.stack.encoding.json.a)object).esC());
            } else if (n2 == 1) {
                extensionObject = new ExtensionObject(expandedNodeId, this.c(b2.M("Body")));
            } else if (n2 == 2) {
                extensionObject = new ExtensionObject(expandedNodeId, this.A(b2.M("Body")));
            } else {
                throw new DecodingException("Unknown encoding byte: " + n2);
            }
            try {
                object = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject((Structure)object);
            }
            catch (DecodingException decodingException) {
                return extensionObject;
            }
        }
        return null;
    }

    private Float k(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Float.valueOf(Float.parseFloat(a2.getString()));
    }

    private UUID l(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return UUID.fromString(a2.getString());
    }

    private Short m(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Short.decode(a2.getString());
    }

    private Integer n(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return this.C(a2);
    }

    private Long o(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Long.valueOf(Long.parseLong(a2.getString()));
    }

    private LocalizedText p(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null) {
            return null;
        }
        if (a2.esz()) {
            b b2 = a2.esx();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.M("Text");
            String string = a3 == null ? null : a3.getString();
            com.prosysopc.ua.stack.encoding.json.a a4 = b2.M("Locale");
            if (a4 == null) {
                return LocalizedText.builder().setText(string, LocalizedText.NO_LOCALE).build();
            }
            return LocalizedText.builder().setText(string, a4.getString()).build();
        }
        if (a2.esA()) {
            return LocalizedText.builder().setText(a2.getString(), LocalizedText.NO_LOCALE).build();
        }
        return null;
    }

    private NodeId q(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        Integer n2;
        if (a2 == null || !a2.esz()) {
            return null;
        }
        b b2 = a2.esx();
        Integer n3 = 0;
        com.prosysopc.ua.stack.encoding.json.a a3 = b2.M("Namespace");
        if (a3 != null) {
            n3 = a3.esB() ? Integer.valueOf(this.C(a3)) : Integer.valueOf(this.ti.getNamespaceTable().getIndex(a3.getString()));
        }
        if ((n2 = this.n(b2.M("IdType"))) == null || n2 == 0) {
            return new NodeId((int)n3, this.x(b2.M("Id")));
        }
        com.prosysopc.ua.stack.encoding.json.a a4 = b2.M("Id");
        switch (n2) {
            case 1: {
                return new NodeId((int)n3, this.v(a4));
            }
            case 2: {
                return new NodeId((int)n3, this.l(a4));
            }
            case 3: {
                return new NodeId((int)n3, this.c(a4));
            }
        }
        return null;
    }

    private UaOptionSet a(com.prosysopc.ua.stack.encoding.json.a a2, UaNodeId uaNodeId) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        OptionSetSpecification optionSetSpecification = this.getEncoderContext().getOptionSetSpecification(uaNodeId);
        if (optionSetSpecification == null) {
            throw new DecodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
        }
        Object obj = this.a(a2, optionSetSpecification.getBaseTypeJavaClass(), optionSetSpecification.getBaseTypeId(), 0);
        try {
            return (UaOptionSet)new Variant(obj).asOptionSet(optionSetSpecification);
        }
        catch (Exception exception) {
            throw new DecodingException(exception, "Could not resolve the value as UaOptionSet");
        }
    }

    private QualifiedName r(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null) {
            return null;
        }
        if (a2.esz()) {
            b b2 = a2.esx();
            String string = b2.M("Name").getString();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.M("Uri");
            if (a3 == null) {
                return new QualifiedName(0, string);
            }
            if (a3.esB()) {
                return new QualifiedName(this.C(a3), string);
            }
            if (a3.esA()) {
                return new QualifiedName(this.ti.getNamespaceTable().getIndex(a3.getString()), string);
            }
        }
        return null;
    }

    private com.prosysopc.ua.stack.encoding.json.a eso() throws DecodingException {
        if (!this.tJ.isEmpty()) {
            return this.tJ.peek();
        }
        this.ess();
        return this.tI;
    }

    private com.prosysopc.ua.stack.encoding.json.a I(String string) throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.eso();
        if (string == null) {
            return a2;
        }
        if (!a2.esz()) {
            throw new DecodingException("JsonDecoder: Root Json is not an object");
        }
        return a2.esx().M(string);
    }

    private Byte s(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Byte.valueOf(Byte.parseByte(a2.getString()));
    }

    private Object t(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        b b2 = a2.esx();
        int n2 = this.C(b2.M("Type"));
        com.prosysopc.ua.stack.encoding.json.a a3 = b2.M("Body");
        try {
            switch (n2) {
                case 1: {
                    return this.a(a3);
                }
                case 2: {
                    return this.s(a3);
                }
                case 3: {
                    return this.b(a3);
                }
                case 4: {
                    return this.m(a3);
                }
                case 5: {
                    return this.w(a3);
                }
                case 6: {
                    return this.n(a3);
                }
                case 7: {
                    return this.x(a3);
                }
                case 8: {
                    return this.o(a3);
                }
                case 9: {
                    return this.y(a3);
                }
                case 10: {
                    return this.k(a3);
                }
                case 11: {
                    return this.h(a3);
                }
                case 12: {
                    return this.v(a3);
                }
                case 13: {
                    return this.e(a3);
                }
                case 14: {
                    return this.l(a3);
                }
                case 15: {
                    return this.c(a3);
                }
                case 16: {
                    return this.A(a3);
                }
                case 17: {
                    return this.q(a3);
                }
                case 18: {
                    return this.i(a3);
                }
                case 19: {
                    return this.u(a3);
                }
                case 20: {
                    return this.r(a3);
                }
                case 21: {
                    return this.p(a3);
                }
                case 22: {
                    return this.j(a3);
                }
                case 23: {
                    return this.d(a3);
                }
                case 24: {
                    return this.z(a3);
                }
                case 25: {
                    return this.g(a3);
                }
            }
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private StatusCode u(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        Integer n2 = 0;
        if (a2 != null) {
            com.prosysopc.ua.stack.encoding.json.a a3;
            if (a2.esB()) {
                n2 = this.C(a2);
            } else if (a2.esz() && (a3 = a2.esx().M("Code")) != null) {
                n2 = this.C(a3);
            }
        }
        return StatusCode.getFromBits(n2);
    }

    private String v(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return a2.getString();
    }

    private UnsignedShort w(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return UnsignedShort.parseUnsignedShort(a2.getString());
    }

    private UnsignedInteger x(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return UnsignedInteger.parseUnsignedInteger(a2.getString());
    }

    private UnsignedLong y(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : UnsignedLong.parseUnsignedLong(a2.getString());
    }

    private Variant z(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        Object object = null;
        if (a2 == null || a2.isNull()) {
            return null;
        }
        if (a2.esz()) {
            b b2 = a2.esx();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.M("Type");
            com.prosysopc.ua.stack.encoding.json.a a4 = b2.M("Body");
            if (a4 == null || a3 == null) {
                object = a2.esC();
            } else if (a4.esy()) {
                int n2 = this.C(a3);
                object = this.a(a2, n2);
                com.prosysopc.ua.stack.encoding.json.a a5 = b2.M("Dimensions");
                if (a5 != null && a5.esy()) {
                    this.tJ.push(a2);
                    int[] nArray = this.getInt32Array_("Dimensions");
                    this.tJ.pop();
                    object = MultiDimensionArrayUtils.demuxArray(object, nArray);
                }
            } else {
                object = this.t(a2);
            }
        } else if (a2.esy()) {
            object = a2.esC();
        } else if (a2.isBoolean()) {
            object = this.a(a2);
        } else if (a2.esB()) {
            object = this.h(a2);
        } else if (a2.esA()) {
            object = this.v(a2);
        }
        return new Variant(object);
    }

    private XmlElement A(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : new XmlElement(a2.getString());
    }

    private void esp() throws DecodingException {
        if (this.tM) {
            throw new DecodingException("JsonDecoder: goBack called twice in succession");
        }
        this.tM = true;
    }

    private <T> T a(com.prosysopc.ua.stack.encoding.json.a a2, Class<T> clazz, UaNodeId uaNodeId, int n2) throws DecodingException {
        int n3;
        Object object;
        Class clazz2;
        ArrayList<com.prosysopc.ua.stack.encoding.json.a> arrayList;
        if (n2 < 0) {
            throw new DecodingException("The given dimensions cannot be negative");
        }
        if (a2 == null) {
            return null;
        }
        a<Object> a3 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = sW.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            arrayList = new AtomicReference();
            a3 = JsonDecoder.c(uaNodeId2, this.getEncoderContext(), arrayList);
            clazz2 = (Class)((AtomicReference)((Object)arrayList)).get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a3 = JsonDecoder.h(clazz2);
        }
        if (n2 == 0) {
            arrayList = a3;
            return arrayList.get(this, a2, clazz, uaNodeId);
        }
        arrayList = a2.esw();
        if (n2 == 1) {
            Object[] objectArray = (Object[])Array.newInstance(clazz2, arrayList.size());
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                objectArray[i2] = a3.get(this, arrayList.get(i2), clazz2, uaNodeId);
            }
            Object[] objectArray2 = objectArray;
            return (T)objectArray2;
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayDeque<ArrayList<com.prosysopc.ua.stack.encoding.json.a>> arrayDeque = new ArrayDeque<ArrayList<com.prosysopc.ua.stack.encoding.json.a>>();
        int[] nArray = new int[n2];
        int n4 = 0;
        arrayDeque.add(arrayList);
        while (!arrayDeque.isEmpty()) {
            List list = (List)arrayDeque.poll();
            if (n4 < n2) {
                nArray[n4++] = list.size();
            }
            if (((com.prosysopc.ua.stack.encoding.json.a)(object = (com.prosysopc.ua.stack.encoding.json.a)list.get(0))).esy()) {
                for (n3 = 0; n3 < list.size(); ++n3) {
                    arrayDeque.add(((com.prosysopc.ua.stack.encoding.json.a)list.get(n3)).esw());
                }
                continue;
            }
            for (n3 = 0; n3 < list.size(); ++n3) {
                arrayList2.add(list.get(n3));
            }
        }
        int n5 = arrayList2.size();
        object = (Object[])Array.newInstance(clazz2, n5);
        for (n3 = 0; n3 < n5; ++n3) {
            object[n3] = a3.get(this, (com.prosysopc.ua.stack.encoding.json.a)arrayList2.get(n3), clazz2, uaNodeId);
        }
        Object object2 = MultiDimensionArrayUtils.demuxArray(object, nArray, clazz2);
        return (T)object2;
    }

    private Structure a(com.prosysopc.ua.stack.encoding.json.a a2, StructureSpecification structureSpecification) throws DecodingException {
        UnsignedLong unsignedLong = null;
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        if (a2 == null || a2.isNull()) {
            return null;
        }
        if (StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
            unsignedLong = this.y(a2.esx().M("EncodingMask"));
        }
        if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
            long l2 = 0L;
            com.prosysopc.ua.stack.encoding.json.a a3 = a2.esx().M("SwitchField");
            if (a3 != null) {
                l2 = this.x(a3).longValue();
            }
            if (l2 < 0L) {
                throw new DecodingException("Union SwitchField must be >= 0");
            }
            if (l2 == 0L) {
                return builder.build();
            }
            long l3 = 0L;
            for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
                if (l2 != ++l3) continue;
                com.prosysopc.ua.stack.encoding.json.a a4 = a2.esx().M(fieldSpecification.getName());
                builder.set(fieldSpecification, this.a(a4, fieldSpecification));
                return builder.build();
            }
            throw new DecodingException("Union SwitchField overflow: " + ++l3);
        }
        int n2 = -1;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            com.prosysopc.ua.stack.encoding.json.a a5 = a2.esx().M(fieldSpecification.getName());
            if (fieldSpecification.isOptional()) {
                if ((unsignedLong.longValue() & (long)(1 << ++n2)) == 0L) continue;
                builder.set(fieldSpecification, this.a(a5, fieldSpecification));
                continue;
            }
            builder.set(fieldSpecification, this.a(a5, fieldSpecification));
        }
        return builder.build();
    }

    private Object a(com.prosysopc.ua.stack.encoding.json.a a2, FieldSpecification fieldSpecification) throws DecodingException {
        Class<?> clazz = fieldSpecification.getJavaClass();
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        if (fieldSpecification.isAllowSubTypes()) {
            Class<?> clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            if (ExtensionObject.class.isAssignableFrom(clazz2)) {
                return this.a(a2, MultiDimensionArrayUtils.arrayClassOf(ExtensionObject.class, n2), UaIds.Structure, n2);
            }
            return this.a(a2, MultiDimensionArrayUtils.arrayClassOf(Variant.class, n2), UaIds.BaseDataType, n2);
        }
        return this.a(a2, clazz, fieldSpecification.getDataTypeId(), n2);
    }

    private char esq() throws DecodingException {
        char c2;
        while (Character.isWhitespace(c2 = this.esv())) {
        }
        return c2;
    }

    private String a(char c2) throws DecodingException {
        char c3 = this.esv();
        StringBuilder stringBuilder = new StringBuilder();
        while (c3 != c2) {
            block1 : switch (c3) {
                case '\n': 
                case '\r': {
                    throw new DecodingException("JsonDecoder: Unterminated string in Json");
                }
                case '\\': {
                    c3 = this.esv();
                    switch (c3) {
                        case 'b': {
                            stringBuilder.append('\b');
                            break block1;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break block1;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            break block1;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            break block1;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break block1;
                        }
                        case 'u': {
                            try {
                                stringBuilder.append((char)Integer.parseInt(this.r(4), 16));
                                break block1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new DecodingException("JsonDecoder: Illegal escape in Json", numberFormatException);
                            }
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            stringBuilder.append(c3);
                            break block1;
                        }
                    }
                    throw new DecodingException("JsonDecoder: Illegal escape in Json");
                }
                default: {
                    stringBuilder.append(c3);
                }
            }
            c3 = this.esv();
        }
        return stringBuilder.toString();
    }

    private com.prosysopc.ua.stack.encoding.json.a esr() throws DecodingException {
        char c2 = this.esq();
        switch (c2) {
            case '\"': 
            case '\'': {
                return new com.prosysopc.ua.stack.encoding.json.a(this.a(c2));
            }
            case '{': {
                this.esp();
                return new com.prosysopc.ua.stack.encoding.json.a(this.esu());
            }
            case '[': {
                this.esp();
                return new com.prosysopc.ua.stack.encoding.json.a(this.est());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.esp();
        while (true) {
            if ((c2 = this.esv()) == '\u0000') {
                throw new DecodingException("JsonDecoder: Unexpected end of Json");
            }
            if (Character.isWhitespace(c2) || ",]}".indexOf(c2) > -1) break;
            stringBuilder.append(c2);
        }
        this.esp();
        String string = stringBuilder.toString().trim();
        if (string.isEmpty()) {
            throw new DecodingException("JsonDecoder: Missing value in Json");
        }
        if ("null".equalsIgnoreCase(string)) {
            return new com.prosysopc.ua.stack.encoding.json.a();
        }
        return new com.prosysopc.ua.stack.encoding.json.a(string, true);
    }

    private void ess() throws DecodingException {
        if (this.tK) {
            return;
        }
        this.tK = true;
        char c2 = this.esq();
        if (c2 == '{') {
            this.esp();
            this.tI = new com.prosysopc.ua.stack.encoding.json.a(this.esu());
            return;
        }
        if (c2 == '[') {
            this.esp();
            this.tI = new com.prosysopc.ua.stack.encoding.json.a(this.est());
            return;
        }
        throw new DecodingException("JsonDecoder: Json text should start with '{' or '[': '" + c2 + "' found");
    }

    private ArrayList<com.prosysopc.ua.stack.encoding.json.a> est() throws DecodingException {
        if (this.esq() != '[') {
            throw new DecodingException("JsonDecoder: Json array must start with '['");
        }
        ArrayList<com.prosysopc.ua.stack.encoding.json.a> arrayList = new ArrayList<com.prosysopc.ua.stack.encoding.json.a>();
        boolean bl = false;
        block5: while (!bl) {
            char c2 = this.esq();
            switch (c2) {
                case ']': {
                    bl = true;
                    continue block5;
                }
                case ',': {
                    if (!arrayList.isEmpty()) continue block5;
                    throw new DecodingException("JsonDecoder: Missing first value in Json array");
                }
                case '\u0000': {
                    throw new DecodingException("JsonDecoder: Unexpected end of Json");
                }
            }
            this.esp();
            arrayList.add(this.esr());
        }
        return arrayList;
    }

    private Double B(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        try {
            return Double.valueOf(a2.getString());
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
    }

    private int C(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        try {
            BigInteger bigInteger = new BigInteger(a2.getString());
            return bigInteger.intValue();
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
    }

    private b esu() throws DecodingException {
        if (this.esq() != '{') {
            throw new DecodingException("JsonDecoder: Json object must start with '{");
        }
        HashMap<String, com.prosysopc.ua.stack.encoding.json.a> hashMap = new HashMap<String, com.prosysopc.ua.stack.encoding.json.a>();
        block8: while (true) {
            char c2 = this.esq();
            switch (c2) {
                case '}': {
                    return new b(hashMap);
                }
                case '\u0000': {
                    throw new DecodingException("JsonDecoder: Unexpected end of Json");
                }
            }
            this.esp();
            String string = this.esr().getString();
            if (this.esq() != ':') {
                throw new DecodingException("JsonDecoder: Expected ':' after field name");
            }
            if (string != null) {
                if (hashMap.containsKey(string)) {
                    throw new DecodingException("JsonDecoder: Duplicate field name: " + string);
                }
                com.prosysopc.ua.stack.encoding.json.a a2 = this.esr();
                hashMap.put(string, a2);
            }
            switch (this.esq()) {
                case ',': {
                    continue block8;
                }
                case '}': {
                    return new b(hashMap);
                }
            }
            break;
        }
        throw new DecodingException("JsonDecoder: Expected a ',' or '}'");
    }

    private char esv() throws DecodingException {
        int n2;
        if (this.tM) {
            this.tM = false;
            return this.tL;
        }
        try {
            n2 = this.tH.read();
        }
        catch (IOException iOException) {
            throw new DecodingException(iOException);
        }
        if (n2 <= 0) {
            return '\u0000';
        }
        this.tL = (char)n2;
        return this.tL;
    }

    private String r(int n2) throws DecodingException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2 && (c2 = this.esv()) != '\u0000'; ++i2) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    <T> T a(String string, Class<T> clazz) throws DecodingException {
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        com.prosysopc.ua.stack.encoding.json.a a2 = this.I(string);
        if (a2 == null) {
            return null;
        }
        if (n2 > 0 && !a2.esy()) {
            throw new DecodingException("JsonDecoder: field '" + string + "' is not an array as expected");
        }
        return this.a(a2, clazz, null, n2);
    }

    static {
        JsonDecoder.b(UaIds.Boolean, Boolean.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.a(a2));
        JsonDecoder.b(UaIds.SByte, Byte.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.s(a2));
        JsonDecoder.b(UaIds.Byte, UnsignedByte.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.b(a2));
        JsonDecoder.b(UaIds.Int16, Short.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.m(a2));
        JsonDecoder.b(UaIds.UInt16, UnsignedShort.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.w(a2));
        JsonDecoder.b(UaIds.Int32, Integer.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.n(a2));
        JsonDecoder.b(UaIds.UInt32, UnsignedInteger.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.x(a2));
        JsonDecoder.b(UaIds.Int64, Long.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.o(a2));
        JsonDecoder.b(UaIds.UInt64, UnsignedLong.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.y(a2));
        JsonDecoder.b(UaIds.Float, Float.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.k(a2));
        JsonDecoder.b(UaIds.Double, Double.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.h(a2));
        JsonDecoder.b(UaIds.String, String.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.v(a2));
        JsonDecoder.b(UaIds.Guid, UUID.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.l(a2));
        JsonDecoder.b(UaIds.ByteString, ByteString.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.c(a2));
        JsonDecoder.b(UaIds.XmlElement, XmlElement.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.A(a2));
        JsonDecoder.b(UaIds.NodeId, NodeId.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.q(a2));
        JsonDecoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.i(a2));
        JsonDecoder.b(UaIds.StatusCode, StatusCode.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.u(a2));
        JsonDecoder.b(UaIds.QualifiedName, QualifiedName.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.r(a2));
        JsonDecoder.b(UaIds.LocalizedText, LocalizedText.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.p(a2));
        ty = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.e(a2);
        JsonDecoder.a(UaIds.DateTime, DateTime.class, ty);
        tz = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.j(a2);
        JsonDecoder.a(UaIds.Structure, ExtensionObject.class, tz);
        tA = (jsonDecoder, a2, clazz, uaNodeId) -> {
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            StructureSpecification structureSpecification = jsonDecoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new DecodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            return jsonDecoder.a(a2, structureSpecification);
        };
        tB = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.d(a2);
        JsonDecoder.a(UaIds.DataValue, DataValue.class, tB);
        tC = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.z(a2);
        tD = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.g(a2);
        JsonDecoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, tD);
        tE = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.a(a2, clazz, uaNodeId);
        tF = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.f(a2);
        JsonDecoder.a(UaIds.Decimal, BigDecimal.class, tF);
        tG = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.a(a2, uaNodeId);
        JsonDecoder.b(null, Object.class, (jsonDecoder, a2, clazz, uaNodeId) -> tC.get(jsonDecoder, a2, Variant.class, uaNodeId).getValue());
    }

    private static interface a<T> {
        public T get(JsonDecoder var1, com.prosysopc.ua.stack.encoding.json.a var2, Class<? extends T> var3, UaNodeId var4) throws DecodingException;
    }
}

