/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncoderMode;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.NodeIdEncoding;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.EncodingLimitsExceededIoException;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.OutputStreamWriteable;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEncoder
implements IEncoder {
    private static final Logger logger = LoggerFactory.getLogger(BinaryEncoder.class);
    private static final Map<Class<?>, a<?>> sU = new HashMap();
    private static final Map<UaNodeId, a<?>> sV = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> sW = new BijectionMap();
    private static final a<DateTime> tk;
    private static final a<ExtensionObject> tl;
    private static final a<Structure> tm;
    private static final a<DataValue> tn;
    private static final a<Variant> to;
    private static final a<DiagnosticInfo> tp;
    private static final a<Enumeration> tq;
    private static final a<BigDecimal> tr;
    private static final a<UaOptionSet> ts;
    private static final ExpandedNodeId tg;
    private final List<Locale> lW = new CopyOnWriteArrayList<Locale>();
    IBinaryWriteable tt;
    EncoderContext ti;
    EncoderMode tu = EncoderMode.NonStrict;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (sV.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (sW.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (sW.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            sW.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (sU.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        BinaryEncoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> g(Class<?> clazz) throws EncodingException {
        if (clazz == null) {
            throw new EncodingException("Cannot encode class null");
        }
        a<?> a2 = sU.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return tl;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return tm;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return tn;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return to;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return tp;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return tq;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return tk;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return tr;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return ts;
        }
        throw new EncodingException("Cannot encode class: " + clazz);
    }

    private static a<Object> b(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws EncodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return BinaryEncoder.g(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return BinaryEncoder.g(ExtensionObject.class);
        }
        a<Object> a2 = sV.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = sV.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = tm;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = ts;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = tq;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(sW.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new EncodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new EncodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    private static UnsignedInteger b(UnsignedInteger unsignedInteger, int n2) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("mask cannot be null");
        }
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("position must be between 0-31");
        }
        int n3 = 1 << n2;
        return unsignedInteger.or(n3);
    }

    private static EncodingException b(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new EncodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new EncodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new EncodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new EncodingException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
        }
        if (iOException instanceof EncodingLimitsExceededIoException) {
            return new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, (Throwable)iOException, iOException.getMessage());
        }
        return new EncodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    static ExtensionObject[] a(BigDecimal[] bigDecimalArray) throws EncodingException {
        if (bigDecimalArray == null) {
            return null;
        }
        ExtensionObject[] extensionObjectArray = new ExtensionObject[bigDecimalArray.length];
        for (int i2 = 0; i2 < bigDecimalArray.length; ++i2) {
            extensionObjectArray[i2] = BinaryEncoder.a(bigDecimalArray[i2]);
        }
        return extensionObjectArray;
    }

    static ExtensionObject a(BigDecimal bigDecimal) throws EncodingException {
        int n2 = bigDecimal.scale();
        if (n2 > Short.MAX_VALUE) {
            throw new EncodingException("Decimal scale overflow Short max value: " + n2);
        }
        if (n2 < Short.MIN_VALUE) {
            throw new EncodingException("Decimal scale underflow Short min value: " + n2);
        }
        short s2 = (short)n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort(s2);
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = com.prosysopc.ua.stack.encoding.binary.a.reverse(bigDecimal.unscaledValue().toByteArray());
        byte[] byArray3 = com.prosysopc.ua.stack.encoding.binary.a.concat(byArray, byArray2);
        return new ExtensionObject(tg, ByteString.valueOf(byArray3));
    }

    public BinaryEncoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(ByteBuffer byteBuffer) {
        ByteBufferWriteable byteBufferWriteable = new ByteBufferWriteable(byteBuffer);
        this.setWriteable(byteBufferWriteable);
    }

    public BinaryEncoder(IBinaryWriteable iBinaryWriteable) {
        this.setWriteable(iBinaryWriteable);
    }

    public BinaryEncoder(OutputStream outputStream) {
        OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(outputStream);
        outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(outputStreamWriteable);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.ti;
    }

    public EncoderMode getEncoderType() {
        return this.tu;
    }

    @Override
    public List<Locale> getLocales() {
        return this.lW;
    }

    public IBinaryWriteable getOutput() {
        return this.tt;
    }

    public IBinaryWriteable getWriteable() {
        return this.tt;
    }

    @Override
    public void put(String string, Object object, UaNodeId uaNodeId, int n2) throws EncodingException {
        try {
            if (n2 < 0) {
                throw new EncodingException("The given dimensions cannot be negative");
            }
            this.a(object, null, uaNodeId, n2);
        }
        catch (Exception exception) {
            throw new EncodingException("Error while trying to encode DataTypeId: " + uaNodeId, exception);
        }
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ti = encoderContext;
    }

    public void setEncoderMode(EncoderMode encoderMode) {
        this.tu = encoderMode;
    }

    public void setWriteable(IBinaryWriteable iBinaryWriteable) {
        if (iBinaryWriteable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Writeable must be in Little-Ending byte order");
        }
        this.tt = iBinaryWriteable;
    }

    private void p(int n2) throws EncodingException {
        int n3 = this.ti.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void l(int n2) throws EncodingException {
        int n3 = this.ti.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
            logger.warn("assertByteStringLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void f(Object object) throws EncodingException {
        if (object != null) {
            return;
        }
        if (this.tu == EncoderMode.Strict) {
            throw new EncodingException("Cannot encode null value");
        }
    }

    private void m(int n2) throws EncodingException {
        int n3 = this.ti.getMaxStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
            logger.warn("assertStringLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void a(Object object, Class<?> clazz, UaNodeId uaNodeId, int n2) throws EncodingException {
        Class<?> clazz2;
        Object[] objectArray;
        if (n2 < 0) {
            throw new EncodingException("The given dimensions cannot be negative");
        }
        a<Object> a2 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = sW.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            objectArray = new AtomicReference();
            a2 = BinaryEncoder.b(uaNodeId2, this.getEncoderContext(), objectArray);
            clazz2 = objectArray.get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a2 = BinaryEncoder.g(clazz2);
        }
        if (n2 == 0) {
            a2.put(this, null, object, uaNodeId2);
            return;
        }
        if (n2 == 1) {
            if (object == null) {
                this.b(-1);
                return;
            }
            objectArray = (Object[])object;
            int n3 = objectArray.length;
            this.p(n3);
            this.b(n3);
            for (Object object2 : objectArray) {
                a2.put(this, null, object2, uaNodeId2);
            }
            return;
        }
        if (object == null) {
            objectArray = new int[n2];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = -1;
            }
            this.a((int[])objectArray);
            return;
        }
        objectArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray2 = (Object[])MultiDimensionArrayUtils.muxArray(object, (int[])objectArray, Object.class);
        int n4 = objectArray2.length;
        this.p(n4);
        this.a((int[])objectArray);
        for (Object object3 : objectArray2) {
            a2.put(this, null, object3, uaNodeId2);
        }
    }

    private void a(Boolean bl) throws EncodingException {
        try {
            if (bl == null) {
                this.f(bl);
                this.putSByte(null, 0);
            } else {
                this.tt.put(bl != false ? (byte)1 : 0);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UnsignedByte unsignedByte) throws EncodingException {
        try {
            if (unsignedByte == null) {
                this.f(unsignedByte);
                this.q(0);
            } else {
                this.tt.put(unsignedByte.toByteBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(byte[] byArray) throws EncodingException {
        try {
            if (byArray == null) {
                this.tt.putInt(-1);
            } else {
                this.l(byArray.length);
                this.tt.putInt(byArray.length);
                this.tt.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void e(ByteString byteString) throws EncodingException {
        this.b(byteString == null ? null : byteString.getValue());
    }

    private void j(DataValue dataValue) throws EncodingException {
        if (dataValue == null) {
            this.q(0);
            return;
        }
        int n2 = 0;
        if (dataValue.getValue() != null) {
            n2 |= 1;
        }
        if (dataValue.getStatusCode() != null && !dataValue.getStatusCode().equals(StatusCode.GOOD)) {
            n2 |= 2;
        }
        if (dataValue.getSourceTimestamp() != null && !dataValue.getSourceTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 4;
        }
        if (dataValue.getServerTimestamp() != null && !dataValue.getServerTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 8;
        }
        if (dataValue.getSourcePicoseconds() != null && !dataValue.getSourcePicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x10;
        }
        if (dataValue.getServerPicoseconds() != null && !dataValue.getServerPicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x20;
        }
        this.q(n2);
        if ((n2 & 1) == 1) {
            this.c(dataValue.getValue());
        }
        if ((n2 & 2) == 2) {
            this.a(dataValue.getStatusCode());
        }
        if ((n2 & 4) == 4) {
            this.e(dataValue.getSourceTimestamp());
        }
        if ((n2 & 0x10) == 16) {
            this.a(dataValue.getSourcePicoseconds());
        }
        if ((n2 & 8) == 8) {
            this.e(dataValue.getServerTimestamp());
        }
        if ((n2 & 0x20) == 32) {
            this.a(dataValue.getServerPicoseconds());
        }
    }

    private void e(DateTime dateTime) throws EncodingException {
        try {
            if (dateTime == null) {
                this.f(dateTime);
                this.tt.putLong(0L);
            } else if (dateTime.compareTo(DateTime.MAX_VALUE) >= 0) {
                this.tt.putLong(Long.MAX_VALUE);
            } else if (dateTime.compareTo(DateTime.MIN_VALUE) <= 0) {
                this.tt.putLong(0L);
            } else {
                this.tt.putLong(dateTime.getValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(BigDecimal bigDecimal) throws EncodingException {
        ExtensionObject extensionObject = BinaryEncoder.a(bigDecimal);
        this.b(extensionObject);
    }

    private void b(DiagnosticInfo diagnosticInfo) throws EncodingException {
        if (diagnosticInfo == null) {
            this.q(0);
            return;
        }
        int n2 = 0;
        if (diagnosticInfo.getSymbolicId() != null) {
            n2 |= 1;
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            n2 |= 2;
        }
        if (diagnosticInfo.getLocalizedTextStr() != null) {
            n2 |= 4;
        }
        if (diagnosticInfo.getLocaleStr() != null) {
            n2 |= 8;
        }
        if (diagnosticInfo.getAdditionalInfo() != null) {
            n2 |= 0x10;
        }
        if (diagnosticInfo.getInnerStatusCode() != null) {
            n2 |= 0x20;
        }
        if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
            n2 |= 0x40;
        }
        try {
            this.putSByte(null, n2);
            if ((n2 & 1) == 1) {
                this.tt.putInt(diagnosticInfo.getSymbolicId());
            }
            if ((n2 & 2) == 2) {
                this.tt.putInt(diagnosticInfo.getNamespaceUri());
            }
            if ((n2 & 8) == 8) {
                this.tt.putInt(diagnosticInfo.getLocale());
            }
            if ((n2 & 4) == 4) {
                this.tt.putInt(diagnosticInfo.getLocalizedText());
            }
            if ((n2 & 0x10) == 16) {
                this.H(diagnosticInfo.getAdditionalInfo());
            }
            if ((n2 & 0x20) == 32) {
                this.a(diagnosticInfo.getInnerStatusCode());
            }
            if ((n2 & 0x40) == 64) {
                this.b(diagnosticInfo.getInnerDiagnosticInfo());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(Double d2) throws EncodingException {
        try {
            if (d2 == null) {
                this.f(d2);
                this.tt.putDouble(0.0);
            } else {
                this.tt.putDouble(d2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Enumeration enumeration) throws EncodingException {
        try {
            if (enumeration == null) {
                this.tt.putInt(0);
                return;
            }
            this.tt.putInt(enumeration.getValue());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            if (expandedNodeId == null) {
                expandedNodeId = ExpandedNodeId.NULL;
            }
            int n2 = 0;
            if (expandedNodeId.getNamespaceUri() != null) {
                n2 = (byte)(n2 | 0x80);
            }
            if (expandedNodeId.getServerIndex() != null) {
                n2 = (byte)(n2 | 0x40);
            }
            Object object = expandedNodeId.getValue();
            if (expandedNodeId.getIdType() == IdType.Numeric) {
                UnsignedInteger unsignedInteger = (UnsignedInteger)object;
                if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() == 0) {
                    this.q(NodeIdEncoding.TwoByte.getBits() | n2);
                    this.tt.put(unsignedInteger.byteValue());
                } else if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() < 256) {
                    this.q(NodeIdEncoding.FourByte.getBits() | n2);
                    this.q(expandedNodeId.getNamespaceIndex());
                    this.tt.putShort(unsignedInteger.shortValue());
                } else {
                    this.q(NodeIdEncoding.Numeric.getBits() | n2);
                    this.tt.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.tt.putInt(unsignedInteger.intValue());
                }
            }
            if (expandedNodeId.getIdType() == IdType.String) {
                this.q(NodeIdEncoding.String.getBits() | n2);
                this.tt.putShort((short)expandedNodeId.getNamespaceIndex());
                this.H((String)expandedNodeId.getValue());
            } else if (expandedNodeId.getIdType() == IdType.Opaque) {
                this.q(NodeIdEncoding.ByteString.getBits() | n2);
                this.tt.putShort((short)expandedNodeId.getNamespaceIndex());
                this.e((ByteString)expandedNodeId.getValue());
            } else if (expandedNodeId.getIdType() == IdType.Guid) {
                this.q(NodeIdEncoding.Guid.getBits() | n2);
                this.tt.putShort((short)expandedNodeId.getNamespaceIndex());
                this.a((UUID)expandedNodeId.getValue());
            }
            if (expandedNodeId.getNamespaceUri() != null) {
                this.H(expandedNodeId.getNamespaceUri());
            }
            if (expandedNodeId.getServerIndex() != null) {
                this.tt.putInt(expandedNodeId.getServerIndex().intValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(ExtensionObject extensionObject) throws EncodingException {
        NodeId nodeId;
        if (extensionObject == null) {
            this.f(extensionObject);
            this.n(null);
            this.q(0);
            return;
        }
        if (!extensionObject.isEncoded()) {
            this.b(ExtensionObject.binaryEncode((Structure)extensionObject.getObject(), this.ti, this.lW));
            return;
        }
        try {
            nodeId = this.ti.getNamespaceTable().toNodeId(extensionObject.getTypeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get namespace index for given id");
        }
        this.n(nodeId);
        Object object = extensionObject.getObject();
        if (object == null) {
            this.q(0);
        } else if (extensionObject.getEncodeType() == EncodeType.Binary) {
            this.q(1);
            this.e((ByteString)object);
        } else if (extensionObject.getEncodeType() == EncodeType.Xml) {
            this.q(2);
            this.a((XmlElement)object);
        } else {
            throw new EncodingException("Unexpected object " + (Object)((Object)extensionObject.getEncodeType()));
        }
    }

    private void a(Collection<ExtensionObject> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.tt.putInt(-1);
                return;
            }
            this.p(collection.size());
            this.tt.putInt(collection.size());
            for (ExtensionObject extensionObject : collection) {
                this.b(extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(ExtensionObject[] extensionObjectArray) throws EncodingException {
        try {
            if (extensionObjectArray == null) {
                this.tt.putInt(-1);
                return;
            }
            this.p(extensionObjectArray.length);
            this.tt.putInt(extensionObjectArray.length);
            for (ExtensionObject extensionObject : extensionObjectArray) {
                this.b(extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Structure[] structureArray) throws EncodingException {
        try {
            if (structureArray == null) {
                this.tt.putInt(-1);
                return;
            }
            this.p(structureArray.length);
            this.tt.putInt(structureArray.length);
            for (Structure structure : structureArray) {
                this.b(new ExtensionObject(structure));
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Float f2) throws EncodingException {
        try {
            if (f2 == null) {
                this.f(f2);
                this.tt.putFloat(0.0f);
            } else {
                this.tt.putFloat(f2.floatValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UUID uUID) throws EncodingException {
        try {
            if (uUID == null) {
                this.f(uUID);
                this.tt.putLong(0L);
                this.tt.putLong(0L);
            } else {
                int n2;
                long l2 = uUID.getMostSignificantBits();
                long l3 = uUID.getLeastSignificantBits();
                byte[] byArray = new byte[16];
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray[n2] = (byte)(l2 >>> 8 * (7 - n2));
                }
                for (n2 = 8; n2 < 16; ++n2) {
                    byArray[n2] = (byte)(l3 >>> 8 * (7 - n2));
                }
                this.tt.put(byArray[3]);
                this.tt.put(byArray[2]);
                this.tt.put(byArray[1]);
                this.tt.put(byArray[0]);
                this.tt.put(byArray[5]);
                this.tt.put(byArray[4]);
                this.tt.put(byArray[7]);
                this.tt.put(byArray[6]);
                for (n2 = 8; n2 < 16; ++n2) {
                    this.tt.put(byArray[n2]);
                }
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Short s2) throws EncodingException {
        try {
            if (s2 == null) {
                this.f(s2);
                this.tt.putShort((short)0);
            } else {
                this.tt.putShort(s2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(Integer n2) throws EncodingException {
        try {
            if (n2 == null) {
                this.f(n2);
                this.tt.putInt(0);
            } else {
                this.tt.putInt(n2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(int[] nArray) throws EncodingException {
        if (nArray == null) {
            this.a(null, Integer[].class, UaIds.Int32, 1);
            return;
        }
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = nArray[i2];
        }
        this.a(integerArray, Integer[].class, UaIds.Int32, 1);
    }

    private void b(Long l2) throws EncodingException {
        try {
            if (l2 == null) {
                this.f(l2);
                this.tt.putLong(0L);
            } else {
                this.tt.putLong(l2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(LocalizedText localizedText) throws EncodingException {
        try {
            if (localizedText == null) {
                this.putSByte(null, 0);
                return;
            }
            localizedText = localizedText.asSingleLocale(this.getLocales());
            String string = localizedText.getLocaleId();
            String string2 = localizedText.getText();
            boolean bl = string != null && !string.isEmpty();
            boolean bl2 = string2 != null && !string2.isEmpty();
            byte by = (byte)((bl ? 1 : 0) | (bl2 ? 2 : 0));
            this.tt.put(by);
            if (bl) {
                this.H(string);
            }
            if (bl2) {
                this.H(string2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void n(NodeId nodeId) throws EncodingException {
        block11: {
            try {
                if (nodeId == null) {
                    nodeId = NodeId.NULL;
                }
                Object object = nodeId.getValue();
                if (nodeId.getIdType() == IdType.Numeric) {
                    UnsignedInteger unsignedInteger = (UnsignedInteger)object;
                    if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() == 0) {
                        this.tt.put(NodeIdEncoding.TwoByte.getBits());
                        this.tt.put(unsignedInteger.byteValue());
                    } else if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() < 256) {
                        this.tt.put(NodeIdEncoding.FourByte.getBits());
                        this.q(nodeId.getNamespaceIndex());
                        this.tt.putShort(unsignedInteger.shortValue());
                    } else {
                        this.tt.put(NodeIdEncoding.Numeric.getBits());
                        this.tt.putShort((short)nodeId.getNamespaceIndex());
                        this.tt.putInt(unsignedInteger.intValue());
                    }
                    break block11;
                }
                if (nodeId.getIdType() == IdType.String) {
                    this.tt.put(NodeIdEncoding.String.getBits());
                    this.tt.putShort((short)nodeId.getNamespaceIndex());
                    this.H((String)nodeId.getValue());
                    break block11;
                }
                if (nodeId.getIdType() == IdType.Opaque) {
                    this.tt.put(NodeIdEncoding.ByteString.getBits());
                    this.tt.putShort((short)nodeId.getNamespaceIndex());
                    this.e((ByteString)nodeId.getValue());
                    break block11;
                }
                if (nodeId.getIdType() == IdType.Guid) {
                    UUID uUID = (UUID)nodeId.getValue();
                    this.tt.put(NodeIdEncoding.Guid.getBits());
                    this.tt.putShort((short)nodeId.getNamespaceIndex());
                    this.a(uUID);
                    break block11;
                }
                throw new EncodingException("Unknown IdType: " + nodeId.getIdType());
            }
            catch (IOException iOException) {
                throw BinaryEncoder.b(iOException);
            }
        }
    }

    private void a(UaOptionSet uaOptionSet, UaNodeId uaNodeId) throws EncodingException {
        OptionSetSpecification optionSetSpecification = this.getEncoderContext().getOptionSetSpecification(uaNodeId);
        if (optionSetSpecification == null) {
            throw new EncodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId + ", thus cannot encode the 'null' form of this type as it's length is unknown");
        }
        if (uaOptionSet == null) {
            this.put(null, null, optionSetSpecification.getBaseTypeId(), 0);
        } else {
            this.put(null, uaOptionSet.getValue(), optionSetSpecification.getBaseTypeId(), 0);
        }
    }

    private void d(QualifiedName qualifiedName) throws EncodingException {
        try {
            if (qualifiedName == null) {
                this.tt.putShort((short)0);
                this.H(null);
                return;
            }
            this.tt.putShort((short)qualifiedName.getNamespaceIndex());
            this.H(qualifiedName.getName());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Byte by) throws EncodingException {
        try {
            if (by == null) {
                this.f(by);
                this.q(0);
            } else {
                this.tt.put(by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void q(int n2) throws EncodingException {
        this.a((byte)n2);
    }

    private void a(StatusCode statusCode) throws EncodingException {
        try {
            if (statusCode == null) {
                this.f(statusCode);
                this.tt.putInt(StatusCode.GOOD.getValueAsIntBits());
            } else {
                this.tt.putInt(statusCode.getValueAsIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void H(String string) throws EncodingException {
        try {
            if (string == null) {
                this.f(string);
                this.tt.putInt(-1);
            } else {
                this.m(string.length());
                byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                this.tt.putInt(byArray.length);
                this.tt.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        try {
            if (structure == null) {
                structure = structureSpecification.toInstanceBuilder().build();
            }
            Map<FieldSpecification, Object> map = structure.toFieldsMap(structureSpecification);
            if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
                long l2 = 0L;
                FieldSpecification fieldSpecification = null;
                Object object = null;
                for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                    ++l2;
                    if (entry.getValue() == null) continue;
                    fieldSpecification = entry.getKey();
                    object = entry.getValue();
                    break;
                }
                if (fieldSpecification == null) {
                    this.putUInt32("SwitchField", UnsignedInteger.ZERO);
                    return;
                }
                this.putUInt32("SwitchField", UnsignedInteger.valueOf(l2));
                int n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
                this.put("Value", object, fieldSpecification.getDataTypeId(), n2);
                return;
            }
            if (StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
                void var5_17;
                int n3 = -1;
                UnsignedInteger object = UnsignedInteger.ZERO;
                for (Map.Entry<FieldSpecification, Object> entry2 : map.entrySet()) {
                    if (!entry2.getKey().isOptional()) continue;
                    ++n3;
                    if (structure == null || entry2.getValue() == null) continue;
                    UnsignedInteger unsignedInteger = BinaryEncoder.b((UnsignedInteger)var5_17, n3);
                }
                this.putUInt32("EncodingMask", (UnsignedInteger)var5_17);
            }
            for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                int n4;
                Map.Entry<FieldSpecification, Object> entry2;
                FieldSpecification fieldSpecification = entry.getKey();
                entry2 = entry.getValue();
                if (fieldSpecification.isOptional() && entry2 == null) continue;
                int n2 = n4 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
                if (fieldSpecification.isAllowSubTypes()) {
                    if (ExtensionObject.class.isAssignableFrom(fieldSpecification.getCompositeClass())) {
                        this.put(null, entry2, UaIds.Structure, n4);
                        continue;
                    }
                    if (Object.class.equals(fieldSpecification.getCompositeClass())) {
                        this.put(null, entry2, UaIds.BaseDataType, n4);
                        continue;
                    }
                    throw new EncodingException("The java class for AllowSubTypes field should either be ExtensionObject.class or Object.class, got: " + fieldSpecification + "in structure type: " + structureSpecification);
                }
                this.put(null, entry2, fieldSpecification.getDataTypeId(), n4);
            }
        }
        catch (Exception exception) {
            throw new EncodingException("Could not encode Structure", exception);
        }
    }

    private void a(UnsignedShort unsignedShort) throws EncodingException {
        try {
            if (unsignedShort == null) {
                this.f(unsignedShort);
                this.tt.putShort((short)0);
            } else {
                this.tt.putShort(unsignedShort.toShortBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void j(UnsignedInteger unsignedInteger) throws EncodingException {
        try {
            if (unsignedInteger == null) {
                this.f(unsignedInteger);
                this.tt.putInt(0);
            } else {
                this.tt.putInt(unsignedInteger.toIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UnsignedLong unsignedLong) throws EncodingException {
        try {
            if (unsignedLong == null) {
                this.f(unsignedLong);
                this.tt.putLong(0L);
            } else {
                this.tt.putLong(unsignedLong.toLongBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(XmlElement xmlElement) throws EncodingException {
        try {
            if (xmlElement == null) {
                this.tt.putInt(-1);
            } else {
                this.b(xmlElement.getData());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Deprecated
    void a(int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.putBooleanArray(null, (Boolean[])object);
                break;
            }
            case 2: {
                this.putSByteArray(null, (Byte[])object);
                break;
            }
            case 3: {
                this.putByteArray(null, (UnsignedByte[])object);
                break;
            }
            case 4: {
                this.putInt16Array(null, (Short[])object);
                break;
            }
            case 5: {
                this.putUInt16Array(null, (UnsignedShort[])object);
                break;
            }
            case 6: {
                this.putInt32Array((String)null, (Integer[])object);
                break;
            }
            case 7: {
                this.putUInt32Array(null, (UnsignedInteger[])object);
                break;
            }
            case 8: {
                this.putInt64Array(null, (Long[])object);
                break;
            }
            case 9: {
                this.putUInt64Array(null, (UnsignedLong[])object);
                break;
            }
            case 10: {
                this.putFloatArray(null, (Float[])object);
                break;
            }
            case 11: {
                this.putDoubleArray(null, (Double[])object);
                break;
            }
            case 12: {
                this.putStringArray(null, (String[])object);
                break;
            }
            case 13: {
                this.putDateTimeArray(null, (DateTime[])object);
                break;
            }
            case 14: {
                this.putGuidArray(null, (UUID[])object);
                break;
            }
            case 15: {
                this.putByteStringArray(null, (ByteString[])object);
                break;
            }
            case 16: {
                this.putXmlElementArray(null, (XmlElement[])object);
                break;
            }
            case 17: {
                this.putNodeIdArray(null, (NodeId[])object);
                break;
            }
            case 18: {
                this.putExpandedNodeIdArray(null, (ExpandedNodeId[])object);
                break;
            }
            case 19: {
                this.putStatusCodeArray(null, (StatusCode[])object);
                break;
            }
            case 20: {
                this.putQualifiedNameArray(null, (QualifiedName[])object);
                break;
            }
            case 21: {
                this.putLocalizedTextArray(null, (LocalizedText[])object);
                break;
            }
            case 22: {
                if (object instanceof ExtensionObject[]) {
                    this.c((ExtensionObject[])object);
                    break;
                }
                if (object instanceof Structure[]) {
                    this.a((Structure[])object);
                    break;
                }
                throw new EncodingException("cannot encode " + object);
            }
            case 23: {
                this.putDataValueArray(null, (DataValue[])object);
                break;
            }
            case 24: {
                this.putVariantArray(null, (Variant[])object);
                break;
            }
            case 25: {
                this.putDiagnosticInfoArray(null, (DiagnosticInfo[])object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    @Deprecated
    void b(int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.a((Boolean)object);
                break;
            }
            case 2: {
                this.a((Byte)object);
                break;
            }
            case 3: {
                this.a((UnsignedByte)object);
                break;
            }
            case 4: {
                this.a((Short)object);
                break;
            }
            case 5: {
                this.a((UnsignedShort)object);
                break;
            }
            case 6: {
                this.b((Integer)object);
                break;
            }
            case 7: {
                this.j((UnsignedInteger)object);
                break;
            }
            case 8: {
                this.b((Long)object);
                break;
            }
            case 9: {
                this.a((UnsignedLong)object);
                break;
            }
            case 10: {
                this.a((Float)object);
                break;
            }
            case 11: {
                this.c((Double)object);
                break;
            }
            case 12: {
                this.H((String)object);
                break;
            }
            case 13: {
                this.e((DateTime)object);
                break;
            }
            case 14: {
                this.a((UUID)object);
                break;
            }
            case 15: {
                this.e((ByteString)object);
                break;
            }
            case 16: {
                this.a((XmlElement)object);
                break;
            }
            case 17: {
                this.n((NodeId)object);
                break;
            }
            case 18: {
                this.b((ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.a((StatusCode)object);
                break;
            }
            case 20: {
                this.d((QualifiedName)object);
                break;
            }
            case 21: {
                this.a((LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.b(new ExtensionObject((Structure)object));
                    break;
                }
                this.b((ExtensionObject)object);
                break;
            }
            case 23: {
                this.j((DataValue)object);
                break;
            }
            case 24: {
                this.c((Variant)object);
                break;
            }
            case 25: {
                this.b((DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    void c(Variant variant) throws EncodingException {
        boolean bl;
        int n2;
        if (variant == null) {
            this.f(variant);
            this.q(0);
            return;
        }
        ExtensionObject[] extensionObjectArray = variant.getValue();
        if (extensionObjectArray == null) {
            this.q(0);
            return;
        }
        Class<?> clazz = variant.getCompositeClass();
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            n2 = 22;
            bl = true;
        } else {
            bl = false;
            if (Structure.class.isAssignableFrom(clazz)) {
                n2 = 22;
            } else if (BuiltinsMap.ID_MAP.containsKey(clazz)) {
                n2 = BuiltinsMap.ID_MAP.get(clazz);
            } else {
                throw new EncodingException("Non-suitable composite class for Variant: " + clazz);
            }
        }
        if (!variant.isArray()) {
            this.q(n2);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal)extensionObjectArray);
            }
            this.b(n2, extensionObjectArray);
            return;
        }
        int n3 = variant.getDimension();
        if (n3 == 1) {
            this.q(n2 | 0x80);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal[])extensionObjectArray);
            }
            this.a(n2, extensionObjectArray);
            return;
        }
        int[] nArray = variant.getArrayDimensions();
        int n4 = MultiDimensionArrayUtils.getLength(nArray);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), variant.getArrayDimensions());
        try {
            this.q(n2 | 0xC0);
            this.tt.putInt(n4);
            while (arrayIterator.hasNext()) {
                Object object = arrayIterator.next();
                if (bl) {
                    object = BinaryEncoder.a((BigDecimal)object);
                }
                this.b(n2, object);
            }
            this.a(nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EncodingException("The dimensions of inner array elements of a multi-dimension variable must be equal in length", arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    static {
        tg = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        BinaryEncoder.b(UaIds.Boolean, Boolean.class, (BinaryEncoder binaryEncoder, String string, T bl, UaNodeId uaNodeId) -> binaryEncoder.a((Boolean)bl));
        BinaryEncoder.b(UaIds.SByte, Byte.class, (BinaryEncoder binaryEncoder, String string, T by, UaNodeId uaNodeId) -> binaryEncoder.a((Byte)by));
        BinaryEncoder.b(UaIds.Byte, UnsignedByte.class, (BinaryEncoder binaryEncoder, String string, T unsignedByte, UaNodeId uaNodeId) -> binaryEncoder.a((UnsignedByte)unsignedByte));
        BinaryEncoder.b(UaIds.Int16, Short.class, (BinaryEncoder binaryEncoder, String string, T s2, UaNodeId uaNodeId) -> binaryEncoder.a((Short)s2));
        BinaryEncoder.b(UaIds.UInt16, UnsignedShort.class, (BinaryEncoder binaryEncoder, String string, T unsignedShort, UaNodeId uaNodeId) -> binaryEncoder.a((UnsignedShort)unsignedShort));
        BinaryEncoder.b(UaIds.Int32, Integer.class, (BinaryEncoder binaryEncoder, String string, T n2, UaNodeId uaNodeId) -> binaryEncoder.b((Integer)n2));
        BinaryEncoder.b(UaIds.UInt32, UnsignedInteger.class, (BinaryEncoder binaryEncoder, String string, T unsignedInteger, UaNodeId uaNodeId) -> binaryEncoder.j((UnsignedInteger)unsignedInteger));
        BinaryEncoder.b(UaIds.Int64, Long.class, (BinaryEncoder binaryEncoder, String string, T l2, UaNodeId uaNodeId) -> binaryEncoder.b((Long)l2));
        BinaryEncoder.b(UaIds.UInt64, UnsignedLong.class, (BinaryEncoder binaryEncoder, String string, T unsignedLong, UaNodeId uaNodeId) -> binaryEncoder.a((UnsignedLong)unsignedLong));
        BinaryEncoder.b(UaIds.Float, Float.class, (BinaryEncoder binaryEncoder, String string, T f2, UaNodeId uaNodeId) -> binaryEncoder.a((Float)f2));
        BinaryEncoder.b(UaIds.Double, Double.class, (BinaryEncoder binaryEncoder, String string, T d2, UaNodeId uaNodeId) -> binaryEncoder.c((Double)d2));
        BinaryEncoder.b(UaIds.String, String.class, (BinaryEncoder binaryEncoder, String string, T string2, UaNodeId uaNodeId) -> binaryEncoder.H((String)string2));
        BinaryEncoder.b(UaIds.Guid, UUID.class, (BinaryEncoder binaryEncoder, String string, T uUID, UaNodeId uaNodeId) -> binaryEncoder.a((UUID)uUID));
        BinaryEncoder.b(UaIds.ByteString, ByteString.class, (BinaryEncoder binaryEncoder, String string, T byteString, UaNodeId uaNodeId) -> binaryEncoder.b(ByteString.asByteArray(byteString)));
        BinaryEncoder.b(UaIds.XmlElement, XmlElement.class, (BinaryEncoder binaryEncoder, String string, T xmlElement, UaNodeId uaNodeId) -> binaryEncoder.a((XmlElement)xmlElement));
        BinaryEncoder.b(UaIds.NodeId, NodeId.class, (BinaryEncoder binaryEncoder, String string, T nodeId, UaNodeId uaNodeId) -> binaryEncoder.n((NodeId)nodeId));
        BinaryEncoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (BinaryEncoder binaryEncoder, String string, T expandedNodeId, UaNodeId uaNodeId) -> binaryEncoder.b((ExpandedNodeId)expandedNodeId));
        BinaryEncoder.b(UaIds.StatusCode, StatusCode.class, (BinaryEncoder binaryEncoder, String string, T statusCode, UaNodeId uaNodeId) -> binaryEncoder.a((StatusCode)statusCode));
        BinaryEncoder.b(UaIds.QualifiedName, QualifiedName.class, (BinaryEncoder binaryEncoder, String string, T qualifiedName, UaNodeId uaNodeId) -> binaryEncoder.d((QualifiedName)qualifiedName));
        BinaryEncoder.b(UaIds.LocalizedText, LocalizedText.class, (BinaryEncoder binaryEncoder, String string, T localizedText, UaNodeId uaNodeId) -> binaryEncoder.a((LocalizedText)localizedText));
        tk = (binaryEncoder, string, dateTime, uaNodeId) -> binaryEncoder.e((DateTime)dateTime);
        BinaryEncoder.a(UaIds.DateTime, DateTime.class, tk);
        tl = (binaryEncoder, string, extensionObject, uaNodeId) -> binaryEncoder.b((ExtensionObject)extensionObject);
        BinaryEncoder.a(UaIds.Structure, ExtensionObject.class, tl);
        tm = (binaryEncoder, string, structure, uaNodeId) -> {
            StructureSpecification structureSpecification = binaryEncoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new EncodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            binaryEncoder.a((Structure)structure, structureSpecification);
        };
        tn = (binaryEncoder, string, dataValue, uaNodeId) -> binaryEncoder.j((DataValue)dataValue);
        BinaryEncoder.a(UaIds.DataValue, DataValue.class, tn);
        to = (binaryEncoder, string, variant, uaNodeId) -> binaryEncoder.c((Variant)variant);
        tp = (binaryEncoder, string, diagnosticInfo, uaNodeId) -> binaryEncoder.b((DiagnosticInfo)diagnosticInfo);
        BinaryEncoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, tp);
        tq = (binaryEncoder, string, enumeration, uaNodeId) -> binaryEncoder.a((Enumeration)enumeration);
        tr = (binaryEncoder, string, bigDecimal, uaNodeId) -> binaryEncoder.b((BigDecimal)bigDecimal);
        BinaryEncoder.a(UaIds.Decimal, BigDecimal.class, tr);
        ts = (binaryEncoder, string, uaOptionSet, uaNodeId) -> binaryEncoder.a((UaOptionSet)uaOptionSet, uaNodeId);
        BinaryEncoder.b(null, Object.class, (BinaryEncoder binaryEncoder, String string, T object, UaNodeId uaNodeId) -> {
            if (object == null) {
                to.put(binaryEncoder, string, null, UaIds.BaseDataType);
            } else if (object instanceof Variant) {
                to.put(binaryEncoder, string, (Variant)object, UaIds.BaseDataType);
            } else {
                to.put(binaryEncoder, string, new Variant(object), UaIds.BaseDataType);
            }
        });
    }

    private static interface a<T> {
        public void put(BinaryEncoder var1, String var2, T var3, UaNodeId var4) throws EncodingException;
    }
}

