/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.binary.NodeIdEncoding;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoder
implements IDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BinaryDecoder.class);
    private static final Map<Class<?>, a<?>> sU = new HashMap();
    private static final Map<UaNodeId, a<?>> sV = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> sW = new BijectionMap();
    private static final a<DateTime> sX;
    private static final a<ExtensionObject> sY;
    private static final a<Structure> sZ;
    private static final a<DataValue> ta;
    private static final a<Variant> tb;
    private static final a<DiagnosticInfo> tc;
    private static final a<Enumeration> td;
    private static final a<BigDecimal> te;
    private static final a<UaOptionSet> tf;
    private static final ExpandedNodeId tg;
    IBinaryReadable th;
    EncoderContext ti;
    private BiConsumer<FieldSpecification, Object> tj;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (sV.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (sW.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (sW.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            sW.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (sU.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        BinaryDecoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> f(Class<?> clazz) throws DecodingException {
        if (clazz == null) {
            throw new DecodingException("Cannot decode class null");
        }
        a<?> a2 = sU.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return sY;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return sZ;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return ta;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return tb;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return tc;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return td;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return sX;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return te;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return tf;
        }
        throw new DecodingException("Cannot decode class: " + clazz);
    }

    private static a<Object> a(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws DecodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return BinaryDecoder.f(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return BinaryDecoder.f(ExtensionObject.class);
        }
        a<Object> a2 = sV.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = sV.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = sZ;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = tf;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = td;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(sW.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new DecodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new DecodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    private static boolean a(UnsignedInteger unsignedInteger, int n2) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("mask cannot be null");
        }
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("position must be between 0-31");
        }
        int n3 = 1 << n2;
        if (UnsignedInteger.ZERO.equals(unsignedInteger)) {
            return false;
        }
        return unsignedInteger.and(n3).equals(UnsignedInteger.valueOf(n3));
    }

    private static DecodingException a(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new DecodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new DecodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new DecodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
        }
        return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    public BinaryDecoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(ByteBuffer byteBuffer) {
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(IBinaryReadable iBinaryReadable) {
        this.setReadable(iBinaryReadable);
    }

    public BinaryDecoder(InputStream inputStream, int n2) {
        InputStreamReadable inputStreamReadable = new InputStreamReadable(inputStream, n2);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(inputStreamReadable);
    }

    @Override
    public <T> T get(String string, UaNodeId uaNodeId, int n2) throws DecodingException {
        Object object;
        Class clazz;
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            clazz = Object.class;
        } else if (UaIds.Structure.equals(uaNodeId)) {
            clazz = ExtensionObject.class;
        } else {
            object = this.getEncoderContext().getDataTypeSpecification(uaNodeId);
            if (object == null) {
                throw new DecodingException("Cannot find UaDataTypeSpecification, cannot decode DataType: " + uaNodeId);
            }
            clazz = object.getJavaClass();
        }
        try {
            if (n2 < 0) {
                throw new DecodingException("The given dimensions cannot be negative");
            }
            object = this.a(clazz, uaNodeId, n2);
            return (T)object;
        }
        catch (Exception exception) {
            throw new DecodingException("Error while trying to decode, DataTypeId: " + uaNodeId, exception);
        }
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.ti;
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        return this.esb();
    }

    public IBinaryReadable getReadable() {
        return this.th;
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ti = encoderContext;
    }

    public void setReadable(IBinaryReadable iBinaryReadable) {
        if (iBinaryReadable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Readable must be in Little-Ending byte order");
        }
        this.th = iBinaryReadable;
    }

    public void setStructureFieldDecodeListener(BiConsumer<FieldSpecification, Object> biConsumer) {
        this.tj = biConsumer;
    }

    private void a(int n2, int n3) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Illegal array length " + n2);
        }
        int n4 = this.ti.getMaxArrayLength();
        if (n4 > 0 && n2 > n4) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength=" + n4 + " < " + n2);
        }
        long l2 = n2;
        if (l2 * (long)n3 > this.remaining()) {
            throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
        }
    }

    private void l(int n2) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected byte string length " + n2);
        }
        int n3 = this.ti.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
        }
        if ((long)n2 > this.remaining()) {
            throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
        }
    }

    private void m(int n2) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected string length " + n2);
        }
        int n3 = this.ti.getMaxStringLength();
        if (n3 > 0 && n2 > n3) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
        }
        if ((long)n2 > this.remaining()) {
            throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
        }
    }

    private BigDecimal d(ByteString byteString) {
        byte[] byArray = byteString.getValue();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[0]);
        byteBuffer.put(byArray[1]);
        byteBuffer.rewind();
        short s2 = byteBuffer.getShort();
        byte[] byArray2 = Arrays.copyOfRange(byArray, 2, byArray.length);
        byArray2 = com.prosysopc.ua.stack.encoding.binary.a.reverse(byArray2);
        BigInteger bigInteger = new BigInteger(byArray2);
        return new BigDecimal(bigInteger, s2);
    }

    private BigDecimal G(String string) throws DecodingException {
        ExtensionObject extensionObject = this.getExtensionObject(string);
        if (!this.getEncoderContext().getNamespaceTable().nodeIdEquals(extensionObject.getTypeId(), tg)) {
            logger.error("Encountered a Decimal that does not define correct id, is {}", (Object)extensionObject.getTypeId());
        }
        try {
            return this.d((ByteString)extensionObject.getObject());
        }
        catch (ClassCastException classCastException) {
            throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
        }
    }

    private UaOptionSet a(String string, UaNodeId uaNodeId) throws DecodingException {
        OptionSetSpecification optionSetSpecification = this.getEncoderContext().getOptionSetSpecification(uaNodeId);
        if (optionSetSpecification == null) {
            throw new DecodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
        }
        Object obj = this.a(optionSetSpecification.getBaseTypeJavaClass(), optionSetSpecification.getBaseTypeId(), 0);
        try {
            return (UaOptionSet)new Variant(obj).asOptionSet(optionSetSpecification);
        }
        catch (Exception exception) {
            throw new DecodingException(exception, "Could not resolve the value as UaOptionSet");
        }
    }

    private <T> T a(Class<T> clazz, UaNodeId uaNodeId, int n2) throws DecodingException {
        Class clazz2;
        Object[] objectArray;
        if (n2 < 0) {
            throw new DecodingException("The given dimensions cannot be negative");
        }
        a<Object> a2 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = sW.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            objectArray = new AtomicReference();
            a2 = BinaryDecoder.a(uaNodeId2, this.getEncoderContext(), objectArray);
            clazz2 = (Class)objectArray.get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a2 = BinaryDecoder.f(clazz2);
        }
        if (n2 == 0) {
            objectArray = a2;
            return objectArray.get(this, null, clazz, uaNodeId);
        }
        if (n2 == 1) {
            int n3 = this.getInt32(null);
            if (n3 == -1) {
                return null;
            }
            Object[] objectArray2 = (Object[])Array.newInstance(clazz2, n3);
            a<Object> a3 = a2;
            for (int i2 = 0; i2 < n3; ++i2) {
                objectArray2[i2] = a3.get(this, null, clazz2, uaNodeId);
            }
            Object[] objectArray3 = objectArray2;
            return (T)objectArray3;
        }
        objectArray = this.getInt32Array_(null);
        if (objectArray == null) {
            return null;
        }
        int n4 = 1;
        for (Object object : objectArray) {
            if (object < 0) {
                return null;
            }
            n4 *= object;
        }
        Object[] objectArray4 = (Object[])Array.newInstance(clazz2, n4);
        a<Object> a4 = a2;
        for (int i3 = 0; i3 < n4; ++i3) {
            objectArray4[i3] = a4.get(this, null, clazz2, uaNodeId);
        }
        Object object = MultiDimensionArrayUtils.demuxArray((Object)objectArray4, (int[])objectArray, clazz2);
        return (T)object;
    }

    private Object n(int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.getBooleanArray(null);
            }
            case 2: {
                return this.getSByteArray(null);
            }
            case 3: {
                return this.getByteArray(null);
            }
            case 4: {
                return this.getInt16Array(null);
            }
            case 5: {
                return this.getUInt16Array(null);
            }
            case 6: {
                return this.getInt32Array(null);
            }
            case 7: {
                return this.getUInt32Array(null);
            }
            case 8: {
                return this.getInt64Array(null);
            }
            case 9: {
                return this.getUInt64Array(null);
            }
            case 10: {
                return this.getFloatArray(null);
            }
            case 11: {
                return this.getDoubleArray(null);
            }
            case 12: {
                return this.getStringArray(null);
            }
            case 13: {
                return this.getDateTimeArray(null);
            }
            case 14: {
                return this.getGuidArray(null);
            }
            case 15: {
                return this.getByteStringArray(null);
            }
            case 16: {
                return this.getXmlElementArray(null);
            }
            case 17: {
                return this.getNodeIdArray(null);
            }
            case 18: {
                return this.getExpandedNodeIdArray(null);
            }
            case 19: {
                return this.getStatusCodeArray(null);
            }
            case 20: {
                return this.getQualifiedNameArray(null);
            }
            case 21: {
                return this.getLocalizedTextArray(null);
            }
            case 22: {
                return this.getExtensionObjectArray(null);
            }
            case 23: {
                return this.getDataValueArray(null);
            }
            case 24: {
                return this.getVariantArray(null);
            }
            case 25: {
                return this.getDiagnosticInfoArray(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private Boolean erO() throws DecodingException {
        try {
            if (this.th.get() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedByte erP() throws DecodingException {
        try {
            return UnsignedByte.getFromBits(this.th.get());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ByteString erQ() throws DecodingException {
        try {
            int n2 = this.th.getInt();
            if (n2 == -1) {
                return null;
            }
            this.l(n2);
            byte[] byArray = new byte[n2];
            this.th.get(byArray);
            return ByteString.valueOf(byArray);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private DataValue erR() throws DecodingException {
        try {
            byte by = this.th.get();
            Variant variant = (by & 1) != 0 ? this.getVariant(null) : null;
            StatusCode statusCode = (by & 2) != 0 ? this.getStatusCode(null) : StatusCode.GOOD;
            DateTime dateTime = (by & 4) != 0 ? this.getDateTime(null) : null;
            UnsignedShort unsignedShort = (by & 0x10) != 0 ? this.getUInt16(null) : UnsignedShort.MIN_VALUE;
            DateTime dateTime2 = (by & 8) != 0 ? this.getDateTime(null) : null;
            UnsignedShort unsignedShort2 = (by & 0x20) != 0 ? this.getUInt16(null) : UnsignedShort.MIN_VALUE;
            return new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private DateTime erS() throws DecodingException {
        try {
            long l2 = this.th.getLong();
            return DateTime.valueOf(l2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private DiagnosticInfo erT() throws DecodingException {
        try {
            byte by = this.th.get();
            Integer n2 = (by & 1) != 0 ? this.getInt32(null) : null;
            Integer n3 = (by & 2) != 0 ? this.getInt32(null) : null;
            Integer n4 = (by & 8) != 0 ? this.getInt32(null) : null;
            Integer n5 = (by & 4) != 0 ? this.getInt32(null) : null;
            String string = (by & 0x10) != 0 ? this.getString(null) : null;
            StatusCode statusCode = (by & 0x20) != 0 ? this.getStatusCode(null) : null;
            DiagnosticInfo diagnosticInfo = (by & 0x40) != 0 ? this.getDiagnosticInfo(null) : null;
            return new DiagnosticInfo(string, diagnosticInfo, statusCode, n4, n5, n3, n2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Double erU() throws DecodingException {
        try {
            return this.th.getDouble();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private <T extends Enumeration> T a(Class<T> clazz, UaNodeId uaNodeId) throws DecodingException {
        try {
            int n2 = this.th.getInt();
            EnumerationSpecification enumerationSpecification = this.getEncoderContext().getEnumerationSpecification(uaNodeId);
            if (enumerationSpecification != null) {
                return (T)enumerationSpecification.getByValue(n2);
            }
            Method method = clazz.getMethod("valueOf", Integer.TYPE);
            return (T)((Enumeration)method.invoke(null, n2));
        }
        catch (SecurityException securityException) {
            throw new DecodingException(securityException, "cannot decode " + clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DecodingException(noSuchMethodException, "cannot decode " + clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DecodingException(illegalArgumentException, "cannot decode " + clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DecodingException(illegalAccessException, "cannot decode " + clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DecodingException(invocationTargetException, "cannot decode " + clazz);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ExpandedNodeId erV() throws DecodingException {
        try {
            byte by = this.th.get();
            boolean bl = (by & 0x40) == 64;
            boolean bl2 = (by & 0x80) == 128;
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by & 0x3F);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            Object object = null;
            int n2 = 0;
            String string = null;
            UnsignedInteger unsignedInteger = null;
            if (nodeIdEncoding == NodeIdEncoding.TwoByte) {
                n2 = 0;
                object = UnsignedInteger.getFromBits(this.th.get() & 0xFF);
            }
            if (nodeIdEncoding == NodeIdEncoding.FourByte) {
                n2 = this.th.get() & 0xFF;
                object = UnsignedInteger.getFromBits(this.th.getShort() & 0xFFFF);
            }
            if (nodeIdEncoding == NodeIdEncoding.Numeric) {
                n2 = this.th.getShort() & 0xFFFF;
                object = UnsignedInteger.getFromBits(this.th.getInt());
            }
            if (nodeIdEncoding == NodeIdEncoding.String) {
                n2 = this.th.getShort() & 0xFFFF;
                object = this.getString(null);
            }
            if (nodeIdEncoding == NodeIdEncoding.ByteString) {
                n2 = this.th.getShort() & 0xFFFF;
                object = this.getByteString(null);
                if (object != null) {
                    object = ((ByteString)object).getValue();
                }
            }
            if (nodeIdEncoding == NodeIdEncoding.Guid) {
                n2 = this.th.getShort() & 0xFFFF;
                object = this.getGuid(null);
            }
            if (bl2) {
                string = this.getString(null);
            }
            if (bl) {
                unsignedInteger = this.getUInt32(null);
            }
            if (string != null) {
                return new ExpandedNodeId(unsignedInteger, string, object);
            }
            return new ExpandedNodeId(unsignedInteger, n2, object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ExtensionObject erW() throws DecodingException {
        try {
            ExtensionObject extensionObject;
            NodeId nodeId = this.getNodeId(null);
            ExpandedNodeId expandedNodeId = this.ti.getNamespaceTable().toExpandedNodeId(nodeId);
            byte by = this.th.get();
            if (by == 0) {
                if (nodeId == null || nodeId.equals(NodeId.NULL)) {
                    return null;
                }
                return new ExtensionObject(expandedNodeId);
            }
            if (by == 1) {
                extensionObject = new ExtensionObject(expandedNodeId, this.getByteString(null));
            } else if (by == 2) {
                extensionObject = new ExtensionObject(expandedNodeId, this.getXmlElement(null));
            } else {
                throw new DecodingException("Unexpected encoding byte (" + by + ") in ExtensionObject");
            }
            if (this.a(extensionObject)) {
                return extensionObject;
            }
            try {
                Structure structure = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject(structure);
            }
            catch (DecodingException decodingException) {
                return extensionObject;
            }
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Float erX() throws DecodingException {
        try {
            return Float.valueOf(this.th.getFloat());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UUID erY() throws DecodingException {
        try {
            int n2;
            byte[] byArray = new byte[16];
            byArray[3] = this.th.get();
            byArray[2] = this.th.get();
            byArray[1] = this.th.get();
            byArray[0] = this.th.get();
            byArray[5] = this.th.get();
            byArray[4] = this.th.get();
            byArray[7] = this.th.get();
            byArray[6] = this.th.get();
            for (int i2 = 8; i2 < 16; ++i2) {
                byArray[i2] = this.th.get();
            }
            long l2 = 0L;
            long l3 = 0L;
            for (n2 = 0; n2 < 8; ++n2) {
                l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
            }
            for (n2 = 8; n2 < 16; ++n2) {
                l3 = l3 << 8 | (long)(byArray[n2] & 0xFF);
            }
            return new UUID(l2, l3);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Short erZ() throws DecodingException {
        try {
            return this.th.getShort();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Integer esa() throws DecodingException {
        try {
            return this.th.getInt();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private int[] esb() throws DecodingException {
        try {
            int n2 = this.th.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.getInt32(null);
            }
            return nArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Long esc() throws DecodingException {
        try {
            return this.th.getLong();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private LocalizedText esd() throws DecodingException {
        try {
            byte by = this.th.get();
            String string = null;
            String string2 = null;
            if ((by & 1) == 1) {
                string = this.getString(null);
            }
            if ((by & 2) == 2) {
                string2 = this.getString(null);
            }
            return LocalizedText.builder().setText(string2, string).build();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private NodeId ese() throws DecodingException {
        try {
            NodeId nodeId;
            byte by = this.th.get();
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            int n2 = 0;
            if (nodeIdEncoding == NodeIdEncoding.TwoByte) {
                n2 = 0;
                UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(this.th.get() & 0xFF);
                nodeId = new NodeId(n2, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.FourByte) {
                n2 = this.th.get() & 0xFF;
                UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(this.th.getShort() & 0xFFFF);
                nodeId = new NodeId(n2, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.Numeric) {
                n2 = this.th.getShort() & 0xFFFF;
                UnsignedInteger unsignedInteger = this.getUInt32(null);
                nodeId = new NodeId(n2, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.String) {
                n2 = this.th.getShort() & 0xFFFF;
                String string = this.getString(null);
                nodeId = new NodeId(n2, string);
            } else if (nodeIdEncoding == NodeIdEncoding.ByteString) {
                n2 = this.th.getShort() & 0xFFFF;
                ByteString byteString = this.getByteString(null);
                nodeId = new NodeId(n2, ByteString.asByteArray(byteString));
            } else if (nodeIdEncoding == NodeIdEncoding.Guid) {
                n2 = this.th.getShort() & 0xFFFF;
                UUID uUID = this.getGuid(null);
                nodeId = new NodeId(n2, uUID);
            } else {
                throw new DecodingException("Unsupported NodeId Encoding byte " + (Object)((Object)nodeIdEncoding));
            }
            return nodeId;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private QualifiedName esf() throws DecodingException {
        UnsignedShort unsignedShort = this.getUInt16(null);
        String string = this.getString(null);
        if (string == null) {
            return new QualifiedName(unsignedShort, null);
        }
        return new QualifiedName(unsignedShort, string);
    }

    private Byte esg() throws DecodingException {
        try {
            return this.th.get();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Object o(int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.erO();
            }
            case 2: {
                return this.esg();
            }
            case 3: {
                return this.erP();
            }
            case 4: {
                return this.erZ();
            }
            case 5: {
                return this.esj();
            }
            case 6: {
                return this.esa();
            }
            case 7: {
                return this.esk();
            }
            case 8: {
                return this.esc();
            }
            case 9: {
                return this.esl();
            }
            case 10: {
                return this.erX();
            }
            case 11: {
                return this.erU();
            }
            case 12: {
                return this.esi();
            }
            case 13: {
                return this.erS();
            }
            case 14: {
                return this.erY();
            }
            case 15: {
                return this.erQ();
            }
            case 16: {
                return this.esn();
            }
            case 17: {
                return this.ese();
            }
            case 18: {
                return this.erV();
            }
            case 19: {
                return this.esh();
            }
            case 20: {
                return this.esf();
            }
            case 21: {
                return this.esd();
            }
            case 22: {
                return this.erW();
            }
            case 23: {
                return this.erR();
            }
            case 24: {
                return this.esm();
            }
            case 25: {
                return this.erT();
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private StatusCode esh() throws DecodingException {
        return StatusCode.valueOf(this.esk());
    }

    private String esi() throws DecodingException {
        try {
            int n2 = this.th.getInt();
            if (n2 == -1) {
                return null;
            }
            this.m(n2);
            byte[] byArray = new byte[n2];
            this.th.get(byArray);
            return new String(byArray, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Structure b(StructureSpecification structureSpecification) throws DecodingException {
        UnsignedInteger unsignedInteger = null;
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        if (StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
            unsignedInteger = this.esk();
            logger.trace("EncodingMask: {}", (Object)unsignedInteger);
        }
        if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
            unsignedInteger = this.esk();
            long l2 = unsignedInteger.longValue();
            logger.trace("SwitchField: {}", (Object)l2);
            if (l2 < 0L) {
                throw new DecodingException("Union SwitchField must be >= 0");
            }
            if (l2 == 0L) {
                return builder.build();
            }
            long l3 = 0L;
            for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
                if (l2 != ++l3) continue;
                logger.trace("Decoded Union Field: {}, SwitchValue: {}", (Object)fieldSpecification, (Object)l3);
                builder.set(fieldSpecification, this.a(fieldSpecification));
                return builder.build();
            }
            throw new DecodingException("Union SwitchField overflow: " + ++l3);
        }
        int n2 = -1;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            if (fieldSpecification.isOptional()) {
                if (!BinaryDecoder.a(unsignedInteger, ++n2)) continue;
                builder.set(fieldSpecification, this.a(fieldSpecification));
                continue;
            }
            builder.set(fieldSpecification, this.a(fieldSpecification));
        }
        return builder.build();
    }

    private Object a(FieldSpecification fieldSpecification) throws DecodingException {
        Class<?> clazz;
        Class<?> clazz2 = fieldSpecification.getJavaClass();
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz2);
        Object obj = fieldSpecification.isAllowSubTypes() ? (ExtensionObject.class.isAssignableFrom(clazz = MultiDimensionArrayUtils.getComponentType(clazz2)) ? this.a(MultiDimensionArrayUtils.arrayClassOf(ExtensionObject.class, n2), UaIds.Structure, n2) : this.a(MultiDimensionArrayUtils.arrayClassOf(Variant.class, n2), UaIds.BaseDataType, n2)) : this.a(clazz2, fieldSpecification.getDataTypeId(), n2);
        Optional.ofNullable(this.tj).ifPresent(biConsumer -> biConsumer.accept(fieldSpecification, obj));
        return obj;
    }

    private UnsignedShort esj() throws DecodingException {
        try {
            return UnsignedShort.getFromBits(this.th.getShort());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedInteger esk() throws DecodingException {
        try {
            return UnsignedInteger.getFromBits(this.th.getInt());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedLong esl() throws DecodingException {
        try {
            return UnsignedLong.getFromBits(this.th.getLong());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Variant esm() throws DecodingException {
        try {
            boolean bl;
            boolean bl2;
            byte by = this.th.get();
            int n2 = by & 0x3F;
            boolean bl3 = (by & 0x80) == 128;
            boolean bl4 = (by & 0x40) == 64;
            boolean bl5 = bl2 = n2 == 0;
            if (n2 > 25) {
                n2 = 15;
            }
            Object object = bl2 ? null : (bl3 ? this.n(n2) : this.o(n2));
            int[] nArray = bl4 ? this.getInt32Array_(null) : null;
            boolean bl6 = bl = bl3 && nArray != null && nArray.length > 1;
            if (bl4) {
                long l2;
                long l3;
                if (nArray != null && nArray.length != 0) {
                    l3 = 1L;
                    for (int n3 : nArray) {
                        l3 *= (long)n3;
                    }
                } else {
                    l3 = nArray == null ? -1L : 0L;
                }
                Object[] objectArray = object;
                long l4 = l2 = objectArray == null ? -1L : (long)objectArray.length;
                if (l2 != l3) {
                    throw new DecodingException("Variant's ArrayDimensions " + Arrays.toString(nArray) + " total size of " + l3 + " does not match defined ArrayLength of " + l2 + ". Variant value was: " + MultiDimensionArrayUtils.toString(object, this.ti));
                }
            }
            if (object instanceof ExtensionObject && this.a((ExtensionObject)object)) {
                try {
                    object = this.d((ByteString)((ExtensionObject)object).getObject());
                }
                catch (ClassCastException classCastException) {
                    throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
                }
            }
            if (object instanceof ExtensionObject) {
                ExtensionObject extensionObject = (ExtensionObject)object;
                try {
                    object = extensionObject.decode(this.ti);
                }
                catch (DecodingException exception) {
                    object = extensionObject;
                }
            }
            if (bl3) {
                if (object instanceof ExtensionObject[]) {
                    object = this.b((ExtensionObject[])object);
                }
                if (object instanceof ExtensionObject[]) {
                    ExtensionObject[] extensionObjectArray = object;
                    try {
                        object = this.ti.decode(extensionObjectArray);
                    }
                    catch (Exception exception) {
                        object = extensionObjectArray;
                    }
                }
                if (bl) {
                    try {
                        object = MultiDimensionArrayUtils.demuxArray(object, nArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException("The length of ArrayDimensions-field does not match Value-field");
                    }
                }
            }
            return new Variant(object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private XmlElement esn() throws DecodingException {
        ByteString byteString = this.erQ();
        if (byteString == null) {
            return null;
        }
        return new XmlElement(ByteString.asByteArray(byteString));
    }

    private boolean a(ExtensionObject extensionObject) {
        if (extensionObject == null) {
            return false;
        }
        return this.ti.getNamespaceTable().nodeIdEquals(Identifiers.Decimal, extensionObject.getTypeId());
    }

    private Object b(ExtensionObject[] extensionObjectArray) {
        BigDecimal[] bigDecimalArray = new BigDecimal[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (!this.a(extensionObject)) {
                return extensionObjectArray;
            }
            bigDecimalArray[i2] = this.d((ByteString)extensionObject.getObject());
        }
        return bigDecimalArray;
    }

    protected long remaining() throws DecodingException {
        try {
            return this.th.limit() - this.th.position();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Deprecated
    <T> T a(String string, Class<T> clazz) throws DecodingException {
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        return this.a(clazz, null, n2);
    }

    static {
        tg = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        BinaryDecoder.b(UaIds.Boolean, Boolean.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erO());
        BinaryDecoder.b(UaIds.SByte, Byte.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esg());
        BinaryDecoder.b(UaIds.Byte, UnsignedByte.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erP());
        BinaryDecoder.b(UaIds.Int16, Short.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erZ());
        BinaryDecoder.b(UaIds.UInt16, UnsignedShort.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esj());
        BinaryDecoder.b(UaIds.Int32, Integer.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esa());
        BinaryDecoder.b(UaIds.UInt32, UnsignedInteger.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esk());
        BinaryDecoder.b(UaIds.Int64, Long.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esc());
        BinaryDecoder.b(UaIds.UInt64, UnsignedLong.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esl());
        BinaryDecoder.b(UaIds.Float, Float.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erX());
        BinaryDecoder.b(UaIds.Double, Double.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erU());
        BinaryDecoder.b(UaIds.String, String.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esi());
        BinaryDecoder.b(UaIds.Guid, UUID.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erY());
        BinaryDecoder.b(UaIds.ByteString, ByteString.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erQ());
        BinaryDecoder.b(UaIds.XmlElement, XmlElement.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esn());
        BinaryDecoder.b(UaIds.NodeId, NodeId.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.ese());
        BinaryDecoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erV());
        BinaryDecoder.b(UaIds.StatusCode, StatusCode.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esh());
        BinaryDecoder.b(UaIds.QualifiedName, QualifiedName.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esf());
        BinaryDecoder.b(UaIds.LocalizedText, LocalizedText.class, (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esd());
        sX = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erS();
        BinaryDecoder.a(UaIds.DateTime, DateTime.class, sX);
        sY = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erW();
        BinaryDecoder.a(UaIds.Structure, ExtensionObject.class, sY);
        sZ = (binaryDecoder, string, clazz, uaNodeId) -> {
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            StructureSpecification structureSpecification = binaryDecoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new DecodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            return binaryDecoder.b(structureSpecification);
        };
        ta = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erR();
        BinaryDecoder.a(UaIds.DataValue, DataValue.class, ta);
        tb = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.esm();
        tc = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.erT();
        BinaryDecoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, tc);
        td = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.a(clazz, uaNodeId);
        te = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.G(string);
        BinaryDecoder.a(UaIds.Decimal, BigDecimal.class, te);
        tf = (binaryDecoder, string, clazz, uaNodeId) -> binaryDecoder.a(string, uaNodeId);
        BinaryDecoder.b(null, Object.class, (binaryDecoder, string, clazz, uaNodeId) -> tb.get(binaryDecoder, string, Variant.class, uaNodeId).getValue());
    }

    private static interface a<T> {
        public T get(BinaryDecoder var1, String var2, Class<? extends T> var3, UaNodeId var4) throws DecodingException;
    }
}

