/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding;

import com.prosysopc.ua.CommonCodegenModel;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import com.prosysopc.ua.types.opcua.CommonInformationModel;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncoderContext {
    private static final Logger logger = LoggerFactory.getLogger(EncoderContext.class);
    private NamespaceTable iz;
    private ServerTable sN;
    private int maxMessageSize = 0;
    private int sO = 0;
    private int sP = 0;
    private int sQ = 0;
    private final Map<UaNodeId, UaDataTypeSpecification> specifications = new ConcurrentHashMap<UaNodeId, UaDataTypeSpecification>();
    private volatile Function<UaNodeId, UaDataTypeSpecification> sR;

    @Deprecated
    public static EncoderContext getDefaultInstance() {
        return a.sS;
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable) {
        this.iz = namespaceTable;
        this.sN = serverTable;
        this.registerModel(CommonInformationModel.MODEL);
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable, int n2) {
        this.iz = namespaceTable;
        this.sN = serverTable;
        this.maxMessageSize = n2;
        this.registerModel(CommonInformationModel.MODEL);
    }

    public void addDataTypeSpecification(UaDataTypeSpecification uaDataTypeSpecification) {
        if (uaDataTypeSpecification == null) {
            throw new IllegalArgumentException("The given specification cannot be null");
        }
        this.specifications.put(uaDataTypeSpecification.getTypeId(), uaDataTypeSpecification);
        if (uaDataTypeSpecification instanceof StructureSpecification) {
            StructureSpecification structureSpecification = (StructureSpecification)uaDataTypeSpecification;
            if (structureSpecification.getBinaryEncodeId() != null) {
                this.specifications.put(structureSpecification.getBinaryEncodeId(), uaDataTypeSpecification);
            }
            if (structureSpecification.getXmlEncodeId() != null) {
                this.specifications.put(structureSpecification.getXmlEncodeId(), uaDataTypeSpecification);
            }
            if (structureSpecification.getJsonEncodeId() != null) {
                this.specifications.put(structureSpecification.getJsonEncodeId(), uaDataTypeSpecification);
            }
        }
    }

    @Deprecated
    public void addEnumerationSpecification(EnumerationSpecification enumerationSpecification) {
        this.addDataTypeSpecification(enumerationSpecification);
    }

    @Deprecated
    public void addStructureSpecification(StructureSpecification structureSpecification) {
        this.addDataTypeSpecification(structureSpecification);
    }

    public Object decode(ExtensionObject[] extensionObjectArray) throws DecodingException {
        return this.decode(extensionObjectArray, null);
    }

    public Object decode(ExtensionObject[] extensionObjectArray, NamespaceTable namespaceTable) throws DecodingException {
        int n2 = extensionObjectArray.length;
        Structure[] structureArray = new Structure[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (extensionObject == null) continue;
            structureArray[i2] = (Structure)extensionObject.decode(this, namespaceTable);
        }
        Structure[] structureArray2 = structureArray;
        if (n2 > 0) {
            Class<?> clazz = null;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (structureArray[i3] == null) continue;
                Class<?> clazz2 = structureArray[i3].getClass();
                if (clazz == null) {
                    clazz = clazz2;
                    continue;
                }
                if (clazz2.isAssignableFrom(clazz)) continue;
                if (clazz.isAssignableFrom(clazz2)) {
                    clazz = clazz2;
                    continue;
                }
                clazz = null;
                break;
            }
            if (clazz != null) {
                structureArray2 = Arrays.copyOf(structureArray, n2, ((Structure[])Array.newInstance(clazz, 0)).getClass());
            }
        }
        return structureArray2;
    }

    public UaDataTypeSpecification getDataTypeSpecification(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given id cannot be null");
        }
        UaDataTypeSpecification uaDataTypeSpecification = this.specifications.get(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification;
        }
        Function<UaNodeId, UaDataTypeSpecification> function = this.sR;
        if (function != null) {
            return function.apply(uaNodeId);
        }
        return null;
    }

    public Map<UaNodeId, UaDataTypeSpecification> getDataTypeSpecifications() {
        return Collections.unmodifiableMap(this.specifications);
    }

    public EnumerationSpecification getEnumerationSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof EnumerationSpecification) {
            return (EnumerationSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public int getMaxArrayLength() {
        return this.sQ;
    }

    public int getMaxByteStringLength() {
        return this.sP;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxStringLength() {
        return this.sO;
    }

    public NamespaceTable getNamespaceTable() {
        return this.iz;
    }

    public OptionSetSpecification getOptionSetSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof OptionSetSpecification) {
            return (OptionSetSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public ServerTable getServerTable() {
        return this.sN;
    }

    public SimpleTypeSpecification getSimpleTypeSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
            return (SimpleTypeSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public StructureSpecification getStructureSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof StructureSpecification) {
            return (StructureSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public void registerModel(CommonCodegenModel commonCodegenModel) {
        if (commonCodegenModel == null) {
            throw new IllegalArgumentException("The given model cannot be null");
        }
        commonCodegenModel.getSpecifications().values().forEach(this::addDataTypeSpecification);
    }

    public void setDynamicDataTypeSpecificationProvider(Function<UaNodeId, UaDataTypeSpecification> function) {
        this.sR = function;
    }

    public void setMaxArrayLength(int n2) {
        this.sQ = n2;
    }

    public void setMaxByteStringLength(int n2) {
        this.sP = n2;
    }

    public void setMaxMessageSize(int n2) {
        this.maxMessageSize = n2;
    }

    public void setMaxStringLength(int n2) {
        this.sO = n2;
    }

    public void setNamespaceTable(NamespaceTable namespaceTable) {
        this.iz = namespaceTable;
    }

    public void setServerTable(ServerTable serverTable) {
        this.sN = serverTable;
    }

    public EncoderContext shallowCopy() {
        EncoderContext encoderContext = new EncoderContext(this.getNamespaceTable(), this.getServerTable());
        encoderContext.setMaxArrayLength(this.getMaxArrayLength());
        encoderContext.setMaxByteStringLength(this.getMaxByteStringLength());
        encoderContext.setMaxMessageSize(this.getMaxMessageSize());
        encoderContext.setMaxStringLength(this.getMaxStringLength());
        encoderContext.specifications.putAll(this.specifications);
        encoderContext.sR = this.sR;
        return encoderContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("   namespaceTable = " + this.iz + "\n");
        stringBuilder.append("   serverTable = " + this.sN + "\n");
        stringBuilder.append("   maxMessageSize = " + this.maxMessageSize + "\n");
        stringBuilder.append("   maxStringLength = " + this.sO + "\n");
        stringBuilder.append("   maxByteStringLength = " + this.sP + "\n");
        stringBuilder.append("   maxArrayLength = " + this.sQ + "\n");
        return stringBuilder.toString();
    }

    private static final class a {
        static final EncoderContext sS = new EncoderContext(NamespaceTable.getDefaultInstance(), null);

        private a() {
        }
    }
}

