/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12080")
public class XVType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.XVType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.XVType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.XVType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.XVType;
    public static final StructureSpecification SPECIFICATION;
    private Double f_x;
    private Float f_value;

    public XVType() {
    }

    public XVType(Double d2, Float f2) {
        this.f_x = d2;
        this.f_value = f2;
    }

    public Double getX() {
        return this.f_x;
    }

    public void setX(Double d2) {
        this.f_x = d2;
    }

    public Float getValue() {
        return this.f_value;
    }

    public void setValue(Float f2) {
        this.f_value = f2;
    }

    @Override
    public XVType clone() {
        XVType xVType = (XVType)super.clone();
        xVType.f_x = StructureUtils.clone(this.f_x);
        xVType.f_value = StructureUtils.clone(this.f_value);
        return xVType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XVType xVType = (XVType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getX(), xVType.getX())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValue(), xVType.getValue());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getX(), this.getValue());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_x = null;
        this.f_value = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Number> linkedHashMap = new LinkedHashMap<Fields, Number>();
        linkedHashMap.put(Fields.X, this.getX());
        linkedHashMap.put(Fields.Value, this.getValue());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.X.equals(fieldSpecification)) {
            return this.getX();
        }
        if (Fields.Value.equals(fieldSpecification)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.X.equals(fieldSpecification)) {
            this.setX((Double)object);
            return;
        }
        if (Fields.Value.equals(fieldSpecification)) {
            this.setValue((Float)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = XVType.builder();
        builder.setX(StructureUtils.clone(this.getX()));
        builder.setValue(StructureUtils.clone(this.getValue()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.X);
        builder.addField(Fields.Value);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("XVType");
        builder.setJavaClass(XVType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Double f_x;
        private Float f_value;

        protected Builder() {
        }

        public Double getX() {
            return this.f_x;
        }

        public Builder setX(Double d2) {
            this.f_x = d2;
            return this;
        }

        public Float getValue() {
            return this.f_value;
        }

        public Builder setValue(Float f2) {
            this.f_value = f2;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getX(), builder.getX())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getValue(), builder.getValue());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getX(), this.getValue());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.X.equals(fieldSpecification)) {
                return this.getX();
            }
            if (Fields.Value.equals(fieldSpecification)) {
                return this.getValue();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.X.equals(fieldSpecification)) {
                this.setX((Double)object);
                return this;
            }
            if (Fields.Value.equals(fieldSpecification)) {
                this.setValue((Float)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_x = null;
            this.f_value = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public XVType build() {
            return new XVType(this.f_x, this.f_value);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        X("X", Double.class, false, UaIds.Double, -1, null, false),
        Value("Value", Float.class, false, UaIds.Float, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

