/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.WriteResponse;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=671")
public class WriteRequest
extends AbstractStructure
implements ServiceRequest<WriteResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.WriteRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.WriteRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.WriteRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.WriteRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader f_requestHeader;
    private WriteValue[] f_nodesToWrite;

    public WriteRequest() {
    }

    public WriteRequest(RequestHeader requestHeader, WriteValue[] writeValueArray) {
        this.f_requestHeader = requestHeader;
        this.f_nodesToWrite = writeValueArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.f_requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.f_requestHeader = requestHeader;
    }

    public WriteValue[] getNodesToWrite() {
        return this.f_nodesToWrite;
    }

    public void setNodesToWrite(WriteValue[] writeValueArray) {
        this.f_nodesToWrite = writeValueArray;
    }

    @Override
    public WriteRequest clone() {
        WriteRequest writeRequest = (WriteRequest)super.clone();
        writeRequest.f_requestHeader = StructureUtils.clone(this.f_requestHeader);
        writeRequest.f_nodesToWrite = StructureUtils.clone(this.f_nodesToWrite);
        return writeRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WriteRequest writeRequest = (WriteRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), writeRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToWrite(), writeRequest.getNodesToWrite());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getNodesToWrite());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_requestHeader = null;
        this.f_nodesToWrite = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.RequestHeader, this.getRequestHeader());
        linkedHashMap.put(Fields.NodesToWrite, this.getNodesToWrite());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.NodesToWrite.equals(fieldSpecification)) {
            return this.getNodesToWrite();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.NodesToWrite.equals(fieldSpecification)) {
            this.setNodesToWrite((WriteValue[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = WriteRequest.builder();
        builder.setRequestHeader(StructureUtils.clone(this.getRequestHeader()));
        builder.setNodesToWrite(StructureUtils.clone(this.getNodesToWrite()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader);
        builder.addField(Fields.NodesToWrite);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("WriteRequest");
        builder.setJavaClass(WriteRequest.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader f_requestHeader;
        private WriteValue[] f_nodesToWrite;

        protected Builder() {
        }

        public RequestHeader getRequestHeader() {
            return this.f_requestHeader;
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.f_requestHeader = requestHeader;
            return this;
        }

        public WriteValue[] getNodesToWrite() {
            return this.f_nodesToWrite;
        }

        public Builder setNodesToWrite(WriteValue[] writeValueArray) {
            this.f_nodesToWrite = writeValueArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), builder.getRequestHeader())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getNodesToWrite(), builder.getNodesToWrite());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getRequestHeader(), this.getNodesToWrite());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                return this.getRequestHeader();
            }
            if (Fields.NodesToWrite.equals(fieldSpecification)) {
                return this.getNodesToWrite();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.NodesToWrite.equals(fieldSpecification)) {
                this.setNodesToWrite((WriteValue[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_requestHeader = null;
            this.f_nodesToWrite = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public WriteRequest build() {
            return new WriteRequest(this.f_requestHeader, this.f_nodesToWrite);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaIds.RequestHeader, -1, null, false),
        NodesToWrite("NodesToWrite", WriteValue[].class, false, UaIds.WriteValue, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

