/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=511")
public class ViewDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ViewDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ViewDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ViewDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ViewDescription;
    public static final StructureSpecification SPECIFICATION;
    private NodeId f_viewId;
    private DateTime f_timestamp;
    private UnsignedInteger f_viewVersion;

    public ViewDescription() {
    }

    public ViewDescription(NodeId nodeId, DateTime dateTime, UnsignedInteger unsignedInteger) {
        this.f_viewId = nodeId;
        this.f_timestamp = dateTime;
        this.f_viewVersion = unsignedInteger;
    }

    public NodeId getViewId() {
        return this.f_viewId;
    }

    public void setViewId(NodeId nodeId) {
        this.f_viewId = nodeId;
    }

    public DateTime getTimestamp() {
        return this.f_timestamp;
    }

    public void setTimestamp(DateTime dateTime) {
        this.f_timestamp = dateTime;
    }

    public UnsignedInteger getViewVersion() {
        return this.f_viewVersion;
    }

    public void setViewVersion(UnsignedInteger unsignedInteger) {
        this.f_viewVersion = unsignedInteger;
    }

    @Override
    public ViewDescription clone() {
        ViewDescription viewDescription = (ViewDescription)super.clone();
        viewDescription.f_viewId = StructureUtils.clone(this.f_viewId);
        viewDescription.f_timestamp = StructureUtils.clone(this.f_timestamp);
        viewDescription.f_viewVersion = StructureUtils.clone(this.f_viewVersion);
        return viewDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewDescription viewDescription = (ViewDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getViewId(), viewDescription.getViewId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTimestamp(), viewDescription.getTimestamp())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getViewVersion(), viewDescription.getViewVersion());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getViewId(), this.getTimestamp(), this.getViewVersion());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_viewId = null;
        this.f_timestamp = null;
        this.f_viewVersion = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Comparable<NodeId>> linkedHashMap = new LinkedHashMap<Fields, Comparable<NodeId>>();
        linkedHashMap.put(Fields.ViewId, this.getViewId());
        linkedHashMap.put(Fields.Timestamp, this.getTimestamp());
        linkedHashMap.put(Fields.ViewVersion, this.getViewVersion());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ViewId.equals(fieldSpecification)) {
            return this.getViewId();
        }
        if (Fields.Timestamp.equals(fieldSpecification)) {
            return this.getTimestamp();
        }
        if (Fields.ViewVersion.equals(fieldSpecification)) {
            return this.getViewVersion();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ViewId.equals(fieldSpecification)) {
            this.setViewId((NodeId)object);
            return;
        }
        if (Fields.Timestamp.equals(fieldSpecification)) {
            this.setTimestamp((DateTime)object);
            return;
        }
        if (Fields.ViewVersion.equals(fieldSpecification)) {
            this.setViewVersion((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ViewDescription.builder();
        builder.setViewId(StructureUtils.clone(this.getViewId()));
        builder.setTimestamp(StructureUtils.clone(this.getTimestamp()));
        builder.setViewVersion(StructureUtils.clone(this.getViewVersion()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.ViewId);
        builder.addField(Fields.Timestamp);
        builder.addField(Fields.ViewVersion);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ViewDescription");
        builder.setJavaClass(ViewDescription.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId f_viewId;
        private DateTime f_timestamp;
        private UnsignedInteger f_viewVersion;

        protected Builder() {
        }

        public NodeId getViewId() {
            return this.f_viewId;
        }

        public Builder setViewId(NodeId nodeId) {
            this.f_viewId = nodeId;
            return this;
        }

        public DateTime getTimestamp() {
            return this.f_timestamp;
        }

        public Builder setTimestamp(DateTime dateTime) {
            this.f_timestamp = dateTime;
            return this;
        }

        public UnsignedInteger getViewVersion() {
            return this.f_viewVersion;
        }

        public Builder setViewVersion(UnsignedInteger unsignedInteger) {
            this.f_viewVersion = unsignedInteger;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getViewId(), builder.getViewId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getTimestamp(), builder.getTimestamp())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getViewVersion(), builder.getViewVersion());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getViewId(), this.getTimestamp(), this.getViewVersion());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.ViewId.equals(fieldSpecification)) {
                return this.getViewId();
            }
            if (Fields.Timestamp.equals(fieldSpecification)) {
                return this.getTimestamp();
            }
            if (Fields.ViewVersion.equals(fieldSpecification)) {
                return this.getViewVersion();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ViewId.equals(fieldSpecification)) {
                this.setViewId((NodeId)object);
                return this;
            }
            if (Fields.Timestamp.equals(fieldSpecification)) {
                this.setTimestamp((DateTime)object);
                return this;
            }
            if (Fields.ViewVersion.equals(fieldSpecification)) {
                this.setViewVersion((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_viewId = null;
            this.f_timestamp = null;
            this.f_viewVersion = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ViewDescription build() {
            return new ViewDescription(this.f_viewId, this.f_timestamp, this.f_viewVersion);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        ViewId("ViewId", NodeId.class, false, UaIds.NodeId, -1, null, false),
        Timestamp("Timestamp", DateTime.class, false, UaIds.UtcTime, -1, null, false),
        ViewVersion("ViewVersion", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

