/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=303")
public enum UserTokenType implements Enumeration
{
    Anonymous(0),
    UserName(1),
    Certificate(2),
    IssuedToken(3);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<UserTokenType> NONE;
    public static final EnumSet<UserTokenType> ALL;
    private static final Map<Integer, UserTokenType> map;
    private final int value;

    private UserTokenType(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static UserTokenType valueOf(int n2) {
        return map.get(n2);
    }

    public static UserTokenType valueOf(Integer n2) {
        return n2 == null ? null : UserTokenType.valueOf((int)n2);
    }

    public static UserTokenType valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : UserTokenType.valueOf(unsignedInteger.intValue());
    }

    public static UserTokenType[] valueOf(int[] nArray) {
        UserTokenType[] userTokenTypeArray = new UserTokenType[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            userTokenTypeArray[i2] = UserTokenType.valueOf(nArray[i2]);
        }
        return userTokenTypeArray;
    }

    public static UserTokenType[] valueOf(Integer[] integerArray) {
        UserTokenType[] userTokenTypeArray = new UserTokenType[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            userTokenTypeArray[i2] = UserTokenType.valueOf(integerArray[i2]);
        }
        return userTokenTypeArray;
    }

    public static UserTokenType[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        UserTokenType[] userTokenTypeArray = new UserTokenType[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            userTokenTypeArray[i2] = UserTokenType.valueOf(unsignedIntegerArray[i2]);
        }
        return userTokenTypeArray;
    }

    public static UnsignedInteger getMask(UserTokenType ... userTokenTypeArray) {
        int n2 = 0;
        for (UserTokenType userTokenType : userTokenTypeArray) {
            n2 |= userTokenType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<UserTokenType> collection) {
        int n2 = 0;
        for (UserTokenType userTokenType : collection) {
            n2 |= userTokenType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<UserTokenType> getSet(UnsignedInteger unsignedInteger) {
        return UserTokenType.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<UserTokenType> getSet(int n2) {
        ArrayList<UserTokenType> arrayList = new ArrayList<UserTokenType>();
        for (UserTokenType userTokenType : UserTokenType.values()) {
            if ((n2 & userTokenType.value) != userTokenType.value) continue;
            arrayList.add(userTokenType);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = UserTokenType.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(UserTokenType.class);
        ALL = EnumSet.allOf(UserTokenType.class);
        map = new HashMap<Integer, UserTokenType>();
        for (UserTokenType userTokenType : UserTokenType.values()) {
            map.put(userTokenType.value, userTokenType);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("UserTokenType");
        builder.setJavaClass(UserTokenType.class);
        builder.setTypeId(UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=303")));
        builder.addMapping(0, "Anonymous");
        builder.addMapping(1, "UserName");
        builder.addMapping(2, "Certificate");
        builder.addMapping(3, "IssuedToken");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return UserTokenType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    implements Enumeration.Builder {
        private UserTokenType value;

        private Builder() {
        }

        @Override
        public UserTokenType build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = UserTokenType.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum UserTokenType int value: " + n2);
            }
            return this;
        }
    }
}

