/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=322")
public class UserNameIdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.UserNameIdentityToken_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.UserNameIdentityToken_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.UserNameIdentityToken_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.UserNameIdentityToken;
    public static final StructureSpecification SPECIFICATION;
    private String f_userName;
    private ByteString f_password;
    private String f_encryptionAlgorithm;

    public UserNameIdentityToken() {
    }

    public UserNameIdentityToken(String string, ByteString byteString, String string2) {
        this.f_userName = string;
        this.f_password = byteString;
        this.f_encryptionAlgorithm = string2;
    }

    public UserNameIdentityToken(String string, String string2, ByteString byteString, String string3) {
        super(string);
        this.f_userName = string2;
        this.f_password = byteString;
        this.f_encryptionAlgorithm = string3;
    }

    public String getUserName() {
        return this.f_userName;
    }

    public void setUserName(String string) {
        this.f_userName = string;
    }

    public ByteString getPassword() {
        return this.f_password;
    }

    public void setPassword(ByteString byteString) {
        this.f_password = byteString;
    }

    public String getEncryptionAlgorithm() {
        return this.f_encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.f_encryptionAlgorithm = string;
    }

    @Override
    public UserNameIdentityToken clone() {
        UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)super.clone();
        userNameIdentityToken.f_userName = StructureUtils.clone(this.f_userName);
        userNameIdentityToken.f_password = StructureUtils.clone(this.f_password);
        userNameIdentityToken.f_encryptionAlgorithm = StructureUtils.clone(this.f_encryptionAlgorithm);
        return userNameIdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), userNameIdentityToken.getPolicyId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserName(), userNameIdentityToken.getUserName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getPassword(), userNameIdentityToken.getPassword())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEncryptionAlgorithm(), userNameIdentityToken.getEncryptionAlgorithm());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId(), this.getUserName(), this.getPassword(), this.getEncryptionAlgorithm());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_userName = null;
        this.f_password = null;
        this.f_encryptionAlgorithm = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.PolicyId, this.getPolicyId());
        linkedHashMap.put(Fields.UserName, this.getUserName());
        linkedHashMap.put(Fields.Password, this.getPassword());
        linkedHashMap.put(Fields.EncryptionAlgorithm, this.getEncryptionAlgorithm());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        if (Fields.UserName.equals(fieldSpecification)) {
            return this.getUserName();
        }
        if (Fields.Password.equals(fieldSpecification)) {
            return this.getPassword();
        }
        if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
            return this.getEncryptionAlgorithm();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        if (Fields.UserName.equals(fieldSpecification)) {
            this.setUserName((String)object);
            return;
        }
        if (Fields.Password.equals(fieldSpecification)) {
            this.setPassword((ByteString)object);
            return;
        }
        if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
            this.setEncryptionAlgorithm((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = UserNameIdentityToken.builder();
        builder.setPolicyId(StructureUtils.clone(this.getPolicyId()));
        builder.setUserName(StructureUtils.clone(this.getUserName()));
        builder.setPassword(StructureUtils.clone(this.getPassword()));
        builder.setEncryptionAlgorithm(StructureUtils.clone(this.getEncryptionAlgorithm()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId);
        builder.addField(Fields.UserName);
        builder.addField(Fields.Password);
        builder.addField(Fields.EncryptionAlgorithm);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.UserIdentityToken);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("UserNameIdentityToken");
        builder.setJavaClass(UserNameIdentityToken.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String f_policyId;
        private String f_userName;
        private ByteString f_password;
        private String f_encryptionAlgorithm;

        protected Builder() {
        }

        @Override
        public String getPolicyId() {
            return this.f_policyId;
        }

        @Override
        public Builder setPolicyId(String string) {
            this.f_policyId = string;
            return this;
        }

        public String getUserName() {
            return this.f_userName;
        }

        public Builder setUserName(String string) {
            this.f_userName = string;
            return this;
        }

        public ByteString getPassword() {
            return this.f_password;
        }

        public Builder setPassword(ByteString byteString) {
            this.f_password = byteString;
            return this;
        }

        public String getEncryptionAlgorithm() {
            return this.f_encryptionAlgorithm;
        }

        public Builder setEncryptionAlgorithm(String string) {
            this.f_encryptionAlgorithm = string;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), builder.getPolicyId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getUserName(), builder.getUserName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getPassword(), builder.getPassword())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getEncryptionAlgorithm(), builder.getEncryptionAlgorithm());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getPolicyId(), this.getUserName(), this.getPassword(), this.getEncryptionAlgorithm());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                return this.getPolicyId();
            }
            if (Fields.UserName.equals(fieldSpecification)) {
                return this.getUserName();
            }
            if (Fields.Password.equals(fieldSpecification)) {
                return this.getPassword();
            }
            if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
                return this.getEncryptionAlgorithm();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            if (Fields.UserName.equals(fieldSpecification)) {
                this.setUserName((String)object);
                return this;
            }
            if (Fields.Password.equals(fieldSpecification)) {
                this.setPassword((ByteString)object);
                return this;
            }
            if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
                this.setEncryptionAlgorithm((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_userName = null;
            this.f_password = null;
            this.f_encryptionAlgorithm = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public UserNameIdentityToken build() {
            return new UserNameIdentityToken(this.f_policyId, this.f_userName, this.f_password, this.f_encryptionAlgorithm);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        PolicyId("PolicyId", String.class, false, UaIds.String, -1, null, false),
        UserName("UserName", String.class, false, UaIds.String, -1, null, false),
        Password("Password", ByteString.class, false, UaIds.ByteString, -1, null, false),
        EncryptionAlgorithm("EncryptionAlgorithm", String.class, false, UaIds.String, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

