/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeSchemaHeader;
import com.prosysopc.ua.stack.core.EnumDescription;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.SimpleTypeDescription;
import com.prosysopc.ua.stack.core.StructureDescription;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15006")
public class UABinaryFileDataType
extends DataTypeSchemaHeader {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.UABinaryFileDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.UABinaryFileDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.UABinaryFileDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.UABinaryFileDataType;
    public static final StructureSpecification SPECIFICATION;
    private String f_schemaLocation;
    private KeyValuePair[] f_fileHeader;
    private Object f_body;

    public UABinaryFileDataType() {
    }

    public UABinaryFileDataType(String string, KeyValuePair[] keyValuePairArray, Object object) {
        this.f_schemaLocation = string;
        this.f_fileHeader = keyValuePairArray;
        this.f_body = object;
    }

    public UABinaryFileDataType(String[] stringArray, StructureDescription[] structureDescriptionArray, EnumDescription[] enumDescriptionArray, SimpleTypeDescription[] simpleTypeDescriptionArray, String string, KeyValuePair[] keyValuePairArray, Object object) {
        super(stringArray, structureDescriptionArray, enumDescriptionArray, simpleTypeDescriptionArray);
        this.f_schemaLocation = string;
        this.f_fileHeader = keyValuePairArray;
        this.f_body = object;
    }

    public String getSchemaLocation() {
        return this.f_schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.f_schemaLocation = string;
    }

    public KeyValuePair[] getFileHeader() {
        return this.f_fileHeader;
    }

    public void setFileHeader(KeyValuePair[] keyValuePairArray) {
        this.f_fileHeader = keyValuePairArray;
    }

    public Object getBody() {
        return this.f_body;
    }

    public void setBody(Object object) {
        this.f_body = object;
    }

    @Override
    public UABinaryFileDataType clone() {
        UABinaryFileDataType uABinaryFileDataType = (UABinaryFileDataType)super.clone();
        uABinaryFileDataType.f_schemaLocation = StructureUtils.clone(this.f_schemaLocation);
        uABinaryFileDataType.f_fileHeader = StructureUtils.clone(this.f_fileHeader);
        uABinaryFileDataType.f_body = StructureUtils.clone(this.f_body);
        return uABinaryFileDataType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UABinaryFileDataType uABinaryFileDataType = (UABinaryFileDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNamespaces(), uABinaryFileDataType.getNamespaces())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStructureDataTypes(), uABinaryFileDataType.getStructureDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEnumDataTypes(), uABinaryFileDataType.getEnumDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSimpleDataTypes(), uABinaryFileDataType.getSimpleDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSchemaLocation(), uABinaryFileDataType.getSchemaLocation())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getFileHeader(), uABinaryFileDataType.getFileHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getBody(), uABinaryFileDataType.getBody());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes(), this.getSchemaLocation(), this.getFileHeader(), this.getBody());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_schemaLocation = null;
        this.f_fileHeader = null;
        this.f_body = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Namespaces, this.getNamespaces());
        linkedHashMap.put(Fields.StructureDataTypes, this.getStructureDataTypes());
        linkedHashMap.put(Fields.EnumDataTypes, this.getEnumDataTypes());
        linkedHashMap.put(Fields.SimpleDataTypes, this.getSimpleDataTypes());
        linkedHashMap.put(Fields.SchemaLocation, this.getSchemaLocation());
        linkedHashMap.put(Fields.FileHeader, this.getFileHeader());
        linkedHashMap.put(Fields.Body, this.getBody());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Namespaces.equals(fieldSpecification)) {
            return this.getNamespaces();
        }
        if (Fields.StructureDataTypes.equals(fieldSpecification)) {
            return this.getStructureDataTypes();
        }
        if (Fields.EnumDataTypes.equals(fieldSpecification)) {
            return this.getEnumDataTypes();
        }
        if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
            return this.getSimpleDataTypes();
        }
        if (Fields.SchemaLocation.equals(fieldSpecification)) {
            return this.getSchemaLocation();
        }
        if (Fields.FileHeader.equals(fieldSpecification)) {
            return this.getFileHeader();
        }
        if (Fields.Body.equals(fieldSpecification)) {
            return this.getBody();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Namespaces.equals(fieldSpecification)) {
            this.setNamespaces((String[])object);
            return;
        }
        if (Fields.StructureDataTypes.equals(fieldSpecification)) {
            this.setStructureDataTypes((StructureDescription[])object);
            return;
        }
        if (Fields.EnumDataTypes.equals(fieldSpecification)) {
            this.setEnumDataTypes((EnumDescription[])object);
            return;
        }
        if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
            this.setSimpleDataTypes((SimpleTypeDescription[])object);
            return;
        }
        if (Fields.SchemaLocation.equals(fieldSpecification)) {
            this.setSchemaLocation((String)object);
            return;
        }
        if (Fields.FileHeader.equals(fieldSpecification)) {
            this.setFileHeader((KeyValuePair[])object);
            return;
        }
        if (Fields.Body.equals(fieldSpecification)) {
            this.setBody(object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = UABinaryFileDataType.builder();
        builder.setNamespaces(StructureUtils.clone(this.getNamespaces()));
        builder.setStructureDataTypes(StructureUtils.clone(this.getStructureDataTypes()));
        builder.setEnumDataTypes(StructureUtils.clone(this.getEnumDataTypes()));
        builder.setSimpleDataTypes(StructureUtils.clone(this.getSimpleDataTypes()));
        builder.setSchemaLocation(StructureUtils.clone(this.getSchemaLocation()));
        builder.setFileHeader(StructureUtils.clone(this.getFileHeader()));
        builder.setBody(StructureUtils.clone(this.getBody()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Namespaces);
        builder.addField(Fields.StructureDataTypes);
        builder.addField(Fields.EnumDataTypes);
        builder.addField(Fields.SimpleDataTypes);
        builder.addField(Fields.SchemaLocation);
        builder.addField(Fields.FileHeader);
        builder.addField(Fields.Body);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.DataTypeSchemaHeader);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("UABinaryFileDataType");
        builder.setJavaClass(UABinaryFileDataType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeSchemaHeader.Builder {
        private String[] f_namespaces;
        private StructureDescription[] f_structureDataTypes;
        private EnumDescription[] f_enumDataTypes;
        private SimpleTypeDescription[] f_simpleDataTypes;
        private String f_schemaLocation;
        private KeyValuePair[] f_fileHeader;
        private Object f_body;

        protected Builder() {
        }

        @Override
        public String[] getNamespaces() {
            return this.f_namespaces;
        }

        @Override
        public Builder setNamespaces(String[] stringArray) {
            this.f_namespaces = stringArray;
            return this;
        }

        @Override
        public StructureDescription[] getStructureDataTypes() {
            return this.f_structureDataTypes;
        }

        @Override
        public Builder setStructureDataTypes(StructureDescription[] structureDescriptionArray) {
            this.f_structureDataTypes = structureDescriptionArray;
            return this;
        }

        @Override
        public EnumDescription[] getEnumDataTypes() {
            return this.f_enumDataTypes;
        }

        @Override
        public Builder setEnumDataTypes(EnumDescription[] enumDescriptionArray) {
            this.f_enumDataTypes = enumDescriptionArray;
            return this;
        }

        @Override
        public SimpleTypeDescription[] getSimpleDataTypes() {
            return this.f_simpleDataTypes;
        }

        @Override
        public Builder setSimpleDataTypes(SimpleTypeDescription[] simpleTypeDescriptionArray) {
            this.f_simpleDataTypes = simpleTypeDescriptionArray;
            return this;
        }

        public String getSchemaLocation() {
            return this.f_schemaLocation;
        }

        public Builder setSchemaLocation(String string) {
            this.f_schemaLocation = string;
            return this;
        }

        public KeyValuePair[] getFileHeader() {
            return this.f_fileHeader;
        }

        public Builder setFileHeader(KeyValuePair[] keyValuePairArray) {
            this.f_fileHeader = keyValuePairArray;
            return this;
        }

        public Object getBody() {
            return this.f_body;
        }

        public Builder setBody(Object object) {
            this.f_body = object;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getNamespaces(), builder.getNamespaces())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getStructureDataTypes(), builder.getStructureDataTypes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getEnumDataTypes(), builder.getEnumDataTypes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSimpleDataTypes(), builder.getSimpleDataTypes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSchemaLocation(), builder.getSchemaLocation())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getFileHeader(), builder.getFileHeader())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getBody(), builder.getBody());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes(), this.getSchemaLocation(), this.getFileHeader(), this.getBody());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Namespaces.equals(fieldSpecification)) {
                return this.getNamespaces();
            }
            if (Fields.StructureDataTypes.equals(fieldSpecification)) {
                return this.getStructureDataTypes();
            }
            if (Fields.EnumDataTypes.equals(fieldSpecification)) {
                return this.getEnumDataTypes();
            }
            if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
                return this.getSimpleDataTypes();
            }
            if (Fields.SchemaLocation.equals(fieldSpecification)) {
                return this.getSchemaLocation();
            }
            if (Fields.FileHeader.equals(fieldSpecification)) {
                return this.getFileHeader();
            }
            if (Fields.Body.equals(fieldSpecification)) {
                return this.getBody();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Namespaces.equals(fieldSpecification)) {
                this.setNamespaces((String[])object);
                return this;
            }
            if (Fields.StructureDataTypes.equals(fieldSpecification)) {
                this.setStructureDataTypes((StructureDescription[])object);
                return this;
            }
            if (Fields.EnumDataTypes.equals(fieldSpecification)) {
                this.setEnumDataTypes((EnumDescription[])object);
                return this;
            }
            if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
                this.setSimpleDataTypes((SimpleTypeDescription[])object);
                return this;
            }
            if (Fields.SchemaLocation.equals(fieldSpecification)) {
                this.setSchemaLocation((String)object);
                return this;
            }
            if (Fields.FileHeader.equals(fieldSpecification)) {
                this.setFileHeader((KeyValuePair[])object);
                return this;
            }
            if (Fields.Body.equals(fieldSpecification)) {
                this.setBody(object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_schemaLocation = null;
            this.f_fileHeader = null;
            this.f_body = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public UABinaryFileDataType build() {
            return new UABinaryFileDataType(this.f_namespaces, this.f_structureDataTypes, this.f_enumDataTypes, this.f_simpleDataTypes, this.f_schemaLocation, this.f_fileHeader, this.f_body);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Namespaces("Namespaces", String[].class, false, UaIds.String, 1, UaArrayDimensions.valueOf(0L), false),
        StructureDataTypes("StructureDataTypes", StructureDescription[].class, false, UaIds.StructureDescription, 1, UaArrayDimensions.valueOf(0L), false),
        EnumDataTypes("EnumDataTypes", EnumDescription[].class, false, UaIds.EnumDescription, 1, UaArrayDimensions.valueOf(0L), false),
        SimpleDataTypes("SimpleDataTypes", SimpleTypeDescription[].class, false, UaIds.SimpleTypeDescription, 1, UaArrayDimensions.valueOf(0L), false),
        SchemaLocation("SchemaLocation", String.class, false, UaIds.String, -1, null, false),
        FileHeader("FileHeader", KeyValuePair[].class, false, UaIds.KeyValuePair, 1, UaArrayDimensions.valueOf(0L), false),
        Body("Body", Object.class, false, UaIds.BaseDataType, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

