/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12554")
public class TrustListDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.TrustListDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.TrustListDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.TrustListDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.TrustListDataType;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger f_specifiedLists;
    private ByteString[] f_trustedCertificates;
    private ByteString[] f_trustedCrls;
    private ByteString[] f_issuerCertificates;
    private ByteString[] f_issuerCrls;

    public TrustListDataType() {
    }

    public TrustListDataType(UnsignedInteger unsignedInteger, ByteString[] byteStringArray, ByteString[] byteStringArray2, ByteString[] byteStringArray3, ByteString[] byteStringArray4) {
        this.f_specifiedLists = unsignedInteger;
        this.f_trustedCertificates = byteStringArray;
        this.f_trustedCrls = byteStringArray2;
        this.f_issuerCertificates = byteStringArray3;
        this.f_issuerCrls = byteStringArray4;
    }

    public UnsignedInteger getSpecifiedLists() {
        return this.f_specifiedLists;
    }

    public void setSpecifiedLists(UnsignedInteger unsignedInteger) {
        this.f_specifiedLists = unsignedInteger;
    }

    public ByteString[] getTrustedCertificates() {
        return this.f_trustedCertificates;
    }

    public void setTrustedCertificates(ByteString[] byteStringArray) {
        this.f_trustedCertificates = byteStringArray;
    }

    public ByteString[] getTrustedCrls() {
        return this.f_trustedCrls;
    }

    public void setTrustedCrls(ByteString[] byteStringArray) {
        this.f_trustedCrls = byteStringArray;
    }

    public ByteString[] getIssuerCertificates() {
        return this.f_issuerCertificates;
    }

    public void setIssuerCertificates(ByteString[] byteStringArray) {
        this.f_issuerCertificates = byteStringArray;
    }

    public ByteString[] getIssuerCrls() {
        return this.f_issuerCrls;
    }

    public void setIssuerCrls(ByteString[] byteStringArray) {
        this.f_issuerCrls = byteStringArray;
    }

    @Override
    public TrustListDataType clone() {
        TrustListDataType trustListDataType = (TrustListDataType)super.clone();
        trustListDataType.f_specifiedLists = StructureUtils.clone(this.f_specifiedLists);
        trustListDataType.f_trustedCertificates = StructureUtils.clone(this.f_trustedCertificates);
        trustListDataType.f_trustedCrls = StructureUtils.clone(this.f_trustedCrls);
        trustListDataType.f_issuerCertificates = StructureUtils.clone(this.f_issuerCertificates);
        trustListDataType.f_issuerCrls = StructureUtils.clone(this.f_issuerCrls);
        return trustListDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TrustListDataType trustListDataType = (TrustListDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedLists(), trustListDataType.getSpecifiedLists())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTrustedCertificates(), trustListDataType.getTrustedCertificates())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTrustedCrls(), trustListDataType.getTrustedCrls())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIssuerCertificates(), trustListDataType.getIssuerCertificates())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIssuerCrls(), trustListDataType.getIssuerCrls());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getSpecifiedLists(), this.getTrustedCertificates(), this.getTrustedCrls(), this.getIssuerCertificates(), this.getIssuerCrls());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_specifiedLists = null;
        this.f_trustedCertificates = null;
        this.f_trustedCrls = null;
        this.f_issuerCertificates = null;
        this.f_issuerCrls = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.SpecifiedLists, this.getSpecifiedLists());
        linkedHashMap.put(Fields.TrustedCertificates, this.getTrustedCertificates());
        linkedHashMap.put(Fields.TrustedCrls, this.getTrustedCrls());
        linkedHashMap.put(Fields.IssuerCertificates, this.getIssuerCertificates());
        linkedHashMap.put(Fields.IssuerCrls, this.getIssuerCrls());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SpecifiedLists.equals(fieldSpecification)) {
            return this.getSpecifiedLists();
        }
        if (Fields.TrustedCertificates.equals(fieldSpecification)) {
            return this.getTrustedCertificates();
        }
        if (Fields.TrustedCrls.equals(fieldSpecification)) {
            return this.getTrustedCrls();
        }
        if (Fields.IssuerCertificates.equals(fieldSpecification)) {
            return this.getIssuerCertificates();
        }
        if (Fields.IssuerCrls.equals(fieldSpecification)) {
            return this.getIssuerCrls();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SpecifiedLists.equals(fieldSpecification)) {
            this.setSpecifiedLists((UnsignedInteger)object);
            return;
        }
        if (Fields.TrustedCertificates.equals(fieldSpecification)) {
            this.setTrustedCertificates((ByteString[])object);
            return;
        }
        if (Fields.TrustedCrls.equals(fieldSpecification)) {
            this.setTrustedCrls((ByteString[])object);
            return;
        }
        if (Fields.IssuerCertificates.equals(fieldSpecification)) {
            this.setIssuerCertificates((ByteString[])object);
            return;
        }
        if (Fields.IssuerCrls.equals(fieldSpecification)) {
            this.setIssuerCrls((ByteString[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = TrustListDataType.builder();
        builder.setSpecifiedLists(StructureUtils.clone(this.getSpecifiedLists()));
        builder.setTrustedCertificates(StructureUtils.clone(this.getTrustedCertificates()));
        builder.setTrustedCrls(StructureUtils.clone(this.getTrustedCrls()));
        builder.setIssuerCertificates(StructureUtils.clone(this.getIssuerCertificates()));
        builder.setIssuerCrls(StructureUtils.clone(this.getIssuerCrls()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.SpecifiedLists);
        builder.addField(Fields.TrustedCertificates);
        builder.addField(Fields.TrustedCrls);
        builder.addField(Fields.IssuerCertificates);
        builder.addField(Fields.IssuerCrls);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("TrustListDataType");
        builder.setJavaClass(TrustListDataType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger f_specifiedLists;
        private ByteString[] f_trustedCertificates;
        private ByteString[] f_trustedCrls;
        private ByteString[] f_issuerCertificates;
        private ByteString[] f_issuerCrls;

        protected Builder() {
        }

        public UnsignedInteger getSpecifiedLists() {
            return this.f_specifiedLists;
        }

        public Builder setSpecifiedLists(UnsignedInteger unsignedInteger) {
            this.f_specifiedLists = unsignedInteger;
            return this;
        }

        public ByteString[] getTrustedCertificates() {
            return this.f_trustedCertificates;
        }

        public Builder setTrustedCertificates(ByteString[] byteStringArray) {
            this.f_trustedCertificates = byteStringArray;
            return this;
        }

        public ByteString[] getTrustedCrls() {
            return this.f_trustedCrls;
        }

        public Builder setTrustedCrls(ByteString[] byteStringArray) {
            this.f_trustedCrls = byteStringArray;
            return this;
        }

        public ByteString[] getIssuerCertificates() {
            return this.f_issuerCertificates;
        }

        public Builder setIssuerCertificates(ByteString[] byteStringArray) {
            this.f_issuerCertificates = byteStringArray;
            return this;
        }

        public ByteString[] getIssuerCrls() {
            return this.f_issuerCrls;
        }

        public Builder setIssuerCrls(ByteString[] byteStringArray) {
            this.f_issuerCrls = byteStringArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedLists(), builder.getSpecifiedLists())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getTrustedCertificates(), builder.getTrustedCertificates())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getTrustedCrls(), builder.getTrustedCrls())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getIssuerCertificates(), builder.getIssuerCertificates())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getIssuerCrls(), builder.getIssuerCrls());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getSpecifiedLists(), this.getTrustedCertificates(), this.getTrustedCrls(), this.getIssuerCertificates(), this.getIssuerCrls());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.SpecifiedLists.equals(fieldSpecification)) {
                return this.getSpecifiedLists();
            }
            if (Fields.TrustedCertificates.equals(fieldSpecification)) {
                return this.getTrustedCertificates();
            }
            if (Fields.TrustedCrls.equals(fieldSpecification)) {
                return this.getTrustedCrls();
            }
            if (Fields.IssuerCertificates.equals(fieldSpecification)) {
                return this.getIssuerCertificates();
            }
            if (Fields.IssuerCrls.equals(fieldSpecification)) {
                return this.getIssuerCrls();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SpecifiedLists.equals(fieldSpecification)) {
                this.setSpecifiedLists((UnsignedInteger)object);
                return this;
            }
            if (Fields.TrustedCertificates.equals(fieldSpecification)) {
                this.setTrustedCertificates((ByteString[])object);
                return this;
            }
            if (Fields.TrustedCrls.equals(fieldSpecification)) {
                this.setTrustedCrls((ByteString[])object);
                return this;
            }
            if (Fields.IssuerCertificates.equals(fieldSpecification)) {
                this.setIssuerCertificates((ByteString[])object);
                return this;
            }
            if (Fields.IssuerCrls.equals(fieldSpecification)) {
                this.setIssuerCrls((ByteString[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_specifiedLists = null;
            this.f_trustedCertificates = null;
            this.f_trustedCrls = null;
            this.f_issuerCertificates = null;
            this.f_issuerCrls = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public TrustListDataType build() {
            return new TrustListDataType(this.f_specifiedLists, this.f_trustedCertificates, this.f_trustedCrls, this.f_issuerCertificates, this.f_issuerCrls);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        SpecifiedLists("SpecifiedLists", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        TrustedCertificates("TrustedCertificates", ByteString[].class, false, UaIds.ByteString, 1, UaArrayDimensions.valueOf(0L), false),
        TrustedCrls("TrustedCrls", ByteString[].class, false, UaIds.ByteString, 1, UaArrayDimensions.valueOf(0L), false),
        IssuerCertificates("IssuerCertificates", ByteString[].class, false, UaIds.ByteString, 1, UaArrayDimensions.valueOf(0L), false),
        IssuerCrls("IssuerCrls", ByteString[].class, false, UaIds.ByteString, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

