/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=839")
public class TransferSubscriptionsRequest
extends AbstractStructure
implements ServiceRequest<TransferSubscriptionsResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.TransferSubscriptionsRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.TransferSubscriptionsRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.TransferSubscriptionsRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.TransferSubscriptionsRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader f_requestHeader;
    private UnsignedInteger[] f_subscriptionIds;
    private Boolean f_sendInitialValues;

    public TransferSubscriptionsRequest() {
    }

    public TransferSubscriptionsRequest(RequestHeader requestHeader, UnsignedInteger[] unsignedIntegerArray, Boolean bl) {
        this.f_requestHeader = requestHeader;
        this.f_subscriptionIds = unsignedIntegerArray;
        this.f_sendInitialValues = bl;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.f_requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.f_requestHeader = requestHeader;
    }

    public UnsignedInteger[] getSubscriptionIds() {
        return this.f_subscriptionIds;
    }

    public void setSubscriptionIds(UnsignedInteger[] unsignedIntegerArray) {
        this.f_subscriptionIds = unsignedIntegerArray;
    }

    public Boolean getSendInitialValues() {
        return this.f_sendInitialValues;
    }

    public void setSendInitialValues(Boolean bl) {
        this.f_sendInitialValues = bl;
    }

    @Override
    public TransferSubscriptionsRequest clone() {
        TransferSubscriptionsRequest transferSubscriptionsRequest = (TransferSubscriptionsRequest)super.clone();
        transferSubscriptionsRequest.f_requestHeader = StructureUtils.clone(this.f_requestHeader);
        transferSubscriptionsRequest.f_subscriptionIds = StructureUtils.clone(this.f_subscriptionIds);
        transferSubscriptionsRequest.f_sendInitialValues = StructureUtils.clone(this.f_sendInitialValues);
        return transferSubscriptionsRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferSubscriptionsRequest transferSubscriptionsRequest = (TransferSubscriptionsRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), transferSubscriptionsRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSubscriptionIds(), transferSubscriptionsRequest.getSubscriptionIds())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSendInitialValues(), transferSubscriptionsRequest.getSendInitialValues());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getSubscriptionIds(), this.getSendInitialValues());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_requestHeader = null;
        this.f_subscriptionIds = null;
        this.f_sendInitialValues = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.RequestHeader, this.getRequestHeader());
        linkedHashMap.put(Fields.SubscriptionIds, this.getSubscriptionIds());
        linkedHashMap.put(Fields.SendInitialValues, this.getSendInitialValues());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.SubscriptionIds.equals(fieldSpecification)) {
            return this.getSubscriptionIds();
        }
        if (Fields.SendInitialValues.equals(fieldSpecification)) {
            return this.getSendInitialValues();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.SubscriptionIds.equals(fieldSpecification)) {
            this.setSubscriptionIds((UnsignedInteger[])object);
            return;
        }
        if (Fields.SendInitialValues.equals(fieldSpecification)) {
            this.setSendInitialValues((Boolean)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = TransferSubscriptionsRequest.builder();
        builder.setRequestHeader(StructureUtils.clone(this.getRequestHeader()));
        builder.setSubscriptionIds(StructureUtils.clone(this.getSubscriptionIds()));
        builder.setSendInitialValues(StructureUtils.clone(this.getSendInitialValues()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader);
        builder.addField(Fields.SubscriptionIds);
        builder.addField(Fields.SendInitialValues);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("TransferSubscriptionsRequest");
        builder.setJavaClass(TransferSubscriptionsRequest.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader f_requestHeader;
        private UnsignedInteger[] f_subscriptionIds;
        private Boolean f_sendInitialValues;

        protected Builder() {
        }

        public RequestHeader getRequestHeader() {
            return this.f_requestHeader;
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.f_requestHeader = requestHeader;
            return this;
        }

        public UnsignedInteger[] getSubscriptionIds() {
            return this.f_subscriptionIds;
        }

        public Builder setSubscriptionIds(UnsignedInteger[] unsignedIntegerArray) {
            this.f_subscriptionIds = unsignedIntegerArray;
            return this;
        }

        public Boolean getSendInitialValues() {
            return this.f_sendInitialValues;
        }

        public Builder setSendInitialValues(Boolean bl) {
            this.f_sendInitialValues = bl;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), builder.getRequestHeader())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSubscriptionIds(), builder.getSubscriptionIds())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getSendInitialValues(), builder.getSendInitialValues());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getRequestHeader(), this.getSubscriptionIds(), this.getSendInitialValues());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                return this.getRequestHeader();
            }
            if (Fields.SubscriptionIds.equals(fieldSpecification)) {
                return this.getSubscriptionIds();
            }
            if (Fields.SendInitialValues.equals(fieldSpecification)) {
                return this.getSendInitialValues();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.SubscriptionIds.equals(fieldSpecification)) {
                this.setSubscriptionIds((UnsignedInteger[])object);
                return this;
            }
            if (Fields.SendInitialValues.equals(fieldSpecification)) {
                this.setSendInitialValues((Boolean)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_requestHeader = null;
            this.f_subscriptionIds = null;
            this.f_sendInitialValues = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public TransferSubscriptionsRequest build() {
            return new TransferSubscriptionsRequest(this.f_requestHeader, this.f_subscriptionIds, this.f_sendInitialValues);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaIds.RequestHeader, -1, null, false),
        SubscriptionIds("SubscriptionIds", UnsignedInteger[].class, false, UaIds.IntegerId, 1, UaArrayDimensions.valueOf(0L), false),
        SendInitialValues("SendInitialValues", Boolean.class, false, UaIds.Boolean, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

