/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=98")
public enum StructureType implements Enumeration
{
    Structure(0),
    StructureWithOptionalFields(1),
    Union(2),
    StructureWithSubtypedValues(3),
    UnionWithSubtypedValues(4);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<StructureType> NONE;
    public static final EnumSet<StructureType> ALL;
    private static final Map<Integer, StructureType> map;
    private final int value;

    private StructureType(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static StructureType valueOf(int n2) {
        return map.get(n2);
    }

    public static StructureType valueOf(Integer n2) {
        return n2 == null ? null : StructureType.valueOf((int)n2);
    }

    public static StructureType valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : StructureType.valueOf(unsignedInteger.intValue());
    }

    public static StructureType[] valueOf(int[] nArray) {
        StructureType[] structureTypeArray = new StructureType[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            structureTypeArray[i2] = StructureType.valueOf(nArray[i2]);
        }
        return structureTypeArray;
    }

    public static StructureType[] valueOf(Integer[] integerArray) {
        StructureType[] structureTypeArray = new StructureType[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            structureTypeArray[i2] = StructureType.valueOf(integerArray[i2]);
        }
        return structureTypeArray;
    }

    public static StructureType[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        StructureType[] structureTypeArray = new StructureType[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            structureTypeArray[i2] = StructureType.valueOf(unsignedIntegerArray[i2]);
        }
        return structureTypeArray;
    }

    public static UnsignedInteger getMask(StructureType ... structureTypeArray) {
        int n2 = 0;
        for (StructureType structureType : structureTypeArray) {
            n2 |= structureType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<StructureType> collection) {
        int n2 = 0;
        for (StructureType structureType : collection) {
            n2 |= structureType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<StructureType> getSet(UnsignedInteger unsignedInteger) {
        return StructureType.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<StructureType> getSet(int n2) {
        ArrayList<StructureType> arrayList = new ArrayList<StructureType>();
        for (StructureType structureType : StructureType.values()) {
            if ((n2 & structureType.value) != structureType.value) continue;
            arrayList.add(structureType);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = StructureType.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(StructureType.class);
        ALL = EnumSet.allOf(StructureType.class);
        map = new HashMap<Integer, StructureType>();
        for (StructureType structureType : StructureType.values()) {
            map.put(structureType.value, structureType);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("StructureType");
        builder.setJavaClass(StructureType.class);
        builder.setTypeId(UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=98")));
        builder.addMapping(0, "Structure");
        builder.addMapping(1, "StructureWithOptionalFields");
        builder.addMapping(2, "Union");
        builder.addMapping(3, "StructureWithSubtypedValues");
        builder.addMapping(4, "UnionWithSubtypedValues");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return StructureType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    implements Enumeration.Builder {
        private StructureType value;

        private Builder() {
        }

        @Override
        public StructureType build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = StructureType.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum StructureType int value: " + n2);
            }
            return this;
        }
    }
}

