/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.core.StructureType;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=99")
public class StructureDefinition
extends DataTypeDefinition {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.StructureDefinition_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.StructureDefinition_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.StructureDefinition_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.StructureDefinition;
    public static final StructureSpecification SPECIFICATION;
    private NodeId f_defaultEncodingId;
    private NodeId f_baseDataType;
    private StructureType f_structureType;
    private StructureField[] f_fields;

    public StructureDefinition() {
    }

    public StructureDefinition(NodeId nodeId, NodeId nodeId2, StructureType structureType, StructureField[] structureFieldArray) {
        this.f_defaultEncodingId = nodeId;
        this.f_baseDataType = nodeId2;
        this.f_structureType = structureType;
        this.f_fields = structureFieldArray;
    }

    public NodeId getDefaultEncodingId() {
        return this.f_defaultEncodingId;
    }

    public void setDefaultEncodingId(NodeId nodeId) {
        this.f_defaultEncodingId = nodeId;
    }

    public NodeId getBaseDataType() {
        return this.f_baseDataType;
    }

    public void setBaseDataType(NodeId nodeId) {
        this.f_baseDataType = nodeId;
    }

    public StructureType getStructureType() {
        return this.f_structureType;
    }

    public void setStructureType(StructureType structureType) {
        this.f_structureType = structureType;
    }

    public StructureField[] getFields() {
        return this.f_fields;
    }

    public void setFields(StructureField[] structureFieldArray) {
        this.f_fields = structureFieldArray;
    }

    @Override
    public StructureDefinition clone() {
        StructureDefinition structureDefinition = (StructureDefinition)super.clone();
        structureDefinition.f_defaultEncodingId = StructureUtils.clone(this.f_defaultEncodingId);
        structureDefinition.f_baseDataType = StructureUtils.clone(this.f_baseDataType);
        structureDefinition.f_structureType = StructureUtils.clone(this.f_structureType);
        structureDefinition.f_fields = StructureUtils.clone(this.f_fields);
        return structureDefinition;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StructureDefinition structureDefinition = (StructureDefinition)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getDefaultEncodingId(), structureDefinition.getDefaultEncodingId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBaseDataType(), structureDefinition.getBaseDataType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStructureType(), structureDefinition.getStructureType())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFields(), structureDefinition.getFields());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getDefaultEncodingId(), this.getBaseDataType(), this.getStructureType(), this.getFields());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_defaultEncodingId = null;
        this.f_baseDataType = null;
        this.f_structureType = null;
        this.f_fields = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.DefaultEncodingId, this.getDefaultEncodingId());
        linkedHashMap.put(Fields.BaseDataType, this.getBaseDataType());
        linkedHashMap.put(Fields.StructureType, this.getStructureType());
        linkedHashMap.put(Fields.Fields, this.getFields());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DefaultEncodingId.equals(fieldSpecification)) {
            return this.getDefaultEncodingId();
        }
        if (Fields.BaseDataType.equals(fieldSpecification)) {
            return this.getBaseDataType();
        }
        if (Fields.StructureType.equals(fieldSpecification)) {
            return this.getStructureType();
        }
        if (Fields.Fields.equals(fieldSpecification)) {
            return this.getFields();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DefaultEncodingId.equals(fieldSpecification)) {
            this.setDefaultEncodingId((NodeId)object);
            return;
        }
        if (Fields.BaseDataType.equals(fieldSpecification)) {
            this.setBaseDataType((NodeId)object);
            return;
        }
        if (Fields.StructureType.equals(fieldSpecification)) {
            this.setStructureType((StructureType)object);
            return;
        }
        if (Fields.Fields.equals(fieldSpecification)) {
            this.setFields((StructureField[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = StructureDefinition.builder();
        builder.setDefaultEncodingId(StructureUtils.clone(this.getDefaultEncodingId()));
        builder.setBaseDataType(StructureUtils.clone(this.getBaseDataType()));
        builder.setStructureType(StructureUtils.clone(this.getStructureType()));
        builder.setFields(StructureUtils.clone(this.getFields()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.DefaultEncodingId);
        builder.addField(Fields.BaseDataType);
        builder.addField(Fields.StructureType);
        builder.addField(Fields.Fields);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.DataTypeDefinition);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("StructureDefinition");
        builder.setJavaClass(StructureDefinition.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeDefinition.Builder {
        private NodeId f_defaultEncodingId;
        private NodeId f_baseDataType;
        private StructureType f_structureType;
        private StructureField[] f_fields;

        protected Builder() {
        }

        public NodeId getDefaultEncodingId() {
            return this.f_defaultEncodingId;
        }

        public Builder setDefaultEncodingId(NodeId nodeId) {
            this.f_defaultEncodingId = nodeId;
            return this;
        }

        public NodeId getBaseDataType() {
            return this.f_baseDataType;
        }

        public Builder setBaseDataType(NodeId nodeId) {
            this.f_baseDataType = nodeId;
            return this;
        }

        public StructureType getStructureType() {
            return this.f_structureType;
        }

        public Builder setStructureType(StructureType structureType) {
            this.f_structureType = structureType;
            return this;
        }

        public StructureField[] getFields() {
            return this.f_fields;
        }

        public Builder setFields(StructureField[] structureFieldArray) {
            this.f_fields = structureFieldArray;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getDefaultEncodingId(), builder.getDefaultEncodingId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getBaseDataType(), builder.getBaseDataType())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getStructureType(), builder.getStructureType())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getFields(), builder.getFields());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getDefaultEncodingId(), this.getBaseDataType(), this.getStructureType(), this.getFields());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.DefaultEncodingId.equals(fieldSpecification)) {
                return this.getDefaultEncodingId();
            }
            if (Fields.BaseDataType.equals(fieldSpecification)) {
                return this.getBaseDataType();
            }
            if (Fields.StructureType.equals(fieldSpecification)) {
                return this.getStructureType();
            }
            if (Fields.Fields.equals(fieldSpecification)) {
                return this.getFields();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DefaultEncodingId.equals(fieldSpecification)) {
                this.setDefaultEncodingId((NodeId)object);
                return this;
            }
            if (Fields.BaseDataType.equals(fieldSpecification)) {
                this.setBaseDataType((NodeId)object);
                return this;
            }
            if (Fields.StructureType.equals(fieldSpecification)) {
                this.setStructureType((StructureType)object);
                return this;
            }
            if (Fields.Fields.equals(fieldSpecification)) {
                this.setFields((StructureField[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_defaultEncodingId = null;
            this.f_baseDataType = null;
            this.f_structureType = null;
            this.f_fields = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public StructureDefinition build() {
            return new StructureDefinition(this.f_defaultEncodingId, this.f_baseDataType, this.f_structureType, this.f_fields);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        DefaultEncodingId("DefaultEncodingId", NodeId.class, false, UaIds.NodeId, -1, null, false),
        BaseDataType("BaseDataType", NodeId.class, false, UaIds.NodeId, -1, null, false),
        StructureType("StructureType", StructureType.class, false, UaIds.StructureType, -1, null, false),
        Fields("Fields", StructureField[].class, false, UaIds.StructureField, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

