/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=299")
public class StatusResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.StatusResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.StatusResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.StatusResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.StatusResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode f_statusCode;
    private DiagnosticInfo f_diagnosticInfo;

    public StatusResult() {
    }

    public StatusResult(StatusCode statusCode, DiagnosticInfo diagnosticInfo) {
        this.f_statusCode = statusCode;
        this.f_diagnosticInfo = diagnosticInfo;
    }

    public StatusCode getStatusCode() {
        return this.f_statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.f_statusCode = statusCode;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.f_diagnosticInfo;
    }

    public void setDiagnosticInfo(DiagnosticInfo diagnosticInfo) {
        this.f_diagnosticInfo = diagnosticInfo;
    }

    @Override
    public StatusResult clone() {
        StatusResult statusResult = (StatusResult)super.clone();
        statusResult.f_statusCode = StructureUtils.clone(this.f_statusCode);
        statusResult.f_diagnosticInfo = StructureUtils.clone(this.f_diagnosticInfo);
        return statusResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StatusResult statusResult = (StatusResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), statusResult.getStatusCode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiagnosticInfo(), statusResult.getDiagnosticInfo());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getDiagnosticInfo());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_statusCode = null;
        this.f_diagnosticInfo = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.StatusCode, this.getStatusCode());
        linkedHashMap.put(Fields.DiagnosticInfo, this.getDiagnosticInfo());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.DiagnosticInfo.equals(fieldSpecification)) {
            return this.getDiagnosticInfo();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.DiagnosticInfo.equals(fieldSpecification)) {
            this.setDiagnosticInfo((DiagnosticInfo)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = StatusResult.builder();
        builder.setStatusCode(StructureUtils.clone(this.getStatusCode()));
        builder.setDiagnosticInfo(StructureUtils.clone(this.getDiagnosticInfo()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode);
        builder.addField(Fields.DiagnosticInfo);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("StatusResult");
        builder.setJavaClass(StatusResult.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode f_statusCode;
        private DiagnosticInfo f_diagnosticInfo;

        protected Builder() {
        }

        public StatusCode getStatusCode() {
            return this.f_statusCode;
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.f_statusCode = statusCode;
            return this;
        }

        public DiagnosticInfo getDiagnosticInfo() {
            return this.f_diagnosticInfo;
        }

        public Builder setDiagnosticInfo(DiagnosticInfo diagnosticInfo) {
            this.f_diagnosticInfo = diagnosticInfo;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), builder.getStatusCode())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getDiagnosticInfo(), builder.getDiagnosticInfo());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getStatusCode(), this.getDiagnosticInfo());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.StatusCode.equals(fieldSpecification)) {
                return this.getStatusCode();
            }
            if (Fields.DiagnosticInfo.equals(fieldSpecification)) {
                return this.getDiagnosticInfo();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.DiagnosticInfo.equals(fieldSpecification)) {
                this.setDiagnosticInfo((DiagnosticInfo)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_statusCode = null;
            this.f_diagnosticInfo = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public StatusResult build() {
            return new StatusResult(this.f_statusCode, this.f_diagnosticInfo);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        StatusCode("StatusCode", StatusCode.class, false, UaIds.StatusCode, -1, null, false),
        DiagnosticInfo("DiagnosticInfo", DiagnosticInfo.class, false, UaIds.DiagnosticInfo, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

