/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=456")
public class SignatureData
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.SignatureData_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.SignatureData_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.SignatureData_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.SignatureData;
    public static final StructureSpecification SPECIFICATION;
    private String f_algorithm;
    private ByteString f_signature;

    public SignatureData() {
    }

    public SignatureData(String string, ByteString byteString) {
        this.f_algorithm = string;
        this.f_signature = byteString;
    }

    public String getAlgorithm() {
        return this.f_algorithm;
    }

    public void setAlgorithm(String string) {
        this.f_algorithm = string;
    }

    public ByteString getSignature() {
        return this.f_signature;
    }

    public void setSignature(ByteString byteString) {
        this.f_signature = byteString;
    }

    @Override
    public SignatureData clone() {
        SignatureData signatureData = (SignatureData)super.clone();
        signatureData.f_algorithm = StructureUtils.clone(this.f_algorithm);
        signatureData.f_signature = StructureUtils.clone(this.f_signature);
        return signatureData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SignatureData signatureData = (SignatureData)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getAlgorithm(), signatureData.getAlgorithm())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSignature(), signatureData.getSignature());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getAlgorithm(), this.getSignature());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_algorithm = null;
        this.f_signature = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Algorithm, this.getAlgorithm());
        linkedHashMap.put(Fields.Signature, this.getSignature());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Algorithm.equals(fieldSpecification)) {
            return this.getAlgorithm();
        }
        if (Fields.Signature.equals(fieldSpecification)) {
            return this.getSignature();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Algorithm.equals(fieldSpecification)) {
            this.setAlgorithm((String)object);
            return;
        }
        if (Fields.Signature.equals(fieldSpecification)) {
            this.setSignature((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = SignatureData.builder();
        builder.setAlgorithm(StructureUtils.clone(this.getAlgorithm()));
        builder.setSignature(StructureUtils.clone(this.getSignature()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Algorithm);
        builder.addField(Fields.Signature);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("SignatureData");
        builder.setJavaClass(SignatureData.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String f_algorithm;
        private ByteString f_signature;

        protected Builder() {
        }

        public String getAlgorithm() {
            return this.f_algorithm;
        }

        public Builder setAlgorithm(String string) {
            this.f_algorithm = string;
            return this;
        }

        public ByteString getSignature() {
            return this.f_signature;
        }

        public Builder setSignature(ByteString byteString) {
            this.f_signature = byteString;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getAlgorithm(), builder.getAlgorithm())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getSignature(), builder.getSignature());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getAlgorithm(), this.getSignature());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Algorithm.equals(fieldSpecification)) {
                return this.getAlgorithm();
            }
            if (Fields.Signature.equals(fieldSpecification)) {
                return this.getSignature();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Algorithm.equals(fieldSpecification)) {
                this.setAlgorithm((String)object);
                return this;
            }
            if (Fields.Signature.equals(fieldSpecification)) {
                this.setSignature((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_algorithm = null;
            this.f_signature = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public SignatureData build() {
            return new SignatureData(this.f_algorithm, this.f_signature);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Algorithm("Algorithm", String.class, false, UaIds.String, -1, null, false),
        Signature("Signature", ByteString.class, false, UaIds.ByteString, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

