/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=862")
public class ServerStatusDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ServerStatusDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ServerStatusDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ServerStatusDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ServerStatusDataType;
    public static final StructureSpecification SPECIFICATION;
    private DateTime f_startTime;
    private DateTime f_currentTime;
    private ServerState f_state;
    private BuildInfo f_buildInfo;
    private UnsignedInteger f_secondsTillShutdown;
    private LocalizedText f_shutdownReason;

    public ServerStatusDataType() {
    }

    public ServerStatusDataType(DateTime dateTime, DateTime dateTime2, ServerState serverState, BuildInfo buildInfo, UnsignedInteger unsignedInteger, LocalizedText localizedText) {
        this.f_startTime = dateTime;
        this.f_currentTime = dateTime2;
        this.f_state = serverState;
        this.f_buildInfo = buildInfo;
        this.f_secondsTillShutdown = unsignedInteger;
        this.f_shutdownReason = localizedText;
    }

    public DateTime getStartTime() {
        return this.f_startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.f_startTime = dateTime;
    }

    public DateTime getCurrentTime() {
        return this.f_currentTime;
    }

    public void setCurrentTime(DateTime dateTime) {
        this.f_currentTime = dateTime;
    }

    public ServerState getState() {
        return this.f_state;
    }

    public void setState(ServerState serverState) {
        this.f_state = serverState;
    }

    public BuildInfo getBuildInfo() {
        return this.f_buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.f_buildInfo = buildInfo;
    }

    public UnsignedInteger getSecondsTillShutdown() {
        return this.f_secondsTillShutdown;
    }

    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
        this.f_secondsTillShutdown = unsignedInteger;
    }

    public LocalizedText getShutdownReason() {
        return this.f_shutdownReason;
    }

    public void setShutdownReason(LocalizedText localizedText) {
        this.f_shutdownReason = localizedText;
    }

    @Override
    public ServerStatusDataType clone() {
        ServerStatusDataType serverStatusDataType = (ServerStatusDataType)super.clone();
        serverStatusDataType.f_startTime = StructureUtils.clone(this.f_startTime);
        serverStatusDataType.f_currentTime = StructureUtils.clone(this.f_currentTime);
        serverStatusDataType.f_state = StructureUtils.clone(this.f_state);
        serverStatusDataType.f_buildInfo = StructureUtils.clone(this.f_buildInfo);
        serverStatusDataType.f_secondsTillShutdown = StructureUtils.clone(this.f_secondsTillShutdown);
        serverStatusDataType.f_shutdownReason = StructureUtils.clone(this.f_shutdownReason);
        return serverStatusDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServerStatusDataType serverStatusDataType = (ServerStatusDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), serverStatusDataType.getStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getCurrentTime(), serverStatusDataType.getCurrentTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getState(), serverStatusDataType.getState())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBuildInfo(), serverStatusDataType.getBuildInfo())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecondsTillShutdown(), serverStatusDataType.getSecondsTillShutdown())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getShutdownReason(), serverStatusDataType.getShutdownReason());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStartTime(), this.getCurrentTime(), this.getState(), this.getBuildInfo(), this.getSecondsTillShutdown(), this.getShutdownReason());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_startTime = null;
        this.f_currentTime = null;
        this.f_state = null;
        this.f_buildInfo = null;
        this.f_secondsTillShutdown = null;
        this.f_shutdownReason = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.StartTime, this.getStartTime());
        linkedHashMap.put(Fields.CurrentTime, this.getCurrentTime());
        linkedHashMap.put(Fields.State, this.getState());
        linkedHashMap.put(Fields.BuildInfo, this.getBuildInfo());
        linkedHashMap.put(Fields.SecondsTillShutdown, this.getSecondsTillShutdown());
        linkedHashMap.put(Fields.ShutdownReason, this.getShutdownReason());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StartTime.equals(fieldSpecification)) {
            return this.getStartTime();
        }
        if (Fields.CurrentTime.equals(fieldSpecification)) {
            return this.getCurrentTime();
        }
        if (Fields.State.equals(fieldSpecification)) {
            return this.getState();
        }
        if (Fields.BuildInfo.equals(fieldSpecification)) {
            return this.getBuildInfo();
        }
        if (Fields.SecondsTillShutdown.equals(fieldSpecification)) {
            return this.getSecondsTillShutdown();
        }
        if (Fields.ShutdownReason.equals(fieldSpecification)) {
            return this.getShutdownReason();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StartTime.equals(fieldSpecification)) {
            this.setStartTime((DateTime)object);
            return;
        }
        if (Fields.CurrentTime.equals(fieldSpecification)) {
            this.setCurrentTime((DateTime)object);
            return;
        }
        if (Fields.State.equals(fieldSpecification)) {
            this.setState((ServerState)object);
            return;
        }
        if (Fields.BuildInfo.equals(fieldSpecification)) {
            this.setBuildInfo((BuildInfo)object);
            return;
        }
        if (Fields.SecondsTillShutdown.equals(fieldSpecification)) {
            this.setSecondsTillShutdown((UnsignedInteger)object);
            return;
        }
        if (Fields.ShutdownReason.equals(fieldSpecification)) {
            this.setShutdownReason((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ServerStatusDataType.builder();
        builder.setStartTime(StructureUtils.clone(this.getStartTime()));
        builder.setCurrentTime(StructureUtils.clone(this.getCurrentTime()));
        builder.setState(StructureUtils.clone(this.getState()));
        builder.setBuildInfo(StructureUtils.clone(this.getBuildInfo()));
        builder.setSecondsTillShutdown(StructureUtils.clone(this.getSecondsTillShutdown()));
        builder.setShutdownReason(StructureUtils.clone(this.getShutdownReason()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.StartTime);
        builder.addField(Fields.CurrentTime);
        builder.addField(Fields.State);
        builder.addField(Fields.BuildInfo);
        builder.addField(Fields.SecondsTillShutdown);
        builder.addField(Fields.ShutdownReason);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ServerStatusDataType");
        builder.setJavaClass(ServerStatusDataType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private DateTime f_startTime;
        private DateTime f_currentTime;
        private ServerState f_state;
        private BuildInfo f_buildInfo;
        private UnsignedInteger f_secondsTillShutdown;
        private LocalizedText f_shutdownReason;

        protected Builder() {
        }

        public DateTime getStartTime() {
            return this.f_startTime;
        }

        public Builder setStartTime(DateTime dateTime) {
            this.f_startTime = dateTime;
            return this;
        }

        public DateTime getCurrentTime() {
            return this.f_currentTime;
        }

        public Builder setCurrentTime(DateTime dateTime) {
            this.f_currentTime = dateTime;
            return this;
        }

        public ServerState getState() {
            return this.f_state;
        }

        public Builder setState(ServerState serverState) {
            this.f_state = serverState;
            return this;
        }

        public BuildInfo getBuildInfo() {
            return this.f_buildInfo;
        }

        public Builder setBuildInfo(BuildInfo buildInfo) {
            this.f_buildInfo = buildInfo;
            return this;
        }

        public UnsignedInteger getSecondsTillShutdown() {
            return this.f_secondsTillShutdown;
        }

        public Builder setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
            this.f_secondsTillShutdown = unsignedInteger;
            return this;
        }

        public LocalizedText getShutdownReason() {
            return this.f_shutdownReason;
        }

        public Builder setShutdownReason(LocalizedText localizedText) {
            this.f_shutdownReason = localizedText;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), builder.getStartTime())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getCurrentTime(), builder.getCurrentTime())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getState(), builder.getState())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getBuildInfo(), builder.getBuildInfo())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecondsTillShutdown(), builder.getSecondsTillShutdown())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getShutdownReason(), builder.getShutdownReason());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getStartTime(), this.getCurrentTime(), this.getState(), this.getBuildInfo(), this.getSecondsTillShutdown(), this.getShutdownReason());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.StartTime.equals(fieldSpecification)) {
                return this.getStartTime();
            }
            if (Fields.CurrentTime.equals(fieldSpecification)) {
                return this.getCurrentTime();
            }
            if (Fields.State.equals(fieldSpecification)) {
                return this.getState();
            }
            if (Fields.BuildInfo.equals(fieldSpecification)) {
                return this.getBuildInfo();
            }
            if (Fields.SecondsTillShutdown.equals(fieldSpecification)) {
                return this.getSecondsTillShutdown();
            }
            if (Fields.ShutdownReason.equals(fieldSpecification)) {
                return this.getShutdownReason();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StartTime.equals(fieldSpecification)) {
                this.setStartTime((DateTime)object);
                return this;
            }
            if (Fields.CurrentTime.equals(fieldSpecification)) {
                this.setCurrentTime((DateTime)object);
                return this;
            }
            if (Fields.State.equals(fieldSpecification)) {
                this.setState((ServerState)object);
                return this;
            }
            if (Fields.BuildInfo.equals(fieldSpecification)) {
                this.setBuildInfo((BuildInfo)object);
                return this;
            }
            if (Fields.SecondsTillShutdown.equals(fieldSpecification)) {
                this.setSecondsTillShutdown((UnsignedInteger)object);
                return this;
            }
            if (Fields.ShutdownReason.equals(fieldSpecification)) {
                this.setShutdownReason((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_startTime = null;
            this.f_currentTime = null;
            this.f_state = null;
            this.f_buildInfo = null;
            this.f_secondsTillShutdown = null;
            this.f_shutdownReason = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ServerStatusDataType build() {
            return new ServerStatusDataType(this.f_startTime, this.f_currentTime, this.f_state, this.f_buildInfo, this.f_secondsTillShutdown, this.f_shutdownReason);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        StartTime("StartTime", DateTime.class, false, UaIds.UtcTime, -1, null, false),
        CurrentTime("CurrentTime", DateTime.class, false, UaIds.UtcTime, -1, null, false),
        State("State", ServerState.class, false, UaIds.ServerState, -1, null, false),
        BuildInfo("BuildInfo", BuildInfo.class, false, UaIds.BuildInfo, -1, null, false),
        SecondsTillShutdown("SecondsTillShutdown", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        ShutdownReason("ShutdownReason", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

