/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RepublishResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=830")
public class RepublishRequest
extends AbstractStructure
implements ServiceRequest<RepublishResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RepublishRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RepublishRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RepublishRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RepublishRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader f_requestHeader;
    private UnsignedInteger f_subscriptionId;
    private UnsignedInteger f_retransmitSequenceNumber;

    public RepublishRequest() {
    }

    public RepublishRequest(RequestHeader requestHeader, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        this.f_requestHeader = requestHeader;
        this.f_subscriptionId = unsignedInteger;
        this.f_retransmitSequenceNumber = unsignedInteger2;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.f_requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.f_requestHeader = requestHeader;
    }

    public UnsignedInteger getSubscriptionId() {
        return this.f_subscriptionId;
    }

    public void setSubscriptionId(UnsignedInteger unsignedInteger) {
        this.f_subscriptionId = unsignedInteger;
    }

    public UnsignedInteger getRetransmitSequenceNumber() {
        return this.f_retransmitSequenceNumber;
    }

    public void setRetransmitSequenceNumber(UnsignedInteger unsignedInteger) {
        this.f_retransmitSequenceNumber = unsignedInteger;
    }

    @Override
    public RepublishRequest clone() {
        RepublishRequest republishRequest = (RepublishRequest)super.clone();
        republishRequest.f_requestHeader = StructureUtils.clone(this.f_requestHeader);
        republishRequest.f_subscriptionId = StructureUtils.clone(this.f_subscriptionId);
        republishRequest.f_retransmitSequenceNumber = StructureUtils.clone(this.f_retransmitSequenceNumber);
        return republishRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RepublishRequest republishRequest = (RepublishRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), republishRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSubscriptionId(), republishRequest.getSubscriptionId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRetransmitSequenceNumber(), republishRequest.getRetransmitSequenceNumber());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getSubscriptionId(), this.getRetransmitSequenceNumber());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_requestHeader = null;
        this.f_subscriptionId = null;
        this.f_retransmitSequenceNumber = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.RequestHeader, this.getRequestHeader());
        linkedHashMap.put(Fields.SubscriptionId, this.getSubscriptionId());
        linkedHashMap.put(Fields.RetransmitSequenceNumber, this.getRetransmitSequenceNumber());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.SubscriptionId.equals(fieldSpecification)) {
            return this.getSubscriptionId();
        }
        if (Fields.RetransmitSequenceNumber.equals(fieldSpecification)) {
            return this.getRetransmitSequenceNumber();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.SubscriptionId.equals(fieldSpecification)) {
            this.setSubscriptionId((UnsignedInteger)object);
            return;
        }
        if (Fields.RetransmitSequenceNumber.equals(fieldSpecification)) {
            this.setRetransmitSequenceNumber((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RepublishRequest.builder();
        builder.setRequestHeader(StructureUtils.clone(this.getRequestHeader()));
        builder.setSubscriptionId(StructureUtils.clone(this.getSubscriptionId()));
        builder.setRetransmitSequenceNumber(StructureUtils.clone(this.getRetransmitSequenceNumber()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader);
        builder.addField(Fields.SubscriptionId);
        builder.addField(Fields.RetransmitSequenceNumber);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("RepublishRequest");
        builder.setJavaClass(RepublishRequest.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader f_requestHeader;
        private UnsignedInteger f_subscriptionId;
        private UnsignedInteger f_retransmitSequenceNumber;

        protected Builder() {
        }

        public RequestHeader getRequestHeader() {
            return this.f_requestHeader;
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.f_requestHeader = requestHeader;
            return this;
        }

        public UnsignedInteger getSubscriptionId() {
            return this.f_subscriptionId;
        }

        public Builder setSubscriptionId(UnsignedInteger unsignedInteger) {
            this.f_subscriptionId = unsignedInteger;
            return this;
        }

        public UnsignedInteger getRetransmitSequenceNumber() {
            return this.f_retransmitSequenceNumber;
        }

        public Builder setRetransmitSequenceNumber(UnsignedInteger unsignedInteger) {
            this.f_retransmitSequenceNumber = unsignedInteger;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), builder.getRequestHeader())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSubscriptionId(), builder.getSubscriptionId())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getRetransmitSequenceNumber(), builder.getRetransmitSequenceNumber());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getRequestHeader(), this.getSubscriptionId(), this.getRetransmitSequenceNumber());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                return this.getRequestHeader();
            }
            if (Fields.SubscriptionId.equals(fieldSpecification)) {
                return this.getSubscriptionId();
            }
            if (Fields.RetransmitSequenceNumber.equals(fieldSpecification)) {
                return this.getRetransmitSequenceNumber();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.SubscriptionId.equals(fieldSpecification)) {
                this.setSubscriptionId((UnsignedInteger)object);
                return this;
            }
            if (Fields.RetransmitSequenceNumber.equals(fieldSpecification)) {
                this.setRetransmitSequenceNumber((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_requestHeader = null;
            this.f_subscriptionId = null;
            this.f_retransmitSequenceNumber = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public RepublishRequest build() {
            return new RepublishRequest(this.f_requestHeader, this.f_subscriptionId, this.f_retransmitSequenceNumber);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaIds.RequestHeader, -1, null, false),
        SubscriptionId("SubscriptionId", UnsignedInteger.class, false, UaIds.IntegerId, -1, null, false),
        RetransmitSequenceNumber("RetransmitSequenceNumber", UnsignedInteger.class, false, UaIds.Counter, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

