/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=367")
public class ReferenceTypeAttributes
extends NodeAttributes {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReferenceTypeAttributes_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReferenceTypeAttributes_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReferenceTypeAttributes_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReferenceTypeAttributes;
    public static final StructureSpecification SPECIFICATION;
    private Boolean f_isAbstract;
    private Boolean f_symmetric;
    private LocalizedText f_inverseName;

    public ReferenceTypeAttributes() {
    }

    public ReferenceTypeAttributes(Boolean bl, Boolean bl2, LocalizedText localizedText) {
        this.f_isAbstract = bl;
        this.f_symmetric = bl2;
        this.f_inverseName = localizedText;
    }

    public ReferenceTypeAttributes(UnsignedInteger unsignedInteger, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, Boolean bl, Boolean bl2, LocalizedText localizedText3) {
        super(unsignedInteger, localizedText, localizedText2, unsignedInteger2, unsignedInteger3);
        this.f_isAbstract = bl;
        this.f_symmetric = bl2;
        this.f_inverseName = localizedText3;
    }

    public Boolean getIsAbstract() {
        return this.f_isAbstract;
    }

    public void setIsAbstract(Boolean bl) {
        this.f_isAbstract = bl;
    }

    public Boolean getSymmetric() {
        return this.f_symmetric;
    }

    public void setSymmetric(Boolean bl) {
        this.f_symmetric = bl;
    }

    public LocalizedText getInverseName() {
        return this.f_inverseName;
    }

    public void setInverseName(LocalizedText localizedText) {
        this.f_inverseName = localizedText;
    }

    @Override
    public ReferenceTypeAttributes clone() {
        ReferenceTypeAttributes referenceTypeAttributes = (ReferenceTypeAttributes)super.clone();
        referenceTypeAttributes.f_isAbstract = StructureUtils.clone(this.f_isAbstract);
        referenceTypeAttributes.f_symmetric = StructureUtils.clone(this.f_symmetric);
        referenceTypeAttributes.f_inverseName = StructureUtils.clone(this.f_inverseName);
        return referenceTypeAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReferenceTypeAttributes referenceTypeAttributes = (ReferenceTypeAttributes)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedAttributes(), referenceTypeAttributes.getSpecifiedAttributes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), referenceTypeAttributes.getDisplayName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), referenceTypeAttributes.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getWriteMask(), referenceTypeAttributes.getWriteMask())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserWriteMask(), referenceTypeAttributes.getUserWriteMask())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIsAbstract(), referenceTypeAttributes.getIsAbstract())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSymmetric(), referenceTypeAttributes.getSymmetric())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getInverseName(), referenceTypeAttributes.getInverseName());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask(), this.getIsAbstract(), this.getSymmetric(), this.getInverseName());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_isAbstract = null;
        this.f_symmetric = null;
        this.f_inverseName = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.SpecifiedAttributes, this.getSpecifiedAttributes());
        linkedHashMap.put(Fields.DisplayName, this.getDisplayName());
        linkedHashMap.put(Fields.Description, this.getDescription());
        linkedHashMap.put(Fields.WriteMask, this.getWriteMask());
        linkedHashMap.put(Fields.UserWriteMask, this.getUserWriteMask());
        linkedHashMap.put(Fields.IsAbstract, this.getIsAbstract());
        linkedHashMap.put(Fields.Symmetric, this.getSymmetric());
        linkedHashMap.put(Fields.InverseName, this.getInverseName());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
            return this.getSpecifiedAttributes();
        }
        if (Fields.DisplayName.equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.WriteMask.equals(fieldSpecification)) {
            return this.getWriteMask();
        }
        if (Fields.UserWriteMask.equals(fieldSpecification)) {
            return this.getUserWriteMask();
        }
        if (Fields.IsAbstract.equals(fieldSpecification)) {
            return this.getIsAbstract();
        }
        if (Fields.Symmetric.equals(fieldSpecification)) {
            return this.getSymmetric();
        }
        if (Fields.InverseName.equals(fieldSpecification)) {
            return this.getInverseName();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
            this.setSpecifiedAttributes((UnsignedInteger)object);
            return;
        }
        if (Fields.DisplayName.equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.WriteMask.equals(fieldSpecification)) {
            this.setWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.UserWriteMask.equals(fieldSpecification)) {
            this.setUserWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.IsAbstract.equals(fieldSpecification)) {
            this.setIsAbstract((Boolean)object);
            return;
        }
        if (Fields.Symmetric.equals(fieldSpecification)) {
            this.setSymmetric((Boolean)object);
            return;
        }
        if (Fields.InverseName.equals(fieldSpecification)) {
            this.setInverseName((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReferenceTypeAttributes.builder();
        builder.setSpecifiedAttributes(StructureUtils.clone(this.getSpecifiedAttributes()));
        builder.setDisplayName(StructureUtils.clone(this.getDisplayName()));
        builder.setDescription(StructureUtils.clone(this.getDescription()));
        builder.setWriteMask(StructureUtils.clone(this.getWriteMask()));
        builder.setUserWriteMask(StructureUtils.clone(this.getUserWriteMask()));
        builder.setIsAbstract(StructureUtils.clone(this.getIsAbstract()));
        builder.setSymmetric(StructureUtils.clone(this.getSymmetric()));
        builder.setInverseName(StructureUtils.clone(this.getInverseName()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.SpecifiedAttributes);
        builder.addField(Fields.DisplayName);
        builder.addField(Fields.Description);
        builder.addField(Fields.WriteMask);
        builder.addField(Fields.UserWriteMask);
        builder.addField(Fields.IsAbstract);
        builder.addField(Fields.Symmetric);
        builder.addField(Fields.InverseName);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.NodeAttributes);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ReferenceTypeAttributes");
        builder.setJavaClass(ReferenceTypeAttributes.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends NodeAttributes.Builder {
        private UnsignedInteger f_specifiedAttributes;
        private LocalizedText f_displayName;
        private LocalizedText f_description;
        private UnsignedInteger f_writeMask;
        private UnsignedInteger f_userWriteMask;
        private Boolean f_isAbstract;
        private Boolean f_symmetric;
        private LocalizedText f_inverseName;

        protected Builder() {
        }

        @Override
        public UnsignedInteger getSpecifiedAttributes() {
            return this.f_specifiedAttributes;
        }

        @Override
        public Builder setSpecifiedAttributes(UnsignedInteger unsignedInteger) {
            this.f_specifiedAttributes = unsignedInteger;
            return this;
        }

        @Override
        public LocalizedText getDisplayName() {
            return this.f_displayName;
        }

        @Override
        public Builder setDisplayName(LocalizedText localizedText) {
            this.f_displayName = localizedText;
            return this;
        }

        @Override
        public LocalizedText getDescription() {
            return this.f_description;
        }

        @Override
        public Builder setDescription(LocalizedText localizedText) {
            this.f_description = localizedText;
            return this;
        }

        @Override
        public UnsignedInteger getWriteMask() {
            return this.f_writeMask;
        }

        @Override
        public Builder setWriteMask(UnsignedInteger unsignedInteger) {
            this.f_writeMask = unsignedInteger;
            return this;
        }

        @Override
        public UnsignedInteger getUserWriteMask() {
            return this.f_userWriteMask;
        }

        @Override
        public Builder setUserWriteMask(UnsignedInteger unsignedInteger) {
            this.f_userWriteMask = unsignedInteger;
            return this;
        }

        public Boolean getIsAbstract() {
            return this.f_isAbstract;
        }

        public Builder setIsAbstract(Boolean bl) {
            this.f_isAbstract = bl;
            return this;
        }

        public Boolean getSymmetric() {
            return this.f_symmetric;
        }

        public Builder setSymmetric(Boolean bl) {
            this.f_symmetric = bl;
            return this;
        }

        public LocalizedText getInverseName() {
            return this.f_inverseName;
        }

        public Builder setInverseName(LocalizedText localizedText) {
            this.f_inverseName = localizedText;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedAttributes(), builder.getSpecifiedAttributes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), builder.getDisplayName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), builder.getDescription())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getWriteMask(), builder.getWriteMask())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getUserWriteMask(), builder.getUserWriteMask())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getIsAbstract(), builder.getIsAbstract())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSymmetric(), builder.getSymmetric())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getInverseName(), builder.getInverseName());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask(), this.getIsAbstract(), this.getSymmetric(), this.getInverseName());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
                return this.getSpecifiedAttributes();
            }
            if (Fields.DisplayName.equals(fieldSpecification)) {
                return this.getDisplayName();
            }
            if (Fields.Description.equals(fieldSpecification)) {
                return this.getDescription();
            }
            if (Fields.WriteMask.equals(fieldSpecification)) {
                return this.getWriteMask();
            }
            if (Fields.UserWriteMask.equals(fieldSpecification)) {
                return this.getUserWriteMask();
            }
            if (Fields.IsAbstract.equals(fieldSpecification)) {
                return this.getIsAbstract();
            }
            if (Fields.Symmetric.equals(fieldSpecification)) {
                return this.getSymmetric();
            }
            if (Fields.InverseName.equals(fieldSpecification)) {
                return this.getInverseName();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
                this.setSpecifiedAttributes((UnsignedInteger)object);
                return this;
            }
            if (Fields.DisplayName.equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.WriteMask.equals(fieldSpecification)) {
                this.setWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.UserWriteMask.equals(fieldSpecification)) {
                this.setUserWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.IsAbstract.equals(fieldSpecification)) {
                this.setIsAbstract((Boolean)object);
                return this;
            }
            if (Fields.Symmetric.equals(fieldSpecification)) {
                this.setSymmetric((Boolean)object);
                return this;
            }
            if (Fields.InverseName.equals(fieldSpecification)) {
                this.setInverseName((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_isAbstract = null;
            this.f_symmetric = null;
            this.f_inverseName = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ReferenceTypeAttributes build() {
            return new ReferenceTypeAttributes(this.f_specifiedAttributes, this.f_displayName, this.f_description, this.f_writeMask, this.f_userWriteMask, this.f_isAbstract, this.f_symmetric, this.f_inverseName);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        SpecifiedAttributes("SpecifiedAttributes", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        DisplayName("DisplayName", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        Description("Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        WriteMask("WriteMask", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        UserWriteMask("UserWriteMask", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        IsAbstract("IsAbstract", Boolean.class, false, UaIds.Boolean, -1, null, false),
        Symmetric("Symmetric", Boolean.class, false, UaIds.Boolean, -1, null, false),
        InverseName("InverseName", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

